/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public class RewriteDateLiteralRule
implements ExprRewriteRule {
    public static final ExprRewriteRule INSTANCE = new RewriteDateLiteralRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        Expr childExpr;
        if (!(expr instanceof BinaryPredicate)) {
            return expr;
        }
        Expr lchild = (Expr)expr.getChild(0);
        if (!lchild.getType().isDateType()) {
            return expr;
        }
        Expr valueExpr = (Expr)expr.getChild(1);
        if (!valueExpr.getType().isDateType()) {
            return expr;
        }
        if (!valueExpr.isConstant()) {
            return expr;
        }
        if (valueExpr instanceof CastExpr && (childExpr = (Expr)valueExpr.getChild(0)) instanceof LiteralExpr) {
            try {
                String dateStr = childExpr.getStringValue();
                DateLiteral dateLiteral = new DateLiteral();
                dateLiteral.fromDateStr(dateStr);
                expr.setChild(1, dateLiteral);
            }
            catch (AnalysisException e) {
                if (clauseType == ExprRewriter.ClauseType.OTHER_CLAUSE) {
                    return new NullLiteral();
                }
                throw new AnalysisException("Incorrect datetime value: " + valueExpr.toSql() + " in expression: " + expr.toSql());
            }
        }
        return expr;
    }
}

