/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public class RewriteBinaryPredicatesRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new RewriteBinaryPredicatesRule();

    private Expr rewriteBigintSlotRefCompareDecimalLiteral(Expr expr0, Expr expr1, BinaryPredicate.Operator op) throws AnalysisException {
        if (((DecimalLiteral)expr1).getDoubleValue() % (double)((int)((DecimalLiteral)expr1).getDoubleValue()) != 0.0) {
            if (op == BinaryPredicate.Operator.EQ || op == BinaryPredicate.Operator.EQ_FOR_NULL) {
                return new BoolLiteral(false);
            }
            if (op == BinaryPredicate.Operator.NE) {
                return new BoolLiteral(true);
            }
            if (op == BinaryPredicate.Operator.LE) {
                ((DecimalLiteral)expr1).roundCeiling();
                op = BinaryPredicate.Operator.LT;
            } else if (op == BinaryPredicate.Operator.GE) {
                ((DecimalLiteral)expr1).roundFloor();
                op = BinaryPredicate.Operator.GT;
            } else if (op == BinaryPredicate.Operator.LT) {
                ((DecimalLiteral)expr1).roundCeiling();
            } else if (op == BinaryPredicate.Operator.GT) {
                ((DecimalLiteral)expr1).roundFloor();
            }
        }
        expr0 = (Expr)expr0.getChild(0);
        expr1 = expr1.castTo(Type.BIGINT);
        return new BinaryPredicate(op, expr0, expr1);
    }

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        if (!(expr instanceof BinaryPredicate)) {
            return expr;
        }
        BinaryPredicate.Operator op = ((BinaryPredicate)expr).getOp();
        Expr expr0 = (Expr)expr.getChild(0);
        Expr expr1 = (Expr)expr.getChild(1);
        if (expr0 instanceof CastExpr && expr0.getType() == Type.DECIMALV2 && expr0.getChild(0) instanceof SlotRef && ((Expr)expr0.getChild(0)).getType().getResultType() == Type.BIGINT && expr1 instanceof DecimalLiteral) {
            return this.rewriteBigintSlotRefCompareDecimalLiteral(expr0, expr1, op);
        }
        return expr;
    }
}

