/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.catalog.AliasFunction;
import org.apache.doris.catalog.Function;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public class RewriteAliasFunctionRule
implements ExprRewriteRule {
    public static RewriteAliasFunctionRule INSTANCE = new RewriteAliasFunctionRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        Function fn;
        if (expr instanceof FunctionCallExpr && (fn = expr.getFn()) instanceof AliasFunction) {
            Expr originFn = ((AliasFunction)fn).getOriginFunction();
            if (originFn instanceof FunctionCallExpr) {
                return ((FunctionCallExpr)expr).rewriteExpr();
            }
            if (originFn instanceof CastExpr) {
                return ((CastExpr)originFn).rewriteExpr(((AliasFunction)fn).getParameters(), ((FunctionCallExpr)expr).getParams().exprs());
            }
        }
        return expr;
    }
}

