/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.JoinOperator;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InferFiltersRule
implements ExprRewriteRule {
    private static final Logger LOG = LogManager.getLogger(InferFiltersRule.class);
    public static InferFiltersRule INSTANCE = new InferFiltersRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        if (expr == null) {
            return null;
        }
        if (!analyzer.enableInferPredicate() || clauseType == ExprRewriter.ClauseType.OTHER_CLAUSE) {
            return expr;
        }
        List<Expr> slotEqSlotExpr = analyzer.getOnSlotEqSlotExpr();
        Set<Object> slotEqSlotDeDuplication = clauseType == ExprRewriter.ClauseType.ON_CLAUSE ? analyzer.getOnSlotEqSlotDeDuplication() : Sets.newHashSet();
        List<Expr> slotToLiteralExpr = analyzer.getOnSlotToLiteralExpr();
        Set<Object> slotToLiteralDeDuplication = clauseType == ExprRewriter.ClauseType.ON_CLAUSE ? analyzer.getOnSlotToLiteralDeDuplication() : Sets.newHashSet();
        ArrayList<Pair<Expr, Boolean>> newExprWithState = new ArrayList<Pair<Expr, Boolean>>();
        List<Expr> isNullExpr = analyzer.getOnIsNullExpr();
        Set<Object> isNullDeDuplication = clauseType == ExprRewriter.ClauseType.ON_CLAUSE ? analyzer.getOnIsNullDeDuplication() : Sets.newHashSet();
        List<Expr> inExpr = analyzer.getInExpr();
        Set<Object> inDeDuplication = clauseType == ExprRewriter.ClauseType.ON_CLAUSE ? analyzer.getInDeDuplication() : Sets.newHashSet();
        HashMap<Expr, Integer> exprToWarshallArraySubscript = new HashMap<Expr, Integer>();
        HashMap<Integer, Expr> warshallArraySubscriptToExpr = new HashMap<Integer, Expr>();
        this.initAllStructure(expr, slotEqSlotExpr, slotEqSlotDeDuplication, slotToLiteralExpr, slotToLiteralDeDuplication, isNullExpr, isNullDeDuplication, inExpr, inDeDuplication, analyzer, clauseType);
        this.genNewSlotEqSlotPredicate(slotEqSlotExpr, slotEqSlotDeDuplication, exprToWarshallArraySubscript, warshallArraySubscriptToExpr, analyzer, clauseType);
        this.inferSlotToLiteralPredicates(slotEqSlotExpr, slotToLiteralDeDuplication, slotToLiteralExpr, newExprWithState, analyzer, clauseType);
        this.inferIsNotNullPredicates(slotEqSlotExpr, isNullExpr, isNullDeDuplication, newExprWithState, analyzer, clauseType);
        this.inferInPredicate(slotEqSlotExpr, inDeDuplication, inExpr, newExprWithState, analyzer, clauseType);
        if (!newExprWithState.isEmpty()) {
            Expr rewriteExpr = expr;
            for (Pair pair : newExprWithState) {
                if (!((Boolean)pair.second).booleanValue()) continue;
                rewriteExpr = new CompoundPredicate(CompoundPredicate.Operator.AND, rewriteExpr, (Expr)pair.first);
            }
            return rewriteExpr;
        }
        return expr;
    }

    private void initAllStructure(Expr conjunct, List<Expr> slotEqSlotExpr, Set<Pair<Expr, Expr>> slotEqSlotDeDuplication, List<Expr> slotToLiteralExpr, Set<Pair<Expr, Expr>> slotToLiteralDeDuplication, List<Expr> isNullExpr, Set<Expr> isNullDeDuplication, List<Expr> inExpr, Set<Expr> inDeDuplication, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        if (conjunct instanceof CompoundPredicate && ((CompoundPredicate)conjunct).getOp() == CompoundPredicate.Operator.AND) {
            for (int index = 0; index < conjunct.getChildren().size(); ++index) {
                this.initAllStructure((Expr)conjunct.getChild(index), slotEqSlotExpr, slotEqSlotDeDuplication, slotToLiteralExpr, slotToLiteralDeDuplication, isNullExpr, isNullDeDuplication, inExpr, inDeDuplication, analyzer, clauseType);
            }
        }
        if (conjunct instanceof BinaryPredicate && conjunct.getChild(0) != null && conjunct.getChild(1) != null) {
            if (((Expr)conjunct.getChild(0)).unwrapSlotRef() != null && conjunct.getChild(1) instanceof LiteralExpr) {
                Pair<Expr, Expr> pair = new Pair<Expr, Expr>(((Expr)conjunct.getChild(0)).unwrapSlotRef(), (Expr)conjunct.getChild(1));
                if (!slotToLiteralDeDuplication.contains(pair)) {
                    slotToLiteralDeDuplication.add(pair);
                    slotToLiteralExpr.add(conjunct);
                    if (clauseType == ExprRewriter.ClauseType.ON_CLAUSE) {
                        analyzer.registerOnSlotToLiteralDeDuplication(pair);
                        analyzer.registerOnSlotToLiteralExpr(conjunct);
                    }
                    analyzer.registerGlobalSlotToLiteralDeDuplication(pair);
                }
            } else if (((BinaryPredicate)conjunct).getOp().isEquivalence() && ((Expr)conjunct.getChild(0)).unwrapSlotRef() != null && ((Expr)conjunct.getChild(1)).unwrapSlotRef() != null) {
                Pair<Expr, Expr> pair = new Pair<Expr, Expr>(((Expr)conjunct.getChild(0)).unwrapSlotRef(), ((Expr)conjunct.getChild(1)).unwrapSlotRef());
                Pair<SlotRef, SlotRef> eqPair = new Pair<SlotRef, SlotRef>(((Expr)conjunct.getChild(1)).unwrapSlotRef(), ((Expr)conjunct.getChild(0)).unwrapSlotRef());
                if (!slotEqSlotDeDuplication.contains(pair) && !slotEqSlotDeDuplication.contains(eqPair)) {
                    slotEqSlotDeDuplication.add(pair);
                    slotEqSlotExpr.add(conjunct);
                    if (clauseType == ExprRewriter.ClauseType.ON_CLAUSE) {
                        analyzer.registerOnSlotEqSlotDeDuplication(pair);
                        analyzer.registerOnSlotEqSlotExpr(conjunct);
                    }
                }
            }
        } else if (conjunct instanceof IsNullPredicate && conjunct.getChild(0) != null && ((Expr)conjunct.getChild(0)).unwrapSlotRef() != null) {
            if (!isNullDeDuplication.contains(((Expr)conjunct.getChild(0)).unwrapSlotRef()) && ((IsNullPredicate)conjunct).isNotNull()) {
                isNullDeDuplication.add(((Expr)conjunct.getChild(0)).unwrapSlotRef());
                isNullExpr.add(conjunct);
                if (clauseType == ExprRewriter.ClauseType.ON_CLAUSE) {
                    analyzer.registerOnIsNullDeDuplication(((Expr)conjunct.getChild(0)).unwrapSlotRef());
                    analyzer.registerOnIsNullExpr(conjunct);
                }
            }
        } else if (conjunct instanceof InPredicate && conjunct.getChild(0) != null && ((Expr)conjunct.getChild(0)).unwrapSlotRef() != null && !inDeDuplication.contains(((Expr)conjunct.getChild(0)).unwrapSlotRef())) {
            inDeDuplication.add(((Expr)conjunct.getChild(0)).unwrapSlotRef());
            inExpr.add(conjunct);
            if (clauseType == ExprRewriter.ClauseType.ON_CLAUSE) {
                analyzer.registerInExpr(conjunct);
                analyzer.registerInDeDuplication(((Expr)conjunct.getChild(0)).unwrapSlotRef());
            }
            analyzer.registerGlobalInDeDuplication(((Expr)conjunct.getChild(0)).unwrapSlotRef());
        }
    }

    private void genNewSlotEqSlotPredicate(List<Expr> slotEqSlotExpr, Set<Pair<Expr, Expr>> slotEqSlotDeDuplication, Map<Expr, Integer> exprToWarshallArraySubscript, Map<Integer, Expr> warshallArraySubscriptToExpr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        int arrayMaxSize = slotEqSlotExpr.size() * 2;
        int[][] warshall = new int[arrayMaxSize][arrayMaxSize];
        for (int index = 0; index < arrayMaxSize; ++index) {
            warshall[index] = new int[arrayMaxSize];
            Arrays.fill(warshall[index], 0);
        }
        boolean needGenWarshallArray = this.initWarshallArray(warshall, arrayMaxSize, slotEqSlotExpr, exprToWarshallArraySubscript, warshallArraySubscriptToExpr);
        if (needGenWarshallArray) {
            ArrayList<Pair<Integer, Integer>> newSlotArray = new ArrayList<Pair<Integer, Integer>>();
            this.genWarshallArray(warshall, arrayMaxSize, newSlotArray);
            this.buildNewSlotEqSlotPredicate(newSlotArray, warshallArraySubscriptToExpr, slotEqSlotExpr, slotEqSlotDeDuplication, analyzer, clauseType);
        }
    }

    private boolean initWarshallArray(int[][] warshall, int arrayMaxSize, List<Expr> slotEqSlotExpr, Map<Expr, Integer> exprToWarshallArraySubscript, Map<Integer, Expr> warshallArraySubscriptToExpr) {
        boolean needGenWarshallArray = false;
        int index = 0;
        for (Expr slotEqSlot : slotEqSlotExpr) {
            int column;
            int row;
            if (!exprToWarshallArraySubscript.containsKey(slotEqSlot.getChild(0))) {
                exprToWarshallArraySubscript.put((Expr)slotEqSlot.getChild(0), index);
                warshallArraySubscriptToExpr.put(index, (Expr)slotEqSlot.getChild(0));
                row = index++;
            } else {
                row = exprToWarshallArraySubscript.get(slotEqSlot.getChild(0));
            }
            if (!exprToWarshallArraySubscript.containsKey(slotEqSlot.getChild(1))) {
                exprToWarshallArraySubscript.put((Expr)slotEqSlot.getChild(1), index);
                warshallArraySubscriptToExpr.put(index, (Expr)slotEqSlot.getChild(1));
                column = index++;
            } else {
                column = exprToWarshallArraySubscript.get(slotEqSlot.getChild(1));
            }
            if (row >= arrayMaxSize || column >= arrayMaxSize) {
                LOG.debug("Error row {} or column {}, but max size is {}.", (Object)row, (Object)column, (Object)arrayMaxSize);
                needGenWarshallArray = false;
                break;
            }
            needGenWarshallArray = true;
            warshall[row][column] = 1;
            warshall[column][row] = 1;
        }
        return needGenWarshallArray;
    }

    private void genWarshallArray(int[][] warshall, int arrayMaxSize, List<Pair<Integer, Integer>> newSlotsArray) {
        for (int k = 0; k < arrayMaxSize; ++k) {
            for (int i = 0; i < arrayMaxSize; ++i) {
                if (warshall[i][k] == 0) continue;
                for (int j = 0; j < arrayMaxSize; ++j) {
                    if (warshall[i][k] != 1 || warshall[k][j] != 1 || i == j) continue;
                    warshall[i][j] = 1;
                    Pair<Integer, Integer> pair = new Pair<Integer, Integer>(i, j);
                    newSlotsArray.add(pair);
                }
            }
        }
    }

    private void buildNewSlotEqSlotPredicate(List<Pair<Integer, Integer>> newSlots, Map<Integer, Expr> warshallArraySubscriptToExpr, List<Expr> slotEqSlotExpr, Set<Pair<Expr, Expr>> slotEqSlotDeDuplication, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        for (Pair<Integer, Integer> slotPair : newSlots) {
            Pair<Expr, Expr> pair = new Pair<Expr, Expr>(warshallArraySubscriptToExpr.get(slotPair.first), warshallArraySubscriptToExpr.get(slotPair.second));
            Pair<Expr, Expr> eqPair = new Pair<Expr, Expr>(warshallArraySubscriptToExpr.get(slotPair.second), warshallArraySubscriptToExpr.get(slotPair.first));
            if (slotEqSlotDeDuplication.contains(pair) || slotEqSlotDeDuplication.contains(eqPair)) continue;
            slotEqSlotDeDuplication.add(pair);
            slotEqSlotExpr.add(new BinaryPredicate(BinaryPredicate.Operator.EQ, warshallArraySubscriptToExpr.get(slotPair.first), warshallArraySubscriptToExpr.get(slotPair.second)));
            if (clauseType != ExprRewriter.ClauseType.ON_CLAUSE) continue;
            analyzer.registerOnSlotEqSlotDeDuplication(pair);
            analyzer.registerOnSlotEqSlotExpr(new BinaryPredicate(BinaryPredicate.Operator.EQ, warshallArraySubscriptToExpr.get(slotPair.first), warshallArraySubscriptToExpr.get(slotPair.second)));
        }
    }

    private void inferSlotToLiteralPredicates(List<Expr> slotEqSlotExpr, Set<Pair<Expr, Expr>> slotToLiteralDeDuplication, List<Expr> slotToLiteralExpr, List<Pair<Expr, Boolean>> newExprWithState, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        for (Expr slotToLiteral : slotToLiteralExpr) {
            this.buildNewBinaryPredicate(slotToLiteral, slotEqSlotExpr, slotToLiteralDeDuplication, newExprWithState, analyzer, clauseType);
        }
    }

    private void buildNewBinaryPredicate(Expr slotToLiteral, List<Expr> slotEqSlotExpr, Set<Pair<Expr, Expr>> slotToLiteralDeDuplication, List<Pair<Expr, Boolean>> newExprWithState, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        SlotRef checkSlot = ((Expr)slotToLiteral.getChild(0)).unwrapSlotRef();
        if (checkSlot != null) {
            for (Expr conjunct : slotEqSlotExpr) {
                SlotRef leftSlot = ((Expr)conjunct.getChild(0)).unwrapSlotRef();
                SlotRef rightSlot = ((Expr)conjunct.getChild(1)).unwrapSlotRef();
                if (leftSlot == null || rightSlot == null) continue;
                if (checkSlot.equals(leftSlot)) {
                    this.addNewBinaryPredicate(this.genNewBinaryPredicate(slotToLiteral, rightSlot), slotToLiteralDeDuplication, newExprWithState, this.isNeedInfer(rightSlot, leftSlot, analyzer, clauseType), analyzer, clauseType);
                    continue;
                }
                if (!checkSlot.equals(rightSlot)) continue;
                this.addNewBinaryPredicate(this.genNewBinaryPredicate(slotToLiteral, leftSlot), slotToLiteralDeDuplication, newExprWithState, this.isNeedInfer(leftSlot, rightSlot, analyzer, clauseType), analyzer, clauseType);
            }
        }
    }

    private boolean isNeedInfer(SlotRef newSlot, SlotRef checkSlot, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        TupleId checkTid;
        boolean ret = false;
        TupleId newTid = newSlot.getDesc().getParent().getRef().getId();
        Pair<TupleId, TupleId> tids = new Pair<TupleId, TupleId>(newTid, checkTid = checkSlot.getDesc().getParent().getRef().getId());
        if (analyzer.isContainTupleIds(tids)) {
            JoinOperator joinOperator = analyzer.getAnyTwoTablesJoinOp(tids);
            ret = this.checkNeedInfer(joinOperator, false, clauseType);
        } else {
            Pair<TupleId, TupleId> changeTids = new Pair<TupleId, TupleId>(checkTid, newTid);
            if (analyzer.isContainTupleIds(changeTids)) {
                JoinOperator joinOperator = analyzer.getAnyTwoTablesJoinOp(changeTids);
                ret = this.checkNeedInfer(joinOperator, true, clauseType);
            }
        }
        return ret;
    }

    private boolean checkNeedInfer(JoinOperator joinOperator, boolean needChange, ExprRewriter.ClauseType clauseType) {
        boolean ret = false;
        if (clauseType == ExprRewriter.ClauseType.ON_CLAUSE) {
            if (joinOperator.isInnerJoin() || joinOperator == JoinOperator.LEFT_SEMI_JOIN || !needChange && joinOperator == JoinOperator.RIGHT_OUTER_JOIN || needChange && (joinOperator == JoinOperator.LEFT_OUTER_JOIN || joinOperator == JoinOperator.LEFT_ANTI_JOIN)) {
                ret = true;
            }
        } else if (clauseType == ExprRewriter.ClauseType.WHERE_CLAUSE && (joinOperator.isInnerJoin() || joinOperator == JoinOperator.LEFT_SEMI_JOIN || needChange && joinOperator == JoinOperator.RIGHT_OUTER_JOIN || !needChange && (joinOperator == JoinOperator.LEFT_OUTER_JOIN || joinOperator == JoinOperator.LEFT_ANTI_JOIN))) {
            ret = true;
        }
        return ret;
    }

    private Expr genNewBinaryPredicate(Expr oldExpr, Expr newSlot) {
        if (oldExpr instanceof BinaryPredicate) {
            BinaryPredicate oldBP = (BinaryPredicate)oldExpr;
            return new BinaryPredicate(oldBP.getOp(), newSlot, (Expr)oldBP.getChild(1));
        }
        return oldExpr;
    }

    private void addNewBinaryPredicate(Expr expr, Set<Pair<Expr, Expr>> slotToLiteralDeDuplication, List<Pair<Expr, Boolean>> newExprWithState, boolean needAddnewExprWithState, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        BinaryPredicate newBP;
        Pair<Expr, Expr> pair;
        if (expr instanceof BinaryPredicate && !slotToLiteralDeDuplication.contains(pair = new Pair<Expr, Expr>((Expr)(newBP = (BinaryPredicate)expr).getChild(0), (Expr)newBP.getChild(1)))) {
            slotToLiteralDeDuplication.add(pair);
            Pair<BinaryPredicate, Boolean> newBPWithBool = new Pair<BinaryPredicate, Boolean>(newBP, needAddnewExprWithState);
            newExprWithState.add(newBPWithBool);
            if (clauseType == ExprRewriter.ClauseType.ON_CLAUSE) {
                analyzer.registerOnSlotToLiteralDeDuplication(pair);
                analyzer.registerOnSlotToLiteralExpr(newBP);
            }
            if (needAddnewExprWithState) {
                analyzer.registerGlobalSlotToLiteralDeDuplication(pair);
            }
        }
    }

    private void inferIsNotNullPredicates(List<Expr> slotEqSlotExpr, List<Expr> isNullExpr, Set<Expr> isNullDeDuplication, List<Pair<Expr, Boolean>> newExprWithState, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        for (Expr isNullPredicate : isNullExpr) {
            this.buildNewIsNotNullPredicate(isNullPredicate, slotEqSlotExpr, isNullDeDuplication, newExprWithState, analyzer, clauseType);
        }
    }

    private void buildNewIsNotNullPredicate(Expr expr, List<Expr> slotEqSlotExpr, Set<Expr> isNullDeDuplication, List<Pair<Expr, Boolean>> newExprWithState, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        IsNullPredicate isNullPredicate;
        SlotRef checkSlot;
        if (expr instanceof IsNullPredicate && (checkSlot = ((Expr)(isNullPredicate = (IsNullPredicate)expr).getChild(0)).unwrapSlotRef()) != null) {
            for (Expr conjunct : slotEqSlotExpr) {
                SlotRef leftSlot = ((Expr)conjunct.getChild(0)).unwrapSlotRef();
                SlotRef rightSlot = ((Expr)conjunct.getChild(1)).unwrapSlotRef();
                if (leftSlot == null || rightSlot == null) continue;
                if (checkSlot.equals(leftSlot) && isNullPredicate.isNotNull()) {
                    this.addNewIsNotNullPredicate(this.genNewIsNotNullPredicate(isNullPredicate, rightSlot), isNullDeDuplication, newExprWithState, analyzer, clauseType);
                    continue;
                }
                if (!checkSlot.equals(rightSlot)) continue;
                this.addNewIsNotNullPredicate(this.genNewIsNotNullPredicate(isNullPredicate, leftSlot), isNullDeDuplication, newExprWithState, analyzer, clauseType);
            }
        }
    }

    private Expr genNewIsNotNullPredicate(IsNullPredicate oldExpr, Expr newSlot) {
        return oldExpr != null ? new IsNullPredicate(newSlot, oldExpr.isNotNull()) : null;
    }

    private void addNewIsNotNullPredicate(Expr expr, Set<Expr> isNullDeDuplication, List<Pair<Expr, Boolean>> newExprWithState, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        IsNullPredicate newExpr;
        if (expr instanceof IsNullPredicate && !isNullDeDuplication.contains((newExpr = (IsNullPredicate)expr).getChild(0))) {
            isNullDeDuplication.add((Expr)newExpr.getChild(0));
            Pair<IsNullPredicate, Boolean> newExprWithBoolean = new Pair<IsNullPredicate, Boolean>(newExpr, true);
            newExprWithState.add(newExprWithBoolean);
            if (clauseType == ExprRewriter.ClauseType.ON_CLAUSE) {
                analyzer.registerOnIsNullExpr(newExpr);
                analyzer.registerOnIsNullDeDuplication(newExpr);
            }
        }
    }

    private void inferInPredicate(List<Expr> slotEqSlotExpr, Set<Expr> inDeDuplication, List<Expr> inExprs, List<Pair<Expr, Boolean>> newExprWithState, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        for (Expr inExpr : inExprs) {
            this.buildNewInPredicate(inExpr, slotEqSlotExpr, inDeDuplication, newExprWithState, analyzer, clauseType);
        }
    }

    private void buildNewInPredicate(Expr inExpr, List<Expr> slotEqSlotExpr, Set<Expr> inDeDuplication, List<Pair<Expr, Boolean>> newExprWithState, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        InPredicate inpredicate;
        SlotRef checkSlot;
        if (inExpr instanceof InPredicate && (checkSlot = ((Expr)(inpredicate = (InPredicate)inExpr).getChild(0)).unwrapSlotRef()) != null) {
            for (Expr conjunct : slotEqSlotExpr) {
                SlotRef leftSlot = ((Expr)conjunct.getChild(0)).unwrapSlotRef();
                SlotRef rightSlot = ((Expr)conjunct.getChild(1)).unwrapSlotRef();
                if (leftSlot == null || rightSlot == null) continue;
                if (checkSlot.equals(leftSlot)) {
                    this.addNewInPredicate(this.genNewInPredicate(inpredicate, rightSlot), inDeDuplication, newExprWithState, this.isNeedInfer(rightSlot, leftSlot, analyzer, clauseType), analyzer, clauseType);
                    continue;
                }
                if (!checkSlot.equals(rightSlot)) continue;
                this.addNewInPredicate(this.genNewInPredicate(inpredicate, leftSlot), inDeDuplication, newExprWithState, this.isNeedInfer(leftSlot, rightSlot, analyzer, clauseType), analyzer, clauseType);
            }
        }
    }

    private Expr genNewInPredicate(Expr oldExpr, Expr newSlot) {
        if (oldExpr instanceof InPredicate) {
            InPredicate oldBP = (InPredicate)oldExpr;
            return new InPredicate(newSlot, oldBP.getListChildren(), oldBP.isNotIn());
        }
        return oldExpr;
    }

    private void addNewInPredicate(Expr expr, Set<Expr> inDeDuplication, List<Pair<Expr, Boolean>> newExprWithState, boolean needAddnewExprWithState, Analyzer analyzer, ExprRewriter.ClauseType clauseType) {
        InPredicate newIP;
        if (expr instanceof InPredicate && !inDeDuplication.contains(newIP = (InPredicate)expr)) {
            inDeDuplication.add(newIP);
            Pair<InPredicate, Boolean> newBPWithBool = new Pair<InPredicate, Boolean>(newIP, needAddnewExprWithState);
            newExprWithState.add(newBPWithBool);
            if (clauseType == ExprRewriter.ClauseType.ON_CLAUSE) {
                analyzer.registerInDeDuplication(newIP);
                analyzer.registerInExpr(newIP);
            }
            if (needAddnewExprWithState) {
                analyzer.registerGlobalInDeDuplication(newIP);
            }
        }
    }
}

