/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BetweenPredicate;
import org.apache.doris.analysis.CaseExpr;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InformationFunction;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.SysVariableDesc;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.proto.InternalService;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.VariableMgr;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.doris.rpc.BackendServiceProxy;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.TExpr;
import org.apache.doris.thrift.TFoldConstantParams;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPrimitiveType;
import org.apache.doris.thrift.TQueryGlobals;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FoldConstantsRule
implements ExprRewriteRule {
    private static final Logger LOG = LogManager.getLogger(FoldConstantsRule.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static ExprRewriteRule INSTANCE = new FoldConstantsRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        CastExpr castExpr;
        if (expr instanceof CaseExpr) {
            return CaseExpr.computeCaseExpr((CaseExpr)expr);
        }
        for (Expr child : expr.getChildren()) {
            if (child.isLiteral() || child instanceof CastExpr) continue;
            return expr;
        }
        if (expr.isLiteral() || !expr.isConstant()) {
            return expr;
        }
        if (expr instanceof CastExpr && (castExpr = (CastExpr)expr).getChild(0) instanceof NullLiteral) {
            return expr;
        }
        if (!expr.isAnalyzed()) {
            expr.analyze(analyzer);
            if (!expr.isConstant()) {
                return expr;
            }
        }
        return expr.getResultValue();
    }

    public boolean apply(Map<String, Expr> exprMap, Analyzer analyzer, boolean changed) throws AnalysisException {
        Map<String, Map<String, Expr>> resultMap;
        HashMap<String, Map<String, TExpr>> paramMap = new HashMap<String, Map<String, TExpr>>();
        HashMap<String, Expr> allConstMap = new HashMap<String, Expr>();
        HashMap<String, Map<String, Expr>> sysVarsMap = new HashMap<String, Map<String, Expr>>();
        HashMap<String, Map<String, Expr>> infoFnsMap = new HashMap<String, Map<String, Expr>>();
        for (Map.Entry<String, Expr> entry : exprMap.entrySet()) {
            HashMap<String, TExpr> constMap = new HashMap<String, TExpr>();
            HashMap<String, Expr> oriConstMap = new HashMap<String, Expr>();
            HashMap<String, Expr> sysVarMap = new HashMap<String, Expr>();
            HashMap<String, Expr> infoFnMap = new HashMap<String, Expr>();
            this.getConstExpr(entry.getValue(), constMap, oriConstMap, analyzer, sysVarMap, infoFnMap);
            if (!constMap.isEmpty()) {
                paramMap.put(entry.getKey(), constMap);
                allConstMap.putAll(oriConstMap);
            }
            if (!sysVarMap.isEmpty()) {
                sysVarsMap.put(entry.getKey(), sysVarMap);
            }
            if (infoFnMap.isEmpty()) continue;
            infoFnsMap.put(entry.getKey(), infoFnMap);
        }
        if (!sysVarsMap.isEmpty()) {
            this.putBackConstExpr(exprMap, sysVarsMap);
            changed = true;
        }
        if (!infoFnsMap.isEmpty()) {
            this.putBackConstExpr(exprMap, infoFnsMap);
            changed = true;
        }
        if (!paramMap.isEmpty() && !(resultMap = this.calcConstExpr(paramMap, allConstMap, analyzer.getContext())).isEmpty()) {
            this.putBackConstExpr(exprMap, resultMap);
            changed = true;
        }
        return changed;
    }

    public void getConstExpr(Expr expr, Map<String, TExpr> constExprMap, Map<String, Expr> oriConstMap, Analyzer analyzer, Map<String, Expr> sysVarMap, Map<String, Expr> infoFnMap) throws AnalysisException {
        if (expr.isConstant()) {
            CastExpr castExpr;
            if (expr instanceof CastExpr && (castExpr = (CastExpr)expr).getChild(0) instanceof NullLiteral) {
                return;
            }
            if (expr instanceof LiteralExpr) {
                return;
            }
            if (expr instanceof BetweenPredicate) {
                return;
            }
            if (expr.contains(Predicates.instanceOf(SysVariableDesc.class))) {
                this.getSysVarDescExpr(expr, sysVarMap);
                return;
            }
            if (expr.contains(Predicates.instanceOf(InformationFunction.class))) {
                this.getInfoFnExpr(expr, infoFnMap);
                return;
            }
            constExprMap.put(expr.getId().toString(), expr.treeToThrift());
            oriConstMap.put(expr.getId().toString(), expr);
        } else {
            this.recursiveGetChildrenConstExpr(expr, constExprMap, oriConstMap, analyzer, sysVarMap, infoFnMap);
        }
    }

    private void recursiveGetChildrenConstExpr(Expr expr, Map<String, TExpr> constExprMap, Map<String, Expr> oriConstMap, Analyzer analyzer, Map<String, Expr> sysVarMap, Map<String, Expr> infoFnMap) throws AnalysisException {
        for (int i = 0; i < expr.getChildren().size(); ++i) {
            Expr child = (Expr)expr.getChildren().get(i);
            this.getConstExpr(child, constExprMap, oriConstMap, analyzer, sysVarMap, infoFnMap);
        }
    }

    private void getSysVarDescExpr(Expr expr, Map<String, Expr> sysVarMap) {
        if (expr instanceof SysVariableDesc) {
            Expr literalExpr = ((SysVariableDesc)expr).getLiteralExpr();
            if (literalExpr == null) {
                try {
                    VariableMgr.fillValue(ConnectContext.get().getSessionVariable(), (SysVariableDesc)expr);
                    literalExpr = ((SysVariableDesc)expr).getLiteralExpr();
                }
                catch (AnalysisException e) {
                    LOG.warn("failed to get session variable value: " + ((SysVariableDesc)expr).getName());
                }
            }
            sysVarMap.put(expr.getId().toString(), literalExpr);
        } else {
            for (Expr child : expr.getChildren()) {
                this.getSysVarDescExpr(child, sysVarMap);
            }
        }
    }

    private void getInfoFnExpr(Expr expr, Map<String, Expr> infoFnMap) {
        if (expr instanceof InformationFunction) {
            Type type = expr.getType();
            LiteralExpr literalExpr = null;
            try {
                String str = null;
                if (type.equals(Type.VARCHAR)) {
                    str = ((InformationFunction)expr).getStrValue();
                } else if (type.equals(Type.BIGINT)) {
                    str = ((InformationFunction)expr).getIntValue();
                }
                Preconditions.checkNotNull((Object)str);
                literalExpr = LiteralExpr.create(str, type);
                infoFnMap.put(expr.getId().toString(), literalExpr);
            }
            catch (AnalysisException e) {
                LOG.warn("failed to get const expr value from InformationFunction: {}", (Object)e.getMessage());
            }
        } else {
            for (Expr child : expr.getChildren()) {
                this.getInfoFnExpr(child, infoFnMap);
            }
        }
    }

    private void putBackConstExpr(Map<String, Expr> exprMap, Map<String, Map<String, Expr>> resultMap) {
        for (Map.Entry<String, Map<String, Expr>> entry : resultMap.entrySet()) {
            Expr rewrittenExpr = this.putBackConstExpr(exprMap.get(entry.getKey()), entry.getValue());
            exprMap.put(entry.getKey(), rewrittenExpr);
        }
    }

    private Expr putBackConstExpr(Expr expr, Map<String, Expr> resultMap) {
        for (Map.Entry<String, Expr> entry : resultMap.entrySet()) {
            if (!(entry.getValue() instanceof LiteralExpr)) continue;
            expr = this.replaceExpr(expr, entry.getKey(), (LiteralExpr)entry.getValue());
        }
        return expr;
    }

    private Expr replaceExpr(Expr expr, String key, LiteralExpr literalExpr) {
        if (expr.getId().toString().equals(key)) {
            return literalExpr;
        }
        for (int i = 0; i < expr.getChildren().size(); ++i) {
            Expr child = (Expr)expr.getChild(i);
            if (!literalExpr.equals(this.replaceExpr(child, key, literalExpr))) continue;
            literalExpr.setId(child.getId());
            expr.setChild(i, literalExpr);
            break;
        }
        return expr;
    }

    private Map<String, Map<String, Expr>> calcConstExpr(Map<String, Map<String, TExpr>> map, Map<String, Expr> allConstMap, ConnectContext context) {
        TNetworkAddress brpcAddress = null;
        HashMap<String, Map<String, Expr>> resultMap = new HashMap<String, Map<String, Expr>>();
        try {
            List<Long> backendIds = Catalog.getCurrentSystemInfo().getBackendIds(true);
            if (backendIds.isEmpty()) {
                throw new LoadException("Failed to get all partitions. No alive backends");
            }
            Collections.shuffle(backendIds);
            Backend be = Catalog.getCurrentSystemInfo().getBackend(backendIds.get(0));
            brpcAddress = new TNetworkAddress(be.getHost(), be.getBrpcPort());
            TQueryGlobals queryGlobals = new TQueryGlobals();
            queryGlobals.setNowString(DATE_FORMAT.format(new Date()));
            queryGlobals.setTimestampMs(System.currentTimeMillis());
            queryGlobals.setTimeZone("Asia/Shanghai");
            if (context.getSessionVariable().getTimeZone().equals("CST")) {
                queryGlobals.setTimeZone("Asia/Shanghai");
            } else {
                queryGlobals.setTimeZone(context.getSessionVariable().getTimeZone());
            }
            TFoldConstantParams tParams = new TFoldConstantParams(map, queryGlobals);
            tParams.setVecExec(VectorizedUtil.isVectorized());
            Future<InternalService.PConstantExprResult> future = BackendServiceProxy.getInstance().foldConstantExpr(brpcAddress, tParams);
            InternalService.PConstantExprResult result = future.get(5L, TimeUnit.SECONDS);
            if (result.getStatus().getStatusCode() == 0) {
                for (Map.Entry<String, InternalService.PExprResultMap> entry : result.getExprResultMapMap().entrySet()) {
                    HashMap<String, Expr> tmp = new HashMap<String, Expr>();
                    for (Map.Entry<String, InternalService.PExprResult> entry1 : entry.getValue().getMapMap().entrySet()) {
                        TPrimitiveType type = TPrimitiveType.findByValue((int)entry1.getValue().getType().getType());
                        Expr retExpr = null;
                        retExpr = entry1.getValue().getSuccess() ? LiteralExpr.create(entry1.getValue().getContent(), Type.fromPrimitiveType(PrimitiveType.fromThrift(type))) : allConstMap.get(entry1.getKey());
                        tmp.put(entry1.getKey(), retExpr);
                    }
                    if (tmp.isEmpty()) continue;
                    resultMap.put(entry.getKey(), tmp);
                }
            } else {
                LOG.warn("failed to get const expr value from be: {}", (Object)result.getStatus().getErrorMsgsList());
            }
        }
        catch (Exception e) {
            LOG.warn("failed to get const expr value from be: {}", (Object)e.getMessage());
        }
        return resultMap;
    }
}

