/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.TimeZone;
import org.apache.doris.analysis.ArrayLiteral;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.InvalidFormatException;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.qe.GlobalVariable;
import org.apache.doris.rewrite.FEFunction;
import org.apache.doris.rewrite.FEFunctionList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class FEFunctions {
    private static final Logger LOG = LogManager.getLogger(FEFunctions.class);

    @FEFunction(name="version", argTypes={}, returnType="VARCHAR")
    public static StringLiteral version() throws AnalysisException {
        return new StringLiteral(GlobalVariable.version);
    }

    @FEFunction(name="timediff", argTypes={"DATETIME", "DATETIME"}, returnType="TIME")
    public static FloatLiteral timeDiff(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long firstTimestamp = ((DateLiteral)first).unixTimestamp(TimeUtils.getTimeZone());
        long secondTimestamp = ((DateLiteral)second).unixTimestamp(TimeUtils.getTimeZone());
        return new FloatLiteral((double)(firstTimestamp - secondTimestamp) / 1000.0, Type.TIME);
    }

    @FEFunction(name="datediff", argTypes={"DATETIME", "DATETIME"}, returnType="INT")
    public static IntLiteral dateDiff(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        DateLiteral firstDate = (DateLiteral)first;
        DateLiteral secondDate = (DateLiteral)second;
        firstDate.castToDate();
        secondDate.castToDate();
        long datediff = (firstDate.unixTimestamp(TimeUtils.getTimeZone()) - secondDate.unixTimestamp(TimeUtils.getTimeZone())) / 1000L / 60L / 60L / 24L;
        return new IntLiteral(datediff, (Type)Type.INT);
    }

    @FEFunction(name="date_add", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral dateAdd(LiteralExpr date, LiteralExpr day) throws AnalysisException {
        return FEFunctions.daysAdd(date, day);
    }

    @FEFunction(name="adddate", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral addDate(LiteralExpr date, LiteralExpr day) throws AnalysisException {
        return FEFunctions.daysAdd(date, day);
    }

    @FEFunction(name="years_add", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral yearsAdd(LiteralExpr date, LiteralExpr year) throws AnalysisException {
        DateLiteral dateLiteral = (DateLiteral)date;
        return dateLiteral.plusYears((int)year.getLongValue());
    }

    @FEFunction(name="months_add", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral monthsAdd(LiteralExpr date, LiteralExpr month) throws AnalysisException {
        DateLiteral dateLiteral = (DateLiteral)date;
        return dateLiteral.plusMonths((int)month.getLongValue());
    }

    @FEFunction(name="days_add", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral daysAdd(LiteralExpr date, LiteralExpr day) throws AnalysisException {
        DateLiteral dateLiteral = (DateLiteral)date;
        return dateLiteral.plusDays((int)day.getLongValue());
    }

    @FEFunction(name="hours_add", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral hoursAdd(LiteralExpr date, LiteralExpr hour) throws AnalysisException {
        DateLiteral dateLiteral = (DateLiteral)date;
        return dateLiteral.plusHours((int)hour.getLongValue());
    }

    @FEFunction(name="minutes_add", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral minutesAdd(LiteralExpr date, LiteralExpr minute) throws AnalysisException {
        DateLiteral dateLiteral = (DateLiteral)date;
        return dateLiteral.plusMinutes((int)minute.getLongValue());
    }

    @FEFunction(name="seconds_add", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral secondsAdd(LiteralExpr date, LiteralExpr second) throws AnalysisException {
        DateLiteral dateLiteral = (DateLiteral)date;
        return dateLiteral.plusSeconds((int)second.getLongValue());
    }

    @FEFunction(name="date_format", argTypes={"DATETIME", "VARCHAR"}, returnType="VARCHAR")
    public static StringLiteral dateFormat(LiteralExpr date, StringLiteral fmtLiteral) throws AnalysisException {
        String result = ((DateLiteral)date).dateFormat(fmtLiteral.getStringValue());
        return new StringLiteral(result);
    }

    @FEFunction(name="str_to_date", argTypes={"VARCHAR", "VARCHAR"}, returnType="DATETIME")
    public static DateLiteral dateParse(StringLiteral date, StringLiteral fmtLiteral) throws AnalysisException {
        DateLiteral dateLiteral = new DateLiteral();
        try {
            dateLiteral.fromDateFormatStr(fmtLiteral.getStringValue(), date.getStringValue(), false);
            return dateLiteral;
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            throw new AnalysisException(e.getMessage());
        }
    }

    @FEFunction(name="makedate", argTypes={"INT", "INT"}, returnType="DATETIME")
    public static DateLiteral makeDate(LiteralExpr date) throws AnalysisException {
        return (DateLiteral)date;
    }

    @FEFunction(name="date_sub", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral dateSub(LiteralExpr date, LiteralExpr day) throws AnalysisException {
        return FEFunctions.dateAdd(date, new IntLiteral(-((int)day.getLongValue())));
    }

    @FEFunction(name="years_sub", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral yearsSub(LiteralExpr date, LiteralExpr year) throws AnalysisException {
        return FEFunctions.yearsAdd(date, new IntLiteral(-((int)year.getLongValue())));
    }

    @FEFunction(name="months_sub", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral monthsSub(LiteralExpr date, LiteralExpr month) throws AnalysisException {
        return FEFunctions.monthsAdd(date, new IntLiteral(-((int)month.getLongValue())));
    }

    @FEFunction(name="days_sub", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral daysSub(LiteralExpr date, LiteralExpr day) throws AnalysisException {
        return FEFunctions.daysAdd(date, new IntLiteral(-((int)day.getLongValue())));
    }

    @FEFunction(name="hours_sub", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral hoursSub(LiteralExpr date, LiteralExpr hour) throws AnalysisException {
        return FEFunctions.hoursAdd(date, new IntLiteral(-((int)hour.getLongValue())));
    }

    @FEFunction(name="minutes_sub", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral minutesSub(LiteralExpr date, LiteralExpr minute) throws AnalysisException {
        return FEFunctions.minutesAdd(date, new IntLiteral(-((int)minute.getLongValue())));
    }

    @FEFunction(name="seconds_sub", argTypes={"DATETIME", "INT"}, returnType="DATETIME")
    public static DateLiteral secondsSub(LiteralExpr date, LiteralExpr second) throws AnalysisException {
        return FEFunctions.secondsAdd(date, new IntLiteral(-((int)second.getLongValue())));
    }

    @FEFunction(name="year", argTypes={"DATETIME"}, returnType="INT")
    public static IntLiteral year(LiteralExpr arg) throws AnalysisException {
        return new IntLiteral(((DateLiteral)arg).getYear(), (Type)Type.INT);
    }

    @FEFunction(name="month", argTypes={"DATETIME"}, returnType="INT")
    public static IntLiteral month(LiteralExpr arg) throws AnalysisException {
        return new IntLiteral(((DateLiteral)arg).getMonth(), (Type)Type.INT);
    }

    @FEFunction(name="day", argTypes={"DATETIME"}, returnType="INT")
    public static IntLiteral day(LiteralExpr arg) throws AnalysisException {
        return new IntLiteral(((DateLiteral)arg).getDay(), (Type)Type.INT);
    }

    @FEFunction(name="unix_timestamp", argTypes={"DATETIME"}, returnType="INT")
    public static IntLiteral unixTimestamp(LiteralExpr arg) throws AnalysisException {
        long unixTime = ((DateLiteral)arg).unixTimestamp(TimeUtils.getTimeZone()) / 1000L;
        unixTime = unixTime < 0L ? 0L : unixTime;
        unixTime = unixTime > Integer.MAX_VALUE ? 0L : unixTime;
        return new IntLiteral(unixTime, (Type)Type.INT);
    }

    @FEFunction(name="unix_timestamp", argTypes={"DATE"}, returnType="INT")
    public static IntLiteral unixTimestamp2(LiteralExpr arg) throws AnalysisException {
        long unixTime = ((DateLiteral)arg).unixTimestamp(TimeUtils.getTimeZone()) / 1000L;
        unixTime = unixTime < 0L ? 0L : unixTime;
        unixTime = unixTime > Integer.MAX_VALUE ? 0L : unixTime;
        return new IntLiteral(unixTime, (Type)Type.INT);
    }

    @FEFunction(name="from_unixtime", argTypes={"INT"}, returnType="VARCHAR")
    public static StringLiteral fromUnixTime(LiteralExpr unixTime) throws AnalysisException {
        if (unixTime.getLongValue() < 0L) {
            throw new AnalysisException("unixtime should larger than zero");
        }
        DateLiteral dl = new DateLiteral(unixTime.getLongValue() * 1000L, TimeUtils.getTimeZone(), Type.DATETIME);
        return new StringLiteral(dl.getStringValue());
    }

    @FEFunction(name="from_unixtime", argTypes={"INT", "VARCHAR"}, returnType="VARCHAR")
    public static StringLiteral fromUnixTime(LiteralExpr unixTime, StringLiteral fmtLiteral) throws AnalysisException {
        if (unixTime.getLongValue() < 0L) {
            throw new AnalysisException("unixtime should larger than zero");
        }
        DateLiteral dl = new DateLiteral(unixTime.getLongValue() * 1000L, TimeUtils.getTimeZone(), Type.DATETIME);
        return new StringLiteral(dl.dateFormat(fmtLiteral.getStringValue()));
    }

    @FEFunction(name="now", argTypes={}, returnType="DATETIME")
    public static DateLiteral now() throws AnalysisException {
        return new DateLiteral(LocalDateTime.now((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)TimeUtils.getTimeZone())), (Type)Type.DATETIME);
    }

    @FEFunction(name="current_timestamp", argTypes={}, returnType="DATETIME")
    public static DateLiteral currentTimestamp() throws AnalysisException {
        return FEFunctions.now();
    }

    @FEFunction(name="curdate", argTypes={}, returnType="DATE")
    public static DateLiteral curDate() throws AnalysisException {
        return new DateLiteral(LocalDateTime.now((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)TimeUtils.getTimeZone())), (Type)Type.DATE);
    }

    @FEFunction(name="curtime", argTypes={}, returnType="TIME")
    public static FloatLiteral curTime() throws AnalysisException {
        DateLiteral now = FEFunctions.now();
        return new FloatLiteral(Double.valueOf(now.getHour() * 3600L + now.getMinute() * 60L + now.getSecond()), Type.TIME);
    }

    @FEFunction(name="current_time", argTypes={}, returnType="TIME")
    public static FloatLiteral currentTime() throws AnalysisException {
        return FEFunctions.curTime();
    }

    @FEFunction(name="utc_timestamp", argTypes={}, returnType="DATETIME")
    public static DateLiteral utcTimestamp() throws AnalysisException {
        return new DateLiteral(LocalDateTime.now((DateTimeZone)DateTimeZone.forTimeZone((TimeZone)TimeUtils.getOrSystemTimeZone("+00:00"))), (Type)Type.DATETIME);
    }

    @FEFunction(name="yearweek", argTypes={"DATE"}, returnType="INT")
    public static IntLiteral yearWeek(LiteralExpr arg) throws AnalysisException {
        if (arg instanceof IntLiteral) {
            return (IntLiteral)arg;
        }
        return null;
    }

    @FEFunction(name="yearweek", argTypes={"DATE", "INT"}, returnType="INT")
    public static IntLiteral yearWeekMod(LiteralExpr arg) throws AnalysisException {
        if (arg instanceof IntLiteral) {
            return (IntLiteral)arg;
        }
        return null;
    }

    @FEFunction(name="week", argTypes={"DATE"}, returnType="INT")
    public static IntLiteral week(LiteralExpr arg) throws AnalysisException {
        if (arg instanceof IntLiteral) {
            return (IntLiteral)arg;
        }
        return null;
    }

    @FEFunction(name="week", argTypes={"DATE", "INT"}, returnType="INT")
    public static IntLiteral weekMode(LiteralExpr arg) throws AnalysisException {
        if (arg instanceof IntLiteral) {
            return (IntLiteral)arg;
        }
        return null;
    }

    @FEFunction(name="hour", argTypes={"DATETIME"}, returnType="INT")
    public static IntLiteral hour(LiteralExpr arg) throws AnalysisException {
        if (arg instanceof DateLiteral) {
            return new IntLiteral(((DateLiteral)arg).getHour());
        }
        return null;
    }

    @FEFunction(name="minute", argTypes={"DATETIME"}, returnType="INT")
    public static IntLiteral minute(LiteralExpr arg) throws AnalysisException {
        if (arg instanceof DateLiteral) {
            return new IntLiteral(((DateLiteral)arg).getMinute());
        }
        return null;
    }

    @FEFunction(name="second", argTypes={"DATETIME"}, returnType="INT")
    public static IntLiteral second(LiteralExpr arg) throws AnalysisException {
        if (arg instanceof DateLiteral) {
            return new IntLiteral(((DateLiteral)arg).getSecond());
        }
        return null;
    }

    @FEFunction(name="timestamp", argTypes={"DATETIME"}, returnType="DATETIME")
    public static DateLiteral timestamp(LiteralExpr arg) throws AnalysisException {
        if (arg instanceof DateLiteral) {
            return (DateLiteral)arg;
        }
        return null;
    }

    @FEFunction(name="floor", argTypes={"DOUBLE"}, returnType="BIGINT")
    public static IntLiteral floor(LiteralExpr expr) throws AnalysisException {
        long result = (long)Math.floor(expr.getDoubleValue());
        return new IntLiteral(result, (Type)Type.BIGINT);
    }

    @FEFunction(name="add", argTypes={"TINYINT", "TINYINT"}, returnType="SMALLINT")
    public static IntLiteral addTinyint(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.addExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.SMALLINT);
    }

    @FEFunction(name="add", argTypes={"SMALLINT", "SMALLINT"}, returnType="INT")
    public static IntLiteral addSmallint(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.addExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.INT);
    }

    @FEFunction(name="add", argTypes={"INT", "INT"}, returnType="BIGINT")
    public static IntLiteral addInt(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.addExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.BIGINT);
    }

    @FEFunction(name="add", argTypes={"BIGINT", "BIGINT"}, returnType="BIGINT")
    public static IntLiteral addBigint(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.addExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.BIGINT);
    }

    @FEFunction(name="add", argTypes={"DOUBLE", "DOUBLE"}, returnType="DOUBLE")
    public static FloatLiteral addDouble(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        double result = first.getDoubleValue() + second.getDoubleValue();
        return new FloatLiteral(result, Type.DOUBLE);
    }

    @FEFunction(name="add", argTypes={"DECIMALV2", "DECIMALV2"}, returnType="DECIMALV2")
    public static DecimalLiteral addDecimalV2(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        BigDecimal left = new BigDecimal(first.getStringValue());
        BigDecimal right = new BigDecimal(second.getStringValue());
        BigDecimal result = left.add(right);
        return new DecimalLiteral(result);
    }

    @FEFunction(name="add", argTypes={"LARGEINT", "LARGEINT"}, returnType="LARGEINT")
    public static LargeIntLiteral addBigInt(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        BigInteger left = new BigInteger(first.getStringValue());
        BigInteger right = new BigInteger(second.getStringValue());
        BigInteger result = left.add(right);
        return new LargeIntLiteral(result.toString());
    }

    @FEFunction(name="subtract", argTypes={"TINYINT", "TINYINT"}, returnType="SMALLINT")
    public static IntLiteral subtractTinyint(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.subtractExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.SMALLINT);
    }

    @FEFunction(name="subtract", argTypes={"SMALLINT", "SMALLINT"}, returnType="INT")
    public static IntLiteral subtractSmallint(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.subtractExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.INT);
    }

    @FEFunction(name="subtract", argTypes={"INT", "INT"}, returnType="BIGINT")
    public static IntLiteral subtractInt(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.subtractExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.BIGINT);
    }

    @FEFunction(name="subtract", argTypes={"BIGINT", "BIGINT"}, returnType="BIGINT")
    public static IntLiteral subtractBigint(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.subtractExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.BIGINT);
    }

    @FEFunction(name="subtract", argTypes={"DOUBLE", "DOUBLE"}, returnType="DOUBLE")
    public static FloatLiteral subtractDouble(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        double result = first.getDoubleValue() - second.getDoubleValue();
        return new FloatLiteral(result, Type.DOUBLE);
    }

    @FEFunction(name="subtract", argTypes={"DECIMALV2", "DECIMALV2"}, returnType="DECIMALV2")
    public static DecimalLiteral subtractDecimalV2(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        BigDecimal left = new BigDecimal(first.getStringValue());
        BigDecimal right = new BigDecimal(second.getStringValue());
        BigDecimal result = left.subtract(right);
        return new DecimalLiteral(result);
    }

    @FEFunction(name="subtract", argTypes={"LARGEINT", "LARGEINT"}, returnType="LARGEINT")
    public static LargeIntLiteral subtractBigInt(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        BigInteger left = new BigInteger(first.getStringValue());
        BigInteger right = new BigInteger(second.getStringValue());
        BigInteger result = left.subtract(right);
        return new LargeIntLiteral(result.toString());
    }

    @FEFunction(name="multiply", argTypes={"TINYINT", "TINYINT"}, returnType="SMALLINT")
    public static IntLiteral multiplyTinyint(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.multiplyExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.SMALLINT);
    }

    @FEFunction(name="multiply", argTypes={"SMALLINT", "SMALLINT"}, returnType="INT")
    public static IntLiteral multiplySmallint(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.multiplyExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.INT);
    }

    @FEFunction(name="multiply", argTypes={"INT", "INT"}, returnType="BIGINT")
    public static IntLiteral multiplyInt(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.multiplyExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.BIGINT);
    }

    @FEFunction(name="multiply", argTypes={"BIGINT", "BIGINT"}, returnType="BIGINT")
    public static IntLiteral multiplyBigint(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        long result = Math.multiplyExact(first.getLongValue(), second.getLongValue());
        return new IntLiteral(result, (Type)Type.BIGINT);
    }

    @FEFunction(name="multiply", argTypes={"DOUBLE", "DOUBLE"}, returnType="DOUBLE")
    public static FloatLiteral multiplyDouble(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        double result = first.getDoubleValue() * second.getDoubleValue();
        return new FloatLiteral(result, Type.DOUBLE);
    }

    @FEFunction(name="multiply", argTypes={"DECIMALV2", "DECIMALV2"}, returnType="DECIMALV2")
    public static DecimalLiteral multiplyDecimalV2(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        BigDecimal left = new BigDecimal(first.getStringValue());
        BigDecimal right = new BigDecimal(second.getStringValue());
        BigDecimal result = left.multiply(right);
        return new DecimalLiteral(result);
    }

    @FEFunction(name="multiply", argTypes={"LARGEINT", "LARGEINT"}, returnType="LARGEINT")
    public static LargeIntLiteral multiplyBigInt(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        BigInteger left = new BigInteger(first.getStringValue());
        BigInteger right = new BigInteger(second.getStringValue());
        BigInteger result = left.multiply(right);
        return new LargeIntLiteral(result.toString());
    }

    @FEFunction(name="divide", argTypes={"DOUBLE", "DOUBLE"}, returnType="DOUBLE")
    public static FloatLiteral divideDouble(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        if (second.getDoubleValue() == 0.0) {
            return null;
        }
        double result = first.getDoubleValue() / second.getDoubleValue();
        return new FloatLiteral(result, Type.DOUBLE);
    }

    @FEFunction(name="divide", argTypes={"DECIMALV2", "DECIMALV2"}, returnType="DECIMALV2")
    public static DecimalLiteral divideDecimalV2(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        BigDecimal left = new BigDecimal(first.getStringValue());
        BigDecimal right = new BigDecimal(second.getStringValue());
        if (right.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal result = left.divide(right);
        return new DecimalLiteral(result);
    }

    @FEFunction(name="concat", argTypes={"VARCHAR"}, returnType="VARCHAR")
    public static StringLiteral concat(StringLiteral ... values) throws AnalysisException {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0);
        StringBuilder resultBuilder = new StringBuilder();
        for (StringLiteral value : values) {
            resultBuilder.append(value.getStringValue());
        }
        return new StringLiteral(resultBuilder.toString());
    }

    @FEFunction(name="concat_ws", argTypes={"VARCHAR", "VARCHAR"}, returnType="VARCHAR")
    public static StringLiteral concat_ws(StringLiteral split, StringLiteral ... values) throws AnalysisException {
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0);
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = 0; i < values.length - 1; ++i) {
            resultBuilder.append(values[i].getStringValue()).append(split.getStringValue());
        }
        resultBuilder.append(values[values.length - 1].getStringValue());
        return new StringLiteral(resultBuilder.toString());
    }

    @FEFunctionList(value={@FEFunction(name="ifnull", argTypes={"VARCHAR", "VARCHAR"}, returnType="VARCHAR"), @FEFunction(name="ifnull", argTypes={"TINYINT", "TINYINT"}, returnType="TINYINT"), @FEFunction(name="ifnull", argTypes={"INT", "INT"}, returnType="INT"), @FEFunction(name="ifnull", argTypes={"BIGINT", "BIGINT"}, returnType="BIGINT"), @FEFunction(name="ifnull", argTypes={"DATETIME", "DATETIME"}, returnType="DATETIME"), @FEFunction(name="ifnull", argTypes={"DATE", "DATETIME"}, returnType="DATETIME"), @FEFunction(name="ifnull", argTypes={"DATETIME", "DATE"}, returnType="DATETIME")})
    public static LiteralExpr ifNull(LiteralExpr first, LiteralExpr second) throws AnalysisException {
        return first instanceof NullLiteral ? second : first;
    }

    @FEFunctionList(value={@FEFunction(name="array", argTypes={"INT"}, returnType="ARRAY"), @FEFunction(name="array", argTypes={"VARCHAR"}, returnType="ARRAY")})
    public static ArrayLiteral array(LiteralExpr ... exprs) throws AnalysisException {
        return new ArrayLiteral(exprs);
    }
}

