/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtractCommonFactorsRule
implements ExprRewriteRule {
    private static final Logger LOG = LogManager.getLogger(ExtractCommonFactorsRule.class);
    public static ExtractCommonFactorsRule INSTANCE = new ExtractCommonFactorsRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        if (expr == null) {
            return null;
        }
        if (expr instanceof CompoundPredicate && ((CompoundPredicate)expr).getOp() == CompoundPredicate.Operator.OR) {
            Expr rewrittenExpr = this.extractCommonFactors(this.exprFormatting((CompoundPredicate)expr), analyzer);
            if (rewrittenExpr != null) {
                return rewrittenExpr;
            }
        } else {
            for (int i = 0; i < expr.getChildren().size(); ++i) {
                Expr rewrittenExpr = this.apply((Expr)expr.getChild(i), analyzer, clauseType);
                if (rewrittenExpr == null) continue;
                expr.setChild(i, rewrittenExpr);
            }
        }
        return expr;
    }

    /*
     * WARNING - void declaration
     */
    private Expr extractCommonFactors(List<List<Expr>> exprs, Analyzer analyzer) {
        void var8_16;
        Expr wideCommonExpr;
        if (exprs.size() < 2) {
            return null;
        }
        LinkedHashSet set = new LinkedHashSet();
        for (List<Expr> list : exprs) {
            Set<Expr> es = new LinkedHashSet<Expr>();
            es.addAll(list);
            set.add(es);
        }
        ArrayList<List<Expr>> clearExprs = new ArrayList<List<Expr>>();
        for (Set<Expr> es : set) {
            ArrayList<Expr> el = new ArrayList<Expr>();
            el.addAll(es);
            clearExprs.add(el);
        }
        if (clearExprs.size() == 1) {
            return this.makeCompound((List)clearExprs.get(0), CompoundPredicate.Operator.AND);
        }
        ArrayList<Expr> arrayList = new ArrayList<Expr>((Collection)clearExprs.get(0));
        for (int i = 1; i < clearExprs.size(); ++i) {
            arrayList.retainAll((Collection)clearExprs.get(i));
        }
        boolean isReturnCommonFactorExpr = false;
        for (List list : clearExprs) {
            list.removeAll(arrayList);
            if (list.size() != 0) continue;
            isReturnCommonFactorExpr = true;
            break;
        }
        if (isReturnCommonFactorExpr) {
            Preconditions.checkState((!arrayList.isEmpty() ? 1 : 0) != 0);
            Expr result = this.makeCompound(arrayList, CompoundPredicate.Operator.AND);
            if (LOG.isDebugEnabled()) {
                LOG.debug("equal ors: " + result.toSql());
            }
            return result;
        }
        if (analyzer.getContext() != null && analyzer.getContext().getSessionVariable().isExtractWideRangeExpr() && (wideCommonExpr = this.findWideRangeExpr(clearExprs)) != null) {
            arrayList.add(wideCommonExpr);
        }
        ArrayList remainingOrClause = Lists.newArrayList();
        for (List list : clearExprs) {
            Preconditions.checkState((!list.isEmpty() ? 1 : 0) != 0);
            remainingOrClause.add(this.makeCompound(list, CompoundPredicate.Operator.AND));
        }
        Object var8_13 = null;
        if (CollectionUtils.isNotEmpty(arrayList)) {
            CompoundPredicate compoundPredicate = new CompoundPredicate(CompoundPredicate.Operator.AND, this.makeCompound(arrayList, CompoundPredicate.Operator.AND), this.makeCompound(remainingOrClause, CompoundPredicate.Operator.OR));
            compoundPredicate.setPrintSqlInParens(true);
        } else {
            Expr expr = this.makeCompound(remainingOrClause, CompoundPredicate.Operator.OR);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("equal ors: " + var8_16.toSql());
        }
        return var8_16;
    }

    /*
     * WARNING - void declaration
     */
    private Expr findWideRangeExpr(List<List<Expr>> exprList) {
        Map columnNameToIn;
        void var5_10;
        Map<SlotRef, InPredicate> map;
        void var6_18;
        Map map2;
        void var5_8;
        ArrayList columnNameToRangeList = Lists.newArrayList();
        ArrayList columnNameToInList = Lists.newArrayList();
        block2: for (List<Expr> list : exprList) {
            HashMap hashMap = Maps.newHashMap();
            HashMap columnNameToInPredicate = Maps.newHashMap();
            for (Expr predicate : list) {
                if (!this.singleColumnPredicate(predicate)) continue;
                SlotRef columnName = (SlotRef)predicate.getChild(0);
                if (predicate instanceof BinaryPredicate) {
                    Range predicateRange = ((BinaryPredicate)predicate).convertToRange();
                    if (predicateRange == null) continue;
                    Range range = (Range)hashMap.get(columnName);
                    if (range == null) {
                        range = predicateRange;
                    } else {
                        try {
                            range = range.intersection(predicateRange);
                        }
                        catch (ClassCastException | IllegalArgumentException e) {
                            LOG.debug("The range without intersection", (Throwable)e);
                            continue block2;
                        }
                    }
                    hashMap.put(columnName, range);
                    continue;
                }
                if (!(predicate instanceof InPredicate)) continue;
                InPredicate inPredicate = (InPredicate)predicate;
                InPredicate intersectInPredicate = (InPredicate)columnNameToInPredicate.get(columnName);
                intersectInPredicate = intersectInPredicate == null ? new InPredicate((Expr)inPredicate.getChild(0), inPredicate.getListChildren(), inPredicate.isNotIn()) : intersectInPredicate.intersection((InPredicate)predicate);
                columnNameToInPredicate.put(columnName, intersectInPredicate);
            }
            columnNameToRangeList.add(hashMap);
            columnNameToInList.add(columnNameToInPredicate);
        }
        Map<Object, Object> resultRangeMap = Maps.newHashMap();
        for (Map.Entry entry : ((Map)columnNameToRangeList.get(0)).entrySet()) {
            TreeRangeSet rangeSet = TreeRangeSet.create();
            rangeSet.add((Range)entry.getValue());
            resultRangeMap.put((SlotRef)entry.getKey(), rangeSet);
        }
        boolean bl = true;
        while (var5_8 < columnNameToRangeList.size() && !(resultRangeMap = this.mergeTwoClauseRange((Map<SlotRef, RangeSet<LiteralExpr>>)resultRangeMap, map2 = (Map)columnNameToRangeList.get((int)var5_8))).isEmpty()) {
            ++var5_8;
        }
        Map map3 = (Map)columnNameToInList.get(0);
        boolean bl2 = true;
        while (var6_18 < columnNameToRangeList.size() && !(map = this.mergeTwoClauseIn((Map<SlotRef, InPredicate>)var5_10, columnNameToIn = (Map)columnNameToInList.get((int)var6_18))).isEmpty()) {
            ++var6_18;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : resultRangeMap.entrySet()) {
            Expr wideRangeExpr = this.rangeSetToCompoundPredicate((SlotRef)entry.getKey(), (RangeSet<LiteralExpr>)((RangeSet)entry.getValue()));
            if (wideRangeExpr == null) continue;
            arrayList.add(wideRangeExpr);
        }
        arrayList.addAll(var5_10.values());
        return this.makeCompound(arrayList, CompoundPredicate.Operator.AND);
    }

    private boolean singleColumnPredicate(Expr expr) {
        ArrayList slotRefs = Lists.newArrayList();
        expr.collect(SlotRef.class, slotRefs);
        if (slotRefs.size() != 1) {
            return false;
        }
        if (expr instanceof InPredicate) {
            InPredicate inPredicate = (InPredicate)expr;
            if (!inPredicate.isLiteralChildren()) {
                return false;
            }
            if (inPredicate.isNotIn()) {
                return false;
            }
            return inPredicate.getChild(0) instanceof SlotRef;
        }
        if (expr instanceof BinaryPredicate) {
            BinaryPredicate binaryPredicate = (BinaryPredicate)expr;
            return binaryPredicate.getChild(0) instanceof SlotRef && binaryPredicate.getChild(1) instanceof LiteralExpr;
        }
        return false;
    }

    private Map<SlotRef, RangeSet<LiteralExpr>> mergeTwoClauseRange(Map<SlotRef, RangeSet<LiteralExpr>> clause1, Map<SlotRef, Range<LiteralExpr>> clause2) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<SlotRef, RangeSet<LiteralExpr>> clause1Entry : clause1.entrySet()) {
            SlotRef columnName = clause1Entry.getKey();
            Range<LiteralExpr> clause2Value = clause2.get(columnName);
            if (clause2Value == null) continue;
            try {
                clause1Entry.getValue().add(clause2Value);
            }
            catch (ClassCastException e) {
                LOG.debug("Abort this range of column" + columnName.toSqlImpl());
                continue;
            }
            result.put(columnName, clause1Entry.getValue());
        }
        return result;
    }

    private Map<SlotRef, InPredicate> mergeTwoClauseIn(Map<SlotRef, InPredicate> clause1, Map<SlotRef, InPredicate> clause2) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<SlotRef, InPredicate> clause1Entry : clause1.entrySet()) {
            SlotRef columnName = clause1Entry.getKey();
            InPredicate clause2Value = clause2.get(columnName);
            if (clause2Value == null) continue;
            InPredicate union = clause1Entry.getValue().union(clause2Value);
            result.put(columnName, union);
        }
        return result;
    }

    private List<List<Expr>> exprFormatting(CompoundPredicate expr) {
        ArrayList<List<Expr>> orExprs = new ArrayList<List<Expr>>();
        for (Expr child : expr.getChildren()) {
            if (child instanceof CompoundPredicate) {
                CompoundPredicate childCp = (CompoundPredicate)child;
                if (childCp.getOp() == CompoundPredicate.Operator.OR) {
                    orExprs.addAll(this.exprFormatting(childCp));
                    continue;
                }
                if (childCp.getOp() == CompoundPredicate.Operator.AND) {
                    orExprs.add(this.flatAndExpr(child));
                    continue;
                }
            }
            orExprs.add(Arrays.asList(child));
        }
        return orExprs;
    }

    private List<Expr> flatAndExpr(Expr expr) {
        ArrayList<Expr> andExprs = new ArrayList<Expr>();
        if (expr instanceof CompoundPredicate && ((CompoundPredicate)expr).getOp() == CompoundPredicate.Operator.AND) {
            andExprs.addAll(this.flatAndExpr((Expr)expr.getChild(0)));
            andExprs.addAll(this.flatAndExpr((Expr)expr.getChild(1)));
        } else {
            andExprs.add(expr);
        }
        return andExprs;
    }

    private Expr makeCompound(List<Expr> exprs, CompoundPredicate.Operator op) {
        if (CollectionUtils.isEmpty(exprs)) {
            return null;
        }
        if (exprs.size() == 1) {
            return exprs.get(0);
        }
        CompoundPredicate result = new CompoundPredicate(op, exprs.get(0), exprs.get(1));
        for (int i = 2; i < exprs.size(); ++i) {
            result = new CompoundPredicate(op, result.clone(), exprs.get(i));
        }
        result.setPrintSqlInParens(true);
        return result;
    }

    public Expr rangeSetToCompoundPredicate(SlotRef slotRef, RangeSet<LiteralExpr> rangeSet) {
        ArrayList compoundList = Lists.newArrayList();
        for (Range range : rangeSet.asRanges()) {
            LiteralExpr lowerBound = null;
            LiteralExpr upperBound = null;
            if (range.hasLowerBound()) {
                lowerBound = (LiteralExpr)range.lowerEndpoint();
            }
            if (range.hasUpperBound()) {
                upperBound = (LiteralExpr)range.upperEndpoint();
            }
            if (lowerBound == null && upperBound == null) continue;
            if (lowerBound != null && upperBound != null && lowerBound.equals(upperBound)) {
                compoundList.add(new BinaryPredicate(BinaryPredicate.Operator.EQ, slotRef, lowerBound));
                continue;
            }
            ArrayList binaryPredicateList = Lists.newArrayList();
            if (lowerBound != null) {
                if (range.lowerBoundType() == BoundType.OPEN) {
                    binaryPredicateList.add(new BinaryPredicate(BinaryPredicate.Operator.GT, slotRef, lowerBound));
                } else {
                    binaryPredicateList.add(new BinaryPredicate(BinaryPredicate.Operator.GE, slotRef, lowerBound));
                }
            }
            if (upperBound != null) {
                if (range.upperBoundType() == BoundType.OPEN) {
                    binaryPredicateList.add(new BinaryPredicate(BinaryPredicate.Operator.LT, slotRef, upperBound));
                } else {
                    binaryPredicateList.add(new BinaryPredicate(BinaryPredicate.Operator.LE, slotRef, upperBound));
                }
            }
            compoundList.add(this.makeCompound(binaryPredicateList, CompoundPredicate.Operator.AND));
        }
        return this.makeCompound(compoundList, CompoundPredicate.Operator.OR);
    }
}

