/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.FoldConstantsRule;

public class ExprRewriter {
    private int numChanges_ = 0;
    private final List<ExprRewriteRule> rules_;
    private List<ExprRewriteRule> onceRules_ = Lists.newArrayList();

    public ExprRewriter(List<ExprRewriteRule> rules) {
        this.rules_ = rules;
    }

    public ExprRewriter(List<ExprRewriteRule> rules, List<ExprRewriteRule> onceRules) {
        this.rules_ = rules;
        this.onceRules_ = onceRules;
    }

    public ExprRewriter(ExprRewriteRule rule) {
        this.rules_ = Lists.newArrayList((Object[])new ExprRewriteRule[]{rule});
    }

    public Expr rewrite(Expr expr, Analyzer analyzer) throws AnalysisException {
        ClauseType clauseType = ClauseType.OTHER_CLAUSE;
        return this.rewrite(expr, analyzer, clauseType);
    }

    public Expr rewrite(Expr expr, Analyzer analyzer, ClauseType clauseType) throws AnalysisException {
        int oldNumChanges;
        Expr rewrittenExpr = expr;
        do {
            oldNumChanges = this.numChanges_;
            for (ExprRewriteRule rule : this.rules_) {
                if (rule instanceof FoldConstantsRule && analyzer.safeIsEnableFoldConstantByBe()) continue;
                rewrittenExpr = this.applyRuleRepeatedly(rewrittenExpr, rule, analyzer, clauseType);
            }
        } while (oldNumChanges != this.numChanges_);
        for (ExprRewriteRule rule : this.onceRules_) {
            rewrittenExpr = this.applyRuleOnce(rewrittenExpr, rule, analyzer, clauseType);
        }
        return rewrittenExpr;
    }

    private Expr applyRuleOnce(Expr expr, ExprRewriteRule rule, Analyzer analyzer, ClauseType clauseType) throws AnalysisException {
        Expr rewrittenExpr = rule.apply(expr, analyzer, clauseType);
        if (rewrittenExpr != expr) {
            ++this.numChanges_;
        }
        return rewrittenExpr;
    }

    public void rewriteConstant(Map<String, Expr> exprMap, Analyzer analyzer) throws AnalysisException {
        if (exprMap.isEmpty()) {
            return;
        }
        boolean changed = false;
        for (ExprRewriteRule rule : this.rules_) {
            if (!(rule instanceof FoldConstantsRule)) continue;
            changed = ((FoldConstantsRule)rule).apply(exprMap, analyzer, changed);
        }
        if (changed) {
            ++this.numChanges_;
        }
    }

    private Expr applyRuleRepeatedly(Expr expr, ExprRewriteRule rule, Analyzer analyzer, ClauseType clauseType) throws AnalysisException {
        int oldNumChanges;
        Expr rewrittenExpr = expr;
        do {
            oldNumChanges = this.numChanges_;
            rewrittenExpr = this.applyRuleBottomUp(rewrittenExpr, rule, analyzer, clauseType);
        } while (oldNumChanges != this.numChanges_);
        return rewrittenExpr;
    }

    private Expr applyRuleBottomUp(Expr expr, ExprRewriteRule rule, Analyzer analyzer, ClauseType clauseType) throws AnalysisException {
        for (int i = 0; i < expr.getChildren().size(); ++i) {
            expr.setChild(i, this.applyRuleBottomUp((Expr)expr.getChild(i), rule, analyzer, clauseType));
        }
        Expr rewrittenExpr = rule.apply(expr, analyzer, clauseType);
        if (rewrittenExpr != expr) {
            ++this.numChanges_;
        }
        return rewrittenExpr;
    }

    public void rewriteList(List<Expr> exprs, Analyzer analyzer) throws AnalysisException {
        for (int i = 0; i < exprs.size(); ++i) {
            exprs.set(i, this.rewrite(exprs.get(i), analyzer));
        }
    }

    public void reset() {
        this.numChanges_ = 0;
    }

    public boolean changed() {
        return this.numChanges_ > 0;
    }

    public int getNumChanges() {
        return this.numChanges_;
    }

    public static enum ClauseType {
        ON_CLAUSE,
        WHERE_CLAUSE,
        OTHER_CLAUSE;

    }
}

