/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import java.util.ArrayList;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public class CompoundPredicateWriteRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new CompoundPredicateWriteRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        boolean rightChildFalse;
        if (!(expr instanceof CompoundPredicate)) {
            return expr;
        }
        CompoundPredicate cp = (CompoundPredicate)expr;
        ArrayList children = cp.getChildren();
        if (children.size() != 2) {
            return expr;
        }
        Expr leftChild = (Expr)cp.getChild(0);
        Expr rightChild = (Expr)cp.getChild(1);
        boolean and = cp.getOp() == CompoundPredicate.Operator.AND;
        boolean or = cp.getOp() == CompoundPredicate.Operator.OR;
        boolean leftChildTrue = leftChild instanceof BoolLiteral && ((BoolLiteral)leftChild).getValue();
        boolean leftChildFalse = leftChild instanceof BoolLiteral && !((BoolLiteral)leftChild).getValue();
        boolean rightChildTrue = rightChild instanceof BoolLiteral && ((BoolLiteral)rightChild).getValue();
        boolean bl = rightChildFalse = rightChild instanceof BoolLiteral && !((BoolLiteral)rightChild).getValue();
        if (leftChildTrue && and) {
            return rightChild;
        }
        if (and && rightChildTrue) {
            return leftChild;
        }
        if (leftChildFalse && or) {
            return rightChild;
        }
        if (or && rightChildFalse) {
            return leftChild;
        }
        if (leftChildFalse && and) {
            return new BoolLiteral(false);
        }
        if (and && rightChildFalse) {
            return new BoolLiteral(false);
        }
        if (leftChildTrue && or) {
            return new BoolLiteral(true);
        }
        if (or && rightChildTrue) {
            return new BoolLiteral(true);
        }
        return expr;
    }
}

