/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BetweenPredicate;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public final class BetweenToCompoundRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new BetweenToCompoundRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        if (!(expr instanceof BetweenPredicate)) {
            return expr;
        }
        BetweenPredicate bp = (BetweenPredicate)expr;
        CompoundPredicate result = null;
        if (bp.isNotBetween()) {
            BinaryPredicate lower = new BinaryPredicate(BinaryPredicate.Operator.LT, (Expr)bp.getChild(0), (Expr)bp.getChild(1));
            BinaryPredicate upper = new BinaryPredicate(BinaryPredicate.Operator.GT, (Expr)bp.getChild(0), (Expr)bp.getChild(2));
            result = new CompoundPredicate(CompoundPredicate.Operator.OR, lower, upper);
        } else {
            BinaryPredicate lower = new BinaryPredicate(BinaryPredicate.Operator.GE, (Expr)bp.getChild(0), (Expr)bp.getChild(1));
            BinaryPredicate upper = new BinaryPredicate(BinaryPredicate.Operator.LE, (Expr)bp.getChild(0), (Expr)bp.getChild(2));
            result = new CompoundPredicate(CompoundPredicate.Operator.AND, lower, upper);
        }
        return result;
    }

    private BetweenToCompoundRule() {
    }
}

