/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.resource;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.resource.Tag;

public class TagSet
implements Writable {
    public static final TagSet EMPTY_TAGSET = new TagSet();
    @SerializedName(value="tags")
    private Set<Tag> tags = Sets.newHashSet();

    private TagSet() {
    }

    private TagSet(TagSet other) {
        for (Tag tag : other.getAllTags()) {
            this.tags.add(tag);
        }
    }

    public static TagSet create(Map<String, String> tagsMap) throws AnalysisException {
        TagSet tagSet = new TagSet();
        for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
            String[] tagParts;
            String typeStr = entry.getKey();
            String tagsStr = entry.getValue();
            for (String tagPart : tagParts = tagsStr.split(",")) {
                Tag tag = Tag.create(typeStr, tagPart.trim());
                tagSet.addTag(tag);
            }
        }
        return tagSet;
    }

    public static TagSet create(String type, String tagName) throws AnalysisException {
        TagSet tagSet = new TagSet();
        Tag tag = Tag.create(type, tagName.trim());
        tagSet.addTag(tag);
        return tagSet;
    }

    public static TagSet create(Tag ... tags) {
        TagSet tagSet = new TagSet();
        for (Tag tag : tags) {
            tagSet.addTag(tag);
        }
        return tagSet;
    }

    public static TagSet copyFrom(TagSet other) {
        TagSet tagSet = new TagSet();
        for (Tag tag : other.tags) {
            tagSet.addTag(tag);
        }
        return tagSet;
    }

    public boolean addTag(Tag tag) {
        return this.tags.add(tag);
    }

    public boolean deleteTag(Tag tag) {
        return this.tags.remove(tag);
    }

    public TagSet getTagsByType(String type) {
        type = type.toLowerCase();
        TagSet tagSet = new TagSet();
        for (Tag tag : this.tags) {
            if (!tag.type.equals(type)) continue;
            tagSet.addTag(tag);
        }
        return tagSet;
    }

    public boolean containsTag(Tag tag) {
        return this.tags.contains(tag);
    }

    public void union(TagSet other) {
        for (Tag tag : other.tags) {
            this.addTag(tag);
        }
    }

    public Set<String> getTypes() {
        HashSet set = Sets.newHashSet();
        for (Tag tag : this.tags) {
            set.add(tag.type);
        }
        return set;
    }

    private void deleteType(String type) {
        String lowerType = type.toLowerCase();
        this.tags = this.tags.stream().filter(t -> !t.type.equals(lowerType)).collect(Collectors.toSet());
    }

    public void substituteMerge(TagSet other) {
        Set<String> types = other.getTypes();
        for (String type : types) {
            this.deleteType(type);
            this.union(other.getTagsByType(type));
        }
    }

    public Set<Tag> getAllTags() {
        return this.tags;
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public String toString() {
        HashMap map = Maps.newHashMap();
        Gson gson = new Gson();
        for (String type : this.getTypes()) {
            TagSet tagSet = this.getTagsByType(type);
            if (tagSet.isEmpty()) continue;
            map.put(type, Joiner.on((String)",").join((Iterable)tagSet.getAllTags().stream().map(t -> t.value).collect(Collectors.toList())));
        }
        return gson.toJson((Object)map);
    }

    public int hashCode() {
        return Objects.hash(this.tags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TagSet)) {
            return false;
        }
        TagSet tagSet = (TagSet)obj;
        return this.tags.equals(tagSet.tags);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static TagSet read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (TagSet)GsonUtils.GSON.fromJson(json, TagSet.class);
    }
}

