/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.resource;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.resource.Tag;
import org.apache.doris.resource.TagSet;

public class TagManager
implements Writable {
    private HashMultimap<Tag, Long> tagIndex = HashMultimap.create();
    @SerializedName(value="resourceIndex")
    private Map<Long, TagSet> resourceIndex = Maps.newHashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addResourceTag(Long resourceId, Tag tag) {
        this.lock.writeLock().lock();
        try {
            if (this.resourceIndex.containsKey(resourceId)) {
                this.resourceIndex.get(resourceId).addTag(tag);
            } else {
                this.resourceIndex.put(resourceId, TagSet.create(tag));
            }
            boolean bl = this.tagIndex.put((Object)tag, (Object)resourceId);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceTags(Long resourceId, TagSet tagSet) {
        if (tagSet.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            TagSet existTagSet = this.resourceIndex.get(resourceId);
            if (existTagSet == null) {
                existTagSet = TagSet.create(new Tag[0]);
                this.resourceIndex.put(resourceId, existTagSet);
            }
            existTagSet.union(tagSet);
            for (Tag tag : tagSet.getAllTags()) {
                this.tagIndex.put((Object)tag, (Object)resourceId);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeResource(Long resourceId) {
        this.lock.writeLock().lock();
        try {
            TagSet tagSet = this.resourceIndex.remove(resourceId);
            if (tagSet != null) {
                for (Tag tag : tagSet.getAllTags()) {
                    this.tagIndex.remove((Object)tag, (Object)resourceId);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeResourceTag(Long resourceId, Tag tag) {
        this.lock.writeLock().lock();
        try {
            if (this.resourceIndex.containsKey(resourceId)) {
                TagSet tagSet = this.resourceIndex.get(resourceId);
                boolean res = tagSet.deleteTag(tag);
                if (tagSet.isEmpty()) {
                    this.resourceIndex.remove(resourceId);
                }
                this.tagIndex.remove((Object)tag, (Object)resourceId);
                boolean bl = res;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceTags(Long resourceId, TagSet tagSet) {
        this.lock.writeLock().lock();
        try {
            if (this.resourceIndex.containsKey(resourceId)) {
                TagSet existingTagSet = this.resourceIndex.get(resourceId);
                for (Tag tag : tagSet.getAllTags()) {
                    existingTagSet.deleteTag(tag);
                    this.tagIndex.remove((Object)tag, (Object)resourceId);
                }
                if (tagSet.isEmpty()) {
                    this.resourceIndex.remove(resourceId);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<Long> getResourceIdsByTag(Tag tag) {
        this.lock.readLock().lock();
        try {
            HashSet hashSet = Sets.newHashSet((Iterable)this.tagIndex.get((Object)tag));
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getResourceIdsByTags(TagSet tagSet) {
        if (tagSet.isEmpty()) {
            return Sets.newHashSet();
        }
        this.lock.readLock().lock();
        try {
            HashSet res = null;
            Set<Tag> tags = tagSet.getAllTags();
            for (Tag tag : tags) {
                if (res == null) {
                    res = Sets.newHashSet((Iterable)this.tagIndex.get((Object)tag));
                } else {
                    res.retainAll(this.tagIndex.get((Object)tag));
                }
                if (!res.isEmpty()) continue;
                break;
            }
            HashSet hashSet = res == null ? Sets.newHashSet() : res;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void rebuildTagIndex() {
        for (Map.Entry<Long, TagSet> entry : this.resourceIndex.entrySet()) {
            long resourceId = entry.getKey();
            for (Tag tag : entry.getValue().getAllTags()) {
                this.tagIndex.put((Object)tag, (Object)resourceId);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static TagManager read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        TagManager tagManager = (TagManager)GsonUtils.GSON.fromJson(json, TagManager.class);
        tagManager.rebuildTagIndex();
        return tagManager;
    }
}

