/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.resource;

import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class Tag
implements Writable {
    public static final String TYPE_ROLE = "role";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_LOCATION = "location";
    public static final String VALUE_FRONTEND = "frontend";
    public static final String VALUE_BACKEND = "backend";
    public static final String VALUE_BROKER = "broker";
    public static final String VALUE_REMOTE_STORAGE = "remote_storage";
    public static final String VALUE_STORE = "store";
    public static final String VALUE_COMPUTATION = "computation";
    public static final String VALUE_DEFAULT_CLUSTER = "default_cluster";
    public static final String VALUE_DEFAULT_TAG = "default";
    public static final String VALUE_INVALID_TAG = "invalid";
    public static final ImmutableSet<String> RESERVED_TAG_TYPE = ImmutableSet.of((Object)"role", (Object)"function", (Object)"location");
    public static final ImmutableSet<String> RESERVED_TAG_VALUES = ImmutableSet.of((Object)"frontend", (Object)"backend", (Object)"broker", (Object)"remote_storage", (Object)"store", (Object)"computation", (Object[])new String[]{"default_cluster"});
    private static final String TAG_REGEX = "^[a-z][a-z0-9_]{0,32}$";
    public static final Tag DEFAULT_BACKEND_TAG = new Tag("location", "default");
    public static final Tag INVALID_TAG = new Tag("location", "invalid");
    @SerializedName(value="type")
    public String type;
    @SerializedName(value="value")
    public String value;

    private Tag(String type, String val) {
        this.type = type.toLowerCase();
        this.value = val.toLowerCase();
    }

    public static Tag create(String type, String value) throws AnalysisException {
        if (!type.matches(TAG_REGEX) || !value.matches(TAG_REGEX)) {
            throw new AnalysisException("Invalid tag format: " + type + ":" + value);
        }
        return new Tag(type, value);
    }

    public String toKey() {
        return this.type + "_" + this.value;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Tag)) {
            return false;
        }
        Tag otherTag = (Tag)other;
        return this.type.equals(otherTag.type) && this.value.equals(otherTag.value);
    }

    public String toString() {
        return "{\"" + this.type + "\" : \"" + this.value + "\"}";
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static Tag read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (Tag)GsonUtils.GSON.fromJson(json, Tag.class);
    }
}

