/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe.cache;

import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.common.Status;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.proto.InternalService;
import org.apache.doris.proto.Types;
import org.apache.doris.qe.RowBatch;
import org.apache.doris.qe.cache.Cache;
import org.apache.doris.qe.cache.CacheAnalyzer;
import org.apache.doris.qe.cache.CacheBeProxy;
import org.apache.doris.qe.cache.CacheProxy;
import org.apache.doris.qe.cache.RowBatchBuilder;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlCache
extends Cache {
    private static final Logger LOG = LogManager.getLogger(SqlCache.class);

    public SqlCache(TUniqueId queryId, SelectStmt selectStmt) {
        super(queryId, selectStmt);
    }

    public void setCacheInfo(CacheAnalyzer.CacheTable latestTable, String allViewExpandStmtListStr) {
        this.latestTable = latestTable;
        this.allViewExpandStmtListStr = allViewExpandStmtListStr;
    }

    public String getSqlWithViewStmt() {
        return this.selectStmt.toSql() + "|" + this.allViewExpandStmtListStr;
    }

    public Types.PUniqueId getSqlKey() {
        return CacheProxy.getMd5(this.getSqlWithViewStmt());
    }

    @Override
    public InternalService.PFetchCacheResult getCacheData(Status status) {
        InternalService.PFetchCacheRequest request = InternalService.PFetchCacheRequest.newBuilder().setSqlKey(CacheProxy.getMd5(this.getSqlWithViewStmt())).addParams(InternalService.PCacheParam.newBuilder().setPartitionKey(this.latestTable.latestPartitionId).setLastVersion(this.latestTable.latestVersion).setLastVersionTime(this.latestTable.latestTime)).build();
        InternalService.PFetchCacheResult cacheResult = this.proxy.fetchCache(request, 10000, status);
        if (status.ok() && cacheResult != null && cacheResult.getStatus() == InternalService.PCacheStatus.CACHE_OK) {
            cacheResult = cacheResult.toBuilder().setAllCount(1L).build();
            MetricRepo.COUNTER_CACHE_HIT_SQL.increase(1L);
            this.hitRange = Cache.HitRange.Full;
        }
        return cacheResult;
    }

    @Override
    public SelectStmt getRewriteStmt() {
        return null;
    }

    @Override
    public void copyRowBatch(RowBatch rowBatch) {
        if (this.rowBatchBuilder == null) {
            this.rowBatchBuilder = new RowBatchBuilder(CacheAnalyzer.CacheMode.Sql);
        }
        this.rowBatchBuilder.copyRowData(rowBatch);
    }

    @Override
    public void updateCache() {
        if (!super.checkRowLimit()) {
            return;
        }
        InternalService.PUpdateCacheRequest updateRequest = this.rowBatchBuilder.buildSqlUpdateRequest(this.getSqlWithViewStmt(), this.latestTable.latestPartitionId, this.latestTable.latestVersion, this.latestTable.latestTime);
        if (updateRequest.getValuesCount() > 0) {
            CacheBeProxy proxy = new CacheBeProxy();
            Status status = new Status();
            proxy.updateCache(updateRequest, CacheProxy.UPDATE_TIMEOUT, status);
            int rowCount = 0;
            int dataSize = 0;
            for (InternalService.PCacheValue value : updateRequest.getValuesList()) {
                rowCount += value.getRowsCount();
                dataSize += value.getDataSize();
            }
            LOG.info("update cache model {}, queryid {}, sqlkey {}, value count {}, row count {}, data size {}", (Object)CacheAnalyzer.CacheMode.Sql, (Object)DebugUtil.printId(this.queryId), (Object)DebugUtil.printId(updateRequest.getSqlKey()), (Object)updateRequest.getValuesCount(), (Object)rowCount, (Object)dataSize);
        }
    }
}

