/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe.cache;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Expr;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Type;
import org.apache.doris.proto.InternalService;
import org.apache.doris.qe.RowBatch;
import org.apache.doris.qe.cache.CacheAnalyzer;
import org.apache.doris.qe.cache.CacheProxy;
import org.apache.doris.qe.cache.PartitionRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RowBatchBuilder {
    private static final Logger LOG = LogManager.getLogger(RowBatchBuilder.class);
    private InternalService.PUpdateCacheRequest updateRequest;
    private CacheAnalyzer.CacheMode cacheMode;
    private int keyIndex;
    private Type keyType;
    private HashMap<Long, PartitionRange.PartitionSingle> cachePartMap;
    private List<byte[]> rowList;
    private int batchSize;
    private int rowSize;
    private int dataSize;

    public int getRowSize() {
        return this.rowSize;
    }

    public RowBatchBuilder(CacheAnalyzer.CacheMode model) {
        this.cacheMode = model;
        this.keyIndex = 0;
        this.keyType = Type.INVALID;
        this.rowList = Lists.newArrayList();
        this.cachePartMap = new HashMap();
        this.batchSize = 0;
        this.rowSize = 0;
        this.dataSize = 0;
    }

    public void buildPartitionIndex(ArrayList<Expr> resultExpr, List<String> columnLabel, Column partColumn, List<PartitionRange.PartitionSingle> newSingleList) {
        if (this.cacheMode != CacheAnalyzer.CacheMode.Partition) {
            return;
        }
        for (int i = 0; i < columnLabel.size(); ++i) {
            if (!columnLabel.get(i).equalsIgnoreCase(partColumn.getName())) continue;
            this.keyType = resultExpr.get(i).getType();
            this.keyIndex = i;
            break;
        }
        if (newSingleList != null) {
            for (PartitionRange.PartitionSingle single : newSingleList) {
                this.cachePartMap.put(single.getCacheKey().realValue(), single);
            }
        } else {
            LOG.info("no new partition single list ");
        }
    }

    public void copyRowData(RowBatch rowBatch) {
        ++this.batchSize;
        this.rowSize += rowBatch.getBatch().getRowsSize();
        for (ByteBuffer buf : rowBatch.getBatch().getRows()) {
            byte[] bytes = Arrays.copyOfRange(buf.array(), buf.position(), buf.limit());
            this.dataSize += bytes.length;
            this.rowList.add(bytes);
        }
    }

    public InternalService.PUpdateCacheRequest buildSqlUpdateRequest(String sql, long partitionKey, long lastVersion, long lastestTime) {
        if (this.updateRequest == null) {
            this.updateRequest = InternalService.PUpdateCacheRequest.newBuilder().setSqlKey(CacheProxy.getMd5(sql)).setCacheType(InternalService.CacheType.SQL_CACHE).build();
        }
        this.updateRequest = this.updateRequest.toBuilder().addValues(InternalService.PCacheValue.newBuilder().setParam(InternalService.PCacheParam.newBuilder().setPartitionKey(partitionKey).setLastVersion(lastVersion).setLastVersionTime(lastestTime).build()).setDataSize(this.dataSize).addAllRows(this.rowList.stream().map(row -> ByteString.copyFrom((byte[])row)).collect(Collectors.toList()))).build();
        return this.updateRequest;
    }

    public PartitionRange.PartitionKeyType getKeyFromRow(byte[] row, int index, Type type) {
        PartitionRange.PartitionKeyType key = new PartitionRange.PartitionKeyType();
        ByteBuffer buf = ByteBuffer.wrap(row);
        for (int i = 0; i <= index; ++i) {
            byte len = buf.get();
            if (i < index) {
                buf.position(buf.position() + len);
            }
            if (i != index) continue;
            byte[] content = Arrays.copyOfRange(buf.array(), buf.position(), buf.position() + len);
            String str = new String(content);
            key.init(type, str);
        }
        return key;
    }

    public InternalService.PUpdateCacheRequest buildPartitionUpdateRequest(String sql) {
        List partitionRowList;
        if (this.updateRequest == null) {
            this.updateRequest = InternalService.PUpdateCacheRequest.newBuilder().setSqlKey(CacheProxy.getMd5(sql)).setCacheType(InternalService.CacheType.PARTITION_CACHE).build();
        }
        HashMap<Long, List> partRowMap = new HashMap<Long, List>();
        for (byte[] byArray : this.rowList) {
            PartitionRange.PartitionKeyType cacheKey = this.getKeyFromRow(byArray, this.keyIndex, this.keyType);
            if (!this.cachePartMap.containsKey(cacheKey.realValue())) {
                LOG.info("cant find partition key {}", (Object)cacheKey.realValue());
                continue;
            }
            if (!partRowMap.containsKey(cacheKey.realValue())) {
                partitionRowList = Lists.newArrayList();
                partitionRowList.add(byArray);
                partRowMap.put(cacheKey.realValue(), partitionRowList);
                continue;
            }
            ((List)partRowMap.get(cacheKey.realValue())).add(byArray);
        }
        for (Map.Entry entry : partRowMap.entrySet()) {
            Long key = (Long)entry.getKey();
            PartitionRange.PartitionSingle partition = this.cachePartMap.get(key);
            partitionRowList = (List)entry.getValue();
            int data_size = 0;
            for (byte[] buf : partitionRowList) {
                data_size += buf.length;
            }
            this.updateRequest = this.updateRequest.toBuilder().addValues(InternalService.PCacheValue.newBuilder().setParam(InternalService.PCacheParam.newBuilder().setPartitionKey(key).setLastVersion(partition.getPartition().getVisibleVersion()).setLastVersionTime(partition.getPartition().getVisibleVersionTime()).build()).setDataSize(this.dataSize).addAllRows(partitionRowList.stream().map(row -> ByteString.copyFrom((byte[])row)).collect(Collectors.toList()))).build();
        }
        return this.updateRequest;
    }
}

