/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe.cache;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.PartitionValue;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.RangePartitionItem;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.planner.PartitionColumnFilter;
import org.apache.doris.qe.cache.Cache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionRange {
    private static final Logger LOG = LogManager.getLogger(PartitionRange.class);
    private CompoundPredicate partitionKeyPredicate;
    private OlapTable olapTable;
    private RangePartitionInfo rangePartitionInfo;
    private Column partitionColumn;
    private List<PartitionSingle> partitionSingleList;

    public CompoundPredicate getPartitionKeyPredicate() {
        return this.partitionKeyPredicate;
    }

    public void setPartitionKeyPredicate(CompoundPredicate partitionKeyPredicate) {
        this.partitionKeyPredicate = partitionKeyPredicate;
    }

    public RangePartitionInfo getRangePartitionInfo() {
        return this.rangePartitionInfo;
    }

    public void setRangePartitionInfo(RangePartitionInfo rangePartitionInfo) {
        this.rangePartitionInfo = rangePartitionInfo;
    }

    public Column getPartitionColumn() {
        return this.partitionColumn;
    }

    public void setPartitionColumn(Column partitionColumn) {
        this.partitionColumn = partitionColumn;
    }

    public List<PartitionSingle> getPartitionSingleList() {
        return this.partitionSingleList;
    }

    public PartitionRange() {
    }

    public PartitionRange(CompoundPredicate partitionKeyPredicate, OlapTable olapTable, RangePartitionInfo rangePartitionInfo) {
        this.partitionKeyPredicate = partitionKeyPredicate;
        this.olapTable = olapTable;
        this.rangePartitionInfo = rangePartitionInfo;
        this.partitionSingleList = Lists.newArrayList();
    }

    public boolean analytics() {
        if (this.rangePartitionInfo.getPartitionColumns().size() != 1) {
            return false;
        }
        this.partitionColumn = this.rangePartitionInfo.getPartitionColumns().get(0);
        PartitionColumnFilter filter = this.createPartitionFilter(this.partitionKeyPredicate, this.partitionColumn);
        try {
            if (!this.buildPartitionKeyRange(filter, this.partitionColumn)) {
                return false;
            }
            this.getTablePartitionList(this.olapTable);
        }
        catch (AnalysisException e) {
            LOG.warn("get partition range failed, because:", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean setCacheFlag(long cacheKey) {
        boolean find = false;
        for (PartitionSingle single : this.partitionSingleList) {
            if (single.getCacheKey().realValue() != cacheKey) continue;
            single.setFromCache(true);
            find = true;
            break;
        }
        return find;
    }

    public boolean setTooNewByID(long partitionId) {
        boolean find = false;
        for (PartitionSingle single : this.partitionSingleList) {
            if (single.getPartition().getId() != partitionId) continue;
            single.setTooNew(true);
            find = true;
            break;
        }
        return find;
    }

    public boolean setTooNewByKey(long cacheKey) {
        boolean find = false;
        for (PartitionSingle single : this.partitionSingleList) {
            if (single.getCacheKey().realValue() != cacheKey) continue;
            single.setTooNew(true);
            find = true;
            break;
        }
        return find;
    }

    public Cache.HitRange buildDiskPartitionRange(List<PartitionSingle> rangeList) {
        Cache.HitRange hitRange = Cache.HitRange.None;
        if (this.partitionSingleList.size() == 0) {
            return hitRange;
        }
        int begin = this.partitionSingleList.size() - 1;
        int end = 0;
        for (int i = 0; i < this.partitionSingleList.size(); ++i) {
            if (this.partitionSingleList.get(i).isFromCache()) continue;
            if (begin > i) {
                begin = i;
            }
            if (end >= i) continue;
            end = i;
        }
        if (end < begin) {
            hitRange = Cache.HitRange.Full;
            return hitRange;
        }
        hitRange = begin > 0 && end == this.partitionSingleList.size() - 1 ? Cache.HitRange.Left : (begin == 0 && end < this.partitionSingleList.size() - 1 ? Cache.HitRange.Right : (begin > 0 && end < this.partitionSingleList.size() - 1 ? Cache.HitRange.Middle : Cache.HitRange.None));
        rangeList.add(this.partitionSingleList.get(begin));
        rangeList.add(this.partitionSingleList.get(end));
        LOG.info("the new range for scan be is [{},{}], hit range", (Object)rangeList.get(0).getCacheKey().realValue(), (Object)rangeList.get(1).getCacheKey().realValue(), (Object)hitRange);
        return hitRange;
    }

    public List<PartitionSingle> buildUpdatePartitionRange() {
        ArrayList updateList = Lists.newArrayList();
        for (PartitionSingle single : this.partitionSingleList) {
            if (single.isFromCache() || single.isTooNew()) continue;
            updateList.add(single);
        }
        return updateList;
    }

    public boolean rewritePredicate(CompoundPredicate predicate, List<PartitionSingle> rangeList) {
        if (predicate.getOp() != CompoundPredicate.Operator.AND) {
            LOG.debug("predicate op {}", (Object)predicate.getOp().toString());
            return false;
        }
        for (Expr expr : predicate.getChildren()) {
            InPredicate inPredicate;
            if (expr instanceof BinaryPredicate) {
                LiteralExpr newLiteral;
                BinaryPredicate binPredicate;
                block17: {
                    binPredicate = (BinaryPredicate)expr;
                    BinaryPredicate.Operator op = binPredicate.getOp();
                    if (binPredicate.getChildren().size() != 2) {
                        LOG.info("binary predicate children size {}", (Object)binPredicate.getChildren().size());
                        continue;
                    }
                    if (op == BinaryPredicate.Operator.NE) {
                        LOG.info("binary predicate op {}", (Object)op.toString());
                        continue;
                    }
                    PartitionKeyType key = new PartitionKeyType();
                    switch (op) {
                        case LE: {
                            key.clone(rangeList.get(1).getCacheKey());
                            break;
                        }
                        case LT: {
                            key.clone(rangeList.get(1).getCacheKey());
                            key.add(1);
                            break;
                        }
                        case GE: {
                            key.clone(rangeList.get(0).getCacheKey());
                            break;
                        }
                        case GT: {
                            key.clone(rangeList.get(0).getCacheKey());
                            key.add(-1);
                            break;
                        }
                    }
                    if (key.keyType == KeyType.DATE) {
                        try {
                            newLiteral = new DateLiteral(key.toString(), (Type)Type.DATE);
                            break block17;
                        }
                        catch (Exception e) {
                            LOG.warn("Date's format is error {},{}", (Object)key.toString(), (Object)e);
                            continue;
                        }
                    }
                    if (key.keyType == KeyType.LONG) {
                        newLiteral = new IntLiteral(key.realValue());
                    } else {
                        LOG.warn("Partition cache not support type {}", (Object)key.keyType);
                        continue;
                    }
                }
                if (binPredicate.getChild(1) instanceof LiteralExpr) {
                    binPredicate.removeNode(1);
                    binPredicate.addChild(newLiteral);
                    continue;
                }
                if (!(binPredicate.getChild(0) instanceof LiteralExpr)) continue;
                binPredicate.removeNode(0);
                binPredicate.setChild(0, newLiteral);
                continue;
            }
            if (expr instanceof InPredicate && (inPredicate = (InPredicate)expr).isLiteralChildren() && !inPredicate.isNotIn()) continue;
        }
        return true;
    }

    private void getTablePartitionList(OlapTable table) {
        Map<Long, PartitionItem> range = this.rangePartitionInfo.getIdToItem(false);
        for (Map.Entry<Long, PartitionItem> entry : range.entrySet()) {
            Long partId = entry.getKey();
            for (PartitionSingle single : this.partitionSingleList) {
                if (!((RangePartitionItem)entry.getValue()).getItems().contains((Comparable)single.getPartitionKey()) || single.getPartitionId() != 0L) continue;
                single.setPartitionId(partId);
            }
        }
        for (PartitionSingle single : this.partitionSingleList) {
            single.setPartition(table.getPartition(single.getPartitionId()));
        }
        this.partitionSingleList = this.partitionSingleList.stream().filter(p -> p.getPartition() != null).collect(Collectors.toList());
    }

    private boolean buildPartitionKeyRange(PartitionColumnFilter partitionColumnFilter, Column partitionColumn) throws AnalysisException {
        if (partitionColumnFilter.lowerBound == null || partitionColumnFilter.upperBound == null) {
            LOG.info("filter is null");
            return false;
        }
        PartitionKeyType begin = new PartitionKeyType();
        PartitionKeyType end = new PartitionKeyType();
        begin.init(partitionColumn.getType(), partitionColumnFilter.lowerBound);
        end.init(partitionColumn.getType(), partitionColumnFilter.upperBound);
        if (!partitionColumnFilter.lowerBoundInclusive) {
            begin.add(1);
        }
        if (!partitionColumnFilter.upperBoundInclusive) {
            end.add(-1);
        }
        if (begin.realValue() > end.realValue()) {
            LOG.info("partition range begin {}, end {}", (Object)begin, (Object)end);
            return false;
        }
        if (end.realValue() - begin.realValue() > (long)Config.cache_result_max_row_count) {
            LOG.info("partition key range is too large, begin {}, end {}", (Object)begin.realValue(), (Object)end.realValue());
            return false;
        }
        while (begin.realValue() <= end.realValue()) {
            PartitionKey key = PartitionKey.createPartitionKey(Lists.newArrayList((Object[])new PartitionValue[]{new PartitionValue(begin.toString())}), Lists.newArrayList((Object[])new Column[]{partitionColumn}));
            PartitionSingle single = new PartitionSingle();
            single.setCacheKey(begin);
            single.setPartitionKey(key);
            this.partitionSingleList.add(single);
            begin.add(1);
        }
        return true;
    }

    private PartitionColumnFilter createPartitionFilter(CompoundPredicate partitionKeyPredicate, Column partitionColumn) {
        if (partitionKeyPredicate.getOp() != CompoundPredicate.Operator.AND) {
            LOG.debug("not and op");
            return null;
        }
        PartitionColumnFilter partitionColumnFilter = new PartitionColumnFilter();
        for (Expr expr : partitionKeyPredicate.getChildren()) {
            InPredicate inPredicate;
            if (expr instanceof BinaryPredicate) {
                Expr slotBinding;
                BinaryPredicate binPredicate = (BinaryPredicate)expr;
                BinaryPredicate.Operator op = binPredicate.getOp();
                if (binPredicate.getChildren().size() != 2) {
                    LOG.warn("child size {}", (Object)binPredicate.getChildren().size());
                    continue;
                }
                if (binPredicate.getOp() == BinaryPredicate.Operator.NE) {
                    LOG.debug("not support NE operator");
                    continue;
                }
                if (binPredicate.getChild(1) instanceof LiteralExpr) {
                    slotBinding = (Expr)binPredicate.getChild(1);
                } else if (binPredicate.getChild(0) instanceof LiteralExpr) {
                    slotBinding = (Expr)binPredicate.getChild(0);
                } else {
                    LOG.debug("not find LiteralExpr");
                    continue;
                }
                LiteralExpr literal = (LiteralExpr)slotBinding;
                switch (op) {
                    case EQ: {
                        partitionColumnFilter.setLowerBound(literal, true);
                        partitionColumnFilter.setUpperBound(literal, true);
                        break;
                    }
                    case LE: {
                        partitionColumnFilter.setUpperBound(literal, true);
                        break;
                    }
                    case LT: {
                        partitionColumnFilter.setUpperBound(literal, false);
                        break;
                    }
                    case GE: {
                        partitionColumnFilter.setLowerBound(literal, true);
                        break;
                    }
                    case GT: {
                        partitionColumnFilter.setLowerBound(literal, false);
                        break;
                    }
                }
                continue;
            }
            if (!(expr instanceof InPredicate) || !(inPredicate = (InPredicate)expr).isLiteralChildren() || inPredicate.isNotIn()) continue;
            partitionColumnFilter.setInPredicate(inPredicate);
        }
        return partitionColumnFilter;
    }

    public static class PartitionKeyType {
        private SimpleDateFormat df8 = new SimpleDateFormat("yyyyMMdd");
        private SimpleDateFormat df10 = new SimpleDateFormat("yyyy-MM-dd");
        public KeyType keyType = KeyType.DEFAULT;
        public long value;
        public Date date;

        public boolean init(Type type, String str) {
            switch (type.getPrimitiveType()) {
                case DATE: {
                    try {
                        this.date = this.df10.parse(str);
                    }
                    catch (Exception e) {
                        LOG.warn("parse error str{}.", (Object)str);
                        return false;
                    }
                    this.keyType = KeyType.DATE;
                    break;
                }
                case TINYINT: 
                case SMALLINT: 
                case INT: 
                case BIGINT: {
                    this.value = Long.parseLong(str);
                    this.keyType = KeyType.LONG;
                    break;
                }
                default: {
                    LOG.info("PartitionCache not support such key type {}", (Object)type.toSql());
                    return false;
                }
            }
            return true;
        }

        public boolean init(Type type, LiteralExpr expr) {
            switch (type.getPrimitiveType()) {
                case BOOLEAN: 
                case TIME: 
                case DATETIME: 
                case FLOAT: 
                case DOUBLE: 
                case DECIMALV2: 
                case CHAR: 
                case VARCHAR: 
                case STRING: 
                case LARGEINT: {
                    LOG.info("PartitionCache not support such key type {}", (Object)type.toSql());
                    return false;
                }
                case DATE: {
                    this.date = this.getDateValue(expr);
                    this.keyType = KeyType.DATE;
                    break;
                }
                case TINYINT: 
                case SMALLINT: 
                case INT: 
                case BIGINT: {
                    this.value = expr.getLongValue();
                    this.keyType = KeyType.LONG;
                }
            }
            return true;
        }

        public void clone(PartitionKeyType key) {
            this.keyType = key.keyType;
            this.value = key.value;
            this.date = key.date;
        }

        public boolean equals(PartitionKeyType key) {
            return this.realValue() == key.realValue();
        }

        public void add(int num) {
            if (this.keyType == KeyType.DATE) {
                this.date = new Date(this.date.getTime() + (long)(num * 3600 * 24 * 1000));
            } else {
                this.value += (long)num;
            }
        }

        public String toString() {
            if (this.keyType == KeyType.DEFAULT) {
                return "";
            }
            if (this.keyType == KeyType.DATE) {
                return this.df10.format(this.date);
            }
            return String.valueOf(this.value);
        }

        public long realValue() {
            if (this.keyType == KeyType.DATE) {
                return Long.parseLong(this.df8.format(this.date));
            }
            return this.value;
        }

        private Date getDateValue(LiteralExpr expr) {
            this.value = expr.getLongValue() / 1000000L;
            Date dt = null;
            try {
                dt = this.df8.parse(String.valueOf(this.value));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return dt;
        }
    }

    public static enum KeyType {
        DEFAULT,
        LONG,
        DATE,
        DATETIME,
        TIME;

    }

    public class PartitionSingle {
        private Partition partition;
        private PartitionKey partitionKey;
        private long partitionId = 0L;
        private PartitionKeyType cacheKey = new PartitionKeyType();
        private boolean fromCache = false;
        private boolean tooNew = false;

        public Partition getPartition() {
            return this.partition;
        }

        public void setPartition(Partition partition) {
            this.partition = partition;
        }

        public PartitionKey getPartitionKey() {
            return this.partitionKey;
        }

        public void setPartitionKey(PartitionKey key) {
            this.partitionKey = key;
        }

        public long getPartitionId() {
            return this.partitionId;
        }

        public void setPartitionId(long partitionId) {
            this.partitionId = partitionId;
        }

        public PartitionKeyType getCacheKey() {
            return this.cacheKey;
        }

        public void setCacheKey(PartitionKeyType cacheKey) {
            this.cacheKey.clone(cacheKey);
        }

        public boolean isFromCache() {
            return this.fromCache;
        }

        public void setFromCache(boolean fromCache) {
            this.fromCache = fromCache;
        }

        public boolean isTooNew() {
            return this.tooNew;
        }

        public void setTooNew(boolean tooNew) {
            this.tooNew = tooNew;
        }

        public void Debug() {
            if (this.partition != null) {
                LOG.info("partition id {}, cacheKey {}, version {}, time {}, fromCache {}, tooNew {} ", (Object)this.partitionId, (Object)this.cacheKey.realValue(), (Object)this.partition.getVisibleVersion(), (Object)this.partition.getVisibleVersionTime(), (Object)this.fromCache, (Object)this.tooNew);
            } else {
                LOG.info("partition id {}, cacheKey {}, fromCache {}, tooNew {} ", (Object)this.partitionId, (Object)this.cacheKey.realValue(), (Object)this.fromCache, (Object)this.tooNew);
            }
        }
    }
}

