/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe.cache;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.common.Status;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.proto.InternalService;
import org.apache.doris.qe.RowBatch;
import org.apache.doris.qe.cache.Cache;
import org.apache.doris.qe.cache.CacheAnalyzer;
import org.apache.doris.qe.cache.CacheBeProxy;
import org.apache.doris.qe.cache.CacheProxy;
import org.apache.doris.qe.cache.PartitionRange;
import org.apache.doris.qe.cache.RowBatchBuilder;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionCache
extends Cache {
    private static final Logger LOG = LogManager.getLogger(PartitionCache.class);
    private SelectStmt nokeyStmt;
    private SelectStmt rewriteStmt;
    private CompoundPredicate partitionPredicate;
    private OlapTable olapTable;
    private RangePartitionInfo partitionInfo;
    private Column partColumn;
    private PartitionRange range;
    private List<PartitionRange.PartitionSingle> newRangeList;

    @Override
    public SelectStmt getRewriteStmt() {
        return this.rewriteStmt;
    }

    public SelectStmt getNokeyStmt() {
        return this.nokeyStmt;
    }

    public String getSqlWithViewStmt() {
        return this.nokeyStmt.toSql() + "|" + this.allViewExpandStmtListStr;
    }

    public PartitionCache(TUniqueId queryId, SelectStmt selectStmt) {
        super(queryId, selectStmt);
    }

    public void setCacheInfo(CacheAnalyzer.CacheTable latestTable, RangePartitionInfo partitionInfo, Column partColumn, CompoundPredicate partitionPredicate, String allViewExpandStmtListStr) {
        this.latestTable = latestTable;
        this.olapTable = latestTable.olapTable;
        this.partitionInfo = partitionInfo;
        this.partColumn = partColumn;
        this.partitionPredicate = partitionPredicate;
        this.newRangeList = Lists.newArrayList();
        this.allViewExpandStmtListStr = allViewExpandStmtListStr;
    }

    @Override
    public InternalService.PFetchCacheResult getCacheData(Status status) {
        this.rewriteSelectStmt(null);
        this.range = new PartitionRange(this.partitionPredicate, this.olapTable, this.partitionInfo);
        if (!this.range.analytics()) {
            status.setStatus("analytics range error");
            return null;
        }
        InternalService.PFetchCacheRequest request = InternalService.PFetchCacheRequest.newBuilder().setSqlKey(CacheProxy.getMd5(this.getSqlWithViewStmt())).addAllParams(this.range.getPartitionSingleList().stream().map(p -> InternalService.PCacheParam.newBuilder().setPartitionKey(p.getCacheKey().realValue()).setLastVersion(p.getPartition().getVisibleVersion()).setLastVersionTime(p.getPartition().getVisibleVersionTime()).build()).collect(Collectors.toList())).build();
        InternalService.PFetchCacheResult cacheResult = this.proxy.fetchCache(request, 10000, status);
        if (status.ok() && cacheResult != null && cacheResult.getStatus() == InternalService.PCacheStatus.CACHE_OK) {
            for (InternalService.PCacheValue value : cacheResult.getValuesList()) {
                this.range.setCacheFlag(value.getParam().getPartitionKey());
            }
            cacheResult = cacheResult.toBuilder().setAllCount(this.range.getPartitionSingleList().size()).build();
            MetricRepo.COUNTER_CACHE_HIT_PARTITION.increase(1L);
            MetricRepo.COUNTER_CACHE_PARTITION_ALL.increase(Long.valueOf(this.range.getPartitionSingleList().size()));
            MetricRepo.COUNTER_CACHE_PARTITION_HIT.increase(Long.valueOf(cacheResult.getValuesList().size()));
        }
        this.range.setTooNewByID(this.latestTable.latestPartitionId);
        this.hitRange = this.range.buildDiskPartitionRange(this.newRangeList);
        if (this.newRangeList != null && this.newRangeList.size() > 0) {
            this.rewriteSelectStmt(this.newRangeList);
        }
        return cacheResult;
    }

    @Override
    public void copyRowBatch(RowBatch rowBatch) {
        if (this.rowBatchBuilder == null) {
            this.rowBatchBuilder = new RowBatchBuilder(CacheAnalyzer.CacheMode.Partition);
            this.rowBatchBuilder.buildPartitionIndex((ArrayList<Expr>)this.selectStmt.getResultExprs(), this.selectStmt.getColLabels(), this.partColumn, this.range.buildUpdatePartitionRange());
        }
        this.rowBatchBuilder.copyRowData(rowBatch);
    }

    @Override
    public void updateCache() {
        if (!super.checkRowLimit()) {
            return;
        }
        InternalService.PUpdateCacheRequest updateRequest = this.rowBatchBuilder.buildPartitionUpdateRequest(this.getSqlWithViewStmt());
        if (updateRequest.getValuesCount() > 0) {
            CacheBeProxy proxy = new CacheBeProxy();
            Status status = new Status();
            proxy.updateCache(updateRequest, CacheProxy.UPDATE_TIMEOUT, status);
            int rowCount = 0;
            int dataSize = 0;
            for (InternalService.PCacheValue value : updateRequest.getValuesList()) {
                rowCount += value.getRowsCount();
                dataSize += value.getDataSize();
            }
            LOG.info("update cache model {}, queryid {}, sqlkey {}, value count {}, row count {}, data size {}", (Object)CacheAnalyzer.CacheMode.Partition, (Object)DebugUtil.printId(this.queryId), (Object)DebugUtil.printId(updateRequest.getSqlKey()), (Object)updateRequest.getValuesCount(), (Object)rowCount, (Object)dataSize);
        }
    }

    public void rewriteSelectStmt(List<PartitionRange.PartitionSingle> newRangeList) {
        if (newRangeList == null || newRangeList.size() == 0) {
            this.nokeyStmt = (SelectStmt)this.selectStmt.clone();
            this.rewriteSelectStmt(this.nokeyStmt, this.partitionPredicate, null);
        } else {
            this.rewriteStmt = (SelectStmt)this.selectStmt.clone();
            this.rewriteSelectStmt(this.rewriteStmt, this.partitionPredicate, newRangeList);
        }
    }

    private void rewriteSelectStmt(SelectStmt newStmt, CompoundPredicate predicate, List<PartitionRange.PartitionSingle> newRangeList) {
        newStmt.setWhereClause(this.rewriteWhereClause(newStmt.getWhereClause(), predicate, newRangeList));
        List<TableRef> tableRefs = newStmt.getTableRefs();
        for (TableRef tblRef : tableRefs) {
            InlineViewRef viewRef;
            QueryStmt queryStmt;
            if (!(tblRef instanceof InlineViewRef) || !((queryStmt = (viewRef = (InlineViewRef)tblRef).getViewStmt()) instanceof SelectStmt)) continue;
            this.rewriteSelectStmt((SelectStmt)queryStmt, predicate, newRangeList);
        }
    }

    private Expr rewriteWhereClause(Expr expr, CompoundPredicate predicate, List<PartitionRange.PartitionSingle> newRangeList) {
        if (expr == null) {
            return null;
        }
        if (!(expr instanceof CompoundPredicate)) {
            return expr;
        }
        if (expr.equals(predicate)) {
            if (newRangeList == null) {
                return null;
            }
            this.getPartitionRange().rewritePredicate((CompoundPredicate)expr, newRangeList);
            return expr;
        }
        for (int i = 0; i < expr.getChildren().size(); ++i) {
            Expr child = this.rewriteWhereClause((Expr)expr.getChild(i), predicate, newRangeList);
            if (child == null) {
                expr.removeNode(i);
                --i;
                continue;
            }
            expr.setChild(i, child);
        }
        if (expr.getChildren().size() == 0) {
            return null;
        }
        if (expr.getChildren().size() == 1) {
            return (Expr)expr.getChild(0);
        }
        return expr;
    }

    public PartitionRange getPartitionRange() {
        if (this.range == null) {
            this.range = new PartitionRange(this.partitionPredicate, this.olapTable, this.partitionInfo);
            return this.range;
        }
        return this.range;
    }
}

