/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe.cache;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.apache.doris.common.Status;
import org.apache.doris.proto.InternalService;
import org.apache.doris.proto.Types;
import org.apache.doris.qe.cache.CacheBeProxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CacheProxy {
    private static final Logger LOG = LogManager.getLogger(CacheBeProxy.class);
    public static int FETCH_TIMEOUT = 10000;
    public static int UPDATE_TIMEOUT = 10000;
    public static int CLEAR_TIMEOUT = 30000;

    protected CacheProxy() {
    }

    public static CacheProxy getCacheProxy(CacheProxyType type) {
        switch (type) {
            case BE: {
                return new CacheBeProxy();
            }
            case FE: 
            case OUTER: {
                return null;
            }
        }
        return null;
    }

    public abstract void updateCache(InternalService.PUpdateCacheRequest var1, int var2, Status var3);

    public abstract InternalService.PFetchCacheResult fetchCache(InternalService.PFetchCacheRequest var1, int var2, Status var3);

    public abstract void clearCache(InternalService.PClearCacheRequest var1);

    public static Types.PUniqueId getMd5(String str) {
        byte[] digest;
        try {
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            digest = msgDigest.digest(str.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return null;
        }
        Types.PUniqueId key = Types.PUniqueId.newBuilder().setLo(CacheProxy.getLongFromByte(digest, 0)).setHi(CacheProxy.getLongFromByte(digest, 8)).build();
        return key;
    }

    public static final long getLongFromByte(byte[] array, int offset) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value = value << 8 | (long)(array[offset + i] & 0xFF);
        }
        return value;
    }

    public static enum CacheProxyType {
        FE,
        BE,
        OUTER;

    }
}

