/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe.cache;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.proto.Types;
import org.apache.doris.qe.SimpleScheduler;
import org.apache.doris.qe.cache.CacheBeProxy;
import org.apache.doris.system.Backend;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheCoordinator {
    private static final Logger LOG = LogManager.getLogger(CacheCoordinator.class);
    private static final int VIRTUAL_NODES = 10;
    private static final int REFRESH_NODE_TIME = 300000;
    public boolean DebugModel = false;
    private Hashtable<Long, Backend> realNodes = new Hashtable();
    private SortedMap<Long, Backend> virtualNodes = new TreeMap<Long, Backend>();
    private static Lock belock = new ReentrantLock();
    private long lastRefreshTime;
    private static CacheCoordinator cachePartition;

    public static CacheCoordinator getInstance() {
        if (cachePartition == null) {
            cachePartition = new CacheCoordinator();
        }
        return cachePartition;
    }

    protected CacheCoordinator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Backend findBackend(Types.PUniqueId sqlKey) {
        Backend virtualNode;
        block6: {
            this.resetBackend();
            virtualNode = null;
            try {
                belock.lock();
                SortedMap<Long, Backend> headMap = this.virtualNodes.headMap(sqlKey.getHi());
                SortedMap<Long, Backend> tailMap = this.virtualNodes.tailMap(sqlKey.getHi());
                int retryTimes = 0;
                do {
                    Long key;
                    if (tailMap == null || tailMap.size() == 0) {
                        tailMap = headMap;
                        ++retryTimes;
                    }
                    if (SimpleScheduler.isAvailable(virtualNode = (Backend)tailMap.get(key = tailMap.firstKey()))) {
                        break block6;
                    }
                    LOG.debug("backend {} not alive, key {}, retry {}", (Object)virtualNode.getId(), (Object)key, (Object)retryTimes);
                    virtualNode = null;
                    tailMap = tailMap.tailMap(key + 1L);
                } while (++retryTimes < 5);
                LOG.warn("find backend, reach max retry times {}", (Object)retryTimes);
            }
            finally {
                belock.unlock();
            }
        }
        return virtualNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBackend() {
        if (System.currentTimeMillis() - this.lastRefreshTime < 300000L) {
            return;
        }
        try {
            belock.lock();
            ImmutableMap<Long, Backend> idToBackend = Catalog.getCurrentSystemInfo().getIdToBackend();
            if (idToBackend != null) {
                if (!this.DebugModel) {
                    this.clearBackend(idToBackend);
                }
                for (Backend backend : idToBackend.values().asList()) {
                    this.addBackend(backend);
                }
            }
            this.lastRefreshTime = System.currentTimeMillis();
        }
        finally {
            belock.unlock();
        }
    }

    private void clearBackend(ImmutableMap<Long, Backend> idToBackend) {
        Iterator<Long> itr = this.realNodes.keySet().iterator();
        while (itr.hasNext()) {
            Long bid = itr.next();
            if (idToBackend.containsKey((Object)bid)) continue;
            for (int i = 0; i < 10; ++i) {
                String nodeName = String.valueOf(bid) + "::" + String.valueOf(i);
                Types.PUniqueId nodeId = CacheBeProxy.getMd5(nodeName);
                this.virtualNodes.remove(nodeId.getHi());
                LOG.debug("remove backend id {}, virtual node name {} hashcode {}", (Object)bid, (Object)nodeName, (Object)nodeId.getHi());
            }
            itr.remove();
        }
    }

    public void addBackend(Backend backend) {
        if (this.realNodes.contains(backend.getId())) {
            return;
        }
        this.realNodes.put(backend.getId(), backend);
        for (int i = 0; i < 10; ++i) {
            String nodeName = String.valueOf(backend.getId()) + "::" + String.valueOf(i);
            Types.PUniqueId nodeId = CacheBeProxy.getMd5(nodeName);
            this.virtualNodes.put(nodeId.getHi(), backend);
            LOG.debug("add backend id {}, virtual node name {} hashcode {}", (Object)backend.getId(), (Object)nodeName, (Object)nodeId.getHi());
        }
    }

    public List<Backend> getBackendList() {
        ArrayList backendList = Lists.newArrayList();
        for (Map.Entry<Long, Backend> entry : this.realNodes.entrySet()) {
            backendList.add(entry.getValue());
        }
        return backendList;
    }
}

