/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe.cache;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.doris.common.Status;
import org.apache.doris.proto.InternalService;
import org.apache.doris.proto.Types;
import org.apache.doris.qe.SimpleScheduler;
import org.apache.doris.qe.cache.CacheCoordinator;
import org.apache.doris.qe.cache.CacheProxy;
import org.apache.doris.rpc.BackendServiceProxy;
import org.apache.doris.rpc.RpcException;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TStatusCode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheBeProxy
extends CacheProxy {
    private static final Logger LOG = LogManager.getLogger(CacheBeProxy.class);

    @Override
    public void updateCache(InternalService.PUpdateCacheRequest request, int timeoutMs, Status status) {
        Types.PUniqueId sqlKey = request.getSqlKey();
        Backend backend = CacheCoordinator.getInstance().findBackend(sqlKey);
        if (backend == null) {
            LOG.warn("update cache can't find backend, sqlKey {}", (Object)sqlKey);
            return;
        }
        TNetworkAddress address = new TNetworkAddress(backend.getHost(), backend.getBrpcPort());
        try {
            Future<InternalService.PCacheResponse> future = BackendServiceProxy.getInstance().updateCache(address, request);
            InternalService.PCacheResponse response = future.get(timeoutMs, TimeUnit.MILLISECONDS);
            if (response.getStatus() == InternalService.PCacheStatus.CACHE_OK) {
                status.setStatus(new Status(TStatusCode.OK, "CACHE_OK"));
            } else {
                status.setStatus(response.getStatus().toString());
            }
        }
        catch (Exception e) {
            LOG.warn("update cache exception, sqlKey {}", (Object)sqlKey, (Object)e);
            status.setRpcStatus(e.getMessage());
            SimpleScheduler.addToBlacklist(backend.getId(), e.getMessage());
        }
    }

    @Override
    public InternalService.PFetchCacheResult fetchCache(InternalService.PFetchCacheRequest request, int timeoutMs, Status status) {
        Types.PUniqueId sqlKey = request.getSqlKey();
        Backend backend = CacheCoordinator.getInstance().findBackend(sqlKey);
        if (backend == null) {
            return null;
        }
        TNetworkAddress address = new TNetworkAddress(backend.getHost(), backend.getBrpcPort());
        try {
            Future<InternalService.PFetchCacheResult> future = BackendServiceProxy.getInstance().fetchCache(address, request);
            return future.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (RpcException e) {
            LOG.warn("fetch catch rpc exception, sqlKey {}, backend {}", (Object)sqlKey, (Object)backend.getId(), (Object)e);
            status.setRpcStatus(e.getMessage());
            SimpleScheduler.addToBlacklist(backend.getId(), e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.warn("future get interrupted exception, sqlKey {}, backend {}", (Object)sqlKey, (Object)backend.getId(), (Object)e);
            status.setStatus("interrupted exception");
        }
        catch (ExecutionException e) {
            LOG.warn("future get execution exception, sqlKey {}, backend {}", (Object)sqlKey, (Object)backend.getId(), (Object)e);
            status.setStatus("execution exception");
        }
        catch (TimeoutException e) {
            LOG.warn("fetch result timeout, sqlKey {}, backend {}", (Object)sqlKey, (Object)backend.getId(), (Object)e);
            status.setStatus("query timeout");
        }
        return null;
    }

    @Override
    public void clearCache(InternalService.PClearCacheRequest request) {
        this.clearCache(request, CacheCoordinator.getInstance().getBackendList());
    }

    public void clearCache(InternalService.PClearCacheRequest request, List<Backend> beList) {
        Status status = new Status();
        for (Backend backend : beList) {
            int retry = 1;
            while (retry < 3 && !this.clearCache(request, backend, CLEAR_TIMEOUT, status)) {
                ++retry;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            if (retry < 3) continue;
            String errMsg = "clear cache timeout, backend " + backend.getId();
            LOG.warn(errMsg);
            SimpleScheduler.addToBlacklist(backend.getId(), errMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean clearCache(InternalService.PClearCacheRequest request, Backend backend, int timeoutMs, Status status) {
        InternalService.PCacheResponse response;
        block5: {
            TNetworkAddress address = new TNetworkAddress(backend.getHost(), backend.getBrpcPort());
            request = request.toBuilder().setClearType(InternalService.PClearType.CLEAR_ALL).build();
            LOG.info("clear all backend cache, backendId {}", (Object)backend.getId());
            Future<InternalService.PCacheResponse> future = BackendServiceProxy.getInstance().clearCache(address, request);
            response = future.get(timeoutMs, TimeUnit.MILLISECONDS);
            if (response.getStatus() != InternalService.PCacheStatus.CACHE_OK) break block5;
            status.setStatus(new Status(TStatusCode.OK, "CACHE_OK"));
            boolean bl = true;
            return bl;
        }
        try {
            status.setStatus(response.getStatus().toString());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOG.warn("clear cache exception, backendId {}", (Object)backend.getId(), (Object)e);
        }
        return false;
    }
}

