/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe.cache;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.AggregateInfo;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SetOperationStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.View;
import org.apache.doris.common.Config;
import org.apache.doris.common.Status;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.planner.OlapScanNode;
import org.apache.doris.planner.Planner;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.proto.InternalService;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.RowBatch;
import org.apache.doris.qe.cache.Cache;
import org.apache.doris.qe.cache.PartitionCache;
import org.apache.doris.qe.cache.SqlCache;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CacheAnalyzer {
    private static final Logger LOG = LogManager.getLogger(CacheAnalyzer.class);
    private ConnectContext context;
    private boolean enableSqlCache = false;
    private boolean enablePartitionCache = false;
    private TUniqueId queryId;
    private CacheMode cacheMode;
    private CacheTable latestTable;
    private StatementBase parsedStmt;
    private SelectStmt selectStmt;
    private List<ScanNode> scanNodes;
    private OlapTable olapTable;
    private RangePartitionInfo partitionInfo;
    private Column partColumn;
    private CompoundPredicate partitionPredicate;
    private Cache cache;
    private Set<String> allViewStmtSet;

    public Cache getCache() {
        return this.cache;
    }

    public CacheAnalyzer(ConnectContext context, StatementBase parsedStmt, Planner planner) {
        this.context = context;
        this.queryId = context.queryId();
        this.parsedStmt = parsedStmt;
        this.scanNodes = planner.getScanNodes();
        this.latestTable = new CacheTable();
        this.allViewStmtSet = new HashSet<String>();
        this.checkCacheConfig();
    }

    public CacheAnalyzer(ConnectContext context, StatementBase parsedStmt, List<ScanNode> scanNodes) {
        this.context = context;
        this.parsedStmt = parsedStmt;
        this.scanNodes = scanNodes;
        this.allViewStmtSet = new HashSet<String>();
        this.checkCacheConfig();
    }

    private void checkCacheConfig() {
        if (Config.cache_enable_sql_mode && this.context.getSessionVariable().isEnableSqlCache()) {
            this.enableSqlCache = true;
        }
        if (Config.cache_enable_partition_mode && this.context.getSessionVariable().isEnablePartitionCache()) {
            this.enablePartitionCache = true;
        }
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public boolean enableCache() {
        return this.enableSqlCache || this.enablePartitionCache;
    }

    public boolean enableSqlCache() {
        return this.enableSqlCache;
    }

    public boolean enablePartitionCache() {
        return this.enablePartitionCache;
    }

    public void checkCacheMode(long now) {
        this.cacheMode = this.innerCheckCacheMode(now);
    }

    private CacheMode innerCheckCacheMode(long now) {
        if (!this.enableCache()) {
            LOG.debug("cache is disabled. queryid {}", (Object)DebugUtil.printId(this.queryId));
            return CacheMode.NoNeed;
        }
        if (!(this.parsedStmt instanceof SelectStmt) || this.scanNodes.size() == 0) {
            LOG.debug("not a select stmt or no scan node. queryid {}", (Object)DebugUtil.printId(this.queryId));
            return CacheMode.NoNeed;
        }
        MetricRepo.COUNTER_QUERY_TABLE.increase(1L);
        this.selectStmt = (SelectStmt)this.parsedStmt;
        ArrayList tblTimeList = Lists.newArrayList();
        for (int i = 0; i < this.scanNodes.size(); ++i) {
            ScanNode node = this.scanNodes.get(i);
            if (!(node instanceof OlapScanNode)) {
                LOG.debug("query contains non-olap table. queryid {}", (Object)DebugUtil.printId(this.queryId));
                return CacheMode.None;
            }
            if (this.enablePartitionCache() && ((OlapScanNode)node).getSelectedPartitionNum() > 1 && this.selectStmt.hasGroupByClause()) {
                LOG.debug("more than one partition scanned when qeury has agg, partition cache cannot use, queryid {}", (Object)DebugUtil.printId(this.queryId));
                return CacheMode.None;
            }
            CacheTable cTable = this.getSelectedPartitionLastUpdateTime((OlapScanNode)node);
            tblTimeList.add(cTable);
        }
        MetricRepo.COUNTER_QUERY_OLAP_TABLE.increase(1L);
        Collections.sort(tblTimeList);
        this.latestTable = (CacheTable)tblTimeList.get(0);
        this.latestTable.Debug();
        this.addAllViewStmt(this.selectStmt);
        String allViewExpandStmtListStr = StringUtils.join(this.allViewStmtSet, (String)"|");
        if (now == 0L) {
            now = this.nowtime();
        }
        if (this.enableSqlCache() && now - this.latestTable.latestTime >= (long)(Config.cache_last_version_interval_second * 1000)) {
            LOG.debug("TIME:{},{},{}", (Object)now, (Object)this.latestTable.latestTime, (Object)(Config.cache_last_version_interval_second * 1000));
            this.cache = new SqlCache(this.queryId, this.selectStmt);
            ((SqlCache)this.cache).setCacheInfo(this.latestTable, allViewExpandStmtListStr);
            MetricRepo.COUNTER_CACHE_MODE_SQL.increase(1L);
            return CacheMode.Sql;
        }
        if (!this.enablePartitionCache()) {
            LOG.debug("partition query cache is disabled. queryid {}", (Object)DebugUtil.printId(this.queryId));
            return CacheMode.None;
        }
        for (int i = 1; i < tblTimeList.size(); ++i) {
            if (now - ((CacheTable)tblTimeList.get((int)i)).latestTime >= (long)(Config.cache_last_version_interval_second * 1000)) continue;
            LOG.debug("the time of other tables is newer than {} s, queryid {}", (Object)Config.cache_last_version_interval_second, (Object)DebugUtil.printId(this.queryId));
            return CacheMode.None;
        }
        this.olapTable = this.latestTable.olapTable;
        if (this.olapTable.getPartitionInfo().getType() != PartitionType.RANGE) {
            LOG.debug("the partition of OlapTable not RANGE type, queryid {}", (Object)DebugUtil.printId(this.queryId));
            return CacheMode.None;
        }
        this.partitionInfo = (RangePartitionInfo)this.olapTable.getPartitionInfo();
        List<Column> columns = this.partitionInfo.getPartitionColumns();
        if (columns.size() != 1) {
            LOG.debug("more than one partition column, queryid {}", (Object)columns.size(), (Object)DebugUtil.printId(this.queryId));
            return CacheMode.None;
        }
        this.partColumn = columns.get(0);
        if (!this.checkGroupByPartitionKey(this.selectStmt, this.partColumn)) {
            LOG.debug("group by columns does not contains all partition column, queryid {}", (Object)DebugUtil.printId(this.queryId));
            return CacheMode.None;
        }
        ArrayList compoundPredicates = Lists.newArrayList();
        this.getPartitionKeyFromSelectStmt(this.selectStmt, this.partColumn, compoundPredicates);
        if (compoundPredicates.size() != 1) {
            LOG.debug("empty or more than one predicates contain partition column, queryid {}", (Object)DebugUtil.printId(this.queryId));
            return CacheMode.None;
        }
        this.partitionPredicate = (CompoundPredicate)compoundPredicates.get(0);
        this.cache = new PartitionCache(this.queryId, this.selectStmt);
        ((PartitionCache)this.cache).setCacheInfo(this.latestTable, this.partitionInfo, this.partColumn, this.partitionPredicate, allViewExpandStmtListStr);
        MetricRepo.COUNTER_CACHE_MODE_PARTITION.increase(1L);
        return CacheMode.Partition;
    }

    public InternalService.PFetchCacheResult getCacheData() {
        this.cacheMode = this.innerCheckCacheMode(0L);
        if (this.cacheMode == CacheMode.NoNeed) {
            return null;
        }
        if (this.cacheMode == CacheMode.None) {
            return null;
        }
        Status status = new Status();
        InternalService.PFetchCacheResult cacheResult = this.cache.getCacheData(status);
        if (status.ok() && cacheResult != null && cacheResult.getStatus() == InternalService.PCacheStatus.CACHE_OK) {
            int rowCount = 0;
            int dataSize = 0;
            for (InternalService.PCacheValue value : cacheResult.getValuesList()) {
                rowCount += value.getRowsCount();
                dataSize += value.getDataSize();
            }
            LOG.debug("hit cache, mode {}, queryid {}, all count {}, value count {}, row count {}, data size {}", (Object)this.cacheMode, (Object)DebugUtil.printId(this.queryId), (Object)cacheResult.getAllCount(), (Object)cacheResult.getValuesCount(), (Object)rowCount, (Object)dataSize);
        } else {
            LOG.debug("miss cache, mode {}, queryid {}, code {}, msg {}", (Object)this.cacheMode, (Object)DebugUtil.printId(this.queryId), (Object)status.getErrorCode(), (Object)status.getErrorMsg());
            cacheResult = null;
        }
        return cacheResult;
    }

    public long nowtime() {
        return System.currentTimeMillis();
    }

    private void getPartitionKeyFromSelectStmt(SelectStmt stmt, Column partColumn, List<CompoundPredicate> compoundPredicates) {
        this.getPartitionKeyFromWhereClause(stmt.getWhereClause(), partColumn, compoundPredicates);
        List<TableRef> tableRefs = stmt.getTableRefs();
        for (TableRef tblRef : tableRefs) {
            InlineViewRef viewRef;
            QueryStmt queryStmt;
            if (!(tblRef instanceof InlineViewRef) || !((queryStmt = (viewRef = (InlineViewRef)tblRef).getViewStmt()) instanceof SelectStmt)) continue;
            this.getPartitionKeyFromSelectStmt((SelectStmt)queryStmt, partColumn, compoundPredicates);
        }
    }

    private void getPartitionKeyFromWhereClause(Expr expr, Column partColumn, List<CompoundPredicate> compoundPredicates) {
        if (expr == null) {
            return;
        }
        if (expr instanceof CompoundPredicate) {
            CompoundPredicate cp = (CompoundPredicate)expr;
            if (cp.getOp() == CompoundPredicate.Operator.AND && cp.getChildren().size() == 2 && cp.getChild(0) instanceof BinaryPredicate && cp.getChild(1) instanceof BinaryPredicate) {
                BinaryPredicate leftPre = (BinaryPredicate)cp.getChild(0);
                BinaryPredicate rightPre = (BinaryPredicate)cp.getChild(1);
                String leftColumn = this.getColumnName(leftPre);
                String rightColumn = this.getColumnName(rightPre);
                if (leftColumn.equalsIgnoreCase(partColumn.getName()) && rightColumn.equalsIgnoreCase(partColumn.getName())) {
                    compoundPredicates.add(cp);
                }
            }
            for (Expr subExpr : expr.getChildren()) {
                this.getPartitionKeyFromWhereClause(subExpr, partColumn, compoundPredicates);
            }
        }
    }

    private String getColumnName(BinaryPredicate predicate) {
        CastExpr expr;
        SlotRef slot = null;
        if (predicate.getChild(0) instanceof SlotRef) {
            slot = (SlotRef)predicate.getChild(0);
        } else if (predicate.getChild(0) instanceof CastExpr && (expr = (CastExpr)predicate.getChild(0)).getChild(0) instanceof SlotRef) {
            slot = (SlotRef)expr.getChild(0);
        }
        if (slot != null) {
            return slot.getColumnName();
        }
        return "";
    }

    private boolean checkGroupByPartitionKey(SelectStmt stmt, Column partColumn) {
        ArrayList aggInfoList = Lists.newArrayList();
        this.getAggInfoList(stmt, aggInfoList);
        int groupbyCount = 0;
        for (AggregateInfo aggInfo : aggInfoList) {
            ArrayList<Expr> groupExprs = aggInfo.getGroupingExprs();
            if (groupExprs == null) continue;
            ++groupbyCount;
            boolean matched = false;
            for (Expr groupExpr : groupExprs) {
                if (!(groupExpr instanceof SlotRef)) continue;
                SlotRef slot = (SlotRef)groupExpr;
                if (!partColumn.getName().equals(slot.getColumnName())) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return groupbyCount > 0;
    }

    private void getAggInfoList(SelectStmt stmt, List<AggregateInfo> aggInfoList) {
        AggregateInfo aggInfo = stmt.getAggInfo();
        if (aggInfo != null) {
            aggInfoList.add(aggInfo);
        }
        List<TableRef> tableRefs = stmt.getTableRefs();
        for (TableRef tblRef : tableRefs) {
            InlineViewRef viewRef;
            QueryStmt queryStmt;
            if (!(tblRef instanceof InlineViewRef) || !((queryStmt = (viewRef = (InlineViewRef)tblRef).getViewStmt()) instanceof SelectStmt)) continue;
            this.getAggInfoList((SelectStmt)queryStmt, aggInfoList);
        }
    }

    private CacheTable getSelectedPartitionLastUpdateTime(OlapScanNode node) {
        OlapTable olapTable;
        CacheTable cacheTable = new CacheTable();
        cacheTable.olapTable = olapTable = node.getOlapTable();
        for (Long partitionId : node.getSelectedPartitionIds()) {
            Partition partition = olapTable.getPartition(partitionId);
            if (partition.getVisibleVersionTime() < cacheTable.latestTime) continue;
            cacheTable.latestPartitionId = partition.getId();
            cacheTable.latestTime = partition.getVisibleVersionTime();
            cacheTable.latestVersion = partition.getVisibleVersion();
        }
        return cacheTable;
    }

    private void addAllViewStmt(List<TableRef> tblRefs) {
        for (TableRef tblRef : tblRefs) {
            if (!(tblRef instanceof InlineViewRef)) continue;
            InlineViewRef inlineViewRef = (InlineViewRef)tblRef;
            if (inlineViewRef.isLocalView()) {
                Collection<View> views = inlineViewRef.getAnalyzer().getLocalViews().values();
                for (View view : views) {
                    this.addAllViewStmt(view.getQueryStmt());
                }
            } else {
                this.addAllViewStmt(inlineViewRef.getViewStmt());
                this.allViewStmtSet.add(inlineViewRef.getView().getInlineViewDef());
            }
            this.addAllViewStmt(inlineViewRef.getQueryStmt());
        }
    }

    private void addAllViewStmt(QueryStmt queryStmt) {
        if (queryStmt instanceof SelectStmt) {
            this.addAllViewStmt(((SelectStmt)queryStmt).getTableRefs());
        } else if (queryStmt instanceof SetOperationStmt) {
            for (SetOperationStmt.SetOperand operand : ((SetOperationStmt)queryStmt).getOperands()) {
                this.addAllViewStmt(operand.getQueryStmt());
            }
        }
    }

    public Cache.HitRange getHitRange() {
        if (this.cacheMode == CacheMode.None) {
            return Cache.HitRange.None;
        }
        return this.cache.getHitRange();
    }

    public SelectStmt getRewriteStmt() {
        if (this.cacheMode != CacheMode.Partition) {
            return null;
        }
        return this.cache.getRewriteStmt();
    }

    public void copyRowBatch(RowBatch rowBatch) {
        if (this.cacheMode == CacheMode.None || this.cacheMode == CacheMode.NoNeed) {
            return;
        }
        this.cache.copyRowBatch(rowBatch);
    }

    public void updateCache() {
        if (this.cacheMode == CacheMode.None || this.cacheMode == CacheMode.NoNeed) {
            return;
        }
        this.cache.updateCache();
    }

    public class CacheTable
    implements Comparable<CacheTable> {
        public OlapTable olapTable = null;
        public long latestPartitionId = 0L;
        public long latestVersion = 0L;
        public long latestTime = 0L;

        @Override
        public int compareTo(CacheTable table) {
            return Long.compare(table.latestTime, this.latestTime);
        }

        public void Debug() {
            LOG.debug("table {}, partition id {}, ver {}, time {}", (Object)this.olapTable.getName(), (Object)this.latestPartitionId, (Object)this.latestVersion, (Object)this.latestTime);
        }
    }

    public static enum CacheMode {
        NoNeed,
        None,
        TTL,
        Sql,
        Partition;

    }
}

