/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe.cache;

import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.common.Config;
import org.apache.doris.common.Status;
import org.apache.doris.proto.InternalService;
import org.apache.doris.qe.RowBatch;
import org.apache.doris.qe.cache.CacheAnalyzer;
import org.apache.doris.qe.cache.CacheProxy;
import org.apache.doris.qe.cache.RowBatchBuilder;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Cache {
    private static final Logger LOG = LogManager.getLogger(Cache.class);
    protected TUniqueId queryId;
    protected SelectStmt selectStmt;
    protected RowBatchBuilder rowBatchBuilder;
    protected CacheAnalyzer.CacheTable latestTable;
    protected CacheProxy proxy;
    protected HitRange hitRange;
    protected String allViewExpandStmtListStr;

    protected Cache(TUniqueId queryId, SelectStmt selectStmt) {
        this.queryId = queryId;
        this.selectStmt = selectStmt;
        this.proxy = CacheProxy.getCacheProxy(CacheProxy.CacheProxyType.BE);
        this.hitRange = HitRange.None;
    }

    public abstract InternalService.PFetchCacheResult getCacheData(Status var1);

    public HitRange getHitRange() {
        return this.hitRange;
    }

    public abstract SelectStmt getRewriteStmt();

    public abstract void copyRowBatch(RowBatch var1);

    public abstract void updateCache();

    protected boolean checkRowLimit() {
        if (this.rowBatchBuilder == null) {
            return false;
        }
        if (this.rowBatchBuilder.getRowSize() > Config.cache_result_max_row_count) {
            LOG.info("can not be cached. rowbatch size {} is more than {}", (Object)this.rowBatchBuilder.getRowSize(), (Object)Config.cache_result_max_row_count);
            return false;
        }
        return true;
    }

    public static enum HitRange {
        None,
        Full,
        Left,
        Right,
        Middle;

    }
}

