/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.common.DdlException;
import org.apache.doris.qe.RuntimeFilterTypeHelper;
import org.apache.doris.qe.SqlModeHelper;
import org.apache.doris.qe.VariableVarConverterI;

public class VariableVarConverters {
    public static final Map<String, VariableVarConverterI> converters = Maps.newHashMap();

    public static Boolean hasConverter(String varName) {
        return converters.containsKey(varName);
    }

    public static Long encode(String varName, String value) throws DdlException {
        if (converters.containsKey(varName)) {
            return converters.get(varName).encode(value);
        }
        return 0L;
    }

    public static String decode(String varName, Long value) throws DdlException {
        if (converters.containsKey(varName)) {
            return converters.get(varName).decode(value);
        }
        return "";
    }

    static {
        SqlModeConverter sqlModeConverter = new SqlModeConverter();
        converters.put("sql_mode", sqlModeConverter);
        RuntimeFilterTypeConverter runtimeFilterTypeConverter = new RuntimeFilterTypeConverter();
        converters.put("runtime_filter_type", runtimeFilterTypeConverter);
    }

    public static class RuntimeFilterTypeConverter
    implements VariableVarConverterI {
        @Override
        public Long encode(String value) throws DdlException {
            return RuntimeFilterTypeHelper.encode(value);
        }

        @Override
        public String decode(Long value) throws DdlException {
            return RuntimeFilterTypeHelper.decode(value);
        }
    }

    public static class SqlModeConverter
    implements VariableVarConverterI {
        @Override
        public Long encode(String value) throws DdlException {
            return SqlModeHelper.encode(value);
        }

        @Override
        public String decode(Long value) throws DdlException {
            return SqlModeHelper.decode(value);
        }
    }
}

