/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.SerializationUtils;
import org.apache.doris.analysis.SetType;
import org.apache.doris.analysis.SetVar;
import org.apache.doris.analysis.SysVariableDesc;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.persist.GlobalVarPersistInfo;
import org.apache.doris.qe.GlobalVariable;
import org.apache.doris.qe.SessionVariable;
import org.apache.doris.qe.VariableVarConverters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class VariableMgr {
    private static final Logger LOG = LogManager.getLogger(VariableMgr.class);
    public static final int SESSION = 1;
    public static final int GLOBAL = 2;
    public static final int SESSION_ONLY = 4;
    public static final int READ_ONLY = 8;
    public static final int INVISIBLE = 16;
    private static ImmutableMap<String, VarContext> ctxByVarName;
    private static SessionVariable defaultSessionVariable;
    private static SessionVariable defaultSessionVariableForCkpt;
    private static ImmutableMap<String, VarContext> ctxByVarNameForCkpt;
    private static final ReadWriteLock rwlock;
    private static final Lock rlock;
    private static final Lock wlock;

    public static SessionVariable getDefaultSessionVariable() {
        return defaultSessionVariable;
    }

    private static boolean setValue(Object obj, Field field, String value) throws DdlException {
        VarAttr attr = field.getAnnotation(VarAttr.class);
        if (VariableVarConverters.hasConverter(attr.name()).booleanValue()) {
            value = VariableVarConverters.encode(attr.name(), value).toString();
        }
        try {
            switch (field.getType().getSimpleName()) {
                case "boolean": {
                    if (value.equalsIgnoreCase("ON") || value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("1")) {
                        field.setBoolean(obj, true);
                        break;
                    }
                    if (value.equalsIgnoreCase("OFF") || value.equalsIgnoreCase("FALSE") || value.equalsIgnoreCase("0")) {
                        field.setBoolean(obj, false);
                        break;
                    }
                    throw new IllegalAccessException();
                }
                case "byte": {
                    field.setByte(obj, Byte.valueOf(value));
                    break;
                }
                case "short": {
                    field.setShort(obj, Short.valueOf(value));
                    break;
                }
                case "int": {
                    field.setInt(obj, Integer.valueOf(value));
                    break;
                }
                case "long": {
                    field.setLong(obj, Long.valueOf(value));
                    break;
                }
                case "float": {
                    field.setFloat(obj, Float.valueOf(value).floatValue());
                    break;
                }
                case "double": {
                    field.setDouble(obj, Double.valueOf(value));
                    break;
                }
                case "String": {
                    field.set(obj, value);
                    break;
                }
                default: {
                    ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_TYPE_FOR_VAR, attr.name());
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_TYPE_FOR_VAR, attr.name());
        }
        catch (IllegalAccessException e) {
            ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_VALUE_FOR_VAR, attr.name(), value);
        }
        return true;
    }

    public static void revertSessionValue(SessionVariable obj) throws DdlException {
        Map<Field, String> sessionOriginValue = obj.getSessionOriginValue();
        if (!sessionOriginValue.isEmpty()) {
            for (Field field : sessionOriginValue.keySet()) {
                VariableMgr.setValue(obj, field, sessionOriginValue.get(field));
            }
        }
    }

    public static SessionVariable newSessionVariable() {
        wlock.lock();
        try {
            SessionVariable sessionVariable = (SessionVariable)SerializationUtils.clone((Serializable)defaultSessionVariable);
            return sessionVariable;
        }
        finally {
            wlock.unlock();
        }
    }

    private static void checkUpdate(SetVar setVar, int flag) throws DdlException {
        if ((flag & 8) != 0) {
            ErrorReport.reportDdlException(ErrorCode.ERR_VARIABLE_IS_READONLY, setVar.getVariable());
        }
        if (setVar.getType() == SetType.GLOBAL && (flag & 4) != 0) {
            ErrorReport.reportDdlException(ErrorCode.ERR_LOCAL_VARIABLE, setVar.getVariable());
        }
        if (setVar.getType() != SetType.GLOBAL && (flag & 2) != 0) {
            ErrorReport.reportDdlException(ErrorCode.ERR_GLOBAL_VARIABLE, setVar.getVariable());
        }
    }

    public static void setVar(SessionVariable sessionVariable, SetVar setVar) throws DdlException {
        String value;
        VarContext ctx = (VarContext)ctxByVarName.get((Object)setVar.getVariable());
        if (ctx == null) {
            ErrorReport.reportDdlException(ErrorCode.ERR_UNKNOWN_SYSTEM_VARIABLE, setVar.getVariable());
        }
        VariableMgr.checkUpdate(setVar, ctx.getFlag());
        VarAttr attr = ctx.getField().getAnnotation(VarAttr.class);
        if (setVar.getValue() != null) {
            value = setVar.getValue().getStringValue();
        } else {
            value = ctx.getDefaultValue();
            if (value == null) {
                ErrorReport.reportDdlException(ErrorCode.ERR_NO_DEFAULT, attr.name());
            }
        }
        if (setVar.getType() == SetType.GLOBAL) {
            VariableMgr.setGlobalVarAndWriteEditLog(ctx, attr.name(), setVar.getValue().getStringValue());
        }
        Field field = ctx.getField();
        if (sessionVariable.getIsSingleSetVar()) {
            try {
                sessionVariable.addSessionOriginValue(field, field.get(sessionVariable).toString());
            }
            catch (Exception e) {
                LOG.warn("failed to collect origin session value ", (Throwable)e);
            }
        }
        VariableMgr.setValue(sessionVariable, field, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setGlobalVarAndWriteEditLog(VarContext ctx, String name, String value) throws DdlException {
        wlock.lock();
        try {
            VariableMgr.setValue(ctx.getObj(), ctx.getField(), value);
            GlobalVarPersistInfo info = new GlobalVarPersistInfo(defaultSessionVariable, Lists.newArrayList((Object[])new String[]{name}));
            Catalog.getCurrentCatalog().getEditLog().logGlobalVariableV2(info);
        }
        finally {
            wlock.unlock();
        }
    }

    public static void setLowerCaseTableNames(int mode) throws DdlException {
        VarContext ctx = (VarContext)ctxByVarName.get((Object)"lower_case_table_names");
        VariableMgr.setGlobalVarAndWriteEditLog(ctx, "lower_case_table_names", "" + mode);
    }

    public static void write(DataOutputStream out) throws IOException {
        SessionVariable variablesToWrite = defaultSessionVariable;
        if (Catalog.isCheckpointThread()) {
            variablesToWrite = defaultSessionVariableForCkpt;
        }
        variablesToWrite.write(out);
        List<String> varNames = GlobalVariable.getPersistentGlobalVarNames();
        GlobalVarPersistInfo info = new GlobalVarPersistInfo(variablesToWrite, varNames);
        info.write(out);
    }

    public static void read(DataInputStream in) throws IOException, DdlException {
        wlock.lock();
        try {
            SessionVariable variablesToRead = defaultSessionVariable;
            if (Catalog.isCheckpointThread()) {
                variablesToRead = defaultSessionVariableForCkpt;
            }
            variablesToRead.readFields(in);
            GlobalVarPersistInfo info = GlobalVarPersistInfo.read(in);
            VariableMgr.replayGlobalVariableV2(info);
        }
        finally {
            wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replayGlobalVariableV2(GlobalVarPersistInfo info) throws DdlException {
        wlock.lock();
        try {
            String json = info.getPersistJsonString();
            JSONObject root = (JSONObject)JSONValue.parse((String)json);
            for (Object varName : root.keySet()) {
                VarContext varContext = (VarContext)ctxByVarName.get((Object)((String)varName));
                if (Catalog.isCheckpointThread()) {
                    varContext = (VarContext)ctxByVarNameForCkpt.get((Object)((String)varName));
                }
                if (varContext == null) {
                    LOG.error("failed to get global variable {} when replaying", (Object)((String)varName));
                    continue;
                }
                VariableMgr.setValue(varContext.getObj(), varContext.getField(), root.get((Object)((String)varName)).toString());
            }
        }
        finally {
            wlock.unlock();
        }
    }

    public static void fillValue(SessionVariable var, SysVariableDesc desc) throws AnalysisException {
        VarContext ctx = (VarContext)ctxByVarName.get((Object)desc.getName());
        if (ctx == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_SYSTEM_VARIABLE, desc.getName());
        }
        if (desc.getSetType() == SetType.GLOBAL) {
            rlock.lock();
            try {
                VariableMgr.fillValue(ctx.getObj(), ctx.getField(), desc);
            }
            finally {
                rlock.unlock();
            }
        } else {
            VariableMgr.fillValue(var, ctx.getField(), desc);
        }
    }

    private static void fillValue(Object obj, Field field, SysVariableDesc desc) {
        try {
            switch (field.getType().getSimpleName()) {
                case "boolean": {
                    desc.setType(Type.BOOLEAN);
                    desc.setBoolValue(field.getBoolean(obj));
                    break;
                }
                case "byte": {
                    desc.setType(Type.TINYINT);
                    desc.setIntValue(field.getByte(obj));
                    break;
                }
                case "short": {
                    desc.setType(Type.SMALLINT);
                    desc.setIntValue(field.getShort(obj));
                    break;
                }
                case "int": {
                    desc.setType(Type.INT);
                    desc.setIntValue(field.getInt(obj));
                    break;
                }
                case "long": {
                    desc.setType(Type.BIGINT);
                    desc.setIntValue(field.getLong(obj));
                    break;
                }
                case "float": {
                    desc.setType(Type.FLOAT);
                    desc.setFloatValue(field.getFloat(obj));
                    break;
                }
                case "double": {
                    desc.setType(Type.DOUBLE);
                    desc.setFloatValue(field.getDouble(obj));
                    break;
                }
                case "String": {
                    desc.setType(Type.VARCHAR);
                    desc.setStringValue((String)field.get(obj));
                    break;
                }
                default: {
                    desc.setType(Type.VARCHAR);
                    desc.setStringValue("");
                    break;
                }
            }
        }
        catch (IllegalAccessException e) {
            LOG.warn("Access failed.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValue(SessionVariable var, SysVariableDesc desc) throws AnalysisException {
        VarContext ctx = (VarContext)ctxByVarName.get((Object)desc.getName());
        if (ctx == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_SYSTEM_VARIABLE, desc.getName());
        }
        if (desc.getSetType() == SetType.GLOBAL) {
            rlock.lock();
            try {
                String string = VariableMgr.getValue(ctx.getObj(), ctx.getField());
                return string;
            }
            finally {
                rlock.unlock();
            }
        }
        return VariableMgr.getValue((Object)var, ctx.getField());
    }

    private static String getValue(Object obj, Field field) {
        try {
            switch (field.getType().getSimpleName()) {
                case "boolean": {
                    return Boolean.toString(field.getBoolean(obj));
                }
                case "byte": {
                    return Byte.toString(field.getByte(obj));
                }
                case "short": {
                    return Short.toString(field.getShort(obj));
                }
                case "int": {
                    return Integer.toString(field.getInt(obj));
                }
                case "long": {
                    return Long.toString(field.getLong(obj));
                }
                case "float": {
                    return Float.toString(field.getFloat(obj));
                }
                case "double": {
                    return Double.toString(field.getDouble(obj));
                }
                case "String": {
                    return (String)field.get(obj);
                }
            }
            return "";
        }
        catch (IllegalAccessException e) {
            LOG.warn("Access failed.", (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<String>> dump(SetType type, SessionVariable sessionVar, PatternMatcher matcher) {
        ArrayList rows = Lists.newArrayList();
        rlock.lock();
        try {
            for (Map.Entry entry : ctxByVarName.entrySet()) {
                if (matcher != null && !matcher.match((String)entry.getKey())) continue;
                VarContext ctx = (VarContext)entry.getValue();
                ArrayList row = Lists.newArrayList();
                row.add((String)entry.getKey());
                if (type != SetType.GLOBAL && ctx.getObj() == defaultSessionVariable) {
                    row.add(VariableMgr.getValue((Object)sessionVar, ctx.getField()));
                } else {
                    row.add(VariableMgr.getValue(ctx.getObj(), ctx.getField()));
                }
                if (row.size() > 1 && VariableVarConverters.hasConverter((String)row.get(0)).booleanValue()) {
                    try {
                        row.set(1, VariableVarConverters.decode((String)row.get(0), Long.valueOf((String)row.get(1))));
                    }
                    catch (DdlException e) {
                        row.set(1, "");
                        LOG.warn("Decode session variable failed");
                    }
                }
                rows.add(row);
            }
        }
        finally {
            rlock.unlock();
        }
        Collections.sort(rows, new Comparator<List<String>>(){

            @Override
            public int compare(List<String> o1, List<String> o2) {
                return o1.get(0).compareTo(o2.get(0));
            }
        });
        return rows;
    }

    public static void createDefaultSessionVariableForCkpt() {
        defaultSessionVariableForCkpt = new SessionVariable();
        ImmutableSortedMap.Builder<String, VarContext> builder = VariableMgr.getStringVarContextBuilder(defaultSessionVariableForCkpt);
        ctxByVarNameForCkpt = builder.build();
    }

    public static void destroyDefaultSessionVariableForCkpt() {
        defaultSessionVariableForCkpt = null;
        ctxByVarNameForCkpt = null;
    }

    @NotNull
    private static ImmutableSortedMap.Builder<String, VarContext> getStringVarContextBuilder(SessionVariable sessionVariable) {
        VarAttr attr;
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (Field field : SessionVariable.class.getDeclaredFields()) {
            attr = field.getAnnotation(VarAttr.class);
            if (attr == null) continue;
            field.setAccessible(true);
            builder.put((Object)attr.name(), (Object)new VarContext(field, sessionVariable, 1 | attr.flag(), VariableMgr.getValue((Object)sessionVariable, field)));
        }
        for (Field field : GlobalVariable.class.getDeclaredFields()) {
            attr = field.getAnnotation(VarAttr.class);
            if (attr == null) continue;
            field.setAccessible(true);
            builder.put((Object)attr.name(), (Object)new VarContext(field, null, 2 | attr.flag(), VariableMgr.getValue(null, field)));
        }
        return builder;
    }

    static {
        rwlock = new ReentrantReadWriteLock();
        rlock = rwlock.readLock();
        wlock = rwlock.writeLock();
        defaultSessionVariable = new SessionVariable();
        ImmutableSortedMap.Builder<String, VarContext> builder = VariableMgr.getStringVarContextBuilder(defaultSessionVariable);
        ctxByVarName = builder.build();
    }

    private static class VarContext {
        private Field field;
        private Object obj;
        private int flag;
        private String defaultValue;

        public VarContext(Field field, Object obj, int flag, String defaultValue) {
            this.field = field;
            this.obj = obj;
            this.flag = flag;
            this.defaultValue = defaultValue;
        }

        public Field getField() {
            return this.field;
        }

        public Object getObj() {
            return this.obj;
        }

        public int getFlag() {
            return this.flag;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface VarAttr {
        public String name();

        public int flag() default 0;

        public String minValue() default "0";

        public String maxValue() default "0";

        public boolean needForward() default false;

        public boolean isQueryOption() default false;
    }
}

