/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CreateTableAsSelectStmt;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.DropTableStmt;
import org.apache.doris.analysis.EnterStmt;
import org.apache.doris.analysis.ExplainOptions;
import org.apache.doris.analysis.ExportStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InsertStmt;
import org.apache.doris.analysis.KillStmt;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.OutFileClause;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.SelectListItem;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.analysis.SetStmt;
import org.apache.doris.analysis.SetVar;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.analysis.StmtRewriter;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.analysis.TransactionBeginStmt;
import org.apache.doris.analysis.TransactionCommitStmt;
import org.apache.doris.analysis.TransactionRollbackStmt;
import org.apache.doris.analysis.UseStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.VecNotImplException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.MetaLockUtils;
import org.apache.doris.common.util.ProfileManager;
import org.apache.doris.common.util.ProfileWriter;
import org.apache.doris.common.util.QueryPlannerProfile;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.mysql.MysqlChannel;
import org.apache.doris.mysql.MysqlEofPacket;
import org.apache.doris.mysql.MysqlSerializer;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.planner.Planner;
import org.apache.doris.proto.Data;
import org.apache.doris.proto.InternalService;
import org.apache.doris.qe.CommonResultSet;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.Coordinator;
import org.apache.doris.qe.DdlExecutor;
import org.apache.doris.qe.InsertStreamTxnExecutor;
import org.apache.doris.qe.MasterOpExecutor;
import org.apache.doris.qe.MasterTxnExecutor;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.qe.QueryDetail;
import org.apache.doris.qe.QueryDetailQueue;
import org.apache.doris.qe.QueryState;
import org.apache.doris.qe.QueryStateException;
import org.apache.doris.qe.ResultSet;
import org.apache.doris.qe.ResultSetMetaData;
import org.apache.doris.qe.RowBatch;
import org.apache.doris.qe.SessionVariable;
import org.apache.doris.qe.SetExecutor;
import org.apache.doris.qe.ShowExecutor;
import org.apache.doris.qe.ShowResultSet;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.doris.qe.VariableMgr;
import org.apache.doris.qe.cache.Cache;
import org.apache.doris.qe.cache.CacheAnalyzer;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.doris.rewrite.mvrewrite.MVSelectFailedException;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TFileFormatType;
import org.apache.doris.thrift.TFileType;
import org.apache.doris.thrift.TLoadTxnBeginRequest;
import org.apache.doris.thrift.TLoadTxnBeginResult;
import org.apache.doris.thrift.TMergeType;
import org.apache.doris.thrift.TQueryOptions;
import org.apache.doris.thrift.TQueryType;
import org.apache.doris.thrift.TResultBatch;
import org.apache.doris.thrift.TStreamLoadPutRequest;
import org.apache.doris.thrift.TTxnParams;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.thrift.TWaitingTxnStatusRequest;
import org.apache.doris.thrift.TWaitingTxnStatusResult;
import org.apache.doris.transaction.TabletCommitInfo;
import org.apache.doris.transaction.TransactionEntry;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class StmtExecutor
implements ProfileWriter {
    private static final Logger LOG = LogManager.getLogger(StmtExecutor.class);
    private static final AtomicLong STMT_ID_GENERATOR = new AtomicLong(0L);
    private static final int MAX_DATA_TO_SEND_FOR_TXN = 100;
    private ConnectContext context;
    private MysqlSerializer serializer;
    private OriginStatement originStmt;
    private StatementBase parsedStmt;
    private Analyzer analyzer;
    private RuntimeProfile profile;
    private RuntimeProfile summaryProfile;
    private RuntimeProfile plannerRuntimeProfile;
    private final Object writeProfileLock = new Object();
    private volatile boolean isFinishedProfile = false;
    private String queryType = "Query";
    private volatile Coordinator coord = null;
    private MasterOpExecutor masterOpExecutor = null;
    private RedirectStatus redirectStatus = null;
    private Planner planner;
    private boolean isProxy;
    private ShowResultSet proxyResultSet = null;
    private Data.PQueryStatistics.Builder statisticsForAuditLog;
    private boolean isCached;
    private QueryPlannerProfile plannerProfile = new QueryPlannerProfile();
    private static final String NULL_VALUE_FOR_LOAD = "\\N";

    public StmtExecutor(ConnectContext context, OriginStatement originStmt, boolean isProxy) {
        this.context = context;
        this.originStmt = originStmt;
        this.serializer = context.getSerializer();
        this.isProxy = isProxy;
    }

    public StmtExecutor(ConnectContext context, String stmt) {
        this(context, new OriginStatement(stmt, 0), false);
    }

    public StmtExecutor(ConnectContext ctx, StatementBase parsedStmt) {
        this.context = ctx;
        this.parsedStmt = parsedStmt;
        this.originStmt = parsedStmt.getOrigStmt();
        this.serializer = this.context.getSerializer();
        this.isProxy = false;
    }

    public void setCoord(Coordinator coord) {
        this.coord = coord;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private void initProfile(QueryPlannerProfile plannerProfile, boolean waiteBeReport) {
        long currentTimestamp = System.currentTimeMillis();
        long totalTimeMs = currentTimestamp - this.context.getStartTime();
        RuntimeProfile queryProfile = this.coord == null ? new RuntimeProfile("Execution Profile " + DebugUtil.printId(this.context.queryId())) : this.coord.getQueryProfile();
        if (this.profile == null) {
            this.profile = new RuntimeProfile("Query");
            this.summaryProfile = new RuntimeProfile("Summary");
            this.profile.addChild(this.summaryProfile);
            this.summaryProfile.addInfoString("Query ID", DebugUtil.printId(this.context.queryId()));
            this.summaryProfile.addInfoString("Start Time", TimeUtils.longToTimeString(this.context.getStartTime()));
            this.summaryProfile.addInfoString("End Time", waiteBeReport ? TimeUtils.longToTimeString(currentTimestamp) : "N/A");
            this.summaryProfile.addInfoString("Total", DebugUtil.getPrettyStringMs(totalTimeMs));
            this.summaryProfile.addInfoString("Query Type", this.queryType);
            this.summaryProfile.addInfoString("Query State", !waiteBeReport && this.context.getState().getStateType().equals((Object)QueryState.MysqlStateType.OK) ? "RUNNING" : this.context.getState().toString());
            this.summaryProfile.addInfoString("Doris Version", "1.1.0-rc05");
            this.summaryProfile.addInfoString("User", this.context.getQualifiedUser());
            this.summaryProfile.addInfoString("Default Db", this.context.getDatabase());
            this.summaryProfile.addInfoString("Sql Statement", this.originStmt.originStmt);
            this.summaryProfile.addInfoString("Is Cached", this.isCached ? "Yes" : "No");
            this.plannerRuntimeProfile = new RuntimeProfile("Execution Summary");
            this.summaryProfile.addChild(this.plannerRuntimeProfile);
            this.profile.addChild(queryProfile);
        } else {
            this.summaryProfile.addInfoString("End Time", waiteBeReport ? TimeUtils.longToTimeString(currentTimestamp) : "N/A");
            this.summaryProfile.addInfoString("Total", DebugUtil.getPrettyStringMs(totalTimeMs));
            this.summaryProfile.addInfoString("Query State", !waiteBeReport && this.context.getState().getStateType().equals((Object)QueryState.MysqlStateType.OK) ? "RUNNING" : this.context.getState().toString());
        }
        plannerProfile.initRuntimeProfile(this.plannerRuntimeProfile);
        queryProfile.getCounterTotalTime().setValue(TimeUtils.getEstimatedTime(plannerProfile.getQueryBeginTime()));
        if (this.coord != null) {
            this.coord.endProfile(waiteBeReport);
        }
    }

    public Planner planner() {
        return this.planner;
    }

    public boolean isForwardToMaster() {
        if (Catalog.getCurrentCatalog().isMaster()) {
            return false;
        }
        if (this.parsedStmt instanceof QueryStmt && !Catalog.getCurrentCatalog().isMaster() && !Catalog.getCurrentCatalog().canRead()) {
            return true;
        }
        if (this.redirectStatus == null) {
            return false;
        }
        return this.redirectStatus.isForwardToMaster();
    }

    public ByteBuffer getOutputPacket() {
        if (this.masterOpExecutor == null) {
            return null;
        }
        return this.masterOpExecutor.getOutputPacket();
    }

    public ShowResultSet getProxyResultSet() {
        return this.proxyResultSet;
    }

    public ShowResultSet getShowResultSet() {
        if (this.masterOpExecutor == null) {
            return null;
        }
        return this.masterOpExecutor.getProxyResultSet();
    }

    public boolean isQueryStmt() {
        return this.parsedStmt != null && this.parsedStmt instanceof QueryStmt;
    }

    public StatementBase getParsedStmt() {
        return this.parsedStmt;
    }

    public void execute() throws Exception {
        UUID uuid = UUID.randomUUID();
        TUniqueId queryId = new TUniqueId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        this.execute(queryId);
    }

    /*
     * Exception decompiling
     */
    public void execute(TUniqueId queryId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [33[CATCHBLOCK]], but top level block is 14[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void analyzeVariablesInStmt() throws DdlException {
        SelectStmt selectStmt;
        Map<String, String> optHints;
        SessionVariable sessionVariable = this.context.getSessionVariable();
        if (this.parsedStmt != null && this.parsedStmt instanceof SelectStmt && (optHints = (selectStmt = (SelectStmt)this.parsedStmt).getSelectList().getOptHints()) != null) {
            sessionVariable.setIsSingleSetVar(true);
            for (String key : optHints.keySet()) {
                VariableMgr.setVar(sessionVariable, new SetVar(key, new StringLiteral(optHints.get(key))));
            }
        }
    }

    private void forwardToMaster() throws Exception {
        boolean isQuery = this.parsedStmt instanceof QueryStmt;
        this.masterOpExecutor = new MasterOpExecutor(this.originStmt, this.context, this.redirectStatus, isQuery);
        LOG.debug("need to transfer to Master. stmt: {}", (Object)this.context.getStmtId());
        this.masterOpExecutor.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeProfile(boolean isLastWriteProfile) {
        if (!this.context.getSessionVariable().enableProfile()) {
            return;
        }
        Object object = this.writeProfileLock;
        synchronized (object) {
            if (this.isFinishedProfile) {
                return;
            }
            this.initProfile(this.plannerProfile, isLastWriteProfile);
            this.profile.computeTimeInChildProfile();
            ProfileManager.getInstance().pushProfile(this.profile);
            this.isFinishedProfile = isLastWriteProfile;
        }
    }

    public void analyze(TQueryOptions tQueryOptions) throws UserException {
        SelectStmt selectStmt;
        if (LOG.isDebugEnabled()) {
            LOG.debug("begin to analyze stmt: {}, forwarded stmt id: {}", (Object)this.context.getStmtId(), (Object)this.context.getForwardedStmtId());
        }
        this.parse();
        if (this.isForwardToMaster()) {
            return;
        }
        this.analyzer = new Analyzer(this.context.getCatalog(), this.context);
        if (this.parsedStmt instanceof ShowStmt && (selectStmt = ((ShowStmt)this.parsedStmt).toSelectStmt(this.analyzer)) != null) {
            this.parsedStmt = selectStmt;
        }
        if (this.parsedStmt instanceof QueryStmt || this.parsedStmt instanceof InsertStmt || this.parsedStmt instanceof CreateTableAsSelectStmt) {
            QueryStmt queryStmt;
            TreeMap tableMap = Maps.newTreeMap();
            HashSet parentViewNameSet = Sets.newHashSet();
            if (this.parsedStmt instanceof QueryStmt) {
                queryStmt = (QueryStmt)this.parsedStmt;
                queryStmt.getTables(this.analyzer, tableMap, parentViewNameSet);
            } else if (this.parsedStmt instanceof CreateTableAsSelectStmt) {
                CreateTableAsSelectStmt parsedStmt = (CreateTableAsSelectStmt)this.parsedStmt;
                queryStmt = parsedStmt.getQueryStmt();
                queryStmt.getTables(this.analyzer, tableMap, parentViewNameSet);
            } else {
                InsertStmt insertStmt = (InsertStmt)this.parsedStmt;
                insertStmt.getTables(this.analyzer, tableMap, parentViewNameSet);
            }
            ArrayList tables = Lists.newArrayList(tableMap.values());
            int analyzeTimes = 2;
            for (int i = 1; i <= analyzeTimes; ++i) {
                MetaLockUtils.readLockTables(tables);
                try {
                    this.analyzeAndGenerateQueryPlan(tQueryOptions);
                    break;
                }
                catch (MVSelectFailedException e) {
                    if (i == analyzeTimes) {
                        throw e;
                    }
                    this.resetAnalyzerAndStmt();
                    continue;
                }
                catch (VecNotImplException e) {
                    if (i == analyzeTimes) {
                        throw e;
                    }
                    this.resetAnalyzerAndStmt();
                    VectorizedUtil.switchToQueryNonVec();
                    continue;
                }
                catch (UserException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn("Analyze failed. {}", (Object)this.context.getQueryIdentifier(), (Object)e);
                    throw new AnalysisException("Unexpected exception: " + e.getMessage());
                }
                finally {
                    MetaLockUtils.readUnlockTables(tables);
                }
            }
        } else {
            try {
                this.parsedStmt.analyze(this.analyzer);
            }
            catch (UserException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Analyze failed. {}", (Object)this.context.getQueryIdentifier(), (Object)e);
                throw new AnalysisException("Unexpected exception: " + e.getMessage());
            }
        }
    }

    private void parse() throws AnalysisException, DdlException {
        if (this.parsedStmt == null) {
            SqlScanner input = new SqlScanner(new StringReader(this.originStmt.originStmt), (Long)this.context.getSessionVariable().getSqlMode());
            SqlParser parser = new SqlParser(input);
            try {
                this.parsedStmt = SqlParserUtils.getStmt(parser, this.originStmt.idx);
                this.parsedStmt.setOrigStmt(this.originStmt);
                this.parsedStmt.setUserInfo(this.context.getCurrentUserIdentity());
            }
            catch (Error e) {
                LOG.info("error happened when parsing stmt {}, id: {}", (Object)this.originStmt, (Object)this.context.getStmtId(), (Object)e);
                throw new AnalysisException("sql parsing error, please check your sql");
            }
            catch (AnalysisException e) {
                String syntaxError = parser.getErrorMsg(this.originStmt.originStmt);
                LOG.info("analysis exception happened when parsing stmt {}, id: {}, error: {}", (Object)this.originStmt, (Object)this.context.getStmtId(), (Object)syntaxError, (Object)e);
                if (syntaxError == null) {
                    throw e;
                }
                throw new AnalysisException(syntaxError, e);
            }
            catch (Exception e) {
                LOG.info("unexpected exception happened when parsing stmt {}, id: {}, error: {}", (Object)this.originStmt, (Object)this.context.getStmtId(), (Object)parser.getErrorMsg(this.originStmt.originStmt), (Object)e);
                throw new AnalysisException("Unexpected exception: " + e.getMessage());
            }
            this.analyzeVariablesInStmt();
        }
        this.redirectStatus = this.parsedStmt.getRedirectStatus();
    }

    private void analyzeAndGenerateQueryPlan(TQueryOptions tQueryOptions) throws UserException {
        this.parsedStmt.analyze(this.analyzer);
        if (this.parsedStmt instanceof QueryStmt || this.parsedStmt instanceof InsertStmt) {
            ExprRewriter rewriter = this.analyzer.getExprRewriter();
            rewriter.reset();
            if (this.context.getSessionVariable().isEnableFoldConstantByBe()) {
                this.parsedStmt.foldConstant(rewriter);
            }
            ExplainOptions explainOptions = this.parsedStmt.getExplainOptions();
            boolean reAnalyze = false;
            this.parsedStmt.rewriteExprs(rewriter);
            reAnalyze = rewriter.changed();
            if (this.analyzer.containSubquery()) {
                this.parsedStmt = StmtRewriter.rewrite(this.analyzer, this.parsedStmt);
                reAnalyze = true;
            }
            if (reAnalyze) {
                ArrayList origResultTypes = Lists.newArrayList();
                for (Expr e : this.parsedStmt.getResultExprs()) {
                    origResultTypes.add(e.getType());
                }
                ArrayList origColLabels = Lists.newArrayList(this.parsedStmt.getColLabels());
                this.analyzer = new Analyzer(this.context.getCatalog(), this.context);
                this.parsedStmt.reset();
                this.parsedStmt.analyze(this.analyzer);
                this.parsedStmt.castResultExprs(origResultTypes);
                this.parsedStmt.setColLabels(origColLabels);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("rewrittenStmt: " + this.parsedStmt.toSql());
                }
                if (explainOptions != null) {
                    this.parsedStmt.setIsExplain(explainOptions);
                }
            }
            if (this.parsedStmt instanceof InsertStmt && this.parsedStmt.isExplain() && ConnectContext.get() != null && ConnectContext.get().getExecutor() != null && ConnectContext.get().getExecutor().getParsedStmt() != null) {
                ConnectContext.get().getExecutor().getParsedStmt().setIsExplain(new ExplainOptions(true, false));
            }
        }
        this.plannerProfile.setQueryAnalysisFinishTime();
        this.planner = new Planner();
        if (this.parsedStmt instanceof QueryStmt || this.parsedStmt instanceof InsertStmt) {
            this.planner.plan(this.parsedStmt, this.analyzer, tQueryOptions);
        }
        this.plannerProfile.setQueryPlanFinishTime();
    }

    private void resetAnalyzerAndStmt() {
        this.analyzer = new Analyzer(this.context.getCatalog(), this.context);
        this.parsedStmt.reset();
        if (this.parsedStmt instanceof QueryStmt) {
            ((QueryStmt)this.parsedStmt).resetSelectList();
        }
        if (this.parsedStmt instanceof InsertStmt) {
            ((InsertStmt)this.parsedStmt).getQueryStmt().resetSelectList();
        }
    }

    public void cancel() {
        Coordinator coordRef = this.coord;
        if (coordRef != null) {
            coordRef.cancel();
        }
    }

    private void handleKill() throws DdlException {
        KillStmt killStmt = (KillStmt)this.parsedStmt;
        int id = killStmt.getConnectionId();
        ConnectContext killCtx = this.context.getConnectScheduler().getContext(id);
        if (killCtx == null) {
            ErrorReport.reportDdlException(ErrorCode.ERR_NO_SUCH_THREAD, id);
        }
        if (this.context == killCtx) {
            this.context.setKilled();
        } else {
            if (!killCtx.getQualifiedUser().equals(ConnectContext.get().getQualifiedUser()) && !Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
                ErrorReport.reportDdlException(ErrorCode.ERR_KILL_DENIED_ERROR, id);
            }
            killCtx.kill(killStmt.isConnectionKill());
        }
        this.context.getState().setOk();
    }

    private void handleSetStmt() {
        try {
            SetStmt setStmt = (SetStmt)this.parsedStmt;
            SetExecutor executor = new SetExecutor(this.context, setStmt);
            executor.execute();
        }
        catch (DdlException e) {
            this.context.getState().setError(ErrorCode.ERR_LOCAL_VARIABLE, e.getMessage());
            return;
        }
        this.context.getState().setOk();
    }

    private boolean sendCachedValues(MysqlChannel channel, List<InternalService.PCacheValue> cacheValues, SelectStmt selectStmt, boolean isSendFields, boolean isEos) throws Exception {
        RowBatch batch = null;
        boolean isSend = isSendFields;
        for (InternalService.PCacheValue value : cacheValues) {
            TResultBatch resultBatch = new TResultBatch();
            for (ByteString one : value.getRowsList()) {
                resultBatch.addToRows(ByteBuffer.wrap(one.toByteArray()));
            }
            resultBatch.setPacketSeq(1L);
            resultBatch.setIsCompressed(false);
            batch = new RowBatch();
            batch.setBatch(resultBatch);
            batch.setEos(true);
            if (!isSend) {
                this.sendFields(selectStmt.getColLabels(), this.exprToType(selectStmt.getResultExprs()));
                isSend = true;
            }
            for (ByteBuffer row : batch.getBatch().getRows()) {
                channel.sendOnePacket(row);
            }
            this.context.updateReturnRows(batch.getBatch().getRows().size());
        }
        if (isEos) {
            if (batch != null) {
                Data.PQueryStatistics.Builder builder = this.statisticsForAuditLog = batch.getQueryStatistics() == null ? null : batch.getQueryStatistics().toBuilder();
            }
            if (!isSend) {
                this.sendFields(selectStmt.getColLabels(), this.exprToType(selectStmt.getResultExprs()));
                isSend = true;
            }
            this.context.getState().setEof();
        }
        return isSend;
    }

    private void handleCacheStmt(CacheAnalyzer cacheAnalyzer, MysqlChannel channel, SelectStmt selectStmt) throws Exception {
        InternalService.PFetchCacheResult cacheResult = cacheAnalyzer.getCacheData();
        CacheAnalyzer.CacheMode mode = cacheAnalyzer.getCacheMode();
        SelectStmt newSelectStmt = selectStmt;
        boolean isSendFields = false;
        if (cacheResult != null) {
            this.isCached = true;
            if (cacheAnalyzer.getHitRange() == Cache.HitRange.Full) {
                this.sendCachedValues(channel, cacheResult.getValuesList(), newSelectStmt, isSendFields, true);
                return;
            }
            if (mode == CacheAnalyzer.CacheMode.Partition) {
                if (cacheAnalyzer.getHitRange() == Cache.HitRange.Left) {
                    isSendFields = this.sendCachedValues(channel, cacheResult.getValuesList(), newSelectStmt, isSendFields, false);
                }
                newSelectStmt = cacheAnalyzer.getRewriteStmt();
                newSelectStmt.reset();
                this.analyzer = new Analyzer(this.context.getCatalog(), this.context);
                newSelectStmt.analyze(this.analyzer);
                this.planner = new Planner();
                this.planner.plan(newSelectStmt, this.analyzer, this.context.getSessionVariable().toThrift());
            }
        }
        this.sendResult(false, isSendFields, newSelectStmt, channel, cacheAnalyzer, cacheResult);
    }

    private boolean handleSelectRequestInFe(SelectStmt parsedSelectStmt) throws IOException {
        List<SelectListItem> selectItemList = parsedSelectStmt.getSelectList().getItems();
        ArrayList<Column> columns = new ArrayList<Column>(selectItemList.size());
        CommonResultSet.CommonResultSetMetaData metadata = new CommonResultSet.CommonResultSetMetaData(columns);
        List columnLabels = parsedSelectStmt.getColLabels();
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < selectItemList.size(); ++i) {
            SelectListItem item = selectItemList.get(i);
            Expr expr = item.getExpr();
            String columnName = (String)columnLabels.get(i);
            if (!(expr instanceof LiteralExpr)) {
                return false;
            }
            columns.add(new Column(columnName, PrimitiveType.VARCHAR));
            data.add(((LiteralExpr)expr).getStringValue());
        }
        CommonResultSet resultSet = new CommonResultSet(metadata, Collections.singletonList(data));
        this.sendResultSet(resultSet);
        return true;
    }

    private void handleQueryStmt() throws Exception {
        SelectStmt parsedSelectStmt;
        this.context.getMysqlChannel().reset();
        QueryStmt queryStmt = (QueryStmt)this.parsedStmt;
        QueryDetail queryDetail = new QueryDetail(this.context.getStartTime(), DebugUtil.printId(this.context.queryId()), this.context.getStartTime(), -1L, -1L, QueryDetail.QueryMemState.RUNNING, this.context.getDatabase(), this.originStmt.originStmt);
        this.context.setQueryDetail(queryDetail);
        QueryDetailQueue.addOrUpdateQueryDetail(queryDetail);
        if (this.parsedStmt instanceof SelectStmt && ((SelectStmt)this.parsedStmt).getTableRefs().isEmpty() && Catalog.getCurrentSystemInfo().getBackendIds(true).isEmpty() && this.handleSelectRequestInFe(parsedSelectStmt = (SelectStmt)this.parsedStmt)) {
            return;
        }
        if (queryStmt.isExplain()) {
            String explainString = this.planner.getExplainString(this.planner.getFragments(), queryStmt.getExplainOptions());
            this.handleExplainStmt(explainString);
            return;
        }
        MysqlChannel channel = this.context.getMysqlChannel();
        boolean isOutfileQuery = queryStmt.hasOutFileClause();
        CacheAnalyzer cacheAnalyzer = new CacheAnalyzer(this.context, this.parsedStmt, this.planner);
        if (cacheAnalyzer.enableCache() && !isOutfileQuery && queryStmt instanceof SelectStmt) {
            this.handleCacheStmt(cacheAnalyzer, channel, (SelectStmt)queryStmt);
            return;
        }
        this.sendResult(isOutfileQuery, false, queryStmt, channel, null, null);
    }

    private void sendResult(boolean isOutfileQuery, boolean isSendFields, QueryStmt queryStmt, MysqlChannel channel, CacheAnalyzer cacheAnalyzer, InternalService.PFetchCacheResult cacheResult) throws Exception {
        RowBatch batch;
        this.coord = new Coordinator(this.context, this.analyzer, this.planner);
        QeProcessorImpl.INSTANCE.registerQuery(this.context.queryId(), new QeProcessorImpl.QueryInfo(this.context, this.originStmt.originStmt, this.coord));
        this.coord.setProfileWriter(this);
        this.coord.exec();
        this.plannerProfile.setQueryScheduleFinishTime();
        this.writeProfile(false);
        do {
            if ((batch = this.coord.getNext()).getBatch() == null) continue;
            if (cacheAnalyzer != null) {
                cacheAnalyzer.copyRowBatch(batch);
            }
            if (!isSendFields) {
                if (!isOutfileQuery) {
                    this.sendFields(queryStmt.getColLabels(), this.exprToType(queryStmt.getResultExprs()));
                } else {
                    this.sendFields(OutFileClause.RESULT_COL_NAMES, OutFileClause.RESULT_COL_TYPES);
                }
                isSendFields = true;
            }
            for (ByteBuffer row : batch.getBatch().getRows()) {
                channel.sendOnePacket(row);
            }
            this.context.updateReturnRows(batch.getBatch().getRows().size());
        } while (!batch.isEos());
        if (cacheAnalyzer != null) {
            if (cacheResult != null && cacheAnalyzer.getHitRange() == Cache.HitRange.Right) {
                isSendFields = this.sendCachedValues(channel, cacheResult.getValuesList(), (SelectStmt)queryStmt, isSendFields, false);
            }
            cacheAnalyzer.updateCache();
        }
        if (!isSendFields) {
            if (!isOutfileQuery) {
                this.sendFields(queryStmt.getColLabels(), this.exprToType(queryStmt.getResultExprs()));
            } else {
                this.sendFields(OutFileClause.RESULT_COL_NAMES, OutFileClause.RESULT_COL_TYPES);
            }
        }
        this.statisticsForAuditLog = batch.getQueryStatistics() == null ? null : batch.getQueryStatistics().toBuilder();
        this.context.getState().setEof();
        this.plannerProfile.setQueryFetchResultFinishTime();
    }

    private TWaitingTxnStatusResult getWaitingTxnStatus(TWaitingTxnStatusRequest request) throws Exception {
        TWaitingTxnStatusResult statusResult = null;
        if (Catalog.getCurrentCatalog().isMaster()) {
            statusResult = Catalog.getCurrentGlobalTransactionMgr().getWaitingTxnStatus(request);
        } else {
            MasterTxnExecutor masterTxnExecutor = new MasterTxnExecutor(this.context);
            statusResult = masterTxnExecutor.getWaitingTxnStatus(request);
        }
        return statusResult;
    }

    private void handleTransactionStmt() throws Exception {
        this.context.getMysqlChannel().reset();
        this.context.getState().setOk(0L, 0, "");
        if (this.context.getTxnEntry() != null && this.context.getTxnEntry().getRowsInTransaction() == 0L && (this.parsedStmt instanceof TransactionCommitStmt || this.parsedStmt instanceof TransactionRollbackStmt)) {
            this.context.setTxnEntry(null);
        } else if (this.parsedStmt instanceof TransactionBeginStmt) {
            if (this.context.isTxnModel()) {
                LOG.info("A transaction has already begin");
                return;
            }
            TTxnParams txnParams = new TTxnParams();
            txnParams.setNeedTxn(true).setThriftRpcTimeoutMs(5000L).setTxnId(-1L).setDb("").setTbl("");
            if (this.context.getSessionVariable().getEnableInsertStrict()) {
                txnParams.setMaxFilterRatio(0.0);
            } else {
                txnParams.setMaxFilterRatio(1.0);
            }
            if (this.context.getTxnEntry() == null) {
                this.context.setTxnEntry(new TransactionEntry());
            }
            TransactionEntry txnEntry = this.context.getTxnEntry();
            txnEntry.setTxnConf(txnParams);
            StringBuilder sb = new StringBuilder();
            sb.append("{'label':'").append(this.context.getTxnEntry().getLabel()).append("', 'status':'").append(TransactionStatus.PREPARE.name());
            sb.append("', 'txnId':'").append("'").append("}");
            this.context.getState().setOk(0L, 0, sb.toString());
        } else if (this.parsedStmt instanceof TransactionCommitStmt) {
            if (!this.context.isTxnModel()) {
                LOG.info("No transaction to commit");
                return;
            }
            TTxnParams txnConf = this.context.getTxnEntry().getTxnConf();
            try {
                InsertStreamTxnExecutor executor = new InsertStreamTxnExecutor(this.context.getTxnEntry());
                if (this.context.getTxnEntry().getDataToSend().size() > 0) {
                    executor.sendData();
                }
                executor.commitTransaction();
                TWaitingTxnStatusRequest request = new TWaitingTxnStatusRequest();
                request.setDbId(txnConf.getDbId()).setTxnId(txnConf.getTxnId());
                request.setLabelIsSet(false);
                request.setTxnIdIsSet(true);
                TWaitingTxnStatusResult statusResult = this.getWaitingTxnStatus(request);
                TransactionStatus txnStatus = TransactionStatus.valueOf(statusResult.getTxnStatusId());
                if (txnStatus == TransactionStatus.COMMITTED) {
                    throw new AnalysisException("transaction commit successfully, BUT data will be visible later.");
                }
                if (txnStatus != TransactionStatus.VISIBLE) {
                    String errMsg = "commit failed, rollback.";
                    if (statusResult.getStatus().isSetErrorMsgs() && statusResult.getStatus().getErrorMsgs().size() > 0) {
                        errMsg = String.join((CharSequence)". ", statusResult.getStatus().getErrorMsgs());
                    }
                    throw new AnalysisException(errMsg);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("{'label':'").append(this.context.getTxnEntry().getLabel()).append("', 'status':'").append(txnStatus.name()).append("', 'txnId':'").append(this.context.getTxnEntry().getTxnConf().getTxnId()).append("'").append("}");
                this.context.getState().setOk(0L, 0, sb.toString());
            }
            catch (Exception e) {
                throw new AnalysisException(e.getMessage());
            }
            finally {
                this.context.setTxnEntry(null);
            }
        } else if (this.parsedStmt instanceof TransactionRollbackStmt) {
            if (!this.context.isTxnModel()) {
                LOG.info("No transaction to rollback");
                return;
            }
            try {
                InsertStreamTxnExecutor executor = new InsertStreamTxnExecutor(this.context.getTxnEntry());
                executor.abortTransaction();
                StringBuilder sb = new StringBuilder();
                sb.append("{'label':'").append(this.context.getTxnEntry().getLabel()).append("', 'status':'").append(TransactionStatus.ABORTED.name()).append("', 'txnId':'").append(this.context.getTxnEntry().getTxnConf().getTxnId()).append("'").append("}");
                this.context.getState().setOk(0L, 0, sb.toString());
            }
            catch (Exception e) {
                throw new AnalysisException(e.getMessage());
            }
            finally {
                this.context.setTxnEntry(null);
            }
        } else {
            throw new TException("parsedStmt type is not TransactionStmt");
        }
    }

    public int executeForTxn(InsertStmt insertStmt) throws UserException, TException, InterruptedException, ExecutionException, TimeoutException {
        if (this.context.isTxnIniting()) {
            this.beginTxn(insertStmt.getDb(), insertStmt.getTbl());
        }
        if (!this.context.getTxnEntry().getTxnConf().getDb().equals(insertStmt.getDb()) || !this.context.getTxnEntry().getTxnConf().getTbl().equals(insertStmt.getTbl())) {
            throw new TException("Only one table can be inserted in one transaction.");
        }
        QueryStmt queryStmt = insertStmt.getQueryStmt();
        if (!(queryStmt instanceof SelectStmt)) {
            throw new TException("queryStmt is not SelectStmt, insert command error");
        }
        TransactionEntry txnEntry = this.context.getTxnEntry();
        SelectStmt selectStmt = (SelectStmt)queryStmt;
        int effectRows = 0;
        if (selectStmt.getValueList() != null) {
            Table tbl = txnEntry.getTable();
            int schemaSize = tbl.getBaseSchema(false).size();
            for (List list : selectStmt.getValueList().getRows()) {
                if (schemaSize == list.size()) continue;
                throw new TException("Column count doesn't match value count");
            }
            for (List list : selectStmt.getValueList().getRows()) {
                ++effectRows;
                InternalService.PDataRow data = StmtExecutor.getRowStringValue(list);
                if (data == null) continue;
                List<InternalService.PDataRow> dataToSend = txnEntry.getDataToSend();
                dataToSend.add(data);
                if (dataToSend.size() < 100) continue;
                InsertStreamTxnExecutor executor = new InsertStreamTxnExecutor(txnEntry);
                executor.sendData();
            }
        }
        txnEntry.setRowsInTransaction(txnEntry.getRowsInTransaction() + (long)effectRows);
        return effectRows;
    }

    private void beginTxn(String dbName, String tblName) throws UserException, TException, InterruptedException, ExecutionException, TimeoutException {
        TransactionEntry txnEntry = this.context.getTxnEntry();
        TTxnParams txnConf = txnEntry.getTxnConf();
        long timeoutSecond = ConnectContext.get().getSessionVariable().getQueryTimeoutS();
        TransactionState.LoadJobSourceType sourceType = TransactionState.LoadJobSourceType.INSERT_STREAMING;
        Database dbObj = Catalog.getCurrentCatalog().getDbOrException(dbName, s -> new TException("database is invalid for dbName: " + s));
        Table tblObj = dbObj.getTableOrException(tblName, s -> new TException("table is invalid: " + s));
        txnConf.setDbId(dbObj.getId()).setTbl(tblName).setDb(dbName);
        txnEntry.setTable(tblObj);
        txnEntry.setDb(dbObj);
        String label = txnEntry.getLabel();
        if (Catalog.getCurrentCatalog().isMaster()) {
            long txnId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(txnConf.getDbId(), Lists.newArrayList((Object[])new Long[]{tblObj.getId()}), label, new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), sourceType, timeoutSecond);
            txnConf.setTxnId(txnId);
            String authCodeUuid = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(txnConf.getDbId(), txnConf.getTxnId()).getAuthCode();
            txnConf.setAuthCodeUuid(authCodeUuid);
        } else {
            String authCodeUuid = UUID.randomUUID().toString();
            MasterTxnExecutor masterTxnExecutor = new MasterTxnExecutor(this.context);
            TLoadTxnBeginRequest request = new TLoadTxnBeginRequest();
            request.setDb(txnConf.getDb()).setTbl(txnConf.getTbl()).setAuthCodeUuid(authCodeUuid).setCluster(dbObj.getClusterName()).setLabel(label).setUser("").setUserIp("").setPasswd("");
            TLoadTxnBeginResult result = masterTxnExecutor.beginTxn(request);
            txnConf.setTxnId(result.getTxnId());
            txnConf.setAuthCodeUuid(authCodeUuid);
        }
        TStreamLoadPutRequest request = new TStreamLoadPutRequest();
        request.setTxnId(txnConf.getTxnId()).setDb(txnConf.getDb()).setTbl(txnConf.getTbl()).setFileType(TFileType.FILE_STREAM).setFormatType(TFileFormatType.FORMAT_CSV_PLAIN).setMergeType(TMergeType.APPEND).setThriftRpcTimeoutMs(5000L).setLoadId(this.context.queryId());
        InsertStreamTxnExecutor executor = new InsertStreamTxnExecutor(txnEntry);
        executor.beginTransaction(request);
    }

    public static InternalService.PDataRow getRowStringValue(List<Expr> cols) {
        if (cols.size() == 0) {
            return null;
        }
        InternalService.PDataRow.Builder row = InternalService.PDataRow.newBuilder();
        for (Expr expr : cols) {
            if (expr instanceof NullLiteral) {
                row.addColBuilder().setValue(NULL_VALUE_FOR_LOAD);
                continue;
            }
            row.addColBuilder().setValue(expr.getStringValue());
        }
        return row.build();
    }

    private void handleInsertStmt() throws Exception {
        this.context.getMysqlChannel().reset();
        InsertStmt insertStmt = (InsertStmt)this.parsedStmt;
        if (insertStmt.getQueryStmt().hasOutFileClause()) {
            throw new DdlException("Not support OUTFILE clause in INSERT statement");
        }
        if (insertStmt.getQueryStmt().isExplain()) {
            ExplainOptions explainOptions = insertStmt.getQueryStmt().getExplainOptions();
            insertStmt.setIsExplain(explainOptions);
            String explainString = this.planner.getExplainString(this.planner.getFragments(), explainOptions);
            this.handleExplainStmt(explainString);
            return;
        }
        long createTime = System.currentTimeMillis();
        Throwable throwable = null;
        long txnId = -1L;
        String label = "";
        long loadedRows = 0L;
        int filteredRows = 0;
        TransactionStatus txnStatus = TransactionStatus.ABORTED;
        String errMsg = "";
        if (this.context.isTxnModel()) {
            if (insertStmt.getQueryStmt() instanceof SelectStmt && ((SelectStmt)insertStmt.getQueryStmt()).getTableRefs().size() > 0) {
                throw new TException("Insert into ** select is not supported in a transaction");
            }
            txnStatus = TransactionStatus.PREPARE;
            loadedRows = this.executeForTxn(insertStmt);
            label = this.context.getTxnEntry().getLabel();
            txnId = this.context.getTxnEntry().getTxnConf().getTxnId();
        } else {
            label = insertStmt.getLabel();
            LOG.info("Do insert [{}] with query id: {}", (Object)label, (Object)DebugUtil.printId(this.context.queryId()));
            try {
                this.coord = new Coordinator(this.context, this.analyzer, this.planner);
                this.coord.setLoadZeroTolerance(this.context.getSessionVariable().getEnableInsertStrict());
                this.coord.setQueryType(TQueryType.LOAD);
                QeProcessorImpl.INSTANCE.registerQuery(this.context.queryId(), this.coord);
                this.coord.exec();
                boolean notTimeout = this.coord.join(this.context.getSessionVariable().getQueryTimeoutS());
                if (!this.coord.isDone()) {
                    this.coord.cancel();
                    if (notTimeout) {
                        errMsg = this.coord.getExecStatus().getErrorMsg();
                        ErrorReport.reportDdlException("There exists unhealthy backend. " + errMsg, ErrorCode.ERR_FAILED_WHEN_INSERT, new Object[0]);
                    } else {
                        ErrorReport.reportDdlException(ErrorCode.ERR_EXECUTE_TIMEOUT, new Object[0]);
                    }
                }
                if (!this.coord.getExecStatus().ok()) {
                    errMsg = this.coord.getExecStatus().getErrorMsg();
                    LOG.warn("insert failed: {}", (Object)errMsg);
                    ErrorReport.reportDdlException(errMsg, ErrorCode.ERR_FAILED_WHEN_INSERT, new Object[0]);
                }
                LOG.debug("delta files is {}", this.coord.getDeltaUrls());
                if (this.coord.getLoadCounters().get("dpp.norm.ALL") != null) {
                    loadedRows = Long.valueOf(this.coord.getLoadCounters().get("dpp.norm.ALL"));
                }
                if (this.coord.getLoadCounters().get("dpp.abnorm.ALL") != null) {
                    filteredRows = Integer.valueOf(this.coord.getLoadCounters().get("dpp.abnorm.ALL"));
                }
                if (this.context.getSessionVariable().getEnableInsertStrict() && filteredRows > 0) {
                    this.context.getState().setError(ErrorCode.ERR_FAILED_WHEN_INSERT, "Insert has filtered data in strict mode, tracking_url=" + this.coord.getTrackingUrl());
                    return;
                }
                if (insertStmt.getTargetTable().getType() != Table.TableType.OLAP) {
                    this.context.getState().setOk(loadedRows, filteredRows, null);
                    return;
                }
                if (Catalog.getCurrentGlobalTransactionMgr().commitAndPublishTransaction(insertStmt.getDbObj(), Lists.newArrayList((Object[])new Table[]{insertStmt.getTargetTable()}), insertStmt.getTransactionId(), TabletCommitInfo.fromThrift(this.coord.getCommitInfos()), this.context.getSessionVariable().getInsertVisibleTimeoutMs())) {
                    txnStatus = TransactionStatus.VISIBLE;
                    MetricRepo.COUNTER_LOAD_FINISHED.increase(1L);
                } else {
                    txnStatus = TransactionStatus.COMMITTED;
                }
            }
            catch (Throwable t) {
                LOG.warn("handle insert stmt fail: {}", (Object)label, (Object)t);
                try {
                    Catalog.getCurrentGlobalTransactionMgr().abortTransaction(insertStmt.getDbObj().getId(), insertStmt.getTransactionId(), t.getMessage() == null ? "unknown reason" : t.getMessage());
                }
                catch (Exception abortTxnException) {
                    LOG.warn("errors when abort txn", (Throwable)abortTxnException);
                }
                if (!Config.using_old_load_usage_pattern) {
                    StringBuilder sb = new StringBuilder(t.getMessage());
                    if (!Strings.isNullOrEmpty((String)this.coord.getTrackingUrl())) {
                        sb.append(". url: " + this.coord.getTrackingUrl());
                    }
                    this.context.getState().setError(ErrorCode.ERR_UNKNOWN_ERROR, sb.toString());
                    return;
                }
                throwable = t;
            }
            txnId = insertStmt.getTransactionId();
            try {
                this.context.getCatalog().getLoadManager().recordFinishedLoadJob(label, txnId, insertStmt.getDb(), insertStmt.getTargetTable().getId(), EtlJobType.INSERT, createTime, throwable == null ? "" : throwable.getMessage(), this.coord.getTrackingUrl());
            }
            catch (MetaNotFoundException e) {
                LOG.warn("Record info of insert load with error {}", (Object)e.getMessage(), (Object)e);
                errMsg = "Record info of insert load with error " + e.getMessage();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{'label':'").append(label).append("', 'status':'").append(txnStatus.name());
        sb.append("', 'txnId':'").append(txnId).append("'");
        if (!Strings.isNullOrEmpty((String)errMsg)) {
            sb.append(", 'err':'").append(errMsg).append("'");
        }
        sb.append("}");
        this.context.getState().setOk(loadedRows, filteredRows, sb.toString());
        this.context.setOrUpdateInsertResult(txnId, label, insertStmt.getDb(), insertStmt.getTbl(), txnStatus, loadedRows, filteredRows);
        this.context.updateReturnRows((int)loadedRows);
    }

    private void handleUnsupportedStmt() {
        this.context.getMysqlChannel().reset();
        this.context.getState().setOk();
    }

    private void handleUseStmt() throws AnalysisException {
        UseStmt useStmt = (UseStmt)this.parsedStmt;
        try {
            if (Strings.isNullOrEmpty((String)useStmt.getClusterName())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_CLUSTER_NO_SELECT_CLUSTER, new Object[0]);
            }
            this.context.getCatalog().changeDb(this.context, useStmt.getDatabase());
        }
        catch (DdlException e) {
            this.context.getState().setError(e.getMysqlErrorCode(), e.getMessage());
            return;
        }
        this.context.getState().setOk();
    }

    private void sendMetaData(ResultSetMetaData metaData) throws IOException {
        this.serializer.reset();
        this.serializer.writeVInt(metaData.getColumnCount());
        this.context.getMysqlChannel().sendOnePacket(this.serializer.toByteBuffer());
        for (Column col : metaData.getColumns()) {
            this.serializer.reset();
            this.serializer.writeField(col.getName(), col.getType().getPrimitiveType());
            this.context.getMysqlChannel().sendOnePacket(this.serializer.toByteBuffer());
        }
        this.serializer.reset();
        MysqlEofPacket eofPacket = new MysqlEofPacket(this.context.getState());
        eofPacket.writeTo(this.serializer);
        this.context.getMysqlChannel().sendOnePacket(this.serializer.toByteBuffer());
    }

    private void sendFields(List<String> colNames, List<PrimitiveType> types) throws IOException {
        this.serializer.reset();
        this.serializer.writeVInt(colNames.size());
        this.context.getMysqlChannel().sendOnePacket(this.serializer.toByteBuffer());
        for (int i = 0; i < colNames.size(); ++i) {
            this.serializer.reset();
            this.serializer.writeField(colNames.get(i), types.get(i));
            this.context.getMysqlChannel().sendOnePacket(this.serializer.toByteBuffer());
        }
        this.serializer.reset();
        MysqlEofPacket eofPacket = new MysqlEofPacket(this.context.getState());
        eofPacket.writeTo(this.serializer);
        this.context.getMysqlChannel().sendOnePacket(this.serializer.toByteBuffer());
    }

    public void sendResultSet(ResultSet resultSet) throws IOException {
        this.context.updateReturnRows(resultSet.getResultRows().size());
        this.sendMetaData(resultSet.getMetaData());
        for (List<String> row : resultSet.getResultRows()) {
            this.serializer.reset();
            for (String item : row) {
                if (item == null || item.equals(FeConstants.null_string)) {
                    this.serializer.writeNull();
                    continue;
                }
                this.serializer.writeLenEncodedString(item);
            }
            this.context.getMysqlChannel().sendOnePacket(this.serializer.toByteBuffer());
        }
        this.context.getState().setEof();
    }

    private void handleShow() throws IOException, AnalysisException, DdlException {
        ShowExecutor executor = new ShowExecutor(this.context, (ShowStmt)this.parsedStmt);
        ShowResultSet resultSet = executor.execute();
        if (resultSet == null) {
            return;
        }
        if (this.isProxy) {
            this.proxyResultSet = resultSet;
            return;
        }
        this.sendResultSet(resultSet);
    }

    private void handleUnlockTablesStmt() {
    }

    private void handleLockTablesStmt() {
    }

    private void handleExplainStmt(String result) throws IOException {
        ShowResultSetMetaData metaData = ShowResultSetMetaData.builder().addColumn(new Column("Explain String", ScalarType.createVarchar(20))).build();
        this.sendMetaData(metaData);
        for (String item : result.split("\n")) {
            this.serializer.reset();
            this.serializer.writeLenEncodedString(item);
            this.context.getMysqlChannel().sendOnePacket(this.serializer.toByteBuffer());
        }
        this.context.getState().setEof();
    }

    private void handleDdlStmt() {
        try {
            DdlExecutor.execute(this.context.getCatalog(), (DdlStmt)this.parsedStmt);
            this.context.getState().setOk();
        }
        catch (QueryStateException e) {
            this.context.setState(e.getQueryState());
        }
        catch (UserException e) {
            LOG.debug("DDL statement({}) process failed.", (Object)this.originStmt.originStmt, (Object)e);
            this.context.getState().setError(e.getMysqlErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("DDL statement(" + this.originStmt.originStmt + ") process failed.", (Throwable)e);
            this.context.getState().setError(ErrorCode.ERR_UNKNOWN_ERROR, "Unexpected exception: " + e.getMessage());
        }
    }

    private void handleEnterStmt() {
        EnterStmt enterStmt = (EnterStmt)this.parsedStmt;
        try {
            this.context.getCatalog().changeCluster(this.context, enterStmt.getClusterName());
            this.context.setDatabase("");
        }
        catch (DdlException e) {
            this.context.getState().setError(e.getMysqlErrorCode(), e.getMessage());
            return;
        }
        this.context.getState().setOk();
    }

    private void handleExportStmt() throws Exception {
        ExportStmt exportStmt = (ExportStmt)this.parsedStmt;
        this.context.getCatalog().getExportMgr().addExportJob(exportStmt);
    }

    private void handleCtasStmt() {
        CreateTableAsSelectStmt ctasStmt = (CreateTableAsSelectStmt)this.parsedStmt;
        try {
            DdlExecutor.execute(this.context.getCatalog(), ctasStmt);
            this.context.getState().setOk();
        }
        catch (Exception e) {
            LOG.warn("CTAS create table error, stmt={}", (Object)this.originStmt.originStmt, (Object)e);
            this.context.getState().setError(ErrorCode.ERR_UNKNOWN_ERROR, "Unexpected exception: " + e.getMessage());
        }
        if (QueryState.MysqlStateType.OK.equals((Object)this.context.getState().getStateType())) {
            try {
                this.parsedStmt = ctasStmt.getInsertStmt();
                this.execute();
            }
            catch (Exception e) {
                LOG.warn("CTAS insert data error, stmt={}", (Object)this.parsedStmt.toSql(), (Object)e);
                DropTableStmt dropTableStmt = new DropTableStmt(true, ctasStmt.getCreateTableStmt().getDbTbl(), true);
                try {
                    DdlExecutor.execute(this.context.getCatalog(), dropTableStmt);
                }
                catch (Exception ex) {
                    LOG.warn("CTAS drop table error, stmt={}", (Object)this.parsedStmt.toSql(), (Object)ex);
                    this.context.getState().setError(ErrorCode.ERR_UNKNOWN_ERROR, "Unexpected exception: " + ex.getMessage());
                }
            }
        }
    }

    public Data.PQueryStatistics getQueryStatisticsForAuditLog() {
        if (this.statisticsForAuditLog == null) {
            this.statisticsForAuditLog = Data.PQueryStatistics.newBuilder();
        }
        if (!this.statisticsForAuditLog.hasScanBytes()) {
            this.statisticsForAuditLog.setScanBytes(0L);
        }
        if (!this.statisticsForAuditLog.hasScanRows()) {
            this.statisticsForAuditLog.setScanRows(0L);
        }
        if (this.statisticsForAuditLog.hasReturnedRows()) {
            this.statisticsForAuditLog.setReturnedRows(0L);
        }
        if (!this.statisticsForAuditLog.hasCpuMs()) {
            this.statisticsForAuditLog.setCpuMs(0L);
        }
        return this.statisticsForAuditLog.build();
    }

    private List<PrimitiveType> exprToType(List<Expr> exprs) {
        return exprs.stream().map(e -> e.getType().getPrimitiveType()).collect(Collectors.toList());
    }
}

