/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlModeHelper {
    private static final Logger LOG = LogManager.getLogger(SqlModeHelper.class);
    public static final long MODE_REAL_AS_FLOAT = 1L;
    public static final long MODE_PIPES_AS_CONCAT = 2L;
    public static final long MODE_ANSI_QUOTES = 4L;
    public static final long MODE_IGNORE_SPACE = 8L;
    public static final long MODE_NOT_USED = 16L;
    public static final long MODE_ONLY_FULL_GROUP_BY = 32L;
    public static final long MODE_NO_UNSIGNED_SUBTRACTION = 64L;
    public static final long MODE_NO_DIR_IN_CREATE = 128L;
    public static final long MODE_NO_AUTO_VALUE_ON_ZERO = 524288L;
    public static final long MODE_NO_BACKSLASH_ESCAPES = 0x100000L;
    public static final long MODE_STRICT_TRANS_TABLES = 0x200000L;
    public static final long MODE_STRICT_ALL_TABLES = 0x400000L;
    @Deprecated
    public static final long MODE_NO_ZERO_IN_DATE = 0x800000L;
    @Deprecated
    public static final long MODE_NO_ZERO_DATE = 0x1000000L;
    public static final long MODE_INVALID_DATES = 0x2000000L;
    public static final long MODE_ERROR_FOR_DIVISION_BY_ZERO = 0x4000000L;
    public static final long MODE_HIGH_NOT_PRECEDENCE = 0x20000000L;
    public static final long MODE_NO_ENGINE_SUBSTITUTION = 0x40000000L;
    public static final long MODE_PAD_CHAR_TO_FULL_LENGTH = 0x80000000L;
    public static final long MODE_TIME_TRUNCATE_FRACTIONAL = 0x100000000L;
    public static final long MODE_ANSI = 262144L;
    public static final long MODE_TRADITIONAL = 0x8000000L;
    public static final long MODE_LAST = 0x200000000L;
    public static final long MODE_DEFAULT = 0L;
    public static final long MODE_ALLOWED_MASK = 8321237247L;
    public static final long MODE_COMBINE_MASK = 0x8040000L;
    private static final Map<String, Long> sqlModeSet = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
    private static final Map<String, Long> combineModeSet = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);

    public static String decode(Long sqlMode) throws DdlException {
        if (sqlMode == 0L) {
            return "";
        }
        if ((sqlMode & 0xFFFFFFFE1003FF00L) != 0L) {
            ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_VALUE_FOR_VAR, "sql_mode", sqlMode);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, Long> mode : SqlModeHelper.getSupportedSqlMode().entrySet()) {
            if ((sqlMode & mode.getValue()) == 0L) continue;
            names.add(mode.getKey());
        }
        return Joiner.on((char)',').join(names);
    }

    public static Long encode(String sqlMode) throws DdlException {
        List names = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)sqlMode);
        long resultCode = 0L;
        for (String key : names) {
            long code = 0L;
            if (StringUtils.isNumeric((String)key)) {
                code |= SqlModeHelper.expand(Long.valueOf(key));
            } else {
                code = SqlModeHelper.getCodeFromString(key);
                if (code == 0L) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_VALUE_FOR_VAR, "sql_mode", key);
                }
            }
            if (((resultCode |= code) & 0xFFFFFFFE1003FF00L) == 0L) continue;
            ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_VALUE_FOR_VAR, "sql_mode", key);
        }
        return resultCode;
    }

    public static long expand(long sqlMode) throws DdlException {
        for (String key : SqlModeHelper.getCombineMode().keySet()) {
            if ((sqlMode & SqlModeHelper.getSupportedSqlMode().get(key)) == 0L) continue;
            sqlMode |= SqlModeHelper.getCombineMode().get(key).longValue();
        }
        return sqlMode;
    }

    public static boolean isSupportedSqlMode(String sqlMode) {
        return sqlMode != null && SqlModeHelper.getSupportedSqlMode().containsKey(sqlMode);
    }

    private static long getCodeFromString(String sqlMode) {
        long code = 0L;
        if (SqlModeHelper.isSupportedSqlMode(sqlMode)) {
            if (SqlModeHelper.isCombineMode(sqlMode)) {
                code |= SqlModeHelper.getCombineMode().get(sqlMode).longValue();
            }
            code |= SqlModeHelper.getSupportedSqlMode().get(sqlMode).longValue();
        }
        return code;
    }

    public static boolean isCombineMode(String key) {
        return combineModeSet.containsKey(key);
    }

    public static Map<String, Long> getSupportedSqlMode() {
        return sqlModeSet;
    }

    public static Map<String, Long> getCombineMode() {
        return combineModeSet;
    }

    static {
        sqlModeSet.put("REAL_AS_FLOAT", 1L);
        sqlModeSet.put("PIPES_AS_CONCAT", 2L);
        sqlModeSet.put("ANSI_QUOTES", 4L);
        sqlModeSet.put("IGNORE_SPACE", 8L);
        sqlModeSet.put("NOT_USED", 16L);
        sqlModeSet.put("ONLY_FULL_GROUP_BY", 32L);
        sqlModeSet.put("NO_UNSIGNED_SUBTRACTION", 64L);
        sqlModeSet.put("NO_DIR_IN_CREATE", 128L);
        sqlModeSet.put("ANSI", 262144L);
        sqlModeSet.put("NO_AUTO_VALUE_ON_ZERO", 524288L);
        sqlModeSet.put("NO_BACKSLASH_ESCAPES", 0x100000L);
        sqlModeSet.put("STRICT_TRANS_TABLES", 0x200000L);
        sqlModeSet.put("STRICT_ALL_TABLES", 0x400000L);
        sqlModeSet.put("NO_ZERO_IN_DATE", 0x800000L);
        sqlModeSet.put("NO_ZERO_DATE", 0x1000000L);
        sqlModeSet.put("INVALID_DATES", 0x2000000L);
        sqlModeSet.put("ERROR_FOR_DIVISION_BY_ZERO", 0x4000000L);
        sqlModeSet.put("TRADITIONAL", 0x8000000L);
        sqlModeSet.put("HIGH_NOT_PRECEDENCE", 0x20000000L);
        sqlModeSet.put("NO_ENGINE_SUBSTITUTION", 0x40000000L);
        sqlModeSet.put("PAD_CHAR_TO_FULL_LENGTH", 0x80000000L);
        sqlModeSet.put("TIME_TRUNCATE_FRACTIONAL", 0x100000000L);
        combineModeSet.put("ANSI", 47L);
        combineModeSet.put("TRADITIONAL", 1172307968L);
    }
}

