/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Reference;
import org.apache.doris.common.UserException;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TScanRangeLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleScheduler {
    private static final Logger LOG = LogManager.getLogger(SimpleScheduler.class);
    private static AtomicLong nextId = new AtomicLong(0L);
    private static Map<Long, Pair<Integer, String>> blacklistBackends = Maps.newConcurrentMap();
    private static UpdateBlacklistThread updateBlacklistThread = new UpdateBlacklistThread();

    public static TNetworkAddress getHost(long backendId, List<TScanRangeLocation> locations, ImmutableMap<Long, Backend> backends, Reference<Long> backendIdRef) throws UserException {
        if (CollectionUtils.isEmpty(locations) || backends == null || backends.isEmpty()) {
            throw new UserException("scan range location or candidate backends is empty");
        }
        LOG.debug("getHost backendID={}, backendSize={}", (Object)backendId, (Object)backends.size());
        Backend backend = (Backend)backends.get((Object)backendId);
        if (SimpleScheduler.isAvailable(backend)) {
            backendIdRef.setRef(backendId);
            return new TNetworkAddress(backend.getHost(), backend.getBePort());
        }
        for (TScanRangeLocation location : locations) {
            Backend candidateBackend;
            if (location.backend_id == backendId || !SimpleScheduler.isAvailable(candidateBackend = (Backend)backends.get((Object)location.backend_id))) continue;
            backendIdRef.setRef(location.backend_id);
            return new TNetworkAddress(candidateBackend.getHost(), candidateBackend.getBePort());
        }
        throw new UserException("There is no scanNode Backend available." + SimpleScheduler.getBackendErrorMsg(locations.stream().map(l -> l.backend_id).collect(Collectors.toList()), backends, locations.size()));
    }

    public static TScanRangeLocation getLocation(TScanRangeLocation minLocation, List<TScanRangeLocation> locations, ImmutableMap<Long, Backend> backends, Reference<Long> backendIdRef) throws UserException {
        if (CollectionUtils.isEmpty(locations) || backends == null || backends.isEmpty()) {
            throw new UserException("scan range location or candidate backends is empty");
        }
        Backend backend = (Backend)backends.get((Object)minLocation.backend_id);
        if (SimpleScheduler.isAvailable(backend)) {
            backendIdRef.setRef(minLocation.backend_id);
            return minLocation;
        }
        for (TScanRangeLocation location : locations) {
            Backend candidateBackend;
            if (location.backend_id == minLocation.backend_id || !SimpleScheduler.isAvailable(candidateBackend = (Backend)backends.get((Object)location.backend_id))) continue;
            backendIdRef.setRef(location.backend_id);
            return location;
        }
        throw new UserException("There is no scanNode Backend available." + SimpleScheduler.getBackendErrorMsg(locations.stream().map(l -> l.backend_id).collect(Collectors.toList()), backends, locations.size()));
    }

    public static TNetworkAddress getHost(ImmutableMap<Long, Backend> backends, Reference<Long> backendIdRef) throws UserException {
        if (backends == null || backends.isEmpty()) {
            throw new UserException("candidate backends is empty");
        }
        int backendSize = backends.size();
        long id = nextId.getAndIncrement() % (long)backendSize;
        ArrayList idToBackendId = Lists.newArrayList();
        idToBackendId.addAll(backends.keySet());
        Long backendId = (Long)idToBackendId.get((int)id);
        Backend backend = (Backend)backends.get((Object)backendId);
        if (SimpleScheduler.isAvailable(backend)) {
            backendIdRef.setRef(backendId);
            return new TNetworkAddress(backend.getHost(), backend.getBePort());
        }
        long candidateId = id + 1L;
        int i = 0;
        while (i < backendSize) {
            LOG.debug("i={} candidatedId={}", (Object)i, (Object)candidateId);
            if (candidateId >= (long)backendSize) {
                candidateId = 0L;
            }
            if (candidateId != id) {
                Long candidatebackendId = (Long)idToBackendId.get((int)candidateId);
                LOG.debug("candidatebackendId={}", (Object)candidatebackendId);
                Backend candidateBackend = (Backend)backends.get((Object)candidatebackendId);
                if (SimpleScheduler.isAvailable(candidateBackend)) {
                    backendIdRef.setRef(candidatebackendId);
                    return new TNetworkAddress(candidateBackend.getHost(), candidateBackend.getBePort());
                }
            }
            ++i;
            ++candidateId;
        }
        throw new UserException("There is no scanNode Backend available." + SimpleScheduler.getBackendErrorMsg(Lists.newArrayList((Iterable)backends.keySet()), backends, 3));
    }

    private static String getBackendErrorMsg(List<Long> backendIds, ImmutableMap<Long, Backend> backends, int limit) {
        ArrayList res = Lists.newArrayList();
        for (int i = 0; i < backendIds.size() && i < limit; ++i) {
            long beId = backendIds.get(i);
            Backend be = (Backend)backends.get((Object)beId);
            if (be == null) {
                res.add(beId + ": not exist");
                continue;
            }
            if (!be.isAlive()) {
                res.add(beId + ": not alive");
                continue;
            }
            if (blacklistBackends.containsKey(beId)) {
                Pair<Integer, String> pair = blacklistBackends.get(beId);
                res.add(beId + ": in black list(" + (pair == null ? "unknown" : (String)pair.second) + ")");
                continue;
            }
            if (!be.isQueryAvailable()) {
                res.add(beId + ": disable query");
                continue;
            }
            res.add(beId + ": unknown");
        }
        return ((Object)res).toString();
    }

    public static void addToBlacklist(Long backendID, String reason) {
        if (backendID == null) {
            return;
        }
        blacklistBackends.put(backendID, Pair.create(FeConstants.heartbeat_interval_second + 1, reason));
        LOG.warn("add backend {} to black list. reason: {}", (Object)backendID, (Object)reason);
    }

    public static boolean isAvailable(Backend backend) {
        return backend != null && backend.isQueryAvailable() && !blacklistBackends.containsKey(backend.getId());
    }

    public static TNetworkAddress getHostByCurrentBackend(Map<TNetworkAddress, Long> addressToBackendID) {
        int backendSize = addressToBackendID.size();
        if (backendSize == 0) {
            return null;
        }
        Long id = nextId.getAndIncrement() % (long)backendSize;
        ArrayList idToBackendId = Lists.newArrayList();
        idToBackendId.addAll(addressToBackendID.keySet());
        return (TNetworkAddress)idToBackendId.get(id.intValue());
    }

    static {
        updateBlacklistThread.start();
    }

    private static class UpdateBlacklistThread
    implements Runnable {
        private static final Logger LOG = LogManager.getLogger(UpdateBlacklistThread.class);
        private static Thread thread;

        public UpdateBlacklistThread() {
            thread = new Thread((Runnable)this, "UpdateBlacklistThread");
            thread.setDaemon(true);
        }

        public void start() {
            thread.start();
        }

        @Override
        public void run() {
            LOG.debug("UpdateBlacklistThread is start to run");
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        SystemInfoService clusterInfoService = Catalog.getCurrentSystemInfo();
                        LOG.debug("UpdateBlacklistThread retry begin");
                        Iterator iterator = blacklistBackends.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            Long backendId = (Long)entry.getKey();
                            if (clusterInfoService.getBackend(backendId) == null) {
                                iterator.remove();
                                LOG.info("remove backend {} from black list because it does not exist", (Object)backendId);
                                continue;
                            }
                            ((Pair)entry.getValue()).first = (Integer)((Pair)entry.getValue()).first - 1;
                            if ((Integer)((Pair)entry.getValue()).first <= 0) {
                                iterator.remove();
                                LOG.warn("remove backend {} from black list. reach max try time", (Object)backendId);
                                continue;
                            }
                            LOG.debug("blacklistBackends backendID={} retryTimes={}", (Object)backendId, ((Pair)entry.getValue()).first);
                        }
                        LOG.debug("UpdateBlacklistThread retry end");
                    }
                }
                catch (Throwable ex) {
                    LOG.warn("blacklist thread exception", ex);
                    continue;
                }
                break;
            }
        }
    }
}

