/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.common.FeConstants;
import org.apache.doris.qe.AbstractResultSet;
import org.apache.doris.qe.ResultSetMetaData;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.doris.thrift.TColumnDefinition;
import org.apache.doris.thrift.TShowResultSet;
import org.apache.doris.thrift.TShowResultSetMetaData;

public class ShowResultSet
extends AbstractResultSet {
    public ShowResultSet(ResultSetMetaData metaData, List<List<String>> resultRows) {
        super(metaData, resultRows);
    }

    public ShowResultSet(TShowResultSet resultSet) {
        ArrayList columns = Lists.newArrayList();
        for (int i = 0; i < resultSet.getMetaData().getColumnsSize(); ++i) {
            TColumnDefinition definition = (TColumnDefinition)resultSet.getMetaData().getColumns().get(i);
            columns.add(new Column(definition.getColumnName(), ScalarType.createType(PrimitiveType.fromThrift(definition.getColumnType().getType()))));
        }
        this.metaData = new ShowResultSetMetaData(columns);
        this.resultRows = resultSet.getResultRows();
        this.rowIdx = -1;
    }

    public TShowResultSet tothrift() {
        int i;
        TShowResultSet set = new TShowResultSet();
        set.metaData = new TShowResultSetMetaData();
        for (i = 0; i < this.metaData.getColumnCount(); ++i) {
            Column definition = this.metaData.getColumn(i);
            set.metaData.addToColumns(new TColumnDefinition(definition.getName(), definition.getOriginType().toColumnTypeThrift()));
        }
        set.resultRows = Lists.newArrayList();
        for (i = 0; i < this.resultRows.size(); ++i) {
            ArrayList list = Lists.newArrayList();
            for (int j = 0; j < ((List)this.resultRows.get(i)).size(); ++j) {
                list.add(((List)this.resultRows.get(i)).get(j) == null ? FeConstants.null_string : (String)((List)this.resultRows.get(i)).get(j));
            }
            set.resultRows.add(list);
        }
        return set;
    }
}

