/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.doris.analysis.AdminDiagnoseTabletStmt;
import org.apache.doris.analysis.AdminShowConfigStmt;
import org.apache.doris.analysis.AdminShowReplicaDistributionStmt;
import org.apache.doris.analysis.AdminShowReplicaStatusStmt;
import org.apache.doris.analysis.AdminShowTabletStorageFormatStmt;
import org.apache.doris.analysis.DescribeStmt;
import org.apache.doris.analysis.HelpStmt;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.ShowAlterStmt;
import org.apache.doris.analysis.ShowAuthorStmt;
import org.apache.doris.analysis.ShowBackendsStmt;
import org.apache.doris.analysis.ShowBackupStmt;
import org.apache.doris.analysis.ShowBrokerStmt;
import org.apache.doris.analysis.ShowClusterStmt;
import org.apache.doris.analysis.ShowCollationStmt;
import org.apache.doris.analysis.ShowColumnStatsStmt;
import org.apache.doris.analysis.ShowColumnStmt;
import org.apache.doris.analysis.ShowCreateDbStmt;
import org.apache.doris.analysis.ShowCreateFunctionStmt;
import org.apache.doris.analysis.ShowCreateRoutineLoadStmt;
import org.apache.doris.analysis.ShowCreateTableStmt;
import org.apache.doris.analysis.ShowDataSkewStmt;
import org.apache.doris.analysis.ShowDataStmt;
import org.apache.doris.analysis.ShowDbIdStmt;
import org.apache.doris.analysis.ShowDbStmt;
import org.apache.doris.analysis.ShowDeleteStmt;
import org.apache.doris.analysis.ShowDynamicPartitionStmt;
import org.apache.doris.analysis.ShowEncryptKeysStmt;
import org.apache.doris.analysis.ShowEnginesStmt;
import org.apache.doris.analysis.ShowExportStmt;
import org.apache.doris.analysis.ShowFrontendsStmt;
import org.apache.doris.analysis.ShowFunctionsStmt;
import org.apache.doris.analysis.ShowGrantsStmt;
import org.apache.doris.analysis.ShowIndexStmt;
import org.apache.doris.analysis.ShowLastInsertStmt;
import org.apache.doris.analysis.ShowLoadProfileStmt;
import org.apache.doris.analysis.ShowLoadStmt;
import org.apache.doris.analysis.ShowLoadWarningsStmt;
import org.apache.doris.analysis.ShowMigrationsStmt;
import org.apache.doris.analysis.ShowPartitionIdStmt;
import org.apache.doris.analysis.ShowPartitionsStmt;
import org.apache.doris.analysis.ShowPluginsStmt;
import org.apache.doris.analysis.ShowProcStmt;
import org.apache.doris.analysis.ShowProcesslistStmt;
import org.apache.doris.analysis.ShowQueryProfileStmt;
import org.apache.doris.analysis.ShowRepositoriesStmt;
import org.apache.doris.analysis.ShowResourcesStmt;
import org.apache.doris.analysis.ShowRestoreStmt;
import org.apache.doris.analysis.ShowRolesStmt;
import org.apache.doris.analysis.ShowRollupStmt;
import org.apache.doris.analysis.ShowRoutineLoadStmt;
import org.apache.doris.analysis.ShowRoutineLoadTaskStmt;
import org.apache.doris.analysis.ShowSmallFilesStmt;
import org.apache.doris.analysis.ShowSnapshotStmt;
import org.apache.doris.analysis.ShowSqlBlockRuleStmt;
import org.apache.doris.analysis.ShowStmt;
import org.apache.doris.analysis.ShowStreamLoadStmt;
import org.apache.doris.analysis.ShowSyncJobStmt;
import org.apache.doris.analysis.ShowTableCreationStmt;
import org.apache.doris.analysis.ShowTableIdStmt;
import org.apache.doris.analysis.ShowTableStatsStmt;
import org.apache.doris.analysis.ShowTableStatusStmt;
import org.apache.doris.analysis.ShowTableStmt;
import org.apache.doris.analysis.ShowTabletStmt;
import org.apache.doris.analysis.ShowTransactionStmt;
import org.apache.doris.analysis.ShowTrashDiskStmt;
import org.apache.doris.analysis.ShowTrashStmt;
import org.apache.doris.analysis.ShowUserPropertyStmt;
import org.apache.doris.analysis.ShowVariablesStmt;
import org.apache.doris.analysis.ShowViewStmt;
import org.apache.doris.backup.AbstractJob;
import org.apache.doris.backup.BackupJob;
import org.apache.doris.backup.Repository;
import org.apache.doris.backup.RestoreJob;
import org.apache.doris.blockrule.SqlBlockRule;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.DynamicPartitionProperty;
import org.apache.doris.catalog.EncryptKey;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.Index;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.MetadataViewer;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.catalog.View;
import org.apache.doris.clone.DynamicPartitionScheduler;
import org.apache.doris.cluster.BaseParam;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.ConfigBase;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.proc.BackendsProcDir;
import org.apache.doris.common.proc.FrontendsProcNode;
import org.apache.doris.common.proc.PartitionsProcDir;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.RollupProcDir;
import org.apache.doris.common.proc.SchemaChangeProcDir;
import org.apache.doris.common.proc.TabletsProcDir;
import org.apache.doris.common.proc.TrashProcDir;
import org.apache.doris.common.proc.TrashProcNode;
import org.apache.doris.common.profile.ProfileTreeNode;
import org.apache.doris.common.profile.ProfileTreePrinter;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.LogBuilder;
import org.apache.doris.common.util.LogKey;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.ProfileManager;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.external.iceberg.IcebergTableCreationRecord;
import org.apache.doris.load.DeleteHandler;
import org.apache.doris.load.ExportJob;
import org.apache.doris.load.ExportMgr;
import org.apache.doris.load.Load;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.load.LoadJob;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.HelpModule;
import org.apache.doris.qe.HelpTopic;
import org.apache.doris.qe.InsertResult;
import org.apache.doris.qe.ShowResultSet;
import org.apache.doris.qe.ShowResultSetMetaData;
import org.apache.doris.qe.VariableMgr;
import org.apache.doris.system.Backend;
import org.apache.doris.system.Diagnoser;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.task.AgentClient;
import org.apache.doris.thrift.TCheckStorageFormatResult;
import org.apache.doris.thrift.TUnit;
import org.apache.doris.transaction.GlobalTransactionMgr;
import org.apache.doris.transaction.TransactionStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowExecutor {
    private static final Logger LOG = LogManager.getLogger(ShowExecutor.class);
    private static final List<List<String>> EMPTY_SET = Lists.newArrayList();
    private ConnectContext ctx;
    private ShowStmt stmt;
    private ShowResultSet resultSet;

    public ShowExecutor(ConnectContext ctx, ShowStmt stmt) {
        this.ctx = ctx;
        this.stmt = stmt;
        this.resultSet = null;
    }

    public ShowResultSet execute() throws AnalysisException {
        if (this.stmt instanceof ShowRollupStmt) {
            this.handleShowRollup();
        } else if (this.stmt instanceof ShowAuthorStmt) {
            this.handleShowAuthor();
        } else if (this.stmt instanceof ShowProcStmt) {
            this.handleShowProc();
        } else if (this.stmt instanceof HelpStmt) {
            this.handleHelp();
        } else if (this.stmt instanceof ShowDbStmt) {
            this.handleShowDb();
        } else if (this.stmt instanceof ShowDbIdStmt) {
            this.handleShowDbId();
        } else if (this.stmt instanceof ShowTableStmt) {
            this.handleShowTable();
        } else if (this.stmt instanceof ShowTableStatusStmt) {
            this.handleShowTableStatus();
        } else if (this.stmt instanceof ShowTableIdStmt) {
            this.handleShowTableId();
        } else if (this.stmt instanceof DescribeStmt) {
            this.handleDescribe();
        } else if (this.stmt instanceof ShowCreateTableStmt) {
            this.handleShowCreateTable();
        } else if (this.stmt instanceof ShowCreateDbStmt) {
            this.handleShowCreateDb();
        } else if (this.stmt instanceof ShowProcesslistStmt) {
            this.handleShowProcesslist();
        } else if (this.stmt instanceof ShowEnginesStmt) {
            this.handleShowEngines();
        } else if (this.stmt instanceof ShowFunctionsStmt) {
            this.handleShowFunctions();
        } else if (this.stmt instanceof ShowCreateFunctionStmt) {
            this.handleShowCreateFunction();
        } else if (this.stmt instanceof ShowEncryptKeysStmt) {
            this.handleShowEncryptKeys();
        } else if (this.stmt instanceof ShowVariablesStmt) {
            this.handleShowVariables();
        } else if (this.stmt instanceof ShowColumnStmt) {
            this.handleShowColumn();
        } else if (this.stmt instanceof ShowLoadStmt) {
            this.handleShowLoad();
        } else if (this.stmt instanceof ShowStreamLoadStmt) {
            this.handleShowStreamLoad();
        } else if (this.stmt instanceof ShowLoadWarningsStmt) {
            this.handleShowLoadWarnings();
        } else if (this.stmt instanceof ShowRoutineLoadStmt) {
            this.handleShowRoutineLoad();
        } else if (this.stmt instanceof ShowRoutineLoadTaskStmt) {
            this.handleShowRoutineLoadTask();
        } else if (this.stmt instanceof ShowCreateRoutineLoadStmt) {
            this.handleShowCreateRoutineLoad();
        } else if (this.stmt instanceof ShowDeleteStmt) {
            this.handleShowDelete();
        } else if (this.stmt instanceof ShowAlterStmt) {
            this.handleShowAlter();
        } else if (this.stmt instanceof ShowUserPropertyStmt) {
            this.handleShowUserProperty();
        } else if (this.stmt instanceof ShowDataStmt) {
            this.handleShowData();
        } else if (this.stmt instanceof ShowCollationStmt) {
            this.handleShowCollation();
        } else if (this.stmt instanceof ShowPartitionsStmt) {
            this.handleShowPartitions();
        } else if (this.stmt instanceof ShowPartitionIdStmt) {
            this.handleShowPartitionId();
        } else if (this.stmt instanceof ShowTabletStmt) {
            this.handleShowTablet();
        } else if (this.stmt instanceof ShowBackupStmt) {
            this.handleShowBackup();
        } else if (this.stmt instanceof ShowRestoreStmt) {
            this.handleShowRestore();
        } else if (this.stmt instanceof ShowClusterStmt) {
            this.handleShowCluster();
        } else if (this.stmt instanceof ShowMigrationsStmt) {
            this.handleShowMigrations();
        } else if (this.stmt instanceof ShowBrokerStmt) {
            this.handleShowBroker();
        } else if (this.stmt instanceof ShowResourcesStmt) {
            this.handleShowResources();
        } else if (this.stmt instanceof ShowExportStmt) {
            this.handleShowExport();
        } else if (this.stmt instanceof ShowBackendsStmt) {
            this.handleShowBackends();
        } else if (this.stmt instanceof ShowFrontendsStmt) {
            this.handleShowFrontends();
        } else if (this.stmt instanceof ShowRepositoriesStmt) {
            this.handleShowRepositories();
        } else if (this.stmt instanceof ShowSnapshotStmt) {
            this.handleShowSnapshot();
        } else if (this.stmt instanceof ShowGrantsStmt) {
            this.handleShowGrants();
        } else if (this.stmt instanceof ShowRolesStmt) {
            this.handleShowRoles();
        } else if (this.stmt instanceof ShowTrashStmt) {
            this.handleShowTrash();
        } else if (this.stmt instanceof ShowTrashDiskStmt) {
            this.handleShowTrashDisk();
        } else if (this.stmt instanceof AdminShowReplicaStatusStmt) {
            this.handleAdminShowTabletStatus();
        } else if (this.stmt instanceof AdminShowReplicaDistributionStmt) {
            this.handleAdminShowTabletDistribution();
        } else if (this.stmt instanceof AdminShowConfigStmt) {
            this.handleAdminShowConfig();
        } else if (this.stmt instanceof ShowSmallFilesStmt) {
            this.handleShowSmallFiles();
        } else if (this.stmt instanceof ShowDynamicPartitionStmt) {
            this.handleShowDynamicPartition();
        } else if (this.stmt instanceof ShowIndexStmt) {
            this.handleShowIndex();
        } else if (this.stmt instanceof ShowViewStmt) {
            this.handleShowView();
        } else if (this.stmt instanceof ShowTransactionStmt) {
            this.handleShowTransaction();
        } else if (this.stmt instanceof ShowPluginsStmt) {
            this.handleShowPlugins();
        } else if (this.stmt instanceof ShowQueryProfileStmt) {
            this.handleShowQueryProfile();
        } else if (this.stmt instanceof ShowLoadProfileStmt) {
            this.handleShowLoadProfile();
        } else if (this.stmt instanceof ShowDataSkewStmt) {
            this.handleShowDataSkew();
        } else if (this.stmt instanceof ShowSyncJobStmt) {
            this.handleShowSyncJobs();
        } else if (this.stmt instanceof ShowSqlBlockRuleStmt) {
            this.handleShowSqlBlockRule();
        } else if (this.stmt instanceof ShowTableStatsStmt) {
            this.handleShowTableStats();
        } else if (this.stmt instanceof ShowColumnStatsStmt) {
            this.handleShowColumnStats();
        } else if (this.stmt instanceof ShowTableCreationStmt) {
            this.handleShowTableCreation();
        } else if (this.stmt instanceof ShowLastInsertStmt) {
            this.handleShowLastInsert();
        } else if (this.stmt instanceof AdminShowTabletStorageFormatStmt) {
            this.handleAdminShowTabletStorageFormat();
        } else if (this.stmt instanceof AdminDiagnoseTabletStmt) {
            this.handleAdminDiagnoseTablet();
        } else {
            this.handleEmtpy();
        }
        return this.resultSet;
    }

    private void handleShowRollup() {
        ShowRollupStmt showRollupStmt = (ShowRollupStmt)this.stmt;
        ArrayList rowSets = Lists.newArrayList();
        this.resultSet = new ShowResultSet(showRollupStmt.getMetaData(), rowSets);
    }

    private void handleShowProcesslist() {
        ShowProcesslistStmt showStmt = (ShowProcesslistStmt)this.stmt;
        ArrayList rowSet = Lists.newArrayList();
        List<ConnectContext.ThreadInfo> threadInfos = this.ctx.getConnectScheduler().listConnection(this.ctx.getQualifiedUser());
        long nowMs = System.currentTimeMillis();
        for (ConnectContext.ThreadInfo info : threadInfos) {
            rowSet.add(info.toRow(nowMs));
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rowSet);
    }

    private void handleEmtpy() {
        this.resultSet = new ShowResultSet(this.stmt.getMetaData(), EMPTY_SET);
    }

    private void handleShowAuthor() {
        ShowAuthorStmt showAuthorStmt = (ShowAuthorStmt)this.stmt;
        ArrayList rowSet = Lists.newArrayList();
        this.resultSet = new ShowResultSet(showAuthorStmt.getMetaData(), rowSet);
    }

    private void handleShowEngines() {
        ShowEnginesStmt showStmt = (ShowEnginesStmt)this.stmt;
        ArrayList rowSet = Lists.newArrayList();
        rowSet.add(Lists.newArrayList((Object[])new String[]{"Olap engine", "YES", "Default storage engine of palo", "NO", "NO", "NO"}));
        rowSet.add(Lists.newArrayList((Object[])new String[]{"MySQL", "YES", "MySQL server which data is in it", "NO", "NO", "NO"}));
        rowSet.add(Lists.newArrayList((Object[])new String[]{"ELASTICSEARCH", "YES", "ELASTICSEARCH cluster which data is in it", "NO", "NO", "NO"}));
        rowSet.add(Lists.newArrayList((Object[])new String[]{"HIVE", "YES", "HIVE database which data is in it", "NO", "NO", "NO"}));
        rowSet.add(Lists.newArrayList((Object[])new String[]{"ICEBERG", "YES", "ICEBERG data lake which data is in it", "NO", "NO", "NO"}));
        rowSet.add(Lists.newArrayList((Object[])new String[]{"ODBC", "YES", "ODBC driver which data we can connect", "NO", "NO", "NO"}));
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rowSet);
    }

    private void handleShowFunctions() throws AnalysisException {
        ShowFunctionsStmt showStmt = (ShowFunctionsStmt)this.stmt;
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(showStmt.getDbName());
        List<Function> functions = showStmt.getIsBuiltin() ? this.ctx.getCatalog().getBuiltinFunctions() : db.getFunctions();
        ArrayList rowSet = Lists.newArrayList();
        for (Function function : functions) {
            List<Comparable> row = function.getInfo(showStmt.getIsVerbose());
            if (showStmt.getWild() != null && !showStmt.like(function.functionName())) continue;
            rowSet.add(row);
        }
        ListComparator comparator = null;
        OrderByPair orderByPair = new OrderByPair(0, false);
        comparator = new ListComparator(orderByPair);
        Collections.sort(rowSet, comparator);
        ArrayList resultRowSet = Lists.newArrayList();
        HashSet<String> functionNameSet = new HashSet<String>();
        for (List row : rowSet) {
            ArrayList resultRow = Lists.newArrayList();
            if (functionNameSet.contains(((Comparable)row.get(0)).toString())) continue;
            for (Comparable column : row) {
                resultRow.add(column.toString());
            }
            resultRowSet.add(resultRow);
            functionNameSet.add((String)resultRow.get(0));
        }
        ShowResultSetMetaData showMetaData = showStmt.getIsVerbose() ? showStmt.getMetaData() : ShowResultSetMetaData.builder().addColumn(new Column("Function Name", ScalarType.createVarchar(256))).build();
        this.resultSet = new ShowResultSet(showMetaData, resultRowSet);
    }

    private void handleShowCreateFunction() throws AnalysisException {
        ShowCreateFunctionStmt showCreateFunctionStmt = (ShowCreateFunctionStmt)this.stmt;
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(showCreateFunctionStmt.getDbName());
        Function function = db.getFunction(showCreateFunctionStmt.getFunction());
        ArrayList resultRowSet = Lists.newArrayList();
        ArrayList resultRow = Lists.newArrayList();
        resultRow.add(function.signatureString());
        resultRow.add(function.toSql(false));
        resultRowSet.add(resultRow);
        this.resultSet = new ShowResultSet(showCreateFunctionStmt.getMetaData(), resultRowSet);
    }

    private void handleShowEncryptKeys() throws AnalysisException {
        ShowEncryptKeysStmt showStmt = (ShowEncryptKeysStmt)this.stmt;
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(showStmt.getDbName());
        List<EncryptKey> encryptKeys = db.getEncryptKeys();
        ArrayList rowSet = Lists.newArrayList();
        for (EncryptKey encryptKey : encryptKeys) {
            List<Comparable> row = encryptKey.getInfo();
            if (showStmt.getWild() != null && !showStmt.like(encryptKey.getEncryptKeyName().getKeyName())) continue;
            rowSet.add(row);
        }
        ListComparator comparator = null;
        OrderByPair orderByPair = new OrderByPair(0, false);
        comparator = new ListComparator(orderByPair);
        Collections.sort(rowSet, comparator);
        ArrayList resultRowSet = Lists.newArrayList();
        HashSet<String> encryptKeyNameSet = new HashSet<String>();
        for (List row : rowSet) {
            ArrayList resultRow = Lists.newArrayList();
            for (Comparable column : row) {
                resultRow.add(column.toString());
            }
            resultRowSet.add(resultRow);
            encryptKeyNameSet.add((String)resultRow.get(0));
        }
        ShowResultSetMetaData showMetaData = showStmt.getMetaData();
        this.resultSet = new ShowResultSet(showMetaData, resultRowSet);
    }

    private void handleShowProc() throws AnalysisException {
        ShowProcStmt showProcStmt = (ShowProcStmt)this.stmt;
        ShowResultSetMetaData metaData = showProcStmt.getMetaData();
        ProcNodeInterface procNode = showProcStmt.getNode();
        List<List<String>> finalRows = procNode.fetchResult().getRows();
        if (procNode instanceof BackendsProcDir && !Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.OPERATOR)) {
            for (List<String> row : finalRows) {
                row.remove(3);
            }
            metaData.removeColumn(3);
        }
        this.resultSet = new ShowResultSet(metaData, finalRows);
    }

    private void handleShowCluster() throws AnalysisException {
        ShowClusterStmt showStmt = (ShowClusterStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        List<String> clusterNames = this.ctx.getCatalog().getClusterNames();
        TreeSet clusterNameSet = Sets.newTreeSet();
        for (String cluster : clusterNames) {
            clusterNameSet.add(cluster);
        }
        for (String clusterName : clusterNameSet) {
            rows.add(Lists.newArrayList((Object[])new String[]{clusterName}));
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowMigrations() throws AnalysisException {
        ShowMigrationsStmt showStmt = (ShowMigrationsStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        Set<BaseParam> infos = this.ctx.getCatalog().getMigrations();
        for (BaseParam param : infos) {
            int percent = (int)(param.getFloatParam(0) * 100.0f);
            rows.add(Lists.newArrayList((Object[])new String[]{param.getStringParam(0), param.getStringParam(1), param.getStringParam(2), String.valueOf(percent + "%")}));
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowDbId() throws AnalysisException {
        ShowDbIdStmt showStmt = (ShowDbIdStmt)this.stmt;
        long dbId = showStmt.getDbId();
        ArrayList rows = Lists.newArrayList();
        Catalog catalog = this.ctx.getCatalog();
        Database database = catalog.getDbNullable(dbId);
        if (database != null) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(database.getFullName());
            rows.add(row);
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowTableId() throws AnalysisException {
        ShowTableIdStmt showStmt = (ShowTableIdStmt)this.stmt;
        long tableId = showStmt.getTableId();
        ArrayList rows = Lists.newArrayList();
        Catalog catalog = this.ctx.getCatalog();
        List<Long> dbIds = catalog.getDbIds();
        for (long dbId : dbIds) {
            Table table;
            Database database = catalog.getDbNullable(dbId);
            if (database == null || (table = database.getTableNullable(tableId)) == null) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add(database.getFullName());
            row.add(table.getName());
            row.add(String.valueOf(database.getId()));
            rows.add(row);
            break;
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShowPartitionId() throws AnalysisException {
        ShowPartitionIdStmt showStmt = (ShowPartitionIdStmt)this.stmt;
        long partitionId = showStmt.getPartitionId();
        ArrayList rows = Lists.newArrayList();
        Catalog catalog = this.ctx.getCatalog();
        List<Long> dbIds = catalog.getDbIds();
        block3: for (long dbId : dbIds) {
            Database database = catalog.getDbNullable(dbId);
            if (database == null) continue;
            List<Table> tables = database.getTables();
            for (Table tbl : tables) {
                if (!(tbl instanceof OlapTable)) continue;
                tbl.readLock();
                try {
                    Partition partition = ((OlapTable)tbl).getPartition(partitionId);
                    if (partition == null) continue;
                    ArrayList<String> row = new ArrayList<String>();
                    row.add(database.getFullName());
                    row.add(tbl.getName());
                    row.add(partition.getName());
                    row.add(String.valueOf(database.getId()));
                    row.add(String.valueOf(tbl.getId()));
                    rows.add(row);
                    continue block3;
                }
                finally {
                    tbl.readUnlock();
                    continue block3;
                }
            }
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowDb() throws AnalysisException {
        ShowDbStmt showDbStmt = (ShowDbStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        List<String> dbNames = this.ctx.getCatalog().getClusterDbNames(this.ctx.getClusterName());
        PatternMatcher matcher = null;
        if (showDbStmt.getPattern() != null) {
            matcher = PatternMatcher.createMysqlPattern(showDbStmt.getPattern(), CaseSensibility.DATABASE.getCaseSensibility());
        }
        TreeSet dbNameSet = Sets.newTreeSet();
        for (String fullName : dbNames) {
            String db = ClusterNamespace.getNameFromFullName(fullName);
            if (matcher != null && !matcher.match(db) || !Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), fullName, PrivPredicate.SHOW)) continue;
            dbNameSet.add(db);
        }
        for (String dbName : dbNameSet) {
            rows.add(Lists.newArrayList((Object[])new String[]{dbName}));
        }
        this.resultSet = new ShowResultSet(showDbStmt.getMetaData(), rows);
    }

    private void handleShowTable() throws AnalysisException {
        ShowTableStmt showTableStmt = (ShowTableStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(showTableStmt.getDb());
        PatternMatcher matcher = null;
        if (showTableStmt.getPattern() != null) {
            matcher = PatternMatcher.createMysqlPattern(showTableStmt.getPattern(), CaseSensibility.TABLE.getCaseSensibility());
        }
        for (Table tbl : db.getTables()) {
            if (matcher != null && !matcher.match(tbl.getName()) || !Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), db.getFullName(), tbl.getName(), PrivPredicate.SHOW)) continue;
            if (showTableStmt.isVerbose()) {
                String storageFormat = "NONE";
                if (tbl instanceof OlapTable) {
                    storageFormat = ((OlapTable)tbl).getStorageFormat().toString();
                }
                rows.add(Lists.newArrayList((Object[])new String[]{tbl.getName(), tbl.getMysqlType(), storageFormat}));
                continue;
            }
            rows.add(Lists.newArrayList((Object[])new String[]{tbl.getName()}));
        }
        this.resultSet = new ShowResultSet(showTableStmt.getMetaData(), rows);
    }

    private void handleShowTableStatus() throws AnalysisException {
        ShowTableStatusStmt showStmt = (ShowTableStatusStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        Database db = this.ctx.getCatalog().getDbNullable(showStmt.getDb());
        if (db != null) {
            PatternMatcher matcher = null;
            if (showStmt.getPattern() != null) {
                matcher = PatternMatcher.createMysqlPattern(showStmt.getPattern(), CaseSensibility.TABLE.getCaseSensibility());
            }
            for (Table table : db.getTables()) {
                if (matcher != null && !matcher.match(table.getName()) || !Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), db.getFullName(), table.getName(), PrivPredicate.SHOW)) continue;
                ArrayList row = Lists.newArrayList();
                row.add(table.getName());
                row.add(table.getEngine());
                row.add(null);
                row.add(null);
                row.add(String.valueOf(table.getRowCount()));
                row.add(String.valueOf(table.getAvgRowLength()));
                row.add(String.valueOf(table.getDataLength()));
                row.add(null);
                row.add(null);
                row.add(null);
                row.add(null);
                row.add(TimeUtils.longToTimeString(table.getCreateTime() * 1000L));
                if (table.getUpdateTime() > 0L) {
                    row.add(TimeUtils.longToTimeString(table.getUpdateTime()));
                } else {
                    row.add(null);
                }
                if (table.getLastCheckTime() > 0L) {
                    row.add(TimeUtils.longToTimeString(table.getLastCheckTime()));
                } else {
                    row.add(null);
                }
                row.add("utf-8");
                row.add(null);
                row.add(null);
                row.add(table.getComment());
                rows.add(row);
            }
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowVariables() throws AnalysisException {
        ShowVariablesStmt showStmt = (ShowVariablesStmt)this.stmt;
        PatternMatcher matcher = null;
        if (showStmt.getPattern() != null) {
            matcher = PatternMatcher.createMysqlPattern(showStmt.getPattern(), CaseSensibility.VARIABLES.getCaseSensibility());
        }
        List<List<String>> rows = VariableMgr.dump(showStmt.getType(), this.ctx.getSessionVariable(), matcher);
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowCreateDb() throws AnalysisException {
        ShowCreateDbStmt showStmt = (ShowCreateDbStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(showStmt.getDb());
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE DATABASE `").append(ClusterNamespace.getNameFromFullName(showStmt.getDb())).append("`");
        if (db.getDbProperties().getProperties().size() > 0) {
            sb.append("\nPROPERTIES (\n");
            sb.append(new PrintableMap<String, String>(db.getDbProperties().getProperties(), "=", true, true, false));
            sb.append("\n)");
        }
        rows.add(Lists.newArrayList((Object[])new String[]{ClusterNamespace.getNameFromFullName(showStmt.getDb()), sb.toString()}));
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShowCreateTable() throws AnalysisException {
        ShowCreateTableStmt showStmt = (ShowCreateTableStmt)this.stmt;
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(showStmt.getDb());
        Table table = db.getTableOrAnalysisException(showStmt.getTable());
        ArrayList rows = Lists.newArrayList();
        table.readLock();
        try {
            ArrayList createTableStmt = Lists.newArrayList();
            Catalog.getDdlStmt(table, createTableStmt, null, null, false, true);
            if (createTableStmt.isEmpty()) {
                this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
                return;
            }
            if (table instanceof View) {
                rows.add(Lists.newArrayList((Object[])new String[]{table.getName(), (String)createTableStmt.get(0), "utf8", "utf8_general_ci"}));
                this.resultSet = new ShowResultSet(ShowCreateTableStmt.getViewMetaData(), rows);
            } else {
                if (showStmt.isView()) {
                    ErrorReport.reportAnalysisException(ErrorCode.ERR_WRONG_OBJECT, showStmt.getDb(), showStmt.getTable(), "VIEW");
                }
                rows.add(Lists.newArrayList((Object[])new String[]{table.getName(), (String)createTableStmt.get(0)}));
                this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
            }
        }
        finally {
            table.readUnlock();
        }
    }

    private void handleDescribe() throws AnalysisException {
        DescribeStmt describeStmt = (DescribeStmt)this.stmt;
        this.resultSet = new ShowResultSet(describeStmt.getMetaData(), describeStmt.getResultRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShowColumn() throws AnalysisException {
        ShowColumnStmt showStmt = (ShowColumnStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(showStmt.getDb());
        Table table = db.getTableOrAnalysisException(showStmt.getTable());
        PatternMatcher matcher = null;
        if (showStmt.getPattern() != null) {
            matcher = PatternMatcher.createMysqlPattern(showStmt.getPattern(), CaseSensibility.COLUMN.getCaseSensibility());
        }
        table.readLock();
        try {
            List<Column> columns = table.getBaseSchema();
            for (Column col : columns) {
                String aggType;
                if (matcher != null && !matcher.match(col.getName())) continue;
                String columnName = col.getName();
                String columnType = col.getOriginType().toString();
                String isAllowNull = col.isAllowNull() ? "YES" : "NO";
                String isKey = col.isKey() ? "YES" : "NO";
                String defaultValue = col.getDefaultValue();
                String string = aggType = col.getAggregationType() == null ? "" : col.getAggregationType().toSql();
                if (showStmt.isVerbose()) {
                    rows.add(Lists.newArrayList((Object[])new String[]{columnName, columnType, "", isAllowNull, isKey, defaultValue, aggType, "", col.getComment()}));
                    continue;
                }
                rows.add(Lists.newArrayList((Object[])new String[]{columnName, columnType, isAllowNull, isKey, defaultValue, aggType}));
            }
        }
        finally {
            table.readUnlock();
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShowIndex() throws AnalysisException {
        ShowIndexStmt showStmt = (ShowIndexStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(showStmt.getDbName());
        OlapTable table = db.getOlapTableOrAnalysisException(showStmt.getTableName().getTbl());
        table.readLock();
        try {
            List<Index> indexes = table.getIndexes();
            for (Index index : indexes) {
                rows.add(Lists.newArrayList((Object[])new String[]{showStmt.getTableName().toString(), "", index.getIndexName(), "", String.join((CharSequence)",", index.getColumns()), "", "", "", "", "", index.getIndexType().name(), index.getComment()}));
            }
        }
        finally {
            table.readUnlock();
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShowView() {
        ShowViewStmt showStmt = (ShowViewStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        List<View> matchViews = showStmt.getMatchViews();
        for (View view : matchViews) {
            view.readLock();
            try {
                ArrayList createViewStmt = Lists.newArrayList();
                Catalog.getDdlStmt(view, createViewStmt, null, null, false, true);
                if (createViewStmt.isEmpty()) continue;
                rows.add(Lists.newArrayList((Object[])new String[]{view.getName(), (String)createViewStmt.get(0)}));
            }
            finally {
                view.readUnlock();
            }
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleHelp() {
        HelpStmt helpStmt = (HelpStmt)this.stmt;
        String mark = helpStmt.getMask();
        HelpModule module = HelpModule.getInstance();
        HelpTopic topic = module.getTopic(mark);
        if (topic == null) {
            List<String> topics = module.listTopicByKeyword(mark);
            if (topics.size() == 0) {
                topic = null;
            } else if (topics.size() == 1) {
                topic = module.getTopic(topics.get(0));
            } else {
                ArrayList rows = Lists.newArrayList();
                for (String string : topics) {
                    rows.add(Lists.newArrayList((Object[])new String[]{string, "N"}));
                }
                List<String> categories = module.listCategoryByName(mark);
                for (String str : categories) {
                    rows.add(Lists.newArrayList((Object[])new String[]{str, "Y"}));
                }
                this.resultSet = new ShowResultSet(helpStmt.getKeywordMetaData(), rows);
                return;
            }
        }
        if (topic != null) {
            this.resultSet = new ShowResultSet(helpStmt.getMetaData(), Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{topic.getName(), topic.getDescription(), topic.getExample()})}));
        } else {
            List<String> categories = module.listCategoryByName(mark);
            if (categories.isEmpty()) {
                this.resultSet = new ShowResultSet(helpStmt.getKeywordMetaData(), EMPTY_SET);
            } else if (categories.size() > 1) {
                this.resultSet = new ShowResultSet(helpStmt.getCategoryMetaData(), Lists.newArrayList((Object[])new List[]{categories}));
            } else {
                ArrayList rows = Lists.newArrayList();
                List<String> topics = module.listTopicByCategory(categories.get(0));
                for (String str : topics) {
                    rows.add(Lists.newArrayList((Object[])new String[]{str, "N"}));
                }
                List<String> list = module.listCategoryByCategory(categories.get(0));
                for (String str : list) {
                    rows.add(Lists.newArrayList((Object[])new String[]{str, "Y"}));
                }
                this.resultSet = new ShowResultSet(helpStmt.getKeywordMetaData(), rows);
            }
        }
    }

    private void handleShowLoad() throws AnalysisException {
        long offset;
        ShowLoadStmt showStmt = (ShowLoadStmt)this.stmt;
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbOrAnalysisException(showStmt.getDbName());
        long dbId = db.getId();
        Load load = catalog.getLoadInstance();
        LinkedList<List<Comparable>> loadInfos = load.getLoadJobInfosByDb(dbId, db.getFullName(), showStmt.getLabelValue(), showStmt.isAccurateMatch(), showStmt.getStates());
        Set<String> statesValue = showStmt.getStates() == null ? null : showStmt.getStates().stream().map(entity -> entity.name()).collect(Collectors.toSet());
        loadInfos.addAll(catalog.getLoadManager().getLoadJobInfosByDb(dbId, showStmt.getLabelValue(), showStmt.isAccurateMatch(), statesValue));
        ArrayList<OrderByPair> orderByPairs = showStmt.getOrderByPairs();
        ListComparator comparator = null;
        if (orderByPairs != null) {
            OrderByPair[] orderByPairArr = new OrderByPair[orderByPairs.size()];
            comparator = new ListComparator(orderByPairs.toArray(orderByPairArr));
        } else {
            comparator = new ListComparator(0);
        }
        Collections.sort(loadInfos, comparator);
        List rows = Lists.newArrayList();
        for (List list : loadInfos) {
            ArrayList<String> oneInfo = new ArrayList<String>(list.size());
            if (((Comparable)list.get(2)).equals(LoadJob.JobState.QUORUM_FINISHED.name())) {
                list.set(2, LoadJob.JobState.FINISHED.name());
            }
            for (Comparable element : list) {
                oneInfo.add(element.toString());
            }
            rows.add(oneInfo);
        }
        long limit = showStmt.getLimit();
        long l = offset = showStmt.getOffset() == -1L ? 0L : showStmt.getOffset();
        if (offset >= (long)rows.size()) {
            rows = Lists.newArrayList();
        } else if (limit != -1L) {
            rows = limit + offset < (long)rows.size() ? rows.subList((int)offset, (int)(limit + offset)) : rows.subList((int)offset, rows.size());
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowStreamLoad() throws AnalysisException {
        long offset;
        ShowStreamLoadStmt showStmt = (ShowStreamLoadStmt)this.stmt;
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbOrAnalysisException(showStmt.getDbName());
        long dbId = db.getId();
        List<List<Comparable>> streamLoadRecords = catalog.getStreamLoadRecordMgr().getStreamLoadRecordByDb(dbId, showStmt.getLabelValue(), showStmt.isAccurateMatch(), showStmt.getState());
        ArrayList<OrderByPair> orderByPairs = showStmt.getOrderByPairs();
        if (orderByPairs == null) {
            orderByPairs = showStmt.getOrderByFinishTime();
        }
        ListComparator comparator = null;
        if (orderByPairs != null) {
            OrderByPair[] orderByPairArr = new OrderByPair[orderByPairs.size()];
            comparator = new ListComparator(orderByPairs.toArray(orderByPairArr));
        } else {
            comparator = new ListComparator(0);
        }
        Collections.sort(streamLoadRecords, comparator);
        List rows = Lists.newArrayList();
        for (List<Comparable> streamLoadRecord : streamLoadRecords) {
            ArrayList<String> oneInfo = new ArrayList<String>(streamLoadRecord.size());
            for (Comparable element : streamLoadRecord) {
                oneInfo.add(element.toString());
            }
            rows.add(oneInfo);
        }
        long limit = showStmt.getLimit();
        long l = offset = showStmt.getOffset() == -1L ? 0L : showStmt.getOffset();
        if (offset >= (long)rows.size()) {
            rows = Lists.newArrayList();
        } else if (limit != -1L) {
            rows = limit + offset < (long)rows.size() ? rows.subList((int)offset, (int)(limit + offset)) : rows.subList((int)offset, rows.size());
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowLoadWarnings() throws AnalysisException {
        LoadErrorHub.Param param;
        Set<String> tableNames;
        ShowLoadWarningsStmt showWarningsStmt = (ShowLoadWarningsStmt)this.stmt;
        if (showWarningsStmt.getURL() != null) {
            this.handleShowLoadWarningsFromURL(showWarningsStmt, showWarningsStmt.getURL());
            return;
        }
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbOrAnalysisException(showWarningsStmt.getDbName());
        long dbId = db.getId();
        Load load = catalog.getLoadInstance();
        long jobId = 0L;
        LoadJob job = null;
        String label = null;
        if (showWarningsStmt.isFindByLabel()) {
            label = showWarningsStmt.getLabel();
            jobId = load.getLatestJobIdByLabel(dbId, showWarningsStmt.getLabel());
            job = load.getLoadJob(jobId);
            if (job == null) {
                throw new AnalysisException("job is not exist.");
            }
        } else {
            LOG.debug("load_job_id={}", (Object)jobId);
            jobId = showWarningsStmt.getJobId();
            job = load.getLoadJob(jobId);
            if (job == null) {
                throw new AnalysisException("job is not exist.");
            }
            label = job.getLabel();
            LOG.info("label={}", (Object)label);
        }
        if ((tableNames = job.getTableNames()).isEmpty()) {
            if (!Catalog.getCurrentCatalog().getAuth().checkDbPriv(ConnectContext.get(), db.getFullName(), PrivPredicate.SHOW)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_DBACCESS_DENIED_ERROR, ConnectContext.get().getQualifiedUser(), db.getFullName());
            }
        } else {
            for (String tblName : tableNames) {
                if (Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), db.getFullName(), tblName, PrivPredicate.SHOW)) continue;
                ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SHOW LOAD WARNING", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), db.getFullName() + ": " + tblName);
            }
        }
        if ((param = load.getLoadErrorHubInfo()) == null || param.getType() == LoadErrorHub.HubType.NULL_TYPE) {
            throw new AnalysisException("no load error hub be supplied.");
        }
        LoadErrorHub errorHub = LoadErrorHub.createHub(param);
        List<LoadErrorHub.ErrorMsg> errors = errorHub.fetchLoadError(jobId);
        errorHub.close();
        List<ArrayList> rows = Lists.newArrayList();
        for (LoadErrorHub.ErrorMsg error : errors) {
            ArrayList oneInfo = Lists.newArrayList();
            oneInfo.add(String.valueOf(jobId));
            oneInfo.add(label);
            oneInfo.add(error.getMsg());
            rows.add(oneInfo);
        }
        long limit = showWarningsStmt.getLimitNum();
        if (limit != -1L && limit < (long)rows.size()) {
            rows = rows.subList(0, (int)limit);
        }
        this.resultSet = new ShowResultSet(showWarningsStmt.getMetaData(), (List<List<String>>)rows);
    }

    private void handleShowLoadWarningsFromURL(ShowLoadWarningsStmt showWarningsStmt, URL url) throws AnalysisException {
        String host = url.getHost();
        int port = url.getPort();
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        Backend be = infoService.getBackendWithHttpPort(host, port);
        if (be == null) {
            throw new AnalysisException(host + ":" + port + " is not a valid backend");
        }
        if (!be.isAlive()) {
            throw new AnalysisException("Backend " + host + ":" + port + " is not alive");
        }
        if (!url.getPath().equals("/api/_load_error_log")) {
            throw new AnalysisException("Invalid error log path: " + url.getPath() + ". path should be: /api/_load_error_log");
        }
        ArrayList rows = Lists.newArrayList();
        try {
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                for (int limit = 100; reader.ready() && limit > 0; --limit) {
                    String line = reader.readLine();
                    rows.add(Lists.newArrayList((Object[])new String[]{"-1", FeConstants.null_string, line}));
                }
            }
        }
        catch (Exception e) {
            LOG.warn("failed to get error log from url: " + url, (Throwable)e);
            throw new AnalysisException("failed to get error log from url: " + url + ". reason: " + e.getMessage());
        }
        this.resultSet = new ShowResultSet(showWarningsStmt.getMetaData(), rows);
    }

    private void handleShowRoutineLoad() throws AnalysisException {
        List<RoutineLoadJob> routineLoadJobList;
        ShowRoutineLoadStmt showRoutineLoadStmt = (ShowRoutineLoadStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        try {
            PatternMatcher matcher = null;
            if (showRoutineLoadStmt.getPattern() != null) {
                matcher = PatternMatcher.createMysqlPattern(showRoutineLoadStmt.getPattern(), CaseSensibility.ROUTINE_LOAD.getCaseSensibility());
            }
            routineLoadJobList = Catalog.getCurrentCatalog().getRoutineLoadManager().getJob(showRoutineLoadStmt.getDbFullName(), showRoutineLoadStmt.getName(), showRoutineLoadStmt.isIncludeHistory(), matcher);
        }
        catch (MetaNotFoundException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new AnalysisException(e.getMessage());
        }
        if (routineLoadJobList != null) {
            String dbFullName = showRoutineLoadStmt.getDbFullName();
            String tableName = null;
            for (RoutineLoadJob routineLoadJob : routineLoadJobList) {
                try {
                    tableName = routineLoadJob.getTableName();
                }
                catch (MetaNotFoundException e) {
                    LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("error_msg", "The table metadata of job has been changed. The job will be cancelled automatically").build(), (Throwable)e);
                }
                if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbFullName, tableName, PrivPredicate.LOAD)) {
                    LOG.warn((Object)new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("operator", "show routine load job").add("user", ConnectContext.get().getQualifiedUser()).add("remote_ip", ConnectContext.get().getRemoteIP()).add("db_full_name", dbFullName).add("table_name", tableName).add("error_msg", "The table access denied"));
                    continue;
                }
                rows.add(routineLoadJob.getShowInfo());
            }
        }
        if (!Strings.isNullOrEmpty((String)showRoutineLoadStmt.getName()) && rows.size() == 0) {
            throw new AnalysisException("There is no job named " + showRoutineLoadStmt.getName() + " in db " + showRoutineLoadStmt.getDbFullName() + ". Include history? " + showRoutineLoadStmt.isIncludeHistory());
        }
        this.resultSet = new ShowResultSet(showRoutineLoadStmt.getMetaData(), rows);
    }

    private void handleShowRoutineLoadTask() throws AnalysisException {
        String tableName;
        RoutineLoadJob routineLoadJob;
        ShowRoutineLoadTaskStmt showRoutineLoadTaskStmt = (ShowRoutineLoadTaskStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        try {
            routineLoadJob = Catalog.getCurrentCatalog().getRoutineLoadManager().getJob(showRoutineLoadTaskStmt.getDbFullName(), showRoutineLoadTaskStmt.getJobName());
        }
        catch (MetaNotFoundException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new AnalysisException(e.getMessage());
        }
        if (routineLoadJob == null) {
            throw new AnalysisException("The job named " + showRoutineLoadTaskStmt.getJobName() + "does not exists or job state is stopped or cancelled");
        }
        String dbFullName = showRoutineLoadTaskStmt.getDbFullName();
        try {
            tableName = routineLoadJob.getTableName();
        }
        catch (MetaNotFoundException e) {
            throw new AnalysisException("The table metadata of job has been changed. The job will be cancelled automatically", e);
        }
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbFullName, tableName, PrivPredicate.LOAD)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "LOAD", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), dbFullName + ": " + tableName);
        }
        rows.addAll(routineLoadJob.getTasksShowInfo());
        this.resultSet = new ShowResultSet(showRoutineLoadTaskStmt.getMetaData(), rows);
    }

    private void handleShowUserProperty() throws AnalysisException {
        ShowUserPropertyStmt showStmt = (ShowUserPropertyStmt)this.stmt;
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), showStmt.getRows());
    }

    private void handleShowDelete() throws AnalysisException {
        ShowDeleteStmt showStmt = (ShowDeleteStmt)this.stmt;
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbOrAnalysisException(showStmt.getDbName());
        long dbId = db.getId();
        DeleteHandler deleteHandler = catalog.getDeleteHandler();
        Load load = catalog.getLoadInstance();
        List<List<Comparable>> deleteInfos = deleteHandler.getDeleteInfosByDb(dbId);
        ArrayList rows = Lists.newArrayList();
        for (List<Comparable> deleteInfo : deleteInfos) {
            ArrayList<String> oneInfo = new ArrayList<String>(deleteInfo.size());
            for (Comparable element : deleteInfo) {
                oneInfo.add(element.toString());
            }
            rows.add(oneInfo);
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowAlter() throws AnalysisException {
        ShowAlterStmt showStmt = (ShowAlterStmt)this.stmt;
        ProcNodeInterface procNodeI = showStmt.getNode();
        Preconditions.checkNotNull((Object)procNodeI);
        List<List<String>> rows = procNodeI instanceof SchemaChangeProcDir ? ((SchemaChangeProcDir)procNodeI).fetchResultByFilter(showStmt.getFilterMap(), showStmt.getOrderPairs(), showStmt.getLimitElement()).getRows() : (procNodeI instanceof RollupProcDir ? ((RollupProcDir)procNodeI).fetchResultByFilter(showStmt.getFilterMap(), showStmt.getOrderPairs(), showStmt.getLimitElement()).getRows() : procNodeI.fetchResult().getRows());
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowCollation() throws AnalysisException {
        ShowCollationStmt showStmt = (ShowCollationStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        ArrayList row = Lists.newArrayList();
        row.add("utf8_general_ci");
        row.add("utf8");
        row.add("33");
        row.add("Yes");
        row.add("Yes");
        row.add("1");
        rows.add(row);
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowData() throws AnalysisException {
        ShowDataStmt showStmt = (ShowDataStmt)this.stmt;
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), showStmt.getResultRows());
    }

    private void handleShowPartitions() throws AnalysisException {
        ShowPartitionsStmt showStmt = (ShowPartitionsStmt)this.stmt;
        ProcNodeInterface procNodeI = showStmt.getNode();
        Preconditions.checkNotNull((Object)procNodeI);
        List<List<String>> rows = ((PartitionsProcDir)procNodeI).fetchResultByFilter(showStmt.getFilterMap(), showStmt.getOrderByPairs(), showStmt.getLimitElement()).getRows();
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void handleShowTablet() throws AnalysisException {
        ShowTabletStmt showStmt = (ShowTabletStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        Catalog catalog = Catalog.getCurrentCatalog();
        if (showStmt.isShowSingleTablet()) {
            void var15_26;
            int n;
            Boolean isSync;
            Long indexId;
            String partitionName;
            Long partitionId;
            String tableName;
            Long tableId;
            String dbName;
            Long dbId;
            long tabletId;
            block39: {
                tabletId = showStmt.getTabletId();
                TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
                TabletMeta tabletMeta = invertedIndex.getTabletMeta(tabletId);
                dbId = tabletMeta != null ? tabletMeta.getDbId() : -1L;
                dbName = FeConstants.null_string;
                tableId = tabletMeta != null ? tabletMeta.getTableId() : -1L;
                tableName = FeConstants.null_string;
                partitionId = tabletMeta != null ? tabletMeta.getPartitionId() : -1L;
                partitionName = FeConstants.null_string;
                indexId = tabletMeta != null ? tabletMeta.getIndexId() : -1L;
                String string = FeConstants.null_string;
                isSync = true;
                int n2 = -1;
                Database db = catalog.getDbNullable(dbId);
                if (db == null) {
                    isSync = false;
                } else {
                    dbName = db.getFullName();
                    Table table = db.getTableNullable(tableId);
                    if (table == null || !(table instanceof OlapTable)) {
                        isSync = false;
                    } else {
                        table.readLock();
                        try {
                            tableName = table.getName();
                            OlapTable olapTable = (OlapTable)table;
                            Partition partition = olapTable.getPartition(partitionId);
                            if (partition == null) {
                                isSync = false;
                                break block39;
                            }
                            partitionName = partition.getName();
                            MaterializedIndex index = partition.getIndex(indexId);
                            if (index == null) {
                                isSync = false;
                                break block39;
                            }
                            String string2 = olapTable.getIndexNameById(indexId);
                            Tablet tablet = index.getTablet(tabletId);
                            if (tablet == null) {
                                isSync = false;
                                break block39;
                            }
                            n = index.getTabletOrderIdx(tablet.getId());
                            List<Replica> replicas = tablet.getReplicas();
                            for (Replica replica : replicas) {
                                Replica tmp = invertedIndex.getReplica(tabletId, replica.getBackendId());
                                if (tmp == null) {
                                    isSync = false;
                                } else {
                                    if (tmp == replica) continue;
                                    isSync = false;
                                }
                                break;
                            }
                        }
                        finally {
                            table.readUnlock();
                        }
                    }
                }
            }
            String detailCmd = String.format("SHOW PROC '/dbs/%d/%d/partitions/%d/%d/%d';", dbId, tableId, partitionId, indexId, tabletId);
            rows.add(Lists.newArrayList((Object[])new String[]{dbName, tableName, partitionName, var15_26, dbId.toString(), tableId.toString(), partitionId.toString(), indexId.toString(), isSync.toString(), String.valueOf(n), detailCmd}));
        } else {
            Database db = catalog.getDbOrAnalysisException(showStmt.getDbName());
            OlapTable olapTable = db.getOlapTableOrAnalysisException(showStmt.getTableName());
            olapTable.readLock();
            try {
                void var15_31;
                long sizeLimit = -1L;
                if (showStmt.hasOffset() && showStmt.hasLimit()) {
                    sizeLimit = showStmt.getOffset() + showStmt.getLimit();
                } else if (showStmt.hasLimit()) {
                    sizeLimit = showStmt.getLimit();
                }
                boolean stop = false;
                Collection<Object> partitions = new ArrayList();
                if (showStmt.hasPartition()) {
                    PartitionNames partitionNames = showStmt.getPartitionNames();
                    for (String partName : partitionNames.getPartitionNames()) {
                        Partition partition = olapTable.getPartition(partName, partitionNames.isTemp());
                        if (partition == null) {
                            throw new AnalysisException("Unknown partition: " + partName);
                        }
                        partitions.add(partition);
                    }
                } else {
                    partitions = olapTable.getPartitions();
                }
                List<List<Comparable>> tabletInfos = new ArrayList();
                String indexName = showStmt.getIndexName();
                long indexId = -1L;
                if (indexName != null) {
                    Long id = olapTable.getIndexIdByName(indexName);
                    if (id == null) {
                        ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_TABLE, showStmt.getIndexName(), showStmt.getDbName());
                    }
                    indexId = id;
                }
                block11: for (Partition partition : partitions) {
                    if (stop) break;
                    for (MaterializedIndex materializedIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                        if (indexId > -1L && materializedIndex.getId() != indexId) continue;
                        TabletsProcDir procDir = new TabletsProcDir(olapTable, materializedIndex);
                        tabletInfos.addAll(procDir.fetchComparableResult(showStmt.getVersion(), showStmt.getBackendId(), showStmt.getReplicaState()));
                        if (sizeLimit <= -1L || (long)tabletInfos.size() < sizeLimit) continue;
                        stop = true;
                        continue block11;
                    }
                }
                if (sizeLimit > -1L && (long)tabletInfos.size() < sizeLimit) {
                    tabletInfos.clear();
                } else if (sizeLimit > -1L) {
                    tabletInfos = tabletInfos.subList((int)showStmt.getOffset(), (int)sizeLimit);
                }
                List<OrderByPair> orderByPairs = showStmt.getOrderByPairs();
                Object var15_28 = null;
                if (orderByPairs != null) {
                    OrderByPair[] orderByPairArr = new OrderByPair[orderByPairs.size()];
                    ListComparator listComparator = new ListComparator(orderByPairs.toArray(orderByPairArr));
                } else {
                    ListComparator listComparator = new ListComparator(0, 1);
                }
                Collections.sort(tabletInfos, var15_31);
                for (List list : tabletInfos) {
                    ArrayList<String> oneTablet = new ArrayList<String>(list.size());
                    for (Comparable column : list) {
                        oneTablet.add(column.toString());
                    }
                    rows.add(oneTablet);
                }
            }
            finally {
                olapTable.readUnlock();
            }
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowBroker() {
        ShowBrokerStmt showStmt = (ShowBrokerStmt)this.stmt;
        List<List<String>> brokersInfo = Catalog.getCurrentCatalog().getBrokerMgr().getBrokersInfo();
        for (List<String> row : brokersInfo) {
            row.remove(2);
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), brokersInfo);
    }

    private void handleShowResources() {
        long offset;
        ShowResourcesStmt showStmt = (ShowResourcesStmt)this.stmt;
        List<List<Comparable>> resourcesInfos = Catalog.getCurrentCatalog().getResourceMgr().getResourcesInfo(showStmt.getNameValue(), showStmt.isAccurateMatch(), showStmt.getTypeSet());
        ArrayList<OrderByPair> orderByPairs = showStmt.getOrderByPairs();
        ListComparator comparator = null;
        if (orderByPairs != null) {
            OrderByPair[] orderByPairArr = new OrderByPair[orderByPairs.size()];
            comparator = new ListComparator(orderByPairs.toArray(orderByPairArr));
        } else {
            comparator = new ListComparator(0);
        }
        Collections.sort(resourcesInfos, comparator);
        List rows = Lists.newArrayList();
        for (List<Comparable> resourceInfo : resourcesInfos) {
            ArrayList<String> oneResource = new ArrayList<String>(resourceInfo.size());
            for (Comparable element : resourceInfo) {
                oneResource.add(element.toString());
            }
            rows.add(oneResource);
        }
        long limit = showStmt.getLimit();
        long l = offset = showStmt.getOffset() == -1L ? 0L : showStmt.getOffset();
        if (offset >= (long)rows.size()) {
            rows = Lists.newArrayList();
        } else if (limit != -1L) {
            rows = limit + offset < (long)rows.size() ? rows.subList((int)offset, (int)(limit + offset)) : rows.subList((int)offset, rows.size());
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowExport() throws AnalysisException {
        ShowExportStmt showExportStmt = (ShowExportStmt)this.stmt;
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbOrAnalysisException(showExportStmt.getDbName());
        long dbId = db.getId();
        ExportMgr exportMgr = catalog.getExportMgr();
        HashSet states = null;
        ExportJob.JobState state = showExportStmt.getJobState();
        if (state != null) {
            states = Sets.newHashSet((Object[])new ExportJob.JobState[]{state});
        }
        List<List<String>> infos = exportMgr.getExportJobInfosByIdOrState(dbId, showExportStmt.getJobId(), showExportStmt.getLabel(), showExportStmt.isLabelUseLike(), states, showExportStmt.getOrderByPairs(), showExportStmt.getLimit());
        this.resultSet = new ShowResultSet(showExportStmt.getMetaData(), infos);
    }

    private void handleShowBackends() {
        ShowBackendsStmt showStmt = (ShowBackendsStmt)this.stmt;
        List<List<String>> backendInfos = BackendsProcDir.getClusterBackendInfos(showStmt.getClusterName());
        for (List<String> row : backendInfos) {
            row.remove(3);
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), backendInfos);
    }

    private void handleShowFrontends() {
        ShowFrontendsStmt showStmt = (ShowFrontendsStmt)this.stmt;
        ArrayList infos = Lists.newArrayList();
        FrontendsProcNode.getFrontendsInfo(Catalog.getCurrentCatalog(), infos);
        for (List row : infos) {
            row.remove(2);
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), infos);
    }

    private void handleShowRepositories() {
        ShowRepositoriesStmt showStmt = (ShowRepositoriesStmt)this.stmt;
        List<List<String>> repoInfos = Catalog.getCurrentCatalog().getBackupHandler().getRepoMgr().getReposInfo();
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), repoInfos);
    }

    private void handleShowSnapshot() throws AnalysisException {
        ShowSnapshotStmt showStmt = (ShowSnapshotStmt)this.stmt;
        Repository repo = Catalog.getCurrentCatalog().getBackupHandler().getRepoMgr().getRepo(showStmt.getRepoName());
        if (repo == null) {
            throw new AnalysisException("Repository " + showStmt.getRepoName() + " does not exist");
        }
        List<List<String>> snapshotInfos = repo.getSnapshotInfos(showStmt.getSnapshotName(), showStmt.getTimestamp());
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), snapshotInfos);
    }

    private void handleShowBackup() throws AnalysisException {
        ShowBackupStmt showStmt = (ShowBackupStmt)this.stmt;
        Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(showStmt.getDbName());
        List<AbstractJob> jobs = Catalog.getCurrentCatalog().getBackupHandler().getJobs(db.getId(), showStmt.getLabelPredicate());
        List backupJobs = jobs.stream().filter(job -> job instanceof BackupJob).map(job -> (BackupJob)job).collect(Collectors.toList());
        List<List<String>> infos = backupJobs.stream().map(BackupJob::getInfo).collect(Collectors.toList());
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), infos);
    }

    private void handleShowRestore() throws AnalysisException {
        ShowRestoreStmt showStmt = (ShowRestoreStmt)this.stmt;
        Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(showStmt.getDbName());
        List<AbstractJob> jobs = Catalog.getCurrentCatalog().getBackupHandler().getJobs(db.getId(), showStmt.getLabelPredicate());
        List restoreJobs = jobs.stream().filter(job -> job instanceof RestoreJob).map(job -> (RestoreJob)job).collect(Collectors.toList());
        List<List<String>> infos = restoreJobs.stream().map(RestoreJob::getInfo).collect(Collectors.toList());
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), infos);
    }

    private void handleShowSyncJobs() throws AnalysisException {
        ShowSyncJobStmt showStmt = (ShowSyncJobStmt)this.stmt;
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbOrAnalysisException(showStmt.getDbName());
        List<List<Comparable>> syncInfos = catalog.getSyncJobManager().getSyncJobsInfoByDbId(db.getId());
        Collections.sort(syncInfos, new ListComparator(0));
        ArrayList rows = Lists.newArrayList();
        for (List<Comparable> syncInfo : syncInfos) {
            ArrayList<String> row = new ArrayList<String>(syncInfo.size());
            for (Comparable element : syncInfo) {
                row.add(element.toString());
            }
            rows.add(row);
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowGrants() {
        ShowGrantsStmt showStmt = (ShowGrantsStmt)this.stmt;
        List<List<String>> infos = Catalog.getCurrentCatalog().getAuth().getAuthInfo(showStmt.getUserIdent());
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), infos);
    }

    private void handleShowRoles() {
        ShowRolesStmt showStmt = (ShowRolesStmt)this.stmt;
        List<List<String>> infos = Catalog.getCurrentCatalog().getAuth().getRoleInfo();
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), infos);
    }

    private void handleShowTrash() {
        ShowTrashStmt showStmt = (ShowTrashStmt)this.stmt;
        ArrayList infos = Lists.newArrayList();
        TrashProcDir.getTrashInfo(showStmt.getBackends(), infos);
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), infos);
    }

    private void handleShowTrashDisk() {
        ShowTrashDiskStmt showStmt = (ShowTrashDiskStmt)this.stmt;
        ArrayList infos = Lists.newArrayList();
        TrashProcNode.getTrashDiskInfo(showStmt.getBackend(), infos);
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), infos);
    }

    private void handleAdminShowTabletStatus() throws AnalysisException {
        List<List<String>> results;
        AdminShowReplicaStatusStmt showStmt = (AdminShowReplicaStatusStmt)this.stmt;
        try {
            results = MetadataViewer.getTabletStatus(showStmt);
        }
        catch (DdlException e) {
            throw new AnalysisException(e.getMessage());
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), results);
    }

    private void handleAdminShowTabletDistribution() throws AnalysisException {
        List<List<String>> results;
        AdminShowReplicaDistributionStmt showStmt = (AdminShowReplicaDistributionStmt)this.stmt;
        try {
            results = MetadataViewer.getTabletDistribution(showStmt);
        }
        catch (DdlException e) {
            throw new AnalysisException(e.getMessage());
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), results);
    }

    private void handleAdminShowConfig() throws AnalysisException {
        AdminShowConfigStmt showStmt = (AdminShowConfigStmt)this.stmt;
        PatternMatcher matcher = null;
        if (showStmt.getPattern() != null) {
            matcher = PatternMatcher.createMysqlPattern(showStmt.getPattern(), CaseSensibility.CONFIG.getCaseSensibility());
        }
        List<List<String>> results = ConfigBase.getConfigInfo(matcher);
        results.sort(Comparator.comparing(o -> (String)o.get(0)));
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), results);
    }

    private void handleShowSmallFiles() throws AnalysisException {
        List<List<String>> results;
        ShowSmallFilesStmt showStmt = (ShowSmallFilesStmt)this.stmt;
        try {
            results = Catalog.getCurrentCatalog().getSmallFileMgr().getInfo(showStmt.getDbName());
        }
        catch (DdlException e) {
            throw new AnalysisException(e.getMessage());
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShowDynamicPartition() {
        ShowDynamicPartitionStmt showDynamicPartitionStmt = (ShowDynamicPartitionStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        Database db = this.ctx.getCatalog().getDbNullable(showDynamicPartitionStmt.getDb());
        if (db != null) {
            List<Table> tableList = db.getTables();
            for (Table tbl : tableList) {
                if (!(tbl instanceof OlapTable)) continue;
                DynamicPartitionScheduler dynamicPartitionScheduler = Catalog.getCurrentCatalog().getDynamicPartitionScheduler();
                OlapTable olapTable = (OlapTable)tbl;
                olapTable.readLock();
                try {
                    if (!olapTable.dynamicPartitionExists()) {
                        dynamicPartitionScheduler.removeRuntimeInfo(olapTable.getId());
                        continue;
                    }
                    if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), db.getFullName(), olapTable.getName(), PrivPredicate.SHOW)) continue;
                    DynamicPartitionProperty dynamicPartitionProperty = olapTable.getTableProperty().getDynamicPartitionProperty();
                    String tableName = olapTable.getName();
                    ReplicaAllocation replicaAlloc = dynamicPartitionProperty.getReplicaAllocation();
                    if (replicaAlloc.isNotSet()) {
                        replicaAlloc = olapTable.getDefaultReplicaAllocation();
                    }
                    String unsortedReservedHistoryPeriods = dynamicPartitionProperty.getReservedHistoryPeriods();
                    rows.add(Lists.newArrayList((Object[])new String[]{tableName, String.valueOf(dynamicPartitionProperty.getEnable()), dynamicPartitionProperty.getTimeUnit().toUpperCase(), String.valueOf(dynamicPartitionProperty.getStart()), String.valueOf(dynamicPartitionProperty.getEnd()), dynamicPartitionProperty.getPrefix(), String.valueOf(dynamicPartitionProperty.getBuckets()), String.valueOf(replicaAlloc.getTotalReplicaNum()), replicaAlloc.toCreateStmt(), dynamicPartitionProperty.getStartOfInfo(), dynamicPartitionScheduler.getRuntimeInfo(olapTable.getId(), "lastUpdateTime"), dynamicPartitionScheduler.getRuntimeInfo(olapTable.getId(), "lastSchedulerTime"), dynamicPartitionScheduler.getRuntimeInfo(olapTable.getId(), "dynamicPartitionState"), dynamicPartitionScheduler.getRuntimeInfo(olapTable.getId(), "createPartitionMsg"), dynamicPartitionScheduler.getRuntimeInfo(olapTable.getId(), "dropPartitionMsg"), dynamicPartitionProperty.getSortedReservedHistoryPeriods(unsortedReservedHistoryPeriods, dynamicPartitionProperty.getTimeUnit().toUpperCase())}));
                }
                catch (DdlException e) {
                    e.printStackTrace();
                }
                finally {
                    olapTable.readUnlock();
                }
            }
            this.resultSet = new ShowResultSet(showDynamicPartitionStmt.getMetaData(), rows);
        }
    }

    private void handleShowTransaction() throws AnalysisException {
        ShowTransactionStmt showStmt = (ShowTransactionStmt)this.stmt;
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(showStmt.getDbName());
        TransactionStatus status = showStmt.getStatus();
        GlobalTransactionMgr transactionMgr = Catalog.getCurrentGlobalTransactionMgr();
        if (status != TransactionStatus.UNKNOWN) {
            this.resultSet = new ShowResultSet(showStmt.getMetaData(), transactionMgr.getDbTransInfoByStatus(db.getId(), status));
        } else {
            Long txnId = showStmt.getTxnId();
            String label = showStmt.getLabel();
            if (!label.isEmpty() && (txnId = transactionMgr.getTransactionId(db.getId(), label)) == null) {
                throw new AnalysisException("transaction with label " + label + " does not exist");
            }
            this.resultSet = new ShowResultSet(showStmt.getMetaData(), transactionMgr.getSingleTranInfo(db.getId(), txnId));
        }
    }

    private void handleShowPlugins() throws AnalysisException {
        ShowPluginsStmt pluginsStmt = (ShowPluginsStmt)this.stmt;
        List<List<String>> rows = Catalog.getCurrentPluginMgr().getPluginShowInfos();
        this.resultSet = new ShowResultSet(pluginsStmt.getMetaData(), rows);
    }

    private void handleShowQueryProfile() throws AnalysisException {
        ShowQueryProfileStmt showStmt = (ShowQueryProfileStmt)this.stmt;
        ShowQueryProfileStmt.PathType pathType = showStmt.getPathType();
        List<Object> rows = Lists.newArrayList();
        switch (pathType) {
            case QUERY_IDS: {
                rows = ProfileManager.getInstance().getQueryWithType(ProfileManager.ProfileType.QUERY);
                break;
            }
            case FRAGMETNS: {
                ProfileTreeNode treeRoot = ProfileManager.getInstance().getFragmentProfileTree(showStmt.getQueryId(), showStmt.getQueryId());
                if (treeRoot == null) {
                    throw new AnalysisException("Failed to get fragment tree for query: " + showStmt.getQueryId());
                }
                ArrayList row = Lists.newArrayList((Object[])new String[]{ProfileTreePrinter.printFragmentTree(treeRoot)});
                rows.add(row);
                break;
            }
            case INSTANCES: {
                List<Triple<String, String, Long>> instanceList = ProfileManager.getInstance().getFragmentInstanceList(showStmt.getQueryId(), showStmt.getQueryId(), showStmt.getFragmentId());
                if (instanceList == null) {
                    throw new AnalysisException("Failed to get instance list for fragment: " + showStmt.getFragmentId());
                }
                for (Triple<String, String, Long> triple : instanceList) {
                    ArrayList row = Lists.newArrayList((Object[])new String[]{(String)triple.getLeft(), (String)triple.getMiddle(), RuntimeProfile.printCounter((Long)triple.getRight(), TUnit.TIME_NS)});
                    rows.add(row);
                }
                break;
            }
            case SINGLE_INSTANCE: {
                ProfileTreeNode treeRoot = ProfileManager.getInstance().getInstanceProfileTree(showStmt.getQueryId(), showStmt.getQueryId(), showStmt.getFragmentId(), showStmt.getInstanceId());
                if (treeRoot == null) {
                    throw new AnalysisException("Failed to get instance tree for instance: " + showStmt.getInstanceId());
                }
                ArrayList row = Lists.newArrayList((Object[])new String[]{ProfileTreePrinter.printInstanceTree(treeRoot)});
                rows.add(row);
                break;
            }
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), (List<List<String>>)rows);
    }

    private void handleShowLoadProfile() throws AnalysisException {
        ShowLoadProfileStmt showStmt = (ShowLoadProfileStmt)this.stmt;
        ShowLoadProfileStmt.PathType pathType = showStmt.getPathType();
        List<Object> rows = Lists.newArrayList();
        switch (pathType) {
            case JOB_IDS: {
                rows = ProfileManager.getInstance().getQueryWithType(ProfileManager.ProfileType.LOAD);
                break;
            }
            case TASK_IDS: {
                rows = ProfileManager.getInstance().getLoadJobTaskList(showStmt.getJobId());
                break;
            }
            case INSTANCES: {
                List<Triple<String, String, Long>> instanceList = ProfileManager.getInstance().getFragmentInstanceList(showStmt.getJobId(), showStmt.getTaskId(), "0");
                if (instanceList == null) {
                    throw new AnalysisException("Failed to get instance list for task: " + showStmt.getTaskId());
                }
                for (Triple<String, String, Long> triple : instanceList) {
                    ArrayList row = Lists.newArrayList((Object[])new String[]{(String)triple.getLeft(), (String)triple.getMiddle(), RuntimeProfile.printCounter((Long)triple.getRight(), TUnit.TIME_NS)});
                    rows.add(row);
                }
                break;
            }
            case SINGLE_INSTANCE: {
                ProfileTreeNode treeRoot = ProfileManager.getInstance().getInstanceProfileTree(showStmt.getJobId(), showStmt.getTaskId(), "0", showStmt.getInstanceId());
                if (treeRoot == null) {
                    throw new AnalysisException("Failed to get instance tree for instance: " + showStmt.getInstanceId());
                }
                ArrayList row = Lists.newArrayList((Object[])new String[]{ProfileTreePrinter.printInstanceTree(treeRoot)});
                rows.add(row);
                break;
            }
        }
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), (List<List<String>>)rows);
    }

    private void handleShowCreateRoutineLoad() throws AnalysisException {
        ShowCreateRoutineLoadStmt showCreateRoutineLoadStmt = (ShowCreateRoutineLoadStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        String dbName = showCreateRoutineLoadStmt.getDb();
        String labelName = showCreateRoutineLoadStmt.getLabel();
        if (showCreateRoutineLoadStmt.isIncludeHistory()) {
            List<Object> routineLoadJobList = new ArrayList();
            try {
                routineLoadJobList = Catalog.getCurrentCatalog().getRoutineLoadManager().getJob(dbName, labelName, true, null);
            }
            catch (MetaNotFoundException e) {
                LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, labelName).add("error_msg", "Routine load cannot be found by this name").build(), (Throwable)e);
            }
            if (routineLoadJobList == null) {
                this.resultSet = new ShowResultSet(showCreateRoutineLoadStmt.getMetaData(), rows);
                return;
            }
            for (RoutineLoadJob routineLoadJob : routineLoadJobList) {
                String tableName = "";
                try {
                    tableName = routineLoadJob.getTableName();
                }
                catch (MetaNotFoundException e) {
                    LOG.warn(new LogBuilder(LogKey.ROUTINE_LOAD_JOB, routineLoadJob.getId()).add("error_msg", "The table name for this routine load does not exist").build(), (Throwable)e);
                }
                if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, tableName, PrivPredicate.LOAD)) {
                    this.resultSet = new ShowResultSet(showCreateRoutineLoadStmt.getMetaData(), rows);
                    continue;
                }
                rows.add(Lists.newArrayList((Object[])new String[]{String.valueOf(routineLoadJob.getId()), showCreateRoutineLoadStmt.getLabel(), routineLoadJob.getShowCreateInfo()}));
            }
        } else {
            try {
                RoutineLoadJob routineLoadJob = Catalog.getCurrentCatalog().getRoutineLoadManager().checkPrivAndGetJob(dbName, labelName);
                rows.add(Lists.newArrayList((Object[])new String[]{String.valueOf(routineLoadJob.getId()), showCreateRoutineLoadStmt.getLabel(), routineLoadJob.getShowCreateInfo()}));
            }
            catch (DdlException | MetaNotFoundException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
                throw new AnalysisException(e.getMessage());
            }
        }
        this.resultSet = new ShowResultSet(showCreateRoutineLoadStmt.getMetaData(), rows);
    }

    private void handleShowDataSkew() throws AnalysisException {
        ShowDataSkewStmt showStmt = (ShowDataSkewStmt)this.stmt;
        try {
            List<List<String>> results = MetadataViewer.getDataSkew(showStmt);
            this.resultSet = new ShowResultSet(showStmt.getMetaData(), results);
        }
        catch (DdlException e) {
            throw new AnalysisException(e.getMessage());
        }
    }

    private void handleShowTableStats() throws AnalysisException {
        ShowTableStatsStmt showTableStatsStmt = (ShowTableStatsStmt)this.stmt;
        List<List<String>> results = Catalog.getCurrentCatalog().getStatisticsManager().showTableStatsList(showTableStatsStmt.getDbName(), showTableStatsStmt.getTableName());
        this.resultSet = new ShowResultSet(showTableStatsStmt.getMetaData(), results);
    }

    private void handleShowColumnStats() throws AnalysisException {
        ShowColumnStatsStmt showColumnStatsStmt = (ShowColumnStatsStmt)this.stmt;
        List<List<String>> results = Catalog.getCurrentCatalog().getStatisticsManager().showColumnStatsList(showColumnStatsStmt.getTableName());
        this.resultSet = new ShowResultSet(showColumnStatsStmt.getMetaData(), results);
    }

    public void handleShowSqlBlockRule() throws AnalysisException {
        ShowSqlBlockRuleStmt showStmt = (ShowSqlBlockRuleStmt)this.stmt;
        ArrayList rows = Lists.newArrayList();
        List<SqlBlockRule> sqlBlockRules = Catalog.getCurrentCatalog().getSqlBlockRuleMgr().getSqlBlockRule(showStmt);
        sqlBlockRules.forEach(rule -> rows.add(rule.getShowInfo()));
        this.resultSet = new ShowResultSet(showStmt.getMetaData(), rows);
    }

    private void handleShowTableCreation() throws AnalysisException {
        ShowTableCreationStmt showStmt = (ShowTableCreationStmt)this.stmt;
        String dbName = showStmt.getDbName();
        Database db = this.ctx.getCatalog().getDbOrAnalysisException(dbName);
        List<IcebergTableCreationRecord> records = this.ctx.getCatalog().getIcebergTableCreationRecordMgr().getTableCreationRecordByDbId(db.getId());
        ArrayList rowSet = Lists.newArrayList();
        for (IcebergTableCreationRecord record : records) {
            List<Comparable> row = record.getTableCreationRecord();
            if (!Strings.isNullOrEmpty((String)showStmt.getWild()) && !showStmt.like(record.getTable())) continue;
            rowSet.add(row);
        }
        ListComparator comparator = null;
        OrderByPair orderByPair = new OrderByPair(3, false);
        comparator = new ListComparator(orderByPair);
        Collections.sort(rowSet, comparator);
        ArrayList resultRowSet = Lists.newArrayList();
        HashSet<String> keyNameSet = new HashSet<String>();
        for (List row : rowSet) {
            ArrayList resultRow = Lists.newArrayList();
            for (Comparable column : row) {
                resultRow.add(column.toString());
            }
            resultRowSet.add(resultRow);
            keyNameSet.add((String)resultRow.get(0));
        }
        ShowResultSetMetaData showMetaData = showStmt.getMetaData();
        this.resultSet = new ShowResultSet(showMetaData, resultRowSet);
    }

    private void handleShowLastInsert() {
        InsertResult insertResult;
        ShowLastInsertStmt showStmt = (ShowLastInsertStmt)this.stmt;
        ArrayList resultRowSet = Lists.newArrayList();
        if (ConnectContext.get() != null && (insertResult = ConnectContext.get().getInsertResult()) != null) {
            resultRowSet.add(insertResult.toRow());
        }
        ShowResultSetMetaData showMetaData = showStmt.getMetaData();
        this.resultSet = new ShowResultSet(showMetaData, resultRowSet);
    }

    private void handleAdminShowTabletStorageFormat() throws AnalysisException {
        ArrayList resultRowSet = Lists.newArrayList();
        for (Backend be : Catalog.getCurrentSystemInfo().getIdToBackend().values()) {
            if (!be.isQueryAvailable() || !be.isLoadAvailable()) continue;
            AgentClient client = new AgentClient(be.getHost(), be.getBePort());
            TCheckStorageFormatResult result = client.checkStorageFormat();
            if (result == null) {
                throw new AnalysisException("get tablet data from backend: " + be.getId() + "error.");
            }
            if (this.stmt.isVerbose()) {
                ArrayList<String> row;
                long tabletId;
                Iterator iterator = result.getV1Tablets().iterator();
                while (iterator.hasNext()) {
                    tabletId = (Long)iterator.next();
                    row = new ArrayList<String>();
                    row.add(String.valueOf(be.getId()));
                    row.add(String.valueOf(tabletId));
                    row.add("V1");
                    resultRowSet.add(row);
                }
                iterator = result.getV2Tablets().iterator();
                while (iterator.hasNext()) {
                    tabletId = (Long)iterator.next();
                    row = new ArrayList();
                    row.add(String.valueOf(be.getId()));
                    row.add(String.valueOf(tabletId));
                    row.add("V2");
                    resultRowSet.add(row);
                }
                continue;
            }
            ArrayList<String> row = new ArrayList<String>();
            row.add(String.valueOf(be.getId()));
            row.add(String.valueOf(result.getV1Tablets().size()));
            row.add(String.valueOf(result.getV2Tablets().size()));
            resultRowSet.add(row);
        }
        ShowResultSetMetaData showMetaData = this.stmt.getMetaData();
        this.resultSet = new ShowResultSet(showMetaData, resultRowSet);
    }

    private void handleAdminDiagnoseTablet() {
        AdminDiagnoseTabletStmt showStmt = (AdminDiagnoseTabletStmt)this.stmt;
        List<List<String>> resultRowSet = Diagnoser.diagnoseTablet(showStmt.getTabletId());
        ShowResultSetMetaData showMetaData = showStmt.getMetaData();
        this.resultSet = new ShowResultSet(showMetaData, resultRowSet);
    }
}

