/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import org.apache.doris.analysis.SetLdapPassVar;
import org.apache.doris.analysis.SetNamesVar;
import org.apache.doris.analysis.SetPassVar;
import org.apache.doris.analysis.SetStmt;
import org.apache.doris.analysis.SetTransaction;
import org.apache.doris.analysis.SetVar;
import org.apache.doris.common.DdlException;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.VariableMgr;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetExecutor {
    private static final Logger LOG = LogManager.getLogger(SetExecutor.class);
    private ConnectContext ctx;
    private SetStmt stmt;

    public SetExecutor(ConnectContext ctx, SetStmt stmt) {
        this.ctx = ctx;
        this.stmt = stmt;
    }

    private void setVariable(SetVar var) throws DdlException {
        if (var instanceof SetPassVar) {
            SetPassVar setPassVar = (SetPassVar)var;
            this.ctx.getCatalog().getAuth().setPassword(setPassVar);
        } else if (var instanceof SetLdapPassVar) {
            SetLdapPassVar setLdapPassVar = (SetLdapPassVar)var;
            this.ctx.getCatalog().getAuth().setLdapPassword(setLdapPassVar);
        } else {
            if (var instanceof SetNamesVar) {
                return;
            }
            if (var instanceof SetTransaction) {
                return;
            }
            VariableMgr.setVar(this.ctx.getSessionVariable(), var);
        }
    }

    public void execute() throws DdlException {
        for (SetVar var : this.stmt.getSetVars()) {
            this.setVariable(var);
        }
    }
}

