/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.qe.VariableMgr;
import org.apache.doris.thrift.TQueryOptions;
import org.apache.doris.thrift.TResourceLimit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class SessionVariable
implements Serializable,
Writable {
    static final Logger LOG = LogManager.getLogger(SessionVariable.class);
    public static final String EXEC_MEM_LIMIT = "exec_mem_limit";
    public static final String QUERY_TIMEOUT = "query_timeout";
    public static final String ENABLE_PROFILE = "enable_profile";
    public static final String SQL_MODE = "sql_mode";
    public static final String RESOURCE_VARIABLE = "resource_group";
    public static final String AUTO_COMMIT = "autocommit";
    public static final String TX_ISOLATION = "tx_isolation";
    public static final String TX_READ_ONLY = "tx_read_only";
    public static final String TRANSACTION_READ_ONLY = "transaction_read_only";
    public static final String TRANSACTION_ISOLATION = "transaction_isolation";
    public static final String CHARACTER_SET_CLIENT = "character_set_client";
    public static final String CHARACTER_SET_CONNNECTION = "character_set_connection";
    public static final String CHARACTER_SET_RESULTS = "character_set_results";
    public static final String CHARACTER_SET_SERVER = "character_set_server";
    public static final String COLLATION_CONNECTION = "collation_connection";
    public static final String COLLATION_DATABASE = "collation_database";
    public static final String COLLATION_SERVER = "collation_server";
    public static final String SQL_AUTO_IS_NULL = "SQL_AUTO_IS_NULL";
    public static final String SQL_SELECT_LIMIT = "sql_select_limit";
    public static final String MAX_ALLOWED_PACKET = "max_allowed_packet";
    public static final String AUTO_INCREMENT_INCREMENT = "auto_increment_increment";
    public static final String QUERY_CACHE_TYPE = "query_cache_type";
    public static final String INTERACTIVE_TIMTOUT = "interactive_timeout";
    public static final String WAIT_TIMEOUT = "wait_timeout";
    public static final String NET_WRITE_TIMEOUT = "net_write_timeout";
    public static final String NET_READ_TIMEOUT = "net_read_timeout";
    public static final String TIME_ZONE = "time_zone";
    public static final String SQL_SAFE_UPDATES = "sql_safe_updates";
    public static final String NET_BUFFER_LENGTH = "net_buffer_length";
    public static final String CODEGEN_LEVEL = "codegen_level";
    public static final int MIN_EXEC_MEM_LIMIT = 0x200000;
    public static final String BATCH_SIZE = "batch_size";
    public static final String DISABLE_STREAMING_PREAGGREGATIONS = "disable_streaming_preaggregations";
    public static final String DISABLE_COLOCATE_PLAN = "disable_colocate_plan";
    public static final String ENABLE_BUCKET_SHUFFLE_JOIN = "enable_bucket_shuffle_join";
    public static final String PARALLEL_FRAGMENT_EXEC_INSTANCE_NUM = "parallel_fragment_exec_instance_num";
    public static final String ENABLE_INSERT_STRICT = "enable_insert_strict";
    public static final String ENABLE_SPILLING = "enable_spilling";
    public static final String ENABLE_EXCHANGE_NODE_PARALLEL_MERGE = "enable_exchange_node_parallel_merge";
    public static final String PREFER_JOIN_METHOD = "prefer_join_method";
    public static final String ENABLE_FOLD_CONSTANT_BY_BE = "enable_fold_constant_by_be";
    public static final String ENABLE_ODBC_TRANSCATION = "enable_odbc_transcation";
    public static final String ENABLE_SQL_CACHE = "enable_sql_cache";
    public static final String ENABLE_PARTITION_CACHE = "enable_partition_cache";
    public static final String ENABLE_COST_BASED_JOIN_REORDER = "enable_cost_based_join_reorder";
    public static final int MIN_EXEC_INSTANCE_NUM = 1;
    public static final int MAX_EXEC_INSTANCE_NUM = 32;
    public static final String FORWARD_TO_MASTER = "forward_to_master";
    public static final String PARALLEL_EXCHANGE_INSTANCE_NUM = "parallel_exchange_instance_num";
    public static final String SHOW_HIDDEN_COLUMNS = "show_hidden_columns";
    public static final String LOAD_MEM_LIMIT = "load_mem_limit";
    public static final String USE_V2_ROLLUP = "use_v2_rollup";
    public static final String TEST_MATERIALIZED_VIEW = "test_materialized_view";
    public static final String REWRITE_COUNT_DISTINCT_TO_BITMAP_HLL = "rewrite_count_distinct_to_bitmap_hll";
    public static final String EVENT_SCHEDULER = "event_scheduler";
    public static final String STORAGE_ENGINE = "storage_engine";
    public static final String DIV_PRECISION_INCREMENT = "div_precision_increment";
    public static final String MAX_SCAN_KEY_NUM = "max_scan_key_num";
    public static final String MAX_PUSHDOWN_CONDITIONS_PER_COLUMN = "max_pushdown_conditions_per_column";
    public static final String ALLOW_PARTITION_COLUMN_NULLABLE = "allow_partition_column_nullable";
    public static final String RUNTIME_FILTER_MODE = "runtime_filter_mode";
    public static final String RUNTIME_BLOOM_FILTER_SIZE = "runtime_bloom_filter_size";
    public static final String RUNTIME_BLOOM_FILTER_MIN_SIZE = "runtime_bloom_filter_min_size";
    public static final String RUNTIME_BLOOM_FILTER_MAX_SIZE = "runtime_bloom_filter_max_size";
    public static final String RUNTIME_FILTER_WAIT_TIME_MS = "runtime_filter_wait_time_ms";
    public static final String RUNTIME_FILTERS_MAX_NUM = "runtime_filters_max_num";
    public static final String RUNTIME_FILTER_TYPE = "runtime_filter_type";
    public static final String RUNTIME_FILTER_MAX_IN_NUM = "runtime_filter_max_in_num";
    public static final String INSERT_VISIBLE_TIMEOUT_MS = "insert_visible_timeout_ms";
    public static final String DELETE_WITHOUT_PARTITION = "delete_without_partition";
    public static final String SEND_BATCH_PARALLELISM = "send_batch_parallelism";
    public static final String DISABLE_JOIN_REORDER = "disable_join_reorder";
    public static final String ENABLE_INFER_PREDICATE = "enable_infer_predicate";
    public static final long DEFAULT_INSERT_VISIBLE_TIMEOUT_MS = 10000L;
    public static final String EXTRACT_WIDE_RANGE_EXPR = "extract_wide_range_expr";
    public static final String PARTITION_PRUNE_ALGORITHM_VERSION = "partition_prune_algorithm_version";
    public static final long MIN_INSERT_VISIBLE_TIMEOUT_MS = 1000L;
    public static final String ENABLE_VECTORIZED_ENGINE = "enable_vectorized_engine";
    public static final String CPU_RESOURCE_LIMIT = "cpu_resource_limit";
    public static final String ENABLE_PARALLEL_OUTFILE = "enable_parallel_outfile";
    public static final String ENABLE_LATERAL_VIEW = "enable_lateral_view";
    public static final String SQL_QUOTE_SHOW_CREATE = "sql_quote_show_create";
    public static final String RETURN_OBJECT_DATA_AS_BINARY = "return_object_data_as_binary";
    public static final String BLOCK_ENCRYPTION_MODE = "block_encryption_mode";
    public static final String AUTO_BROADCAST_JOIN_THRESHOLD = "auto_broadcast_join_threshold";
    public static final String ENABLE_PROJECTION = "enable_projection";
    public static final String TRIM_TAILING_SPACES_FOR_EXTERNAL_TABLE_QUERY = "trim_tailing_spaces_for_external_table_query";
    public Map<Field, String> sessionOriginValue = new HashMap<Field, String>();
    public boolean isSingleSetVar = false;
    @VariableMgr.VarAttr(name="insert_visible_timeout_ms", needForward=true)
    public long insertVisibleTimeoutMs = 10000L;
    @VariableMgr.VarAttr(name="exec_mem_limit")
    public long maxExecMemByte = 0x80000000L;
    @VariableMgr.VarAttr(name="enable_spilling")
    public boolean enableSpilling = false;
    @VariableMgr.VarAttr(name="enable_exchange_node_parallel_merge")
    public boolean enableExchangeNodeParallelMerge = false;
    @VariableMgr.VarAttr(name="query_timeout")
    public int queryTimeoutS = 300;
    @VariableMgr.VarAttr(name="enable_profile", needForward=true)
    public boolean enableProfile = false;
    @VariableMgr.VarAttr(name="sql_mode", needForward=true)
    public long sqlMode = 0L;
    @VariableMgr.VarAttr(name="resource_group")
    public String resourceGroup = "normal";
    @VariableMgr.VarAttr(name="autocommit")
    public boolean autoCommit = true;
    @VariableMgr.VarAttr(name="tx_isolation")
    public String txIsolation = "REPEATABLE-READ";
    @VariableMgr.VarAttr(name="tx_read_only")
    public boolean txReadonly = false;
    @VariableMgr.VarAttr(name="transaction_read_only")
    public boolean transactionReadonly = false;
    @VariableMgr.VarAttr(name="transaction_isolation")
    public String transactionIsolation = "REPEATABLE-READ";
    @VariableMgr.VarAttr(name="character_set_client")
    public String charsetClient = "utf8";
    @VariableMgr.VarAttr(name="character_set_connection")
    public String charsetConnection = "utf8";
    @VariableMgr.VarAttr(name="character_set_results")
    public String charsetResults = "utf8";
    @VariableMgr.VarAttr(name="character_set_server")
    public String charsetServer = "utf8";
    @VariableMgr.VarAttr(name="collation_connection")
    public String collationConnection = "utf8_general_ci";
    @VariableMgr.VarAttr(name="collation_database")
    public String collationDatabase = "utf8_general_ci";
    @VariableMgr.VarAttr(name="collation_server")
    public String collationServer = "utf8_general_ci";
    @VariableMgr.VarAttr(name="SQL_AUTO_IS_NULL")
    public boolean sqlAutoIsNull = false;
    @VariableMgr.VarAttr(name="sql_select_limit")
    public long sqlSelectLimit = Long.MAX_VALUE;
    @VariableMgr.VarAttr(name="max_allowed_packet")
    public int maxAllowedPacket = 0x100000;
    @VariableMgr.VarAttr(name="auto_increment_increment")
    public int autoIncrementIncrement = 1;
    @VariableMgr.VarAttr(name="query_cache_type")
    public int queryCacheType = 0;
    @VariableMgr.VarAttr(name="interactive_timeout")
    public int interactiveTimeout = 3600;
    @VariableMgr.VarAttr(name="wait_timeout")
    public int waitTimeoutS = 28800;
    @VariableMgr.VarAttr(name="net_write_timeout")
    public int netWriteTimeout = 60;
    @VariableMgr.VarAttr(name="net_read_timeout")
    public int netReadTimeout = 60;
    @VariableMgr.VarAttr(name="time_zone", needForward=true)
    public String timeZone = TimeUtils.getSystemTimeZone().getID();
    @VariableMgr.VarAttr(name="parallel_exchange_instance_num")
    public int exchangeInstanceParallel = -1;
    @VariableMgr.VarAttr(name="sql_safe_updates")
    public int sqlSafeUpdates = 0;
    @VariableMgr.VarAttr(name="net_buffer_length", flag=8)
    public int netBufferLength = 16384;
    @VariableMgr.VarAttr(name="codegen_level")
    public int codegenLevel = 0;
    @VariableMgr.VarAttr(name="batch_size")
    public int batchSize = 1024;
    @VariableMgr.VarAttr(name="disable_streaming_preaggregations")
    public boolean disableStreamPreaggregations = false;
    @VariableMgr.VarAttr(name="disable_colocate_plan")
    public boolean disableColocatePlan = false;
    @VariableMgr.VarAttr(name="enable_bucket_shuffle_join")
    public boolean enableBucketShuffleJoin = true;
    @VariableMgr.VarAttr(name="prefer_join_method")
    public String preferJoinMethod = "broadcast";
    @VariableMgr.VarAttr(name="enable_fold_constant_by_be")
    private boolean enableFoldConstantByBe = false;
    @VariableMgr.VarAttr(name="parallel_fragment_exec_instance_num")
    public int parallelExecInstanceNum = 1;
    @VariableMgr.VarAttr(name="enable_insert_strict", needForward=true)
    public boolean enableInsertStrict = false;
    @VariableMgr.VarAttr(name="enable_odbc_transcation")
    public boolean enableOdbcTransaction = false;
    @VariableMgr.VarAttr(name="enable_sql_cache")
    public boolean enableSqlCache = false;
    @VariableMgr.VarAttr(name="enable_partition_cache")
    public boolean enablePartitionCache = false;
    @VariableMgr.VarAttr(name="enable_cost_based_join_reorder")
    private boolean enableJoinReorderBasedCost = false;
    @VariableMgr.VarAttr(name="forward_to_master")
    public boolean forwardToMaster = true;
    @VariableMgr.VarAttr(name="load_mem_limit")
    public long loadMemLimit = 0L;
    @VariableMgr.VarAttr(name="use_v2_rollup")
    public boolean useV2Rollup = false;
    @VariableMgr.VarAttr(name="test_materialized_view")
    public boolean testMaterializedView = false;
    @VariableMgr.VarAttr(name="rewrite_count_distinct_to_bitmap_hll")
    public boolean rewriteCountDistinct = true;
    @VariableMgr.VarAttr(name="event_scheduler")
    public String eventScheduler = "OFF";
    @VariableMgr.VarAttr(name="storage_engine")
    public String storageEngine = "olap";
    @VariableMgr.VarAttr(name="div_precision_increment")
    public int divPrecisionIncrement = 4;
    @VariableMgr.VarAttr(name="max_scan_key_num")
    public int maxScanKeyNum = -1;
    @VariableMgr.VarAttr(name="max_pushdown_conditions_per_column")
    public int maxPushdownConditionsPerColumn = -1;
    @VariableMgr.VarAttr(name="show_hidden_columns", flag=4)
    public boolean showHiddenColumns = false;
    @VariableMgr.VarAttr(name="allow_partition_column_nullable")
    public boolean allowPartitionColumnNullable = true;
    @VariableMgr.VarAttr(name="delete_without_partition", needForward=true)
    public boolean deleteWithoutPartition = false;
    @VariableMgr.VarAttr(name="send_batch_parallelism", needForward=true)
    public int sendBatchParallelism = 1;
    @VariableMgr.VarAttr(name="extract_wide_range_expr", needForward=true)
    public boolean extractWideRangeExpr = true;
    @VariableMgr.VarAttr(name="partition_prune_algorithm_version", needForward=true)
    public int partitionPruneAlgorithmVersion = 2;
    @VariableMgr.VarAttr(name="runtime_filter_mode")
    private String runtimeFilterMode = "GLOBAL";
    @VariableMgr.VarAttr(name="runtime_bloom_filter_size")
    private int runtimeBloomFilterSize = 0x200000;
    @VariableMgr.VarAttr(name="runtime_bloom_filter_min_size")
    private int runtimeBloomFilterMinSize = 0x100000;
    @VariableMgr.VarAttr(name="runtime_bloom_filter_max_size")
    private int runtimeBloomFilterMaxSize = 0x1000000;
    @VariableMgr.VarAttr(name="runtime_filter_wait_time_ms")
    private int runtimeFilterWaitTimeMs = 1000;
    @VariableMgr.VarAttr(name="runtime_filters_max_num")
    private int runtimeFiltersMaxNum = 10;
    @VariableMgr.VarAttr(name="runtime_filter_type")
    private int runtimeFilterType = 8;
    @VariableMgr.VarAttr(name="runtime_filter_max_in_num")
    private int runtimeFilterMaxInNum = 1024;
    @VariableMgr.VarAttr(name="enable_vectorized_engine")
    public boolean enableVectorizedEngine = true;
    @VariableMgr.VarAttr(name="enable_parallel_outfile")
    public boolean enableParallelOutfile = false;
    @VariableMgr.VarAttr(name="cpu_resource_limit")
    public int cpuResourceLimit = -1;
    @VariableMgr.VarAttr(name="disable_join_reorder")
    private boolean disableJoinReorder = false;
    @VariableMgr.VarAttr(name="enable_infer_predicate")
    private boolean enableInferPredicate = true;
    @VariableMgr.VarAttr(name="sql_quote_show_create")
    public boolean sqlQuoteShowCreate = true;
    @VariableMgr.VarAttr(name="return_object_data_as_binary")
    private boolean returnObjectDataAsBinary = false;
    @VariableMgr.VarAttr(name="block_encryption_mode")
    private String blockEncryptionMode = "";
    @VariableMgr.VarAttr(name="auto_broadcast_join_threshold")
    public double autoBroadcastJoinThreshold = 0.8;
    @VariableMgr.VarAttr(name="enable_projection")
    private boolean enableProjection = true;
    @VariableMgr.VarAttr(name="trim_tailing_spaces_for_external_table_query", needForward=true)
    public boolean trimTailingSpacesForExternalTableQuery = false;

    public String getBlockEncryptionMode() {
        return this.blockEncryptionMode;
    }

    public void setBlockEncryptionMode(String blockEncryptionMode) {
        this.blockEncryptionMode = blockEncryptionMode;
    }

    public long getMaxExecMemByte() {
        return this.maxExecMemByte;
    }

    public long getLoadMemLimit() {
        return this.loadMemLimit;
    }

    public int getQueryTimeoutS() {
        return this.queryTimeoutS;
    }

    public boolean enableProfile() {
        return this.enableProfile;
    }

    public int getWaitTimeoutS() {
        return this.waitTimeoutS;
    }

    public long getSqlMode() {
        return this.sqlMode;
    }

    public void setSqlMode(long sqlMode) {
        this.sqlMode = sqlMode;
    }

    public boolean isEnableJoinReorderBasedCost() {
        return this.enableJoinReorderBasedCost;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isTxReadonly() {
        return this.txReadonly;
    }

    public boolean isTransactionReadonly() {
        return this.transactionReadonly;
    }

    public String getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public String getTxIsolation() {
        return this.txIsolation;
    }

    public String getCharsetClient() {
        return this.charsetClient;
    }

    public String getCharsetConnection() {
        return this.charsetConnection;
    }

    public String getCharsetResults() {
        return this.charsetResults;
    }

    public String getCharsetServer() {
        return this.charsetServer;
    }

    public String getCollationConnection() {
        return this.collationConnection;
    }

    public String getCollationDatabase() {
        return this.collationDatabase;
    }

    public String getCollationServer() {
        return this.collationServer;
    }

    public boolean isSqlAutoIsNull() {
        return this.sqlAutoIsNull;
    }

    public long getSqlSelectLimit() {
        return this.sqlSelectLimit;
    }

    public int getMaxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    public int getAutoIncrementIncrement() {
        return this.autoIncrementIncrement;
    }

    public int getQueryCacheType() {
        return this.queryCacheType;
    }

    public int getInteractiveTimeout() {
        return this.interactiveTimeout;
    }

    public int getNetWriteTimeout() {
        return this.netWriteTimeout;
    }

    public int getNetReadTimeout() {
        return this.netReadTimeout;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public int getSqlSafeUpdates() {
        return this.sqlSafeUpdates;
    }

    public int getNetBufferLength() {
        return this.netBufferLength;
    }

    public int getCodegenLevel() {
        return this.codegenLevel;
    }

    public void setMaxExecMemByte(long maxExecMemByte) {
        this.maxExecMemByte = maxExecMemByte < 0x200000L ? 0x200000L : maxExecMemByte;
    }

    public boolean isSqlQuoteShowCreate() {
        return this.sqlQuoteShowCreate;
    }

    public void setSqlQuoteShowCreate(boolean sqlQuoteShowCreate) {
        this.sqlQuoteShowCreate = sqlQuoteShowCreate;
    }

    public void setLoadMemLimit(long loadMemLimit) {
        this.loadMemLimit = loadMemLimit;
    }

    public void setQueryTimeoutS(int queryTimeoutS) {
        this.queryTimeoutS = queryTimeoutS;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public boolean isDisableColocatePlan() {
        return this.disableColocatePlan;
    }

    public boolean isEnableBucketShuffleJoin() {
        return this.enableBucketShuffleJoin;
    }

    public boolean isEnableOdbcTransaction() {
        return this.enableOdbcTransaction;
    }

    public String getPreferJoinMethod() {
        return this.preferJoinMethod;
    }

    public void setPreferJoinMethod(String preferJoinMethod) {
        this.preferJoinMethod = preferJoinMethod;
    }

    public boolean isEnableFoldConstantByBe() {
        return this.enableFoldConstantByBe;
    }

    public void setEnableFoldConstantByBe(boolean foldConstantByBe) {
        this.enableFoldConstantByBe = foldConstantByBe;
    }

    public int getParallelExecInstanceNum() {
        return this.parallelExecInstanceNum;
    }

    public int getExchangeInstanceParallel() {
        return this.exchangeInstanceParallel;
    }

    public boolean getEnableInsertStrict() {
        return this.enableInsertStrict;
    }

    public void setEnableInsertStrict(boolean enableInsertStrict) {
        this.enableInsertStrict = enableInsertStrict;
    }

    public boolean isEnableSqlCache() {
        return this.enableSqlCache;
    }

    public void setEnableSqlCache(boolean enableSqlCache) {
        this.enableSqlCache = enableSqlCache;
    }

    public boolean isEnablePartitionCache() {
        return this.enablePartitionCache;
    }

    public void setEnablePartitionCache(boolean enablePartitionCache) {
        this.enablePartitionCache = enablePartitionCache;
    }

    public boolean getForwardToMaster() {
        return this.forwardToMaster;
    }

    public boolean isUseV2Rollup() {
        return this.useV2Rollup;
    }

    public void setUseV2Rollup(boolean useV2Rollup) {
        this.useV2Rollup = useV2Rollup;
    }

    public boolean getTestMaterializedView() {
        return this.testMaterializedView;
    }

    public void setTestMaterializedView(boolean testMaterializedView) {
        this.testMaterializedView = testMaterializedView;
    }

    public boolean isRewriteCountDistinct() {
        return this.rewriteCountDistinct;
    }

    public void setRewriteCountDistinct(boolean rewriteCountDistinct) {
        this.rewriteCountDistinct = rewriteCountDistinct;
    }

    public String getEventScheduler() {
        return this.eventScheduler;
    }

    public void setEventScheduler(String eventScheduler) {
        this.eventScheduler = eventScheduler;
    }

    public String getStorageEngine() {
        return this.storageEngine;
    }

    public void setStorageEngine(String storageEngine) {
        this.storageEngine = storageEngine;
    }

    public int getDivPrecisionIncrement() {
        return this.divPrecisionIncrement;
    }

    public int getMaxScanKeyNum() {
        return this.maxScanKeyNum;
    }

    public void setMaxScanKeyNum(int maxScanKeyNum) {
        this.maxScanKeyNum = maxScanKeyNum;
    }

    public int getMaxPushdownConditionsPerColumn() {
        return this.maxPushdownConditionsPerColumn;
    }

    public void setMaxPushdownConditionsPerColumn(int maxPushdownConditionsPerColumn) {
        this.maxPushdownConditionsPerColumn = maxPushdownConditionsPerColumn;
    }

    public boolean showHiddenColumns() {
        return this.showHiddenColumns;
    }

    public void setShowHiddenColumns(boolean showHiddenColumns) {
        this.showHiddenColumns = showHiddenColumns;
    }

    public boolean isAllowPartitionColumnNullable() {
        return this.allowPartitionColumnNullable;
    }

    public String getRuntimeFilterMode() {
        return this.runtimeFilterMode;
    }

    public void setRuntimeFilterMode(String runtimeFilterMode) {
        this.runtimeFilterMode = runtimeFilterMode;
    }

    public int getRuntimeBloomFilterSize() {
        return this.runtimeBloomFilterSize;
    }

    public void setRuntimeBloomFilterSize(int runtimeBloomFilterSize) {
        this.runtimeBloomFilterSize = runtimeBloomFilterSize;
    }

    public int getRuntimeBloomFilterMinSize() {
        return this.runtimeBloomFilterMinSize;
    }

    public void setRuntimeBloomFilterMinSize(int runtimeBloomFilterMinSize) {
        this.runtimeBloomFilterMinSize = runtimeBloomFilterMinSize;
    }

    public int getRuntimeBloomFilterMaxSize() {
        return this.runtimeBloomFilterMaxSize;
    }

    public void setRuntimeBloomFilterMaxSize(int runtimeBloomFilterMaxSize) {
        this.runtimeBloomFilterMaxSize = runtimeBloomFilterMaxSize;
    }

    public int getRuntimeFilterWaitTimeMs() {
        return this.runtimeFilterWaitTimeMs;
    }

    public void setRuntimeFilterWaitTimeMs(int runtimeFilterWaitTimeMs) {
        this.runtimeFilterWaitTimeMs = runtimeFilterWaitTimeMs;
    }

    public int getRuntimeFiltersMaxNum() {
        return this.runtimeFiltersMaxNum;
    }

    public void setRuntimeFiltersMaxNum(int runtimeFiltersMaxNum) {
        this.runtimeFiltersMaxNum = runtimeFiltersMaxNum;
    }

    public int getRuntimeFilterType() {
        return this.runtimeFilterType;
    }

    public void setRuntimeFilterType(int runtimeFilterType) {
        this.runtimeFilterType = runtimeFilterType;
    }

    public int getRuntimeFilterMaxInNum() {
        return this.runtimeFilterMaxInNum;
    }

    public void setRuntimeFilterMaxInNum(int runtimeFilterMaxInNum) {
        this.runtimeFilterMaxInNum = runtimeFilterMaxInNum;
    }

    public boolean enableVectorizedEngine() {
        return this.enableVectorizedEngine;
    }

    public void setEnableVectorizedEngine(boolean enableVectorizedEngine) {
        this.enableVectorizedEngine = enableVectorizedEngine;
    }

    public long getInsertVisibleTimeoutMs() {
        if (this.insertVisibleTimeoutMs < 1000L) {
            return 1000L;
        }
        return this.insertVisibleTimeoutMs;
    }

    public void setInsertVisibleTimeoutMs(long insertVisibleTimeoutMs) {
        this.insertVisibleTimeoutMs = insertVisibleTimeoutMs < 1000L ? 1000L : insertVisibleTimeoutMs;
    }

    public boolean getIsSingleSetVar() {
        return this.isSingleSetVar;
    }

    public void setIsSingleSetVar(boolean issinglesetvar) {
        this.isSingleSetVar = issinglesetvar;
    }

    public Map<Field, String> getSessionOriginValue() {
        return this.sessionOriginValue;
    }

    public void addSessionOriginValue(Field key, String value) {
        this.sessionOriginValue.put(key, value);
    }

    public void clearSessionOriginValue() {
        this.sessionOriginValue.clear();
    }

    public boolean isDeleteWithoutPartition() {
        return this.deleteWithoutPartition;
    }

    public boolean isExtractWideRangeExpr() {
        return this.extractWideRangeExpr;
    }

    public int getPartitionPruneAlgorithmVersion() {
        return this.partitionPruneAlgorithmVersion;
    }

    public int getCpuResourceLimit() {
        return this.cpuResourceLimit;
    }

    public int getSendBatchParallelism() {
        return this.sendBatchParallelism;
    }

    public boolean isEnableParallelOutfile() {
        return this.enableParallelOutfile;
    }

    public boolean isDisableJoinReorder() {
        return this.disableJoinReorder;
    }

    public boolean isReturnObjectDataAsBinary() {
        return this.returnObjectDataAsBinary;
    }

    public void setReturnObjectDataAsBinary(boolean returnObjectDataAsBinary) {
        this.returnObjectDataAsBinary = returnObjectDataAsBinary;
    }

    public boolean isEnableInferPredicate() {
        return this.enableInferPredicate;
    }

    public void setEnableInferPredicate(boolean enableInferPredicate) {
        this.enableInferPredicate = enableInferPredicate;
    }

    public boolean isEnableProjection() {
        return this.enableProjection;
    }

    public boolean isTrimTailingSpacesForExternalTableQuery() {
        return this.trimTailingSpacesForExternalTableQuery;
    }

    public void setTrimTailingSpacesForExternalTableQuery(boolean trimTailingSpacesForExternalTableQuery) {
        this.trimTailingSpacesForExternalTableQuery = trimTailingSpacesForExternalTableQuery;
    }

    public TQueryOptions toThrift() {
        TQueryOptions tResult = new TQueryOptions();
        tResult.setMemLimit(this.maxExecMemByte);
        tResult.setMinReservation(0L);
        tResult.setMaxReservation(this.maxExecMemByte);
        tResult.setInitialReservationTotalClaims(this.maxExecMemByte);
        tResult.setBufferPoolLimit(this.maxExecMemByte);
        tResult.setQueryTimeout(this.queryTimeoutS);
        tResult.setIsReportSuccess(this.enableProfile);
        tResult.setCodegenLevel(this.codegenLevel);
        tResult.setEnableVectorizedEngine(this.enableVectorizedEngine);
        tResult.setReturnObjectDataAsBinary(this.returnObjectDataAsBinary);
        tResult.setTrimTailingSpacesForExternalTableQuery(this.trimTailingSpacesForExternalTableQuery);
        tResult.setBatchSize(this.batchSize);
        tResult.setDisableStreamPreaggregations(this.disableStreamPreaggregations);
        tResult.setLoadMemLimit(this.loadMemLimit);
        if (this.maxScanKeyNum > -1) {
            tResult.setMaxScanKeyNum(this.maxScanKeyNum);
        }
        if (this.maxPushdownConditionsPerColumn > -1) {
            tResult.setMaxPushdownConditionsPerColumn(this.maxPushdownConditionsPerColumn);
        }
        tResult.setEnableSpilling(this.enableSpilling);
        tResult.setEnableEnableExchangeNodeParallelMerge(this.enableExchangeNodeParallelMerge);
        tResult.setRuntimeFilterWaitTimeMs(this.runtimeFilterWaitTimeMs);
        tResult.setRuntimeFilterMaxInNum(this.runtimeFilterMaxInNum);
        if (this.cpuResourceLimit > 0) {
            TResourceLimit resourceLimit = new TResourceLimit();
            resourceLimit.setCpuLimit(this.cpuResourceLimit);
            tResult.setResourceLimit(resourceLimit);
        }
        return tResult;
    }

    public void write(DataOutput out) throws IOException {
        JSONObject root = new JSONObject();
        try {
            block18: for (Field field : SessionVariable.class.getDeclaredFields()) {
                VariableMgr.VarAttr attr = field.getAnnotation(VariableMgr.VarAttr.class);
                if (attr == null) continue;
                switch (field.getType().getSimpleName()) {
                    case "boolean": {
                        root.put((Object)attr.name(), (Object)((Boolean)field.get(this)));
                        continue block18;
                    }
                    case "int": {
                        root.put((Object)attr.name(), (Object)((Integer)field.get(this)));
                        continue block18;
                    }
                    case "long": {
                        root.put((Object)attr.name(), (Object)((Long)field.get(this)));
                        continue block18;
                    }
                    case "float": {
                        root.put((Object)attr.name(), (Object)((Float)field.get(this)));
                        continue block18;
                    }
                    case "double": {
                        root.put((Object)attr.name(), (Object)((Double)field.get(this)));
                        continue block18;
                    }
                    case "String": {
                        root.put((Object)attr.name(), (Object)((String)field.get(this)));
                        continue block18;
                    }
                    default: {
                        throw new IOException("invalid type: " + field.getType().getSimpleName());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IOException("failed to write session variable: " + e.getMessage());
        }
        Text.writeString((DataOutput)out, (String)root.toString());
    }

    public void readFields(DataInput in) throws IOException {
        this.readFromJson(in);
    }

    private void readFromJson(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        JSONObject root = (JSONObject)JSONValue.parse((String)json);
        try {
            block18: for (Field field : SessionVariable.class.getDeclaredFields()) {
                VariableMgr.VarAttr attr = field.getAnnotation(VariableMgr.VarAttr.class);
                if (attr == null || !root.containsKey((Object)attr.name())) continue;
                switch (field.getType().getSimpleName()) {
                    case "boolean": {
                        field.set(this, root.get((Object)attr.name()));
                        continue block18;
                    }
                    case "int": {
                        field.set(this, Integer.valueOf(root.get((Object)attr.name()).toString()));
                        continue block18;
                    }
                    case "long": {
                        field.set(this, (Long)root.get((Object)attr.name()));
                        continue block18;
                    }
                    case "float": {
                        field.set(this, root.get((Object)attr.name()));
                        continue block18;
                    }
                    case "double": {
                        field.set(this, root.get((Object)attr.name()));
                        continue block18;
                    }
                    case "String": {
                        field.set(this, root.get((Object)attr.name()));
                        continue block18;
                    }
                    default: {
                        throw new IOException("invalid type: " + field.getType().getSimpleName());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IOException("failed to read session variable: " + e.getMessage());
        }
    }

    public Map<String, String> getForwardVariables() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Field[] fields;
            for (Field f : fields = SessionVariable.class.getDeclaredFields()) {
                VariableMgr.VarAttr varAttr = f.getAnnotation(VariableMgr.VarAttr.class);
                if (varAttr == null || !varAttr.needForward()) continue;
                map.put(varAttr.name(), String.valueOf(f.get(this)));
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("failed to get forward variables", (Throwable)e);
        }
        return map;
    }

    public void setForwardedSessionVariables(Map<String, String> variables) {
        try {
            Field[] fields;
            block18: for (Field f : fields = SessionVariable.class.getFields()) {
                String val;
                VariableMgr.VarAttr varAttr = f.getAnnotation(VariableMgr.VarAttr.class);
                if (varAttr == null || !varAttr.needForward() || (val = variables.get(varAttr.name())) == null) continue;
                LOG.debug("set forward variable: {} = {}", (Object)varAttr.name(), (Object)val);
                switch (f.getType().getSimpleName()) {
                    case "short": {
                        f.setShort(this, Short.parseShort(val));
                        continue block18;
                    }
                    case "int": {
                        f.setInt(this, Integer.parseInt(val));
                        continue block18;
                    }
                    case "long": {
                        f.setLong(this, Long.parseLong(val));
                        continue block18;
                    }
                    case "double": {
                        f.setDouble(this, Double.parseDouble(val));
                        continue block18;
                    }
                    case "boolean": {
                        f.setBoolean(this, Boolean.parseBoolean(val));
                        continue block18;
                    }
                    case "String": {
                        f.set(this, val);
                        continue block18;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown field type: " + f.getType().getSimpleName());
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("failed to set forward variables", (Throwable)e);
        }
    }

    public TQueryOptions getQueryOptionVariables() {
        TQueryOptions queryOptions = new TQueryOptions();
        queryOptions.setMemLimit(this.maxExecMemByte);
        queryOptions.setQueryTimeout(this.queryTimeoutS);
        queryOptions.setLoadMemLimit(this.loadMemLimit);
        return queryOptions;
    }

    public void setForwardedSessionVariables(TQueryOptions queryOptions) {
        if (queryOptions.isSetMemLimit()) {
            this.setMaxExecMemByte(queryOptions.getMemLimit());
        }
        if (queryOptions.isSetQueryTimeout()) {
            this.setQueryTimeoutS(queryOptions.getQueryTimeout());
        }
        if (queryOptions.isSetLoadMemLimit()) {
            this.setLoadMemLimit(queryOptions.getLoadMemLimit());
        }
    }
}

