/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.thrift.TRuntimeFilterType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuntimeFilterTypeHelper {
    private static final Logger LOG = LogManager.getLogger(RuntimeFilterTypeHelper.class);
    public static final long ALLOWED_MASK = TRuntimeFilterType.IN.getValue() | TRuntimeFilterType.BLOOM.getValue() | TRuntimeFilterType.MIN_MAX.getValue() | TRuntimeFilterType.IN_OR_BLOOM.getValue();
    private static final Map<String, Long> varValueSet = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);

    public static String decode(Long varValue) throws DdlException {
        if (varValue == 0L) {
            return "";
        }
        if ((varValue & (ALLOWED_MASK ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_VALUE_FOR_VAR, "runtime_filter_type", varValue);
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, Long> value : RuntimeFilterTypeHelper.getSupportedVarValue().entrySet()) {
            if ((varValue & value.getValue()) == 0L) continue;
            names.add(value.getKey());
        }
        return Joiner.on((char)',').join(names);
    }

    public static Long encode(String varValue) throws DdlException {
        List names = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)varValue);
        long resultCode = 0L;
        for (String key : names) {
            long code = 0L;
            if (StringUtils.isNumeric((String)key)) {
                code |= Long.parseLong(key);
            } else {
                code = RuntimeFilterTypeHelper.getCodeFromString(key);
                if (code == 0L) {
                    ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_VALUE_FOR_VAR, "runtime_filter_type", key);
                }
            }
            if (((resultCode |= code) & (ALLOWED_MASK ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            ErrorReport.reportDdlException(ErrorCode.ERR_WRONG_VALUE_FOR_VAR, "runtime_filter_type", key);
        }
        return resultCode;
    }

    public static boolean isSupportedVarValue(String varValue) {
        return varValue != null && RuntimeFilterTypeHelper.getSupportedVarValue().containsKey(varValue);
    }

    private static long getCodeFromString(String varValue) {
        long code = 0L;
        if (RuntimeFilterTypeHelper.isSupportedVarValue(varValue)) {
            code |= RuntimeFilterTypeHelper.getSupportedVarValue().get(varValue).longValue();
        }
        return code;
    }

    public static Map<String, Long> getSupportedVarValue() {
        return varValueSet;
    }

    static {
        varValueSet.put("IN", Long.valueOf(TRuntimeFilterType.IN.getValue()));
        varValueSet.put("BLOOM_FILTER", Long.valueOf(TRuntimeFilterType.BLOOM.getValue()));
        varValueSet.put("MIN_MAX", Long.valueOf(TRuntimeFilterType.MIN_MAX.getValue()));
        varValueSet.put("IN_OR_BLOOM_FILTER", Long.valueOf(TRuntimeFilterType.IN_OR_BLOOM.getValue()));
    }
}

