/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.doris.common.Status;
import org.apache.doris.proto.InternalService;
import org.apache.doris.proto.Types;
import org.apache.doris.qe.RowBatch;
import org.apache.doris.qe.SimpleScheduler;
import org.apache.doris.rpc.BackendServiceProxy;
import org.apache.doris.rpc.RpcException;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TResultBatch;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;

public class ResultReceiver {
    private static final Logger LOG = LogManager.getLogger(ResultReceiver.class);
    private boolean isDone = false;
    private boolean isCancel = false;
    private long packetIdx = 0L;
    private long timeoutTs = 0L;
    private TNetworkAddress address;
    private Types.PUniqueId finstId;
    private Long backendId;
    private Thread currentThread;

    public ResultReceiver(TUniqueId tid, Long backendId, TNetworkAddress address, long timeoutTs) {
        this.finstId = Types.PUniqueId.newBuilder().setHi(tid.hi).setLo(tid.lo).build();
        this.backendId = backendId;
        this.address = address;
        this.timeoutTs = timeoutTs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowBatch getNext(Status status) throws TException {
        if (this.isDone) {
            return null;
        }
        RowBatch rowBatch = new RowBatch();
        try {
            while (!this.isDone && !this.isCancel) {
                InternalService.PFetchDataRequest request = InternalService.PFetchDataRequest.newBuilder().setFinstId(this.finstId).setRespInAttachment(false).build();
                this.currentThread = Thread.currentThread();
                Future<InternalService.PFetchDataResult> future = BackendServiceProxy.getInstance().fetchDataAsync(this.address, request);
                InternalService.PFetchDataResult pResult = null;
                while (pResult == null) {
                    long currentTs = System.currentTimeMillis();
                    if (currentTs >= this.timeoutTs) {
                        throw new TimeoutException("query timeout");
                    }
                    try {
                        pResult = future.get(this.timeoutTs - currentTs, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        LOG.info("future get interrupted Exception");
                        if (!this.isCancel) continue;
                        status.setStatus(Status.CANCELLED);
                        RowBatch rowBatch2 = null;
                        ResultReceiver resultReceiver = this;
                        synchronized (resultReceiver) {
                            this.currentThread = null;
                        }
                        return rowBatch2;
                    }
                }
                TStatusCode code = TStatusCode.findByValue((int)pResult.getStatus().getStatusCode());
                if (code != TStatusCode.OK) {
                    status.setPstatus(pResult.getStatus());
                    RowBatch rowBatch3 = null;
                    return rowBatch3;
                }
                rowBatch.setQueryStatistics(pResult.getQueryStatistics());
                if (this.packetIdx != pResult.getPacketSeq()) {
                    LOG.warn("receive packet failed, expect={}, receive={}", (Object)this.packetIdx, (Object)pResult.getPacketSeq());
                    status.setRpcStatus("receive error packet");
                    RowBatch rowBatch4 = null;
                    return rowBatch4;
                }
                ++this.packetIdx;
                this.isDone = pResult.getEos();
                if (pResult.hasEmptyBatch() && pResult.getEmptyBatch()) {
                    LOG.info("get first empty rowbatch");
                    rowBatch.setEos(false);
                    RowBatch rowBatch5 = rowBatch;
                    return rowBatch5;
                }
                if (!pResult.hasRowBatch() || pResult.getRowBatch().size() <= 0) continue;
                byte[] serialResult = pResult.getRowBatch().toByteArray();
                TResultBatch resultBatch = new TResultBatch();
                TDeserializer deserializer = new TDeserializer();
                deserializer.deserialize((TBase)resultBatch, serialResult);
                rowBatch.setBatch(resultBatch);
                rowBatch.setEos(pResult.getEos());
                RowBatch rowBatch6 = rowBatch;
                return rowBatch6;
            }
        }
        catch (RpcException e) {
            LOG.warn("fetch result rpc exception, finstId={}", (Object)this.finstId, (Object)e);
            status.setRpcStatus(e.getMessage());
            SimpleScheduler.addToBlacklist(this.backendId, e.getMessage());
        }
        catch (ExecutionException e) {
            LOG.warn("fetch result execution exception, finstId={}", (Object)this.finstId, (Object)e);
            if (e.getMessage().contains("time out")) {
                status.setStatus(new Status(TStatusCode.TIMEOUT, e.getMessage()));
            } else {
                status.setRpcStatus(e.getMessage());
                SimpleScheduler.addToBlacklist(this.backendId, e.getMessage());
            }
        }
        catch (TimeoutException e) {
            LOG.warn("fetch result timeout, finstId={}", (Object)this.finstId, (Object)e);
            status.setStatus("query timeout");
        }
        finally {
            ResultReceiver e = this;
            synchronized (e) {
                this.currentThread = null;
            }
        }
        if (this.isCancel) {
            status.setStatus(Status.CANCELLED);
        }
        return rowBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.isCancel = true;
        ResultReceiver resultReceiver = this;
        synchronized (resultReceiver) {
            if (this.currentThread != null) {
                // empty if block
            }
        }
    }
}

