/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TUniqueId;

public final class QueryStatisticsItem {
    private final String queryId;
    private final String user;
    private final String sql;
    private final String db;
    private final String connId;
    private final long queryStartTime;
    private final List<FragmentInstanceInfo> fragmentInstanceInfos;
    private final RuntimeProfile queryProfile;
    private final boolean isReportSucc;

    private QueryStatisticsItem(Builder builder) {
        this.queryId = builder.queryId;
        this.user = builder.user;
        this.sql = builder.sql;
        this.db = builder.db;
        this.connId = builder.connId;
        this.queryStartTime = builder.queryStartTime;
        this.fragmentInstanceInfos = builder.fragmentInstanceInfos;
        this.queryProfile = builder.queryProfile;
        this.isReportSucc = builder.isReportSucc;
    }

    public String getDb() {
        return this.db;
    }

    public String getUser() {
        return this.user;
    }

    public String getSql() {
        return this.sql;
    }

    public String getConnId() {
        return this.connId;
    }

    public String getQueryExecTime() {
        long currentTime = System.currentTimeMillis();
        return String.valueOf(currentTime - this.queryStartTime);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public List<FragmentInstanceInfo> getFragmentInstanceInfos() {
        return this.fragmentInstanceInfos;
    }

    public RuntimeProfile getQueryProfile() {
        return this.queryProfile;
    }

    public boolean getIsReportSucc() {
        return this.isReportSucc;
    }

    public static final class FragmentInstanceInfo {
        private final TUniqueId instanceId;
        private final TNetworkAddress address;
        private final String fragmentId;

        public FragmentInstanceInfo(Builder builder) {
            this.instanceId = builder.instanceId;
            this.address = builder.address;
            this.fragmentId = builder.fragmentId;
        }

        public TUniqueId getInstanceId() {
            return this.instanceId;
        }

        public TNetworkAddress getAddress() {
            return this.address;
        }

        public String getFragmentId() {
            return this.fragmentId;
        }

        public static final class Builder {
            private TUniqueId instanceId;
            private TNetworkAddress address;
            private String fragmentId;

            public Builder instanceId(TUniqueId instanceId) {
                this.instanceId = instanceId;
                return this;
            }

            public Builder address(TNetworkAddress address) {
                this.address = address;
                return this;
            }

            public Builder fragmentId(String fragmentId) {
                this.fragmentId = fragmentId;
                return this;
            }

            public FragmentInstanceInfo build() {
                this.initDefaultValue(this);
                return new FragmentInstanceInfo(this);
            }

            private void initDefaultValue(Builder builder) {
                if (builder.instanceId == null) {
                    builder.instanceId = new TUniqueId(-1L, -1L);
                }
                if (builder.address == null) {
                    builder.address = new TNetworkAddress("null", -1);
                }
                if (builder.fragmentId == null) {
                    builder.fragmentId = "";
                }
            }
        }
    }

    public static final class Builder {
        private String queryId;
        private String db;
        private String user;
        private String sql;
        private String connId;
        private long queryStartTime;
        private List<FragmentInstanceInfo> fragmentInstanceInfos = Lists.newArrayList();
        private RuntimeProfile queryProfile;
        private boolean isReportSucc;

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public Builder connId(String connId) {
            this.connId = connId;
            return this;
        }

        public Builder queryStartTime(long queryStartTime) {
            this.queryStartTime = queryStartTime;
            return this;
        }

        public Builder fragmentInstanceInfos(List<FragmentInstanceInfo> infos) {
            this.fragmentInstanceInfos.addAll(infos);
            return this;
        }

        public Builder profile(RuntimeProfile profile) {
            this.queryProfile = profile;
            return this;
        }

        public Builder isReportSucc(boolean isReportSucc) {
            this.isReportSucc = isReportSucc;
            return this;
        }

        public QueryStatisticsItem build() {
            this.initDefaultValue(this);
            return new QueryStatisticsItem(this);
        }

        private void initDefaultValue(Builder builder) {
            if (this.queryId == null) {
                builder.queryId = "0";
            }
            if (this.db == null) {
                builder.db = "";
            }
            if (this.sql == null) {
                builder.sql = "";
            }
            if (this.user == null) {
                builder.user = "";
            }
            if (this.connId == null) {
                builder.connId = "";
            }
            if (this.queryProfile == null) {
                this.queryProfile = new RuntimeProfile("");
            }
        }
    }
}

