/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import org.apache.doris.common.ErrorCode;
import org.apache.doris.mysql.MysqlEofPacket;
import org.apache.doris.mysql.MysqlErrPacket;
import org.apache.doris.mysql.MysqlOkPacket;
import org.apache.doris.mysql.MysqlPacket;

public class QueryState {
    private MysqlStateType stateType = MysqlStateType.OK;
    private String errorMessage = "";
    private ErrorCode errorCode;
    private String infoMessage;
    private ErrType errType = ErrType.OTHER_ERR;
    private boolean isQuery = false;
    private long affectedRows = 0L;
    private int warningRows = 0;
    public int serverStatus = 0;

    public void reset() {
        this.stateType = MysqlStateType.OK;
        this.errorCode = null;
        this.infoMessage = null;
        this.serverStatus = 0;
        this.isQuery = false;
        this.affectedRows = 0L;
        this.warningRows = 0;
    }

    public MysqlStateType getStateType() {
        return this.stateType;
    }

    public void setEof() {
        this.stateType = MysqlStateType.EOF;
    }

    public void setOk() {
        if (this.stateType == MysqlStateType.OK) {
            return;
        }
        this.setOk(0L, 0, null);
    }

    public void setOk(long affectedRows, int warningRows, String infoMessage) {
        this.affectedRows = affectedRows;
        this.warningRows = warningRows;
        this.infoMessage = infoMessage;
        this.stateType = MysqlStateType.OK;
    }

    public void setError(String errorMsg) {
        this.stateType = MysqlStateType.ERR;
        this.errorMessage = errorMsg;
    }

    public void setError(ErrorCode code, String msg) {
        this.stateType = MysqlStateType.ERR;
        this.errorCode = code;
        this.errorMessage = msg;
    }

    public void setMsg(String msg) {
        this.errorMessage = msg;
    }

    public void setErrType(ErrType errType) {
        this.errType = errType;
    }

    public ErrType getErrType() {
        return this.errType;
    }

    public void setIsQuery(boolean isQuery) {
        this.isQuery = isQuery;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public String getInfoMessage() {
        return this.infoMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public int getWarningRows() {
        return this.warningRows;
    }

    public MysqlPacket toResponsePacket() {
        MysqlPacket packet = null;
        switch (this.stateType) {
            case OK: {
                packet = new MysqlOkPacket(this);
                break;
            }
            case EOF: {
                packet = new MysqlEofPacket(this);
                break;
            }
            case ERR: {
                packet = new MysqlErrPacket(this);
                break;
            }
        }
        return packet;
    }

    public String toString() {
        return String.valueOf((Object)this.stateType);
    }

    public static enum ErrType {
        ANALYSIS_ERR,
        OTHER_ERR;

    }

    public static enum MysqlStateType {
        NOOP,
        OK,
        EOF,
        ERR;

    }
}

