/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.doris.qe.QueryDetail;

public class QueryDetailQueue {
    private static Map<String, QueryDetail> runningQueries = Maps.newHashMap();
    private static LinkedList<QueryDetail> totalQueries = new LinkedList();
    private static int queryCapacity = 10000;

    public static synchronized void addOrUpdateQueryDetail(QueryDetail queryDetail) {
        QueryDetail qDetail;
        if (runningQueries.get(queryDetail.getQueryId()) == null) {
            if (queryDetail.getState() == QueryDetail.QueryMemState.RUNNING) {
                runningQueries.put(queryDetail.getQueryId(), queryDetail);
                totalQueries.add(queryDetail);
            } else {
                totalQueries.add(queryDetail);
            }
        } else if (queryDetail.getState() != QueryDetail.QueryMemState.RUNNING) {
            qDetail = runningQueries.remove(queryDetail.getQueryId());
            qDetail.setLatency(queryDetail.getLatency());
            qDetail.setState(queryDetail.getState());
        }
        if (totalQueries.size() > queryCapacity) {
            qDetail = totalQueries.remove();
            runningQueries.remove(qDetail.getQueryId());
        }
    }

    public static synchronized List<QueryDetail> getQueryDetails(long eventTime) {
        ArrayList results = Lists.newArrayList();
        for (QueryDetail queryDetail : totalQueries) {
            if (queryDetail.getEventTime() <= eventTime) continue;
            results.add(queryDetail);
        }
        return results;
    }
}

