/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import java.io.IOException;
import org.apache.doris.mysql.MysqlServer;
import org.apache.doris.mysql.nio.NMysqlServer;
import org.apache.doris.qe.ConnectScheduler;
import org.apache.doris.qe.HelpModule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QeService {
    private static final Logger LOG = LogManager.getLogger(QeService.class);
    private int port;
    private MysqlServer mysqlServer;

    @Deprecated
    public QeService(int port) {
        this.port = port;
    }

    public QeService(int port, boolean nioEnabled, ConnectScheduler scheduler) {
        try {
            HelpModule.getInstance().setUpModule();
        }
        catch (Exception e) {
            LOG.error("Help module failed, because:", (Throwable)e);
        }
        this.port = port;
        this.mysqlServer = nioEnabled ? new NMysqlServer(port, scheduler) : new MysqlServer(port, scheduler);
    }

    public void start() throws IOException {
        if (!this.mysqlServer.start()) {
            LOG.error("mysql server start failed");
            System.exit(-1);
        }
        LOG.info("QE service start.");
    }

    public MysqlServer getMysqlServer() {
        return this.mysqlServer;
    }

    public void setMysqlServer(MysqlServer mysqlServer) {
        this.mysqlServer = mysqlServer;
    }
}

