/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.doris.common.Config;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.ProfileWriter;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.Coordinator;
import org.apache.doris.qe.QeProcessor;
import org.apache.doris.qe.QueryStatisticsItem;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TReportExecStatusParams;
import org.apache.doris.thrift.TReportExecStatusResult;
import org.apache.doris.thrift.TStatus;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class QeProcessorImpl
implements QeProcessor {
    private static final Logger LOG = LogManager.getLogger(QeProcessorImpl.class);
    private Map<TUniqueId, QueryInfo> coordinatorMap = new ConcurrentHashMap<TUniqueId, QueryInfo>();
    private Map<TUniqueId, Integer> queryToInstancesNum;
    private Map<String, AtomicInteger> userToInstancesCount;
    public static final QeProcessor INSTANCE = new QeProcessorImpl();
    private ExecutorService writeProfileExecutor = ThreadPoolManager.newDaemonProfileThreadPool(1, 100, "profile-write-pool", true);

    private QeProcessorImpl() {
        this.queryToInstancesNum = new ConcurrentHashMap<TUniqueId, Integer>();
        this.userToInstancesCount = new ConcurrentHashMap<String, AtomicInteger>();
    }

    @Override
    public Coordinator getCoordinator(TUniqueId queryId) {
        QueryInfo queryInfo = this.coordinatorMap.get(queryId);
        if (queryInfo != null) {
            return queryInfo.getCoord();
        }
        return null;
    }

    @Override
    public void registerQuery(TUniqueId queryId, Coordinator coord) throws UserException {
        this.registerQuery(queryId, new QueryInfo(coord));
    }

    @Override
    public void registerQuery(TUniqueId queryId, QueryInfo info) throws UserException {
        QueryInfo result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("register query id = " + DebugUtil.printId(queryId) + ", job: " + info.getCoord().getJobId());
        }
        if ((result = this.coordinatorMap.putIfAbsent(queryId, info)) != null) {
            throw new UserException("queryId " + queryId + " already exists");
        }
    }

    @Override
    public void registerInstances(TUniqueId queryId, Integer instancesNum) throws UserException {
        if (!this.coordinatorMap.containsKey(queryId)) {
            throw new UserException("query not exists in coordinatorMap:" + DebugUtil.printId(queryId));
        }
        QueryInfo queryInfo = this.coordinatorMap.get(queryId);
        if (queryInfo.getConnectContext() != null && !Strings.isNullOrEmpty((String)queryInfo.getConnectContext().getQualifiedUser())) {
            String user = queryInfo.getConnectContext().getQualifiedUser();
            long maxQueryInstances = queryInfo.getConnectContext().getCatalog().getAuth().getMaxQueryInstances(user);
            if (maxQueryInstances <= 0L) {
                maxQueryInstances = Config.default_max_query_instances;
            }
            if (maxQueryInstances > 0L) {
                AtomicInteger currentCount = this.userToInstancesCount.computeIfAbsent(user, __ -> new AtomicInteger(0));
                if ((long)(instancesNum + currentCount.get()) > maxQueryInstances) {
                    throw new UserException("reach max_query_instances " + maxQueryInstances);
                }
            }
            this.queryToInstancesNum.put(queryId, instancesNum);
            this.userToInstancesCount.computeIfAbsent(user, __ -> new AtomicInteger(0)).addAndGet(instancesNum);
        }
    }

    public Map<String, Integer> getInstancesNumPerUser() {
        return Maps.transformEntries(this.userToInstancesCount, (__, value) -> value != null ? value.get() : 0);
    }

    @Override
    public void unregisterQuery(TUniqueId queryId) {
        QueryInfo queryInfo = this.coordinatorMap.remove(queryId);
        if (queryInfo != null) {
            Integer num;
            if (LOG.isDebugEnabled()) {
                LOG.debug("deregister query id {}", (Object)DebugUtil.printId(queryId));
            }
            if (queryInfo.getConnectContext() != null && !Strings.isNullOrEmpty((String)queryInfo.getConnectContext().getQualifiedUser()) && (num = this.queryToInstancesNum.remove(queryId)) != null) {
                String user = queryInfo.getConnectContext().getQualifiedUser();
                AtomicInteger instancesNum = this.userToInstancesCount.get(user);
                if (instancesNum == null) {
                    LOG.warn("WTF?? query {} in queryToInstancesNum but not in userToInstancesCount", (Object)DebugUtil.printId(queryId));
                } else {
                    instancesNum.addAndGet(-num.intValue());
                }
            }
        } else {
            LOG.warn("not found query {} when unregisterQuery", (Object)DebugUtil.printId(queryId));
        }
    }

    @Override
    public Map<String, QueryStatisticsItem> getQueryStatistics() {
        HashMap querySet = Maps.newHashMap();
        for (Map.Entry<TUniqueId, QueryInfo> entry : this.coordinatorMap.entrySet()) {
            QueryInfo info = entry.getValue();
            ConnectContext context = info.getConnectContext();
            if (info.sql == null || context == null) continue;
            String queryIdStr = DebugUtil.printId(info.getConnectContext().queryId());
            QueryStatisticsItem item = new QueryStatisticsItem.Builder().queryId(queryIdStr).queryStartTime(info.getStartExecTime()).sql(info.getSql()).user(context.getQualifiedUser()).connId(String.valueOf(context.getConnectionId())).db(context.getDatabase()).fragmentInstanceInfos(info.getCoord().getFragmentInstanceInfos()).profile(info.getCoord().getQueryProfile()).isReportSucc(context.getSessionVariable().enableProfile()).build();
            querySet.put(queryIdStr, item);
        }
        return querySet;
    }

    @Override
    public TReportExecStatusResult reportExecStatus(TReportExecStatusParams params, TNetworkAddress beAddr) {
        if (params.isSetProfile()) {
            LOG.info("ReportExecStatus(): fragment_instance_id={}, query id={}, backend num: {}, ip: {}", (Object)DebugUtil.printId(params.fragment_instance_id), (Object)DebugUtil.printId(params.query_id), (Object)params.backend_num, (Object)beAddr);
            LOG.debug("params: {}", (Object)params);
        }
        TReportExecStatusResult result = new TReportExecStatusResult();
        QueryInfo info = this.coordinatorMap.get(params.query_id);
        if (info == null) {
            result.setStatus(new TStatus(TStatusCode.RUNTIME_ERROR));
            LOG.info("ReportExecStatus() runtime error, query {} does not exist", (Object)DebugUtil.printId(params.query_id));
            return result;
        }
        try {
            info.getCoord().updateFragmentExecStatus(params);
            if (info.getCoord().getProfileWriter() != null && params.isSetProfile()) {
                this.writeProfileExecutor.submit(new WriteProfileTask(params));
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
            return result;
        }
        result.setStatus(new TStatus(TStatusCode.OK));
        return result;
    }

    private class WriteProfileTask
    implements Runnable {
        private TReportExecStatusParams params;

        WriteProfileTask(TReportExecStatusParams params) {
            this.params = params;
        }

        @Override
        public void run() {
            QueryInfo info = (QueryInfo)QeProcessorImpl.this.coordinatorMap.get(this.params.query_id);
            if (info == null) {
                return;
            }
            ProfileWriter profileWriter = info.getCoord().getProfileWriter();
            if (profileWriter != null) {
                profileWriter.writeProfile(false);
            }
        }
    }

    public static final class QueryInfo {
        private final ConnectContext connectContext;
        private final Coordinator coord;
        private final String sql;
        private final long startExecTime;

        public QueryInfo(Coordinator coord) {
            this(null, null, coord);
        }

        public QueryInfo(ConnectContext connectContext, String sql, Coordinator coord) {
            this.connectContext = connectContext;
            this.coord = coord;
            this.sql = sql;
            this.startExecTime = System.currentTimeMillis();
        }

        public ConnectContext getConnectContext() {
            return this.connectContext;
        }

        public Coordinator getCoord() {
            return this.coord;
        }

        public String getSql() {
            return this.sql;
        }

        public long getStartExecTime() {
            return this.startExecTime;
        }
    }
}

