/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.DataDescription;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ImportWhereStmt;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.analysis.LoadStmt;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.Separator;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.loadv2.JobState;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.system.Backend;
import org.apache.doris.system.BeSelectionPolicy;
import org.apache.doris.thrift.TMiniLoadRequest;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.awaitility.Awaitility;

public class MultiLoadMgr {
    private static final Logger LOG = LogManager.getLogger(MultiLoadMgr.class);
    private Map<LabelName, MultiLoadDesc> infoMap = Maps.newHashMap();
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMulti(String fullDbName, String label, Map<String, String> properties) throws DdlException {
        if (Strings.isNullOrEmpty((String)fullDbName)) {
            throw new DdlException("Database is empty");
        }
        if (Strings.isNullOrEmpty((String)label)) {
            throw new DdlException("Label is empty");
        }
        LoadStmt.checkProperties(properties);
        LabelName multiLabel = new LabelName(fullDbName, label);
        this.lock.writeLock().lock();
        try {
            if (this.infoMap.containsKey(multiLabel)) {
                throw new LabelAlreadyUsedException(label);
            }
            BeSelectionPolicy policy = new BeSelectionPolicy.Builder().setCluster(ConnectContext.get().getClusterName()).needLoadAvailable().build();
            List<Long> backendIds = Catalog.getCurrentSystemInfo().selectBackendIdsByPolicy(policy, 1);
            if (backendIds.isEmpty()) {
                throw new DdlException("No backend load available. policy: " + policy);
            }
            MultiLoadDesc multiLoadDesc = new MultiLoadDesc(multiLabel, properties);
            multiLoadDesc.setBackendId(backendIds.get(0));
            this.infoMap.put(multiLabel, multiLoadDesc);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        Catalog.getCurrentCatalog().getLoadManager().createLoadJobV1FromMultiStart(fullDbName, label);
    }

    public void load(TMiniLoadRequest request) throws DdlException {
        if (CollectionUtils.isNotEmpty((Collection)request.getFileSize()) && request.getFileSize().size() != request.getFiles().size()) {
            throw new DdlException("files count and file size count not match: [" + request.getFileSize().size() + "!=" + request.getFiles().size() + "]");
        }
        List<Pair<String, Long>> files = Streams.zip(request.getFiles().stream(), request.getFileSize().stream(), Pair::create).collect(Collectors.toList());
        this.load(request.getDb(), request.getLabel(), request.getSubLabel(), request.getTbl(), files, request.getBackend(), request.getProperties(), request.getTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String fullDbName, String label, String subLabel, String table, List<Pair<String, Long>> files, TNetworkAddress fileAddr, Map<String, String> properties, long timestamp) throws DdlException {
        LabelName multiLabel = new LabelName(fullDbName, label);
        this.lock.writeLock().lock();
        try {
            MultiLoadDesc multiLoadDesc = this.infoMap.get(multiLabel);
            if (multiLoadDesc == null) {
                throw new DdlException("Unknown label(" + multiLabel + ")");
            }
            multiLoadDesc.addFile(subLabel, table, files, fileAddr, properties, timestamp);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(String fullDbName, String label, String subLabel) throws DdlException {
        LabelName multiLabel = new LabelName(fullDbName, label);
        this.lock.writeLock().lock();
        try {
            MultiLoadDesc multiLoadDesc = this.infoMap.get(multiLabel);
            if (multiLoadDesc == null) {
                throw new DdlException("Unknown label(" + multiLabel + ")");
            }
            multiLoadDesc.delFile(subLabel);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(String fullDbName, String label) throws DdlException {
        LabelName multiLabel = new LabelName(fullDbName, label);
        ArrayList jobIds = Lists.newArrayList();
        this.lock.writeLock().lock();
        try {
            MultiLoadDesc multiLoadDesc = this.infoMap.get(multiLabel);
            if (multiLoadDesc == null) {
                throw new DdlException("Unknown label(" + multiLabel + ")");
            }
            jobIds.add(Catalog.getCurrentCatalog().getLoadManager().createLoadJobFromStmt(multiLoadDesc.toLoadStmt()));
            this.infoMap.remove(multiLabel);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        long jobId = jobIds.isEmpty() ? -1L : (Long)jobIds.get(0);
        Catalog.getCurrentCatalog().getLoadInstance().deregisterMiniLabel(fullDbName, label);
        Catalog catalog = Catalog.getCurrentCatalog();
        ConnectContext ctx = ConnectContext.get();
        Awaitility.await().atMost((long)Config.broker_load_default_timeout_second, TimeUnit.SECONDS).until(() -> {
            ConnectContext.threadLocalInfo.set(ctx);
            LoadJob loadJob = catalog.getLoadManager().getLoadJob(jobId);
            if (loadJob.getState() == JobState.FINISHED) {
                return true;
            }
            if (loadJob.getState() == JobState.PENDING || loadJob.getState() == JobState.LOADING) {
                return false;
            }
            throw new DdlException("job failed. ErrorMsg: " + loadJob.getFailMsg().getMsg() + ", URL: " + loadJob.getLoadingStatus().getTrackingUrl() + ", JobDetails: " + loadJob.getLoadStatistic().toJson());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(String fullDbName, String label) throws DdlException {
        LabelName multiLabel = new LabelName(fullDbName, label);
        this.lock.writeLock().lock();
        try {
            MultiLoadDesc multiLoadDesc = this.infoMap.get(multiLabel);
            if (multiLoadDesc == null) {
                throw new DdlException("Unknown label(" + multiLabel + ")");
            }
            this.infoMap.remove(multiLabel);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        Catalog.getCurrentCatalog().getLoadInstance().deregisterMiniLabel(fullDbName, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void desc(String fullDbName, String label, List<String> subLabels) throws DdlException {
        LabelName multiLabel = new LabelName(fullDbName, label);
        this.lock.readLock().lock();
        try {
            MultiLoadDesc multiLoadDesc = this.infoMap.get(multiLabel);
            if (multiLoadDesc == null) {
                throw new DdlException("Unknown label(" + multiLabel + ")");
            }
            multiLoadDesc.listLabel(subLabels);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(String fullDbName, List<String> labels) throws DdlException {
        if (Strings.isNullOrEmpty((String)fullDbName)) {
            throw new DdlException("No database selected");
        }
        this.lock.readLock().lock();
        try {
            for (LabelName label : this.infoMap.keySet()) {
                if (!fullDbName.equals(label.getDbName())) continue;
                labels.add(label.getLabelName());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TNetworkAddress redirectAddr(String fullDbName, String label) throws DdlException {
        LabelName multiLabel = new LabelName(fullDbName, label);
        this.lock.writeLock().lock();
        try {
            MultiLoadDesc desc = this.infoMap.get(multiLabel);
            if (desc == null) {
                throw new DdlException("Unknown multiLabel(" + multiLabel + ")");
            }
            Backend backend = Catalog.getCurrentSystemInfo().getBackend(desc.getBackendId());
            TNetworkAddress tNetworkAddress = new TNetworkAddress(backend.getHost(), backend.getHttpPort());
            return tNetworkAddress;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static class TableLoadDesc {
        private String tbl;
        private Map<String, List<Pair<String, Long>>> filesByLabel;
        private TNetworkAddress address;
        private Long backendId;
        private Map<String, String> properties;
        private Set<Long> timestamps = Sets.newHashSet();

        public TableLoadDesc(String tbl, String label, List<Pair<String, Long>> files, TNetworkAddress address, Map<String, String> properties, long timestamp) {
            this.tbl = tbl;
            this.filesByLabel = Maps.newLinkedHashMap();
            this.address = address;
            this.properties = properties;
            this.filesByLabel.put(label, files);
            this.timestamps.add(timestamp);
        }

        public boolean canMerge(Map<String, String> properties) {
            return Maps.difference(this.properties, properties).areEqual();
        }

        public boolean isEmpty() {
            return this.filesByLabel.isEmpty();
        }

        public void addFiles(String label, List<Pair<String, Long>> files) {
            this.filesByLabel.put(label, files);
        }

        public void delFiles(String label) {
            this.filesByLabel.remove(label);
        }

        public boolean containsTimestamp(long timestamp) {
            return this.timestamps.contains(timestamp);
        }

        public void addTimestamp(long timestamp) {
            this.timestamps.add(timestamp);
        }

        public Long getBackendId() {
            return this.backendId;
        }

        public void setBackendId(Long backendId) {
            this.backendId = backendId;
        }

        public DataDescription toDataDesc() throws DdlException {
            ArrayList files = Lists.newArrayList();
            ArrayList fileSizes = Lists.newArrayList();
            Iterator<Map.Entry<String, List<Pair<String, Long>>>> it = this.filesByLabel.entrySet().iterator();
            while (it.hasNext()) {
                List<Pair<String, Long>> value = it.next().getValue();
                value.stream().forEach(pair -> {
                    files.add((String)pair.first);
                    fileSizes.add((Long)pair.second);
                });
            }
            Separator columnSeparator = null;
            PartitionNames partitionNames = null;
            String fileFormat = this.properties.get("format");
            boolean isNegative = this.properties.get("negative") == null ? false : Boolean.valueOf(this.properties.get("negative"));
            Expr whereExpr = null;
            LoadTask.MergeType mergeType = LoadTask.MergeType.APPEND;
            Expr deleteCondition = null;
            String sequenceColName = this.properties.get("sequence_col");
            String colString = null;
            Backend backend = null;
            boolean stripOuterArray = false;
            String jsonPaths = "";
            String jsonRoot = "";
            boolean fuzzyParse = false;
            if (this.properties != null) {
                colString = this.properties.get("columns");
                String columnSeparatorStr = this.properties.get("column_separator");
                if (columnSeparatorStr != null) {
                    columnSeparator = new Separator(columnSeparatorStr);
                    try {
                        columnSeparator.analyze();
                    }
                    catch (AnalysisException e) {
                        throw new DdlException(e.getMessage());
                    }
                }
                if (this.properties.get("partitions") != null) {
                    Object[] partNames = this.properties.get("partitions").trim().split("\\s*,\\s*");
                    partitionNames = new PartitionNames(false, Lists.newArrayList((Object[])partNames));
                } else if (this.properties.get("temporary_partitions") != null) {
                    Object[] partNames = this.properties.get("temporary_partitions").trim().split("\\s*,\\s*");
                    partitionNames = new PartitionNames(true, Lists.newArrayList((Object[])partNames));
                }
                if (this.properties.get("merge_type") != null) {
                    mergeType = LoadTask.MergeType.valueOf(this.properties.get("merge_type"));
                }
                if (this.properties.get("where") != null) {
                    whereExpr = this.parseWhereExpr(this.properties.get("where"));
                }
                if (this.properties.get("delete") != null) {
                    deleteCondition = this.parseWhereExpr(this.properties.get("delete"));
                }
                if (fileFormat != null && fileFormat.equalsIgnoreCase("json")) {
                    stripOuterArray = Boolean.valueOf(this.properties.getOrDefault("strip_outer_array", "false"));
                    jsonPaths = this.properties.getOrDefault("jsonpaths", "");
                    jsonRoot = this.properties.getOrDefault("json_root", "");
                    fuzzyParse = Boolean.valueOf(this.properties.getOrDefault("fuzzy_parse", "false"));
                }
            }
            DataDescription dataDescription = new DataDescription(this.tbl, partitionNames, files, null, columnSeparator, fileFormat, null, isNegative, null, null, whereExpr, mergeType, deleteCondition, sequenceColName, null);
            dataDescription.setColumnDef(colString);
            backend = Catalog.getCurrentSystemInfo().getBackend(this.backendId);
            if (backend == null) {
                throw new DdlException("Backend [" + this.backendId + "] not found. ");
            }
            dataDescription.setBeAddr(new TNetworkAddress(backend.getHost(), backend.getHeartbeatPort()));
            dataDescription.setFileSize(fileSizes);
            dataDescription.setBackendId(this.backendId);
            dataDescription.setJsonPaths(jsonPaths);
            dataDescription.setJsonRoot(jsonRoot);
            dataDescription.setStripOuterArray(stripOuterArray);
            dataDescription.setFuzzyParse(fuzzyParse);
            return dataDescription;
        }

        private Expr parseWhereExpr(String whereString) throws DdlException {
            ImportWhereStmt whereStmt;
            String whereSQL = "WHERE " + whereString;
            SqlParser parser = new SqlParser(new SqlScanner(new StringReader(whereSQL)));
            try {
                whereStmt = (ImportWhereStmt)SqlParserUtils.getFirstStmt(parser);
            }
            catch (Error e) {
                LOG.warn("error happens when parsing where header, sql={}", (Object)whereSQL, (Object)e);
                throw new DdlException("failed to parsing where header, maybe contain unsupported character");
            }
            catch (DdlException e) {
                LOG.warn("analyze where statement failed, sql={}, error={}", (Object)whereSQL, (Object)parser.getErrorMsg(whereSQL), (Object)e);
                String errorMessage = parser.getErrorMsg(whereSQL);
                if (errorMessage == null) {
                    throw e;
                }
                throw new DdlException(errorMessage, e);
            }
            catch (Exception e) {
                LOG.warn("failed to parse where header, sql={}", (Object)whereSQL, (Object)e);
                throw new DdlException("parse columns header failed", e);
            }
            return whereStmt.getExpr();
        }
    }

    private static class MultiLoadDesc {
        private LabelName multiLabel;
        private Map<String, TableLoadDesc> loadDescByLabel;
        private Map<String, TableLoadDesc> loadDescByTable;
        private Long backendId;
        private Map<String, String> properties;

        public MultiLoadDesc(LabelName label, Map<String, String> properties) {
            this.multiLabel = label;
            this.loadDescByLabel = Maps.newHashMap();
            this.loadDescByTable = Maps.newHashMap();
            this.backendId = -1L;
            this.properties = properties;
        }

        public void addFile(String subLabel, String table, List<Pair<String, Long>> files, TNetworkAddress fileAddr, Map<String, String> properties, long timestamp) throws DdlException {
            if (this.isSubLabelUsed(subLabel, timestamp)) {
                return;
            }
            TableLoadDesc desc = this.loadDescByLabel.get(subLabel);
            if (desc != null) {
                throw new LabelAlreadyUsedException(this.multiLabel.getLabelName(), subLabel);
            }
            desc = this.loadDescByTable.get(table);
            if (desc == null) {
                desc = new TableLoadDesc(table, subLabel, files, fileAddr, properties, timestamp);
                desc.setBackendId(this.backendId);
                this.loadDescByTable.put(table, desc);
            } else {
                if (!desc.canMerge(properties)) {
                    throw new DdlException("Same table have different properties in one multi-load.new=" + properties + ",old=" + desc.properties);
                }
                desc.addFiles(subLabel, files);
                desc.addTimestamp(timestamp);
            }
            this.loadDescByLabel.put(subLabel, desc);
        }

        public void delFile(String label) throws DdlException {
            TableLoadDesc desc = this.loadDescByLabel.get(label);
            if (desc == null) {
                throw new DdlException("Unknown load label(" + label + ")");
            }
            desc.delFiles(label);
            if (desc.isEmpty()) {
                this.loadDescByTable.remove(desc.tbl);
            }
            this.loadDescByLabel.remove(label);
        }

        public void listLabel(List<String> labels) {
            for (String label : this.loadDescByLabel.keySet()) {
                labels.add(label);
            }
        }

        public boolean isSubLabelUsed(String subLabel, long timestamp) throws DdlException {
            if (this.loadDescByLabel.containsKey(subLabel)) {
                if (timestamp == -1L) {
                    throw new LabelAlreadyUsedException(this.multiLabel.getLabelName(), subLabel);
                }
                TableLoadDesc tblLoadDesc = this.loadDescByLabel.get(subLabel);
                if (tblLoadDesc.containsTimestamp(timestamp)) {
                    LOG.info("get a retry request with label: {}, sub label: {}, timestamp: {}. return ok", (Object)this.multiLabel.getLabelName(), (Object)subLabel, (Object)timestamp);
                    return true;
                }
                throw new LabelAlreadyUsedException(this.multiLabel.getLabelName(), subLabel);
            }
            return false;
        }

        public void setBackendId(long backendId) {
            this.backendId = backendId;
        }

        public long getBackendId() {
            return this.backendId;
        }

        public LoadStmt toLoadStmt() throws DdlException {
            LabelName commitLabel = this.multiLabel;
            ArrayList dataDescriptions = Lists.newArrayList();
            for (TableLoadDesc desc : this.loadDescByTable.values()) {
                dataDescriptions.add(desc.toDataDesc());
            }
            HashMap brokerProperties = Maps.newHashMap();
            brokerProperties.put("__DORIS_MULTI_LOAD_BROKER_BACKEND__", this.backendId.toString());
            BrokerDesc brokerDesc = new BrokerDesc("__DORIS_MULTI_LOAD_BROKER__", brokerProperties);
            LoadStmt loadStmt = new LoadStmt(commitLabel, dataDescriptions, brokerDesc, null, this.properties);
            loadStmt.setEtlJobType(EtlJobType.BROKER);
            loadStmt.setOrigStmt(new OriginStatement("", 0));
            loadStmt.setUserInfo(ConnectContext.get().getCurrentUserIdentity());
            Analyzer analyzer = new Analyzer(ConnectContext.get().getCatalog(), ConnectContext.get());
            try {
                loadStmt.analyze(analyzer);
            }
            catch (UserException e) {
                throw new DdlException(e.getMessage());
            }
            return loadStmt;
        }
    }
}

