/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import org.apache.doris.common.ClientPool;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.FrontendService;
import org.apache.doris.thrift.TLoadTxnBeginRequest;
import org.apache.doris.thrift.TLoadTxnBeginResult;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TWaitingTxnStatusRequest;
import org.apache.doris.thrift.TWaitingTxnStatusResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class MasterTxnExecutor {
    private static final Logger LOG = LogManager.getLogger(MasterTxnExecutor.class);
    private int waitTimeoutMs;
    private int thriftTimeoutMs;
    private ConnectContext ctx;

    public MasterTxnExecutor(ConnectContext ctx) {
        this.ctx = ctx;
        this.waitTimeoutMs = ctx.getSessionVariable().getQueryTimeoutS() * 1000;
        this.thriftTimeoutMs = ctx.getSessionVariable().getQueryTimeoutS() * 1000;
    }

    private TNetworkAddress getMasterAddress() throws TException {
        if (!this.ctx.getCatalog().isReady()) {
            throw new TException("Node catalog is not ready, please wait for a while.");
        }
        String masterHost = this.ctx.getCatalog().getMasterIp();
        int masterRpcPort = this.ctx.getCatalog().getMasterRpcPort();
        return new TNetworkAddress(masterHost, masterRpcPort);
    }

    private FrontendService.Client getClient(TNetworkAddress thriftAddress) throws TException {
        try {
            return ClientPool.frontendPool.borrowObject(thriftAddress, this.thriftTimeoutMs);
        }
        catch (Exception e) {
            throw new TException("Failed to get master client.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TLoadTxnBeginResult beginTxn(TLoadTxnBeginRequest request) throws TException {
        TNetworkAddress thriftAddress = this.getMasterAddress();
        FrontendService.Client client = this.getClient(thriftAddress);
        LOG.info("Send begin transaction {} to Master {}", (Object)this.ctx.getStmtId(), (Object)thriftAddress);
        boolean isReturnToPool = false;
        try {
            TLoadTxnBeginResult result = client.loadTxnBegin(request);
            isReturnToPool = true;
            if (result.getStatus().getStatusCode() != TStatusCode.OK) {
                throw new TException("begin txn failed.");
            }
            TLoadTxnBeginResult tLoadTxnBeginResult = result;
            return tLoadTxnBeginResult;
        }
        catch (TTransportException e) {
            boolean ok = ClientPool.frontendPool.reopen(client, this.thriftTimeoutMs);
            if (!ok) {
                throw e;
            }
            if (e.getType() == 3) {
                throw e;
            }
            TLoadTxnBeginResult result = client.loadTxnBegin(request);
            isReturnToPool = true;
            TLoadTxnBeginResult tLoadTxnBeginResult = result;
            return tLoadTxnBeginResult;
        }
        finally {
            if (isReturnToPool) {
                ClientPool.frontendPool.returnObject(thriftAddress, client);
            } else {
                ClientPool.frontendPool.invalidateObject(thriftAddress, client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TWaitingTxnStatusResult getWaitingTxnStatus(TWaitingTxnStatusRequest request) throws TException {
        TNetworkAddress thriftAddress = this.getMasterAddress();
        FrontendService.Client client = this.getClient(thriftAddress);
        LOG.info("Send waiting transaction status {} to Master {}", (Object)this.ctx.getStmtId(), (Object)thriftAddress);
        boolean isReturnToPool = false;
        try {
            TWaitingTxnStatusResult result = client.waitingTxnStatus(request);
            isReturnToPool = true;
            if (result.getStatus().getStatusCode() != TStatusCode.OK) {
                throw new TException("get txn status failed.");
            }
            TWaitingTxnStatusResult tWaitingTxnStatusResult = result;
            return tWaitingTxnStatusResult;
        }
        catch (TTransportException e) {
            boolean ok = ClientPool.frontendPool.reopen(client, this.thriftTimeoutMs);
            if (!ok) {
                throw e;
            }
            if (e.getType() == 3) {
                throw e;
            }
            TWaitingTxnStatusResult result = client.waitingTxnStatus(request);
            if (result.getStatus().getStatusCode() != TStatusCode.OK) {
                throw new TException("commit failed.");
            }
            isReturnToPool = true;
            TWaitingTxnStatusResult tWaitingTxnStatusResult = result;
            return tWaitingTxnStatusResult;
        }
        finally {
            if (isReturnToPool) {
                ClientPool.frontendPool.returnObject(thriftAddress, client);
            } else {
                ClientPool.frontendPool.invalidateObject(thriftAddress, client);
            }
        }
    }
}

