/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import java.nio.ByteBuffer;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.common.ClientPool;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.qe.ShowResultSet;
import org.apache.doris.thrift.FrontendService;
import org.apache.doris.thrift.TMasterOpRequest;
import org.apache.doris.thrift.TMasterOpResult;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.transport.TTransportException;

public class MasterOpExecutor {
    private static final Logger LOG = LogManager.getLogger(MasterOpExecutor.class);
    private final OriginStatement originStmt;
    private final ConnectContext ctx;
    private TMasterOpResult result;
    private int waitTimeoutMs;
    private int thriftTimeoutMs;
    private boolean shouldNotRetry;

    public MasterOpExecutor(OriginStatement originStmt, ConnectContext ctx, RedirectStatus status, boolean isQuery) {
        this.originStmt = originStmt;
        this.ctx = ctx;
        this.waitTimeoutMs = status.isNeedToWaitJournalSync() ? ctx.getSessionVariable().getQueryTimeoutS() * 1000 : 0;
        this.thriftTimeoutMs = ctx.getSessionVariable().getQueryTimeoutS() * 1000;
        this.shouldNotRetry = !isQuery;
    }

    public void execute() throws Exception {
        this.forward();
        LOG.info("forwarding to master get result max journal id: {}", (Object)this.result.maxJournalId);
        this.ctx.getCatalog().getJournalObservable().waitOn(this.result.maxJournalId, this.waitTimeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forward() throws Exception {
        if (!this.ctx.getCatalog().isReady()) {
            throw new Exception("Node catalog is not ready, please wait for a while.");
        }
        String masterHost = this.ctx.getCatalog().getMasterIp();
        int masterRpcPort = this.ctx.getCatalog().getMasterRpcPort();
        TNetworkAddress thriftAddress = new TNetworkAddress(masterHost, masterRpcPort);
        FrontendService.Client client = null;
        try {
            client = ClientPool.frontendPool.borrowObject(thriftAddress, this.thriftTimeoutMs);
        }
        catch (Exception e) {
            throw new Exception("Failed to get master client.", e);
        }
        TMasterOpRequest params = new TMasterOpRequest();
        params.setCluster(this.ctx.getClusterName());
        params.setSql(this.originStmt.originStmt);
        params.setStmtIdx(this.originStmt.idx);
        params.setUser(this.ctx.getQualifiedUser());
        params.setDb(this.ctx.getDatabase());
        params.setResourceInfo(this.ctx.toResourceCtx());
        params.setUserIp(this.ctx.getRemoteIP());
        params.setStmtId(this.ctx.getStmtId());
        params.setCurrentUserIdent(this.ctx.getCurrentUserIdentity().toThrift());
        params.setQueryOptions(this.ctx.getSessionVariable().getQueryOptionVariables());
        params.setSessionVariables(this.ctx.getSessionVariable().getForwardVariables());
        if (null != this.ctx.queryId()) {
            params.setQueryId(this.ctx.queryId());
        }
        LOG.info("Forward statement {} to Master {}", (Object)this.ctx.getStmtId(), (Object)thriftAddress);
        boolean isReturnToPool = false;
        try {
            this.result = client.forward(params);
            isReturnToPool = true;
        }
        catch (TTransportException e) {
            boolean ok = ClientPool.frontendPool.reopen(client, this.thriftTimeoutMs);
            if (!ok) {
                throw e;
            }
            if (this.shouldNotRetry || e.getType() == 3) {
                throw e;
            }
            LOG.warn("Forward statement " + this.ctx.getStmtId() + " to Master " + thriftAddress + " twice", (Throwable)e);
            this.result = client.forward(params);
            isReturnToPool = true;
        }
        finally {
            if (isReturnToPool) {
                ClientPool.frontendPool.returnObject(thriftAddress, client);
            } else {
                ClientPool.frontendPool.invalidateObject(thriftAddress, client);
            }
        }
    }

    public ByteBuffer getOutputPacket() {
        if (this.result == null) {
            return null;
        }
        return this.result.packet;
    }

    public TUniqueId getQueryId() {
        if (this.result != null && this.result.isSetQueryId()) {
            return this.result.getQueryId();
        }
        return null;
    }

    public ShowResultSet getProxyResultSet() {
        if (this.result == null) {
            return null;
        }
        if (this.result.isSetResultSet()) {
            return new ShowResultSet(this.result.resultSet);
        }
        return null;
    }

    public void setResult(TMasterOpResult result) {
        this.result = result;
    }
}

