/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.DdlException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JournalObserver
implements Comparable<JournalObserver> {
    private static final Logger LOG = LogManager.getLogger(JournalObserver.class);
    private static AtomicLong idGen = new AtomicLong(0L);
    private Long id = idGen.getAndIncrement();
    private Long targetJournalVersion;
    private CountDownLatch latch;

    public JournalObserver(Long targetJournalVersion) {
        this.targetJournalVersion = targetJournalVersion;
        this.latch = new CountDownLatch(1);
    }

    public void update() {
        this.latch.countDown();
    }

    public Long getTargetJournalVersion() {
        return this.targetJournalVersion;
    }

    public void waitForReplay(int timeoutMs) throws DdlException {
        long leftTimeoutMs = timeoutMs;
        long minIntervalMs = 1000L;
        try {
            boolean ok = false;
            do {
                long replayedJournalId;
                if ((replayedJournalId = Catalog.getCurrentCatalog().getReplayedJournalId()) < this.targetJournalVersion && timeoutMs > 0) continue;
                LOG.debug("the replayed journal version {} already large than expected version: {}", (Object)replayedJournalId, (Object)this.targetJournalVersion);
                return;
            } while (!(ok = this.latch.await(1000L, TimeUnit.MILLISECONDS)) && (leftTimeoutMs -= 1000L) > 0L);
            if (!ok) {
                LOG.warn("timeout waiting result from master. timeout ms: {}", (Object)timeoutMs);
                throw new DdlException("Execute timeout, the command may be succeed, you'd better retry");
            }
        }
        catch (InterruptedException e) {
            throw new DdlException("Interrupted exception happens, the command may be succeed, you'd better retry");
        }
    }

    @Override
    public int compareTo(JournalObserver jo) {
        if (this.targetJournalVersion < jo.targetJournalVersion) {
            return -1;
        }
        if (this.targetJournalVersion > jo.targetJournalVersion) {
            return 1;
        }
        if (this.id < jo.id) {
            return -1;
        }
        if (this.id > jo.id) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (!(obj instanceof JournalObserver)) {
            return false;
        }
        JournalObserver obs = (JournalObserver)obj;
        return this.targetJournalVersion == obs.targetJournalVersion && this.id == obs.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "target: " + this.targetJournalVersion;
    }
}

