/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import org.apache.doris.common.DdlException;
import org.apache.doris.qe.JournalObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JournalObservable {
    private static final Logger LOG = LogManager.getLogger(JournalObservable.class);
    private Multiset<JournalObserver> obs = TreeMultiset.create();

    private synchronized void addObserver(JournalObserver o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.obs.add((Object)o);
        LOG.debug("JournalObservable addObserver=[{}], the size is {}", (Object)o, (Object)this.obs.size());
    }

    private synchronized void deleteObserver(JournalObserver o) {
        this.obs.remove((Object)o);
        LOG.debug("JournalObservable deleteObserver=[{}], the size is {}", (Object)o, (Object)this.obs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOn(Long expectedJournalVersion, int timeoutMs) throws DdlException {
        LOG.info("waiting for the observer to replay journal to {} with timeout: {} ms", (Object)expectedJournalVersion, (Object)timeoutMs);
        JournalObserver observer = new JournalObserver(expectedJournalVersion);
        this.addObserver(observer);
        try {
            observer.waitForReplay(timeoutMs);
        }
        finally {
            this.deleteObserver(observer);
        }
    }

    public static int upperBound(Object[] array, int size, Long value) {
        int left = 0;
        int right = size - 1;
        while (left < right) {
            int middle = left + (right - left >> 1);
            if (value >= ((JournalObserver)array[middle]).getTargetJournalVersion()) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        if (right == -1) {
            return 0;
        }
        Long rightValue = ((JournalObserver)array[right]).getTargetJournalVersion();
        return value >= rightValue ? right + 1 : right;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Long journalId) {
        Object[] arrLocal;
        int size;
        JournalObservable journalObservable = this;
        synchronized (journalObservable) {
            size = this.obs.size();
            arrLocal = this.obs.toArray();
        }
        int pos = JournalObservable.upperBound(arrLocal, size, journalId);
        LOG.debug("notify observers: journal: {}, pos: {}, size: {}, obs: {}", (Object)journalId, (Object)pos, (Object)size, this.obs);
        for (int i = 0; i < pos; ++i) {
            JournalObserver observer = (JournalObserver)arrLocal[i];
            observer.update();
        }
    }
}

