/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.doris.qe.HelpObjectIface;

public class HelpTopic
implements HelpObjectIface {
    private static final String DESCRIPTION = "description";
    private static final String EXAMPLE = "example";
    private static final String URL = "url";
    private static final String KEYWORD = "keyword";
    private static final String CATEGORY = "category";
    private String name = "";
    private String description = "";
    private String example = "";
    private String url = "";
    private List<String> keywords = Lists.newArrayList();
    private String category = "";

    public String getCategory() {
        return this.category;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public String getUrl() {
        return this.url;
    }

    public String getExample() {
        return this.example;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void loadFrom(Map.Entry<String, Map<String, String>> doc) {
        String category;
        String keyword;
        String url;
        String example;
        if (Strings.isNullOrEmpty((String)doc.getKey())) {
            return;
        }
        this.name = doc.getKey().toUpperCase();
        String desc = doc.getValue().get(DESCRIPTION);
        if (!Strings.isNullOrEmpty((String)desc)) {
            this.description = desc;
        }
        if (!Strings.isNullOrEmpty((String)(example = doc.getValue().get(EXAMPLE)))) {
            this.example = example;
        }
        if (!Strings.isNullOrEmpty((String)(url = doc.getValue().get(URL)))) {
            this.url = url;
        }
        if (!Strings.isNullOrEmpty((String)(keyword = doc.getValue().get(KEYWORD)))) {
            this.keywords = Lists.newArrayList((Iterable)Splitter.onPattern((String)",").trimResults().omitEmptyStrings().split((CharSequence)keyword));
        }
        if (!Strings.isNullOrEmpty((String)(category = doc.getValue().get(CATEGORY)))) {
            this.category = category;
        }
    }

    public String toString() {
        return "name: " + this.name + ", desc: " + this.description;
    }
}

