/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.MarkDownParser;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.HelpCategory;
import org.apache.doris.qe.HelpObjectIface;
import org.apache.doris.qe.HelpTopic;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HelpObjectLoader<HelpTypeT extends HelpObjectIface> {
    private static final Logger LOG = LogManager.getLogger(HelpObjectLoader.class);

    public List<HelpTypeT> loadAll(List<String> lines) throws UserException {
        if (lines == null) {
            LOG.error("Help object loader input lines is empty.");
            return null;
        }
        ArrayList topics = Lists.newArrayList();
        MarkDownParser parser = new MarkDownParser(lines);
        Map<String, Map<String, String>> docs = parser.parse();
        for (Map.Entry<String, Map<String, String>> doc : docs.entrySet()) {
            HelpTypeT topic = this.newInstance();
            topic.loadFrom(doc);
            if (Strings.isNullOrEmpty((String)topic.getName())) continue;
            topics.add(topic);
        }
        return topics;
    }

    public List<HelpTypeT> loadAll(String path) throws IOException, UserException {
        if (Strings.isNullOrEmpty((String)path)) {
            LOG.error("Help object loader input file is empty.");
            return null;
        }
        List<String> lines = Files.readAllLines(Paths.get(path, new String[0]), Charset.forName("UTF-8"));
        return this.loadAll(lines);
    }

    public abstract HelpTypeT newInstance();

    public static HelpObjectLoader<HelpTopic> createTopicLoader() {
        return new HelpObjectLoader<HelpTopic>(){

            @Override
            public HelpTopic newInstance() {
                return new HelpTopic();
            }
        };
    }

    public static HelpObjectLoader<HelpCategory> createCategoryLoader() {
        return new HelpObjectLoader<HelpCategory>(){

            @Override
            public HelpCategory newInstance() {
                return new HelpCategory();
            }
        };
    }
}

