/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.doris.common.UserException;
import org.apache.doris.qe.HelpObjectLoader;
import org.apache.doris.qe.HelpTopic;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelpModule {
    private static final Logger LOG = LogManager.getLogger(HelpModule.class);
    private static volatile HelpModule instance = null;
    private static final ImmutableList<String> EMPTY_LIST = ImmutableList.of();
    private ImmutableMap<String, HelpTopic> topicByName = ImmutableMap.of();
    private ImmutableListMultimap<String, String> topicByKeyword = ImmutableListMultimap.of();
    private ImmutableListMultimap<String, String> topicByCategory = ImmutableListMultimap.of();
    private ImmutableListMultimap<String, String> categoryByParent = ImmutableListMultimap.of();
    private ImmutableMap<String, String> categoryByName = ImmutableMap.of();
    private ImmutableSortedMap.Builder<String, String> categoryByNameBuilder;
    private ImmutableListMultimap.Builder<String, String> categoryByParentBuilder;
    private ImmutableListMultimap.Builder<String, String> topicByCatBuilder;
    private ImmutableListMultimap.Builder<String, String> topicByKeyBuilder;
    private ImmutableMap.Builder<String, HelpTopic> topicBuilder;
    private static final String HELP_ZIP_FILE_NAME = "help-resource.zip";
    private static final long HELP_ZIP_CHECK_INTERVAL_MS = 600000L;
    private static Charset CHARSET_UTF_8;
    private static long lastModifyTime;
    private static long lastCheckTime;
    private boolean isloaded = false;
    private static String zipFilePath;
    private static ReentrantLock lock;

    public void setUpByZip(String path) throws IOException, UserException {
        this.initBuild();
        ZipFile zf = new ZipFile(path);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            String line;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                this.setUpDirInZip(entry.getName());
                continue;
            }
            long size = entry.getSize();
            ArrayList lines = Lists.newArrayList();
            if (size <= 0L) continue;
            BufferedReader reader = new BufferedReader(new InputStreamReader(zf.getInputStream(entry), CHARSET_UTF_8));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            reader.close();
            String parentPathStr = null;
            Path pathObj = Paths.get(entry.getName(), new String[0]);
            if (pathObj.getParent() != null) {
                parentPathStr = pathObj.getParent().getFileName().toString();
            }
            HelpObjectLoader<HelpTopic> topicLoader = HelpObjectLoader.createTopicLoader();
            List<HelpTopic> topics = topicLoader.loadAll(lines);
            this.updateTopic(parentPathStr, topics);
        }
        zf.close();
        this.build();
        this.isloaded = true;
    }

    private void setUpDirInZip(String pathInZip) {
        Path pathObj = Paths.get(pathInZip, new String[0]);
        String pathStr = pathObj.getFileName().toString();
        String parentPathStr = null;
        if (pathObj.getParent() != null) {
            parentPathStr = pathObj.getParent().getFileName().toString();
        }
        this.updateCategory(parentPathStr, pathStr);
    }

    public void setUp(String path) throws UserException, IOException {
        File root = new File(path);
        if (!root.isDirectory()) {
            throw new UserException("Need help directory.");
        }
        this.initBuild();
        for (File file : root.listFiles()) {
            if (file.getName().startsWith(".")) continue;
            this.setUpDir("", file);
        }
        this.build();
    }

    private void setUpDir(String parent, File dir) throws IOException, UserException {
        this.updateCategory(parent, dir.getName());
        for (File file : dir.listFiles()) {
            if (file.getName().startsWith(".")) continue;
            if (file.isDirectory()) {
                this.setUpDir(dir.getName(), file);
                continue;
            }
            HelpObjectLoader<HelpTopic> topicLoader = HelpObjectLoader.createTopicLoader();
            List<HelpTopic> topics = topicLoader.loadAll(file.getPath());
            this.updateTopic(dir.getName(), topics);
        }
    }

    private void initBuild() {
        this.categoryByNameBuilder = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        this.categoryByParentBuilder = ImmutableListMultimap.builder();
        this.categoryByParentBuilder.orderKeysBy(String.CASE_INSENSITIVE_ORDER).orderValuesBy(String.CASE_INSENSITIVE_ORDER);
        this.topicByCatBuilder = ImmutableListMultimap.builder();
        this.topicByCatBuilder.orderKeysBy(String.CASE_INSENSITIVE_ORDER).orderValuesBy(String.CASE_INSENSITIVE_ORDER);
        this.topicByKeyBuilder = ImmutableListMultimap.builder();
        this.topicByKeyBuilder.orderKeysBy(String.CASE_INSENSITIVE_ORDER).orderValuesBy(String.CASE_INSENSITIVE_ORDER);
        this.topicBuilder = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
    }

    private void updateCategory(String parent, String category) {
        if (!Strings.isNullOrEmpty((String)parent)) {
            this.categoryByParentBuilder.put((Object)parent.toLowerCase(), (Object)category);
        }
        this.categoryByNameBuilder.put((Object)category, (Object)category);
    }

    private void updateTopic(String category, List<HelpTopic> topics) {
        for (HelpTopic topic : topics) {
            if (Strings.isNullOrEmpty((String)topic.getName())) continue;
            this.topicBuilder.put((Object)topic.getName(), (Object)topic);
            if (!Strings.isNullOrEmpty((String)category)) {
                this.topicByCatBuilder.put((Object)category.toLowerCase(), (Object)topic.getName());
            }
            for (String keyword : topic.getKeywords()) {
                if (Strings.isNullOrEmpty((String)keyword)) continue;
                this.topicByKeyBuilder.put((Object)keyword.toLowerCase(), (Object)topic.getName());
            }
        }
    }

    private void build() {
        this.categoryByName = this.categoryByNameBuilder.build();
        this.categoryByParent = this.categoryByParentBuilder.build();
        this.topicByName = this.topicBuilder.build();
        this.topicByCategory = this.topicByCatBuilder.build();
        this.topicByKeyword = this.topicByKeyBuilder.build();
        this.categoryByNameBuilder = null;
        this.categoryByParentBuilder = null;
        this.topicBuilder = null;
        this.topicByCatBuilder = null;
        this.topicByKeyBuilder = null;
    }

    public HelpTopic getTopic(String name) {
        return (HelpTopic)this.topicByName.get((Object)name);
    }

    public List<String> listTopicByKeyword(String keyword) {
        if (Strings.isNullOrEmpty((String)keyword)) {
            return EMPTY_LIST;
        }
        return this.topicByKeyword.get((Object)keyword.toLowerCase());
    }

    public List<String> listTopicByCategory(String category) {
        if (Strings.isNullOrEmpty((String)category)) {
            return EMPTY_LIST;
        }
        return this.topicByCategory.get((Object)category.toLowerCase());
    }

    public List<String> listCategoryByCategory(String category) {
        if (Strings.isNullOrEmpty((String)category)) {
            return EMPTY_LIST;
        }
        return this.categoryByParent.get((Object)category.toLowerCase());
    }

    public List<String> listCategoryByName(String name) {
        if (this.categoryByName.get((Object)name) != null) {
            return Lists.newArrayList((Object[])new String[]{(String)this.categoryByName.get((Object)name)});
        }
        return EMPTY_LIST;
    }

    public void setUpModule() throws IOException, UserException {
        long now;
        URL helpResource = instance.getClass().getClassLoader().getResource(HELP_ZIP_FILE_NAME);
        if (helpResource == null) {
            throw new IOException("Can not find help zip file: help-resource.zip");
        }
        zipFilePath = helpResource.getPath();
        this.setUpByZip(zipFilePath);
        lastCheckTime = now = System.currentTimeMillis();
        lastModifyTime = now;
    }

    public boolean needReloadZipFile(String zipPath) throws UserException {
        if (!this.isloaded) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - lastCheckTime < 600000L) {
            return false;
        }
        lastCheckTime = now;
        File file = new File(zipPath);
        if (!file.exists()) {
            throw new UserException("zipfile of help module is not exist" + zipPath);
        }
        long lastModify = file.lastModified();
        if (lastModifyTime >= lastModify) {
            return false;
        }
        lastModifyTime = lastModify;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static HelpModule getInstance() {
        if (instance == null) {
            Class<HelpModule> clazz = HelpModule.class;
            // MONITORENTER : org.apache.doris.qe.HelpModule.class
            if (instance == null) {
                instance = new HelpModule();
            }
            // MONITOREXIT : clazz
        }
        try {
            if (!instance.needReloadZipFile(zipFilePath)) return instance;
            if (!lock.tryLock()) return instance;
            LOG.info("reload help zip file: " + zipFilePath);
            try {
                HelpModule newInstance = new HelpModule();
                newInstance.setUpByZip(zipFilePath);
                instance = newInstance;
                return instance;
            }
            catch (IOException | UserException e) {
                LOG.warn("Failed to reload help zip file: " + zipFilePath, (Throwable)e);
                return instance;
            }
            finally {
                lock.unlock();
            }
        }
        catch (UserException e) {
            LOG.warn("Failed to reload help zip file: " + zipFilePath, (Throwable)e);
        }
        return instance;
    }

    static {
        try {
            CHARSET_UTF_8 = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            CHARSET_UTF_8 = Charset.defaultCharset();
            LOG.error("charset named UTF-8 in not found. use: {}", (Object)CHARSET_UTF_8.displayName());
        }
        lastModifyTime = 0L;
        lastCheckTime = 0L;
        lock = new ReentrantLock();
    }
}

