/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.qe.VariableMgr;

public final class GlobalVariable {
    public static final String VERSION_COMMENT = "version_comment";
    public static final String VERSION = "version";
    public static final String LOWER_CASE_TABLE_NAMES = "lower_case_table_names";
    public static final String LICENSE = "license";
    public static final String LANGUAGE = "language";
    public static final String INIT_CONNECT = "init_connect";
    public static final String SYSTEM_TIME_ZONE = "system_time_zone";
    public static final String QUERY_CACHE_SIZE = "query_cache_size";
    public static final String DEFAULT_ROWSET_TYPE = "default_rowset_type";
    public static final String PERFORMANCE_SCHEMA = "performance_schema";
    @VariableMgr.VarAttr(name="version_comment", flag=8)
    public static String versionComment = "Doris version 1.1.0-rc05-Unknown";
    @VariableMgr.VarAttr(name="version", flag=8)
    public static String version = "5.7.37";
    @VariableMgr.VarAttr(name="lower_case_table_names", flag=8)
    public static int lowerCaseTableNames = 0;
    @VariableMgr.VarAttr(name="license", flag=8)
    public static String license = "Apache License, Version 2.0";
    @VariableMgr.VarAttr(name="language", flag=8)
    public static String language = "/palo/share/english/";
    @VariableMgr.VarAttr(name="init_connect", flag=2)
    public static volatile String initConnect = "";
    @VariableMgr.VarAttr(name="system_time_zone", flag=8)
    public static String systemTimeZone = TimeUtils.getSystemTimeZone().getID();
    @VariableMgr.VarAttr(name="query_cache_size", flag=2)
    public static volatile long queryCacheSize = 0x100000L;
    @VariableMgr.VarAttr(name="default_rowset_type", flag=2)
    public static volatile String defaultRowsetType = "beta";
    @VariableMgr.VarAttr(name="performance_schema", flag=8)
    public static String performanceSchema = "OFF";

    private GlobalVariable() {
    }

    public static List<String> getPersistentGlobalVarNames() {
        ArrayList varNames = Lists.newArrayList();
        for (Field field : GlobalVariable.class.getDeclaredFields()) {
            VariableMgr.VarAttr attr = field.getAnnotation(VariableMgr.VarAttr.class);
            if (attr == null || attr.flag() != 2 && !attr.name().equals(LOWER_CASE_TABLE_NAMES)) continue;
            varNames.add(attr.name());
        }
        return varNames;
    }
}

