/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.map.HashedMap;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DescriptorTable;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.common.Config;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Reference;
import org.apache.doris.common.Status;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.ListUtil;
import org.apache.doris.common.util.ProfileWriter;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.DataStreamSink;
import org.apache.doris.planner.ExceptNode;
import org.apache.doris.planner.ExchangeNode;
import org.apache.doris.planner.HashJoinNode;
import org.apache.doris.planner.IntersectNode;
import org.apache.doris.planner.OlapScanNode;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanFragmentId;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.Planner;
import org.apache.doris.planner.ResultFileSink;
import org.apache.doris.planner.ResultSink;
import org.apache.doris.planner.RuntimeFilter;
import org.apache.doris.planner.RuntimeFilterId;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.planner.SetOperationNode;
import org.apache.doris.planner.UnionNode;
import org.apache.doris.proto.InternalService;
import org.apache.doris.proto.Types;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.qe.QueryStatisticsItem;
import org.apache.doris.qe.ResultReceiver;
import org.apache.doris.qe.RowBatch;
import org.apache.doris.qe.SimpleScheduler;
import org.apache.doris.rpc.BackendServiceProxy;
import org.apache.doris.rpc.RpcException;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.PaloInternalServiceVersion;
import org.apache.doris.thrift.TDescriptorTable;
import org.apache.doris.thrift.TErrorTabletInfo;
import org.apache.doris.thrift.TEsScanRange;
import org.apache.doris.thrift.TExecPlanFragmentParams;
import org.apache.doris.thrift.TExecPlanFragmentParamsList;
import org.apache.doris.thrift.TLoadErrorHubInfo;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPaloScanRange;
import org.apache.doris.thrift.TPlanFragmentDestination;
import org.apache.doris.thrift.TPlanFragmentExecParams;
import org.apache.doris.thrift.TQueryGlobals;
import org.apache.doris.thrift.TQueryOptions;
import org.apache.doris.thrift.TQueryType;
import org.apache.doris.thrift.TReportExecStatusParams;
import org.apache.doris.thrift.TResourceInfo;
import org.apache.doris.thrift.TResourceLimit;
import org.apache.doris.thrift.TRuntimeFilterParams;
import org.apache.doris.thrift.TRuntimeFilterTargetParams;
import org.apache.doris.thrift.TScanRangeLocation;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.doris.thrift.TScanRangeParams;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TTabletCommitInfo;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.jetbrains.annotations.NotNull;

public class Coordinator {
    private static final Logger LOG = LogManager.getLogger(Coordinator.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String localIP = FrontendOptions.getLocalHostAddress();
    private static Random instanceRandom = new Random();
    Status queryStatus = new Status();
    Map<TNetworkAddress, Long> addressToBackendID = Maps.newHashMap();
    private ImmutableMap<Long, Backend> idToBackend = ImmutableMap.of();
    private TDescriptorTable descTable;
    private Set<Long> alreadySentBackendIds = Sets.newHashSet();
    private TQueryGlobals queryGlobals = new TQueryGlobals();
    private TQueryOptions queryOptions;
    private TNetworkAddress coordAddress;
    private Lock lock = new ReentrantLock();
    private boolean returnedAllResults;
    private RuntimeProfile queryProfile;
    private List<RuntimeProfile> fragmentProfile;
    private ProfileWriter profileWriter;
    private Map<PlanFragmentId, FragmentExecParams> fragmentExecParamsMap = Maps.newHashMap();
    private List<PlanFragment> fragments;
    private List<BackendExecState> backendExecStates = Lists.newArrayList();
    private List<BackendExecState> needCheckBackendExecStates = Lists.newArrayList();
    private ResultReceiver receiver;
    private List<ScanNode> scanNodes;
    private Set<TUniqueId> instanceIds = Sets.newHashSet();
    private MarkedCountDownLatch<TUniqueId, Long> profileDoneSignal;
    private boolean isBlockQuery;
    private int numReceivedRows = 0;
    private List<String> deltaUrls;
    private Map<String, String> loadCounters;
    private String trackingUrl;
    private List<String> exportFiles;
    private List<TTabletCommitInfo> commitInfos = Lists.newArrayList();
    private List<TErrorTabletInfo> errorTabletInfos = Lists.newArrayList();
    private long jobId = -1L;
    private TUniqueId queryId;
    private TResourceInfo tResourceInfo;
    private boolean needReport;
    private final TUniqueId nextInstanceId;
    private long timeoutDeadline;
    public TNetworkAddress runtimeFilterMergeAddr;
    public TUniqueId runtimeFilterMergeInstanceId;
    public Map<RuntimeFilterId, List<FRuntimeFilterTargetParam>> ridToTargetParam = Maps.newHashMap();
    public List<RuntimeFilter> assignedRuntimeFilters = new ArrayList<RuntimeFilter>();
    public Map<RuntimeFilterId, Integer> ridToBuilderNum = Maps.newHashMap();
    private Map<PlanFragmentId, BucketSeqToScanRange> fragmentIdTobucketSeqToScanRangeMap = Maps.newHashMap();
    private Map<PlanFragmentId, Map<Integer, TNetworkAddress>> fragmentIdToSeqToAddressMap = Maps.newHashMap();
    private Map<PlanFragmentId, Set<Integer>> fragmentIdToScanNodeIds = Maps.newHashMap();
    private Set<Integer> colocateFragmentIds = new HashSet<Integer>();
    private BucketShuffleJoinController bucketShuffleJoinController = new BucketShuffleJoinController(this.fragmentIdToScanNodeIds);

    public Coordinator(ConnectContext context, Analyzer analyzer, Planner planner) {
        this.isBlockQuery = planner.isBlockQuery();
        this.queryId = context.queryId();
        this.fragments = planner.getFragments();
        this.scanNodes = planner.getScanNodes();
        this.descTable = analyzer.getDescTbl().toThrift();
        this.returnedAllResults = false;
        this.initQueryOptions(context);
        this.setFromUserProperty(analyzer);
        this.queryGlobals.setNowString(DATE_FORMAT.format(new Date()));
        this.queryGlobals.setTimestampMs(System.currentTimeMillis());
        this.queryGlobals.setLoadZeroTolerance(false);
        if (context.getSessionVariable().getTimeZone().equals("CST")) {
            this.queryGlobals.setTimeZone("Asia/Shanghai");
        } else {
            this.queryGlobals.setTimeZone(context.getSessionVariable().getTimeZone());
        }
        this.tResourceInfo = new TResourceInfo(context.getQualifiedUser(), context.getSessionVariable().getResourceGroup());
        this.needReport = context.getSessionVariable().enableProfile();
        this.nextInstanceId = new TUniqueId();
        this.nextInstanceId.setHi(this.queryId.hi);
        this.nextInstanceId.setLo(this.queryId.lo + 1L);
        this.assignedRuntimeFilters = analyzer.getAssignedRuntimeFilter();
    }

    public Coordinator(Long jobId, TUniqueId queryId, DescriptorTable descTable, List<PlanFragment> fragments, List<ScanNode> scanNodes, String timezone, boolean loadZeroTolerance) {
        this.isBlockQuery = true;
        this.jobId = jobId;
        this.queryId = queryId;
        this.descTable = descTable.toThrift();
        this.fragments = fragments;
        this.scanNodes = scanNodes;
        this.queryOptions = new TQueryOptions();
        this.queryGlobals.setNowString(DATE_FORMAT.format(new Date()));
        this.queryGlobals.setTimestampMs(System.currentTimeMillis());
        this.queryGlobals.setTimeZone(timezone);
        this.queryGlobals.setLoadZeroTolerance(loadZeroTolerance);
        this.tResourceInfo = new TResourceInfo("", "");
        this.needReport = true;
        this.nextInstanceId = new TUniqueId();
        this.nextInstanceId.setHi(queryId.hi);
        this.nextInstanceId.setLo(queryId.lo + 1L);
    }

    private void setFromUserProperty(Analyzer analyzer) {
        long memLimit;
        String qualifiedUser = analyzer.getQualifiedUser();
        int cpuLimit = Catalog.getCurrentCatalog().getAuth().getCpuResourceLimit(qualifiedUser);
        if (cpuLimit > 0) {
            TResourceLimit resourceLimit = new TResourceLimit();
            resourceLimit.setCpuLimit(cpuLimit);
            this.queryOptions.setResourceLimit(resourceLimit);
        }
        if ((memLimit = Catalog.getCurrentCatalog().getAuth().getExecMemLimit(qualifiedUser)) > 0L) {
            this.queryOptions.setMemLimit(memLimit);
            this.queryOptions.setMaxReservation(memLimit);
            this.queryOptions.setInitialReservationTotalClaims(memLimit);
            this.queryOptions.setBufferPoolLimit(memLimit);
        }
        if ((memLimit = Catalog.getCurrentCatalog().getAuth().getLoadMemLimit(qualifiedUser)) > 0L) {
            this.queryOptions.setLoadMemLimit(memLimit);
        }
    }

    private void initQueryOptions(ConnectContext context) {
        this.queryOptions = context.getSessionVariable().toThrift();
        this.queryOptions.setEnableVectorizedEngine(VectorizedUtil.isVectorized());
    }

    public long getJobId() {
        return this.jobId;
    }

    public TUniqueId getQueryId() {
        return this.queryId;
    }

    public void setQueryId(TUniqueId queryId) {
        this.queryId = queryId;
    }

    public void setQueryType(TQueryType type) {
        this.queryOptions.setQueryType(type);
    }

    public void setExecVecEngine(boolean vec) {
        this.queryOptions.setEnableVectorizedEngine(vec);
    }

    public Status getExecStatus() {
        return this.queryStatus;
    }

    public RuntimeProfile getQueryProfile() {
        return this.queryProfile;
    }

    public ProfileWriter getProfileWriter() {
        return this.profileWriter;
    }

    public void setProfileWriter(ProfileWriter profileWriter) {
        this.profileWriter = profileWriter;
    }

    public List<String> getDeltaUrls() {
        return this.deltaUrls;
    }

    public Map<String, String> getLoadCounters() {
        return this.loadCounters;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public void setExecMemoryLimit(long execMemoryLimit) {
        this.queryOptions.setMemLimit(execMemoryLimit);
    }

    public void setLoadMemLimit(long loadMemLimit) {
        this.queryOptions.setLoadMemLimit(loadMemLimit);
    }

    public void setTimeout(int timeout) {
        this.queryOptions.setQueryTimeout(timeout);
    }

    public void setLoadZeroTolerance(boolean loadZeroTolerance) {
        this.queryGlobals.setLoadZeroTolerance(loadZeroTolerance);
    }

    public void clearExportStatus() {
        this.lock.lock();
        try {
            this.backendExecStates.clear();
            this.queryStatus.setStatus(new Status());
            if (this.exportFiles == null) {
                this.exportFiles = Lists.newArrayList();
            }
            this.exportFiles.clear();
            this.needCheckBackendExecStates.clear();
            this.alreadySentBackendIds.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<TTabletCommitInfo> getCommitInfos() {
        return this.commitInfos;
    }

    public List<TErrorTabletInfo> getErrorTabletInfos() {
        return this.errorTabletInfos;
    }

    private void prepare() {
        for (PlanFragment fragment : this.fragments) {
            this.fragmentExecParamsMap.put(fragment.getFragmentId(), new FragmentExecParams(fragment));
        }
        for (PlanFragment fragment : this.fragments) {
            if (!(fragment.getSink() instanceof DataStreamSink)) continue;
            FragmentExecParams params = this.fragmentExecParamsMap.get(fragment.getDestFragment().getFragmentId());
            params.inputFragments.add(fragment.getFragmentId());
        }
        this.coordAddress = new TNetworkAddress(localIP, Config.rpc_port);
        int fragmentSize = this.fragments.size();
        this.queryProfile = new RuntimeProfile("Execution Profile " + DebugUtil.printId(this.queryId));
        this.fragmentProfile = new ArrayList<RuntimeProfile>();
        for (int i = 0; i < fragmentSize; ++i) {
            this.fragmentProfile.add(new RuntimeProfile("Fragment " + i));
            this.queryProfile.addChild(this.fragmentProfile.get(i));
        }
        this.idToBackend = Catalog.getCurrentSystemInfo().getIdToBackend();
        if (LOG.isDebugEnabled()) {
            LOG.debug("idToBackend size={}", (Object)this.idToBackend.size());
            for (Map.Entry entry : this.idToBackend.entrySet()) {
                Long backendID = (Long)entry.getKey();
                Backend backend = (Backend)entry.getValue();
                LOG.debug("backend: {}-{}-{}", (Object)backendID, (Object)backend.getHost(), (Object)backend.getBePort());
            }
        }
    }

    private void lock() {
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }

    private void traceInstance() {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            int idx = 0;
            sb.append("query id=").append(DebugUtil.printId(this.queryId)).append(",");
            sb.append("fragment=[");
            for (Map.Entry<PlanFragmentId, FragmentExecParams> entry : this.fragmentExecParamsMap.entrySet()) {
                if (idx++ != 0) {
                    sb.append(",");
                }
                sb.append(entry.getKey());
                entry.getValue().appendTo(sb);
            }
            sb.append("]");
            LOG.debug(sb.toString());
        }
    }

    public void exec() throws Exception {
        if (LOG.isDebugEnabled() && !this.scanNodes.isEmpty()) {
            LOG.debug("debug: in Coordinator::exec. query id: {}, planNode: {}", (Object)DebugUtil.printId(this.queryId), (Object)this.scanNodes.get(0).treeToThrift());
        }
        if (LOG.isDebugEnabled() && !this.fragments.isEmpty()) {
            LOG.debug("debug: in Coordinator::exec. query id: {}, fragment: {}", (Object)DebugUtil.printId(this.queryId), (Object)this.fragments.get(0).toThrift());
        }
        this.prepare();
        this.computeScanRangeAssignment();
        this.computeFragmentExecParams();
        this.traceInstance();
        QeProcessorImpl.INSTANCE.registerInstances(this.queryId, this.instanceIds.size());
        PlanFragmentId topId = this.fragments.get(0).getFragmentId();
        FragmentExecParams topParams = this.fragmentExecParamsMap.get(topId);
        DataSink topDataSink = topParams.fragment.getSink();
        this.timeoutDeadline = System.currentTimeMillis() + (long)(this.queryOptions.query_timeout * 1000);
        if (topDataSink instanceof ResultSink || topDataSink instanceof ResultFileSink) {
            TNetworkAddress execBeAddr = topParams.instanceExecParams.get((int)0).host;
            this.receiver = new ResultReceiver(topParams.instanceExecParams.get((int)0).instanceId, this.addressToBackendID.get(execBeAddr), this.toBrpcHost(execBeAddr), this.timeoutDeadline);
            if (LOG.isDebugEnabled()) {
                LOG.debug("dispatch query job: {} to {}", (Object)DebugUtil.printId(this.queryId), (Object)topParams.instanceExecParams.get((int)0).host);
            }
            if (topDataSink instanceof ResultFileSink && ((ResultFileSink)topDataSink).getStorageType() == StorageBackend.StorageType.BROKER) {
                ResultFileSink topResultFileSink = (ResultFileSink)topDataSink;
                FsBroker broker = Catalog.getCurrentCatalog().getBrokerMgr().getBroker(topResultFileSink.getBrokerName(), execBeAddr.getHostname());
                topResultFileSink.setBrokerAddr(broker.ip, broker.port);
            }
        } else {
            this.queryOptions.setIsReportSuccess(true);
            this.deltaUrls = Lists.newArrayList();
            this.loadCounters = Maps.newHashMap();
            ArrayList relatedBackendIds = Lists.newArrayList(this.addressToBackendID.values());
            Catalog.getCurrentCatalog().getLoadManager().initJobProgress(this.jobId, this.queryId, this.instanceIds, relatedBackendIds);
            LOG.info("dispatch load job: {} to {}", (Object)DebugUtil.printId(this.queryId), this.addressToBackendID.keySet());
        }
        this.profileDoneSignal = new MarkedCountDownLatch(this.instanceIds.size());
        for (TUniqueId instanceId : this.instanceIds) {
            this.profileDoneSignal.addMark(instanceId, -1L);
        }
        this.sendFragment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFragment() throws TException, RpcException, UserException {
        this.lock();
        try {
            HashMultiset hostCounter = HashMultiset.create();
            for (FragmentExecParams params : this.fragmentExecParamsMap.values()) {
                for (FInstanceExecParam fi : params.instanceExecParams) {
                    hostCounter.add((Object)fi.host);
                }
            }
            int backendIdx = 0;
            int profileFragmentId = 0;
            long memoryLimit = this.queryOptions.getMemLimit();
            HashMap beToExecStates = Maps.newHashMap();
            boolean twoPhaseExecution = this.fragments.size() >= 2;
            for (PlanFragment fragment : this.fragments) {
                FragmentExecParams params = this.fragmentExecParamsMap.get(fragment.getFragmentId());
                int instanceNum = params.instanceExecParams.size();
                Preconditions.checkState((instanceNum > 0 ? 1 : 0) != 0);
                List<TExecPlanFragmentParams> tParams = params.toThrift(backendIdx);
                if (this.colocateFragmentIds.contains(fragment.getFragmentId().asInt())) {
                    int rate = Math.min(Config.query_colocate_join_memory_limit_penalty_factor, instanceNum);
                    long newMemory = memoryLimit / (long)rate;
                    for (TExecPlanFragmentParams tParam : tParams) {
                        tParam.query_options.setMemLimit(newMemory);
                    }
                }
                boolean needCheckBackendState = false;
                if (this.queryOptions.getQueryType() == TQueryType.LOAD && profileFragmentId == 0) {
                    needCheckBackendState = true;
                }
                int instanceId = 0;
                for (TExecPlanFragmentParams tParam : tParams) {
                    BackendExecStates states;
                    BackendExecState execState = new BackendExecState(fragment.getFragmentId(), instanceId++, profileFragmentId, tParam, this.addressToBackendID);
                    tParam.setFragmentNumOnHost(hostCounter.count((Object)execState.address));
                    tParam.setBackendId(execState.backend.getId());
                    tParam.setNeedWaitExecutionTrigger(twoPhaseExecution);
                    this.backendExecStates.add(execState);
                    if (needCheckBackendState) {
                        this.needCheckBackendExecStates.add(execState);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("add need check backend {} for fragment, {} job: {}", (Object)execState.backend.getId(), (Object)fragment.getFragmentId().asInt(), (Object)this.jobId);
                        }
                    }
                    if ((states = (BackendExecStates)beToExecStates.get(execState.backend.getId())) == null) {
                        states = new BackendExecStates(execState.backend.getId(), execState.brpcAddress, twoPhaseExecution);
                        beToExecStates.putIfAbsent(execState.backend.getId(), states);
                    }
                    states.addState(execState);
                    ++backendIdx;
                }
                ++profileFragmentId;
            }
            ArrayList futures = Lists.newArrayList();
            for (BackendExecStates states : beToExecStates.values()) {
                states.unsetFields();
                futures.add(Pair.create(states, states.execRemoteFragmentsAsync()));
            }
            this.waitRpc(futures, this.timeoutDeadline - System.currentTimeMillis(), "send fragments");
            if (twoPhaseExecution) {
                futures.clear();
                for (BackendExecStates states : beToExecStates.values()) {
                    futures.add(Pair.create(states, states.execPlanFragmentStartAsync()));
                }
                this.waitRpc(futures, this.timeoutDeadline - System.currentTimeMillis(), "send execution start");
            }
            this.attachInstanceProfileToFragmentProfile();
        }
        finally {
            this.unlock();
        }
    }

    private void waitRpc(List<Pair<BackendExecStates, Future<InternalService.PExecPlanFragmentResult>>> futures, long timeoutMs, String operation) throws RpcException, UserException {
        if (timeoutMs <= 0L) {
            throw new UserException("timeout before waiting for " + operation + " RPC. Elapse(sec): " + ((System.currentTimeMillis() - this.timeoutDeadline) / 1000L + (long)this.queryOptions.query_timeout));
        }
        for (Pair<BackendExecStates, Future<InternalService.PExecPlanFragmentResult>> pair : futures) {
            TStatusCode code;
            String errMsg = null;
            Exception exception = null;
            try {
                InternalService.PExecPlanFragmentResult result = (InternalService.PExecPlanFragmentResult)((Future)pair.second).get(timeoutMs, TimeUnit.MILLISECONDS);
                code = TStatusCode.findByValue((int)result.getStatus().getStatusCode());
                if (code != TStatusCode.OK) {
                    errMsg = !result.getStatus().getErrorMsgsList().isEmpty() ? (String)result.getStatus().getErrorMsgsList().get(0) : operation + " failed. backend id: " + ((BackendExecStates)pair.first).beId;
                }
            }
            catch (ExecutionException e) {
                exception = e;
                code = TStatusCode.THRIFT_RPC_ERROR;
                BackendServiceProxy.getInstance().removeProxy(((BackendExecStates)pair.first).brpcAddr);
            }
            catch (InterruptedException e) {
                exception = e;
                code = TStatusCode.INTERNAL_ERROR;
            }
            catch (TimeoutException e) {
                exception = e;
                errMsg = "timeout when waiting for " + operation + " RPC. Elapse(sec): " + ((System.currentTimeMillis() - this.timeoutDeadline) / 1000L + (long)this.queryOptions.query_timeout);
                code = TStatusCode.TIMEOUT;
            }
            if (code != TStatusCode.OK) {
                if (exception != null && errMsg == null) {
                    errMsg = operation + " failed. " + exception.getMessage();
                }
                this.queryStatus.setStatus(errMsg);
                this.cancelInternal(Types.PPlanFragmentCancelReason.INTERNAL_ERROR);
                switch (code) {
                    case TIMEOUT: {
                        throw new RpcException(((BackendExecStates)pair.first).brpcAddr.hostname, errMsg, exception);
                    }
                    case THRIFT_RPC_ERROR: {
                        SimpleScheduler.addToBlacklist(((BackendExecStates)pair.first).beId, errMsg);
                        throw new RpcException(((BackendExecStates)pair.first).brpcAddr.hostname, errMsg, exception);
                    }
                }
                throw new UserException(errMsg, exception);
            }
            this.alreadySentBackendIds.add(((BackendExecStates)pair.first).beId);
        }
    }

    public List<String> getExportFiles() {
        return this.exportFiles;
    }

    void updateExportFiles(List<String> files) {
        this.lock.lock();
        try {
            if (this.exportFiles == null) {
                this.exportFiles = Lists.newArrayList();
            }
            this.exportFiles.addAll(files);
        }
        finally {
            this.lock.unlock();
        }
    }

    void updateDeltas(List<String> urls) {
        this.lock.lock();
        try {
            this.deltaUrls.addAll(urls);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLoadCounters(Map<String, String> newLoadCounters) {
        this.lock.lock();
        try {
            long numRowsNormal = 0L;
            String value = this.loadCounters.get("dpp.norm.ALL");
            if (value != null) {
                numRowsNormal = Long.valueOf(value);
            }
            long numRowsAbnormal = 0L;
            value = this.loadCounters.get("dpp.abnorm.ALL");
            if (value != null) {
                numRowsAbnormal = Long.valueOf(value);
            }
            long numRowsUnselected = 0L;
            value = this.loadCounters.get("unselected.rows");
            if (value != null) {
                numRowsUnselected = Long.valueOf(value);
            }
            if ((value = newLoadCounters.get("dpp.norm.ALL")) != null) {
                numRowsNormal += Long.valueOf(value).longValue();
            }
            if ((value = newLoadCounters.get("dpp.abnorm.ALL")) != null) {
                numRowsAbnormal += Long.valueOf(value).longValue();
            }
            if ((value = newLoadCounters.get("unselected.rows")) != null) {
                numRowsUnselected += Long.valueOf(value).longValue();
            }
            this.loadCounters.put("dpp.norm.ALL", "" + numRowsNormal);
            this.loadCounters.put("dpp.abnorm.ALL", "" + numRowsAbnormal);
            this.loadCounters.put("unselected.rows", "" + numRowsUnselected);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateCommitInfos(List<TTabletCommitInfo> commitInfos) {
        this.lock.lock();
        try {
            this.commitInfos.addAll(commitInfos);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateErrorTabletInfos(List<TErrorTabletInfo> errorTabletInfos) {
        this.lock.lock();
        try {
            this.errorTabletInfos.addAll(errorTabletInfos);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateStatus(Status status, TUniqueId instanceId) {
        this.lock.lock();
        try {
            if (this.returnedAllResults && status.isCancelled()) {
                return;
            }
            if (status.ok()) {
                return;
            }
            if (!this.queryStatus.ok()) {
                return;
            }
            this.queryStatus.setStatus(status);
            LOG.warn("one instance report fail throw updateStatus(), need cancel. job id: {}, query id: {}, instance id: {}", (Object)this.jobId, (Object)DebugUtil.printId(this.queryId), (Object)(instanceId != null ? DebugUtil.printId(instanceId) : "NaN"));
            this.cancelInternal(Types.PPlanFragmentCancelReason.INTERNAL_ERROR);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowBatch getNext() throws Exception {
        if (this.receiver == null) {
            throw new UserException("There is no receiver.");
        }
        Status status = new Status();
        RowBatch resultBatch = this.receiver.getNext(status);
        if (!status.ok()) {
            LOG.warn("get next fail, need cancel. query id: {}", (Object)DebugUtil.printId(this.queryId));
        }
        this.updateStatus(status, null);
        Status copyStatus = null;
        this.lock();
        try {
            copyStatus = new Status(this.queryStatus);
        }
        finally {
            this.unlock();
        }
        if (!copyStatus.ok()) {
            if (Strings.isNullOrEmpty((String)copyStatus.getErrorMsg())) {
                copyStatus.rewriteErrorMsg();
            }
            if (copyStatus.isRpcError()) {
                throw new RpcException(null, copyStatus.getErrorMsg());
            }
            String errMsg = copyStatus.getErrorMsg();
            LOG.warn("query failed: {}", (Object)errMsg);
            int hostIndex = errMsg.indexOf("host");
            if (hostIndex != -1) {
                errMsg = errMsg.substring(0, hostIndex);
            }
            throw new UserException(errMsg);
        }
        if (resultBatch.isEos()) {
            boolean hasLimit;
            this.returnedAllResults = true;
            Long numLimitRows = this.fragments.get(0).getPlanRoot().getLimit();
            boolean bl = hasLimit = numLimitRows > 0L;
            if (!this.isBlockQuery && this.instanceIds.size() > 1 && hasLimit && (long)this.numReceivedRows >= numLimitRows) {
                LOG.debug("no block query, return num >= limit rows, need cancel");
                this.cancelInternal(Types.PPlanFragmentCancelReason.LIMIT_REACH);
            }
        } else if (resultBatch.getBatch() != null) {
            this.numReceivedRows += resultBatch.getBatch().getRowsSize();
        }
        return resultBatch;
    }

    public void cancel() {
        this.lock();
        try {
            if (!this.queryStatus.ok()) {
                return;
            }
            this.queryStatus.setStatus(Status.CANCELLED);
            LOG.warn("cancel execution of query, this is outside invoke");
            this.cancelInternal(Types.PPlanFragmentCancelReason.USER_CANCEL);
        }
        finally {
            this.unlock();
        }
    }

    private void cancelInternal(Types.PPlanFragmentCancelReason cancelReason) {
        if (null != this.receiver) {
            this.receiver.cancel();
        }
        this.cancelRemoteFragmentsAsync(cancelReason);
        if (this.profileDoneSignal != null) {
            this.profileDoneSignal.countDownToZero(new Status());
            LOG.info("unfinished instance: {}", this.profileDoneSignal.getLeftMarks().stream().map(e -> DebugUtil.printId((TUniqueId)e.getKey())).toArray());
        }
    }

    private void cancelRemoteFragmentsAsync(Types.PPlanFragmentCancelReason cancelReason) {
        for (BackendExecState backendExecState : this.backendExecStates) {
            backendExecState.cancelFragmentInstance(cancelReason);
        }
    }

    private void computeFragmentExecParams() throws Exception {
        this.computeFragmentHosts();
        this.instanceIds.clear();
        for (FragmentExecParams params : this.fragmentExecParamsMap.values()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("fragment {} has instances {}", (Object)params.fragment.getFragmentId(), (Object)params.instanceExecParams.size());
            }
            for (int j = 0; j < params.instanceExecParams.size(); ++j) {
                TUniqueId instanceId = new TUniqueId();
                instanceId.setHi(this.queryId.hi);
                instanceId.setLo(this.queryId.lo + (long)this.instanceIds.size() + 1L);
                params.instanceExecParams.get((int)j).instanceId = instanceId;
                this.instanceIds.add(instanceId);
            }
        }
        this.assignRuntimeFilterAddr();
        for (FragmentExecParams params : this.fragmentExecParamsMap.values()) {
            PlanFragment destFragment = params.fragment.getDestFragment();
            if (destFragment == null) continue;
            FragmentExecParams destParams = this.fragmentExecParamsMap.get(destFragment.getFragmentId());
            DataSink sink = params.fragment.getSink();
            PlanNodeId exchId = sink.getExchNodeId();
            if (destParams.perExchNumSenders.get(exchId.asInt()) == null) {
                destParams.perExchNumSenders.put(exchId.asInt(), params.instanceExecParams.size());
            } else {
                destParams.perExchNumSenders.put(exchId.asInt(), params.instanceExecParams.size() + destParams.perExchNumSenders.get(exchId.asInt()));
            }
            if (sink.getOutputPartition() != null && sink.getOutputPartition().isBucketShuffleHashPartition()) {
                Preconditions.checkState((boolean)this.bucketShuffleJoinController.isBucketShuffleJoin(destFragment.getFragmentId().asInt()), (Object)"Sink isBucket Shuffle Partition, The destFragment must have bucket shuffle join node ");
                int bucketSeq = 0;
                int bucketNum = this.bucketShuffleJoinController.getFragmentBucketNum(destFragment.getFragmentId());
                TNetworkAddress dummyServer = new TNetworkAddress("0.0.0.0", 0);
                if (destParams.instanceExecParams.size() == 1 && destParams.instanceExecParams.get((int)0).bucketSeqSet.isEmpty()) {
                    bucketNum = 1;
                    destParams.instanceExecParams.get((int)0).bucketSeqSet.add(0);
                }
                while (bucketSeq < bucketNum) {
                    TPlanFragmentDestination dest = new TPlanFragmentDestination();
                    dest.fragment_instance_id = new TUniqueId(-1L, -1L);
                    dest.server = dummyServer;
                    dest.setBrpcServer(dummyServer);
                    for (FInstanceExecParam instanceExecParams : destParams.instanceExecParams) {
                        if (!instanceExecParams.bucketSeqSet.contains(bucketSeq)) continue;
                        dest.fragment_instance_id = instanceExecParams.instanceId;
                        dest.server = this.toRpcHost(instanceExecParams.host);
                        dest.setBrpcServer(this.toBrpcHost(instanceExecParams.host));
                        break;
                    }
                    ++bucketSeq;
                    params.destinations.add(dest);
                }
                continue;
            }
            for (int j = 0; j < destParams.instanceExecParams.size(); ++j) {
                TPlanFragmentDestination dest = new TPlanFragmentDestination();
                dest.fragment_instance_id = destParams.instanceExecParams.get((int)j).instanceId;
                dest.server = this.toRpcHost(destParams.instanceExecParams.get((int)j).host);
                dest.setBrpcServer(this.toBrpcHost(destParams.instanceExecParams.get((int)j).host));
                params.destinations.add(dest);
            }
        }
    }

    private TNetworkAddress toRpcHost(TNetworkAddress host) throws Exception {
        Backend backend = Catalog.getCurrentSystemInfo().getBackendWithBePort(host.getHostname(), host.getPort());
        if (backend == null) {
            throw new UserException("There is no scanNode Backend available.");
        }
        TNetworkAddress dest = new TNetworkAddress(backend.getHost(), backend.getBeRpcPort());
        return dest;
    }

    private TNetworkAddress toBrpcHost(TNetworkAddress host) throws Exception {
        Backend backend = Catalog.getCurrentSystemInfo().getBackendWithBePort(host.getHostname(), host.getPort());
        if (backend == null) {
            throw new UserException("No backend load available.");
        }
        if (backend.getBrpcPort() < 0) {
            return null;
        }
        return new TNetworkAddress(backend.getHost(), backend.getBrpcPort());
    }

    private boolean containsUnionNode(PlanNode node) {
        if (node instanceof UnionNode) {
            return true;
        }
        for (PlanNode child : node.getChildren()) {
            if (child instanceof ExchangeNode) continue;
            if (child instanceof UnionNode) {
                return true;
            }
            return this.containsUnionNode(child);
        }
        return false;
    }

    private boolean containsIntersectNode(PlanNode node) {
        if (node instanceof IntersectNode) {
            return true;
        }
        for (PlanNode child : node.getChildren()) {
            if (child instanceof ExchangeNode) continue;
            if (child instanceof IntersectNode) {
                return true;
            }
            return this.containsIntersectNode(child);
        }
        return false;
    }

    private boolean containsExceptNode(PlanNode node) {
        if (node instanceof ExceptNode) {
            return true;
        }
        for (PlanNode child : node.getChildren()) {
            if (child instanceof ExchangeNode) continue;
            if (child instanceof ExceptNode) {
                return true;
            }
            return this.containsExceptNode(child);
        }
        return false;
    }

    private boolean containsSetOperationNode(PlanNode node) {
        if (node instanceof SetOperationNode) {
            return true;
        }
        for (PlanNode child : node.getChildren()) {
            if (child instanceof ExchangeNode) continue;
            if (child instanceof SetOperationNode) {
                return true;
            }
            return this.containsSetOperationNode(child);
        }
        return false;
    }

    private void computeFragmentHosts() throws Exception {
        for (int i = this.fragments.size() - 1; i >= 0; --i) {
            PlanFragment fragment = this.fragments.get(i);
            FragmentExecParams params = this.fragmentExecParamsMap.get(fragment.getFragmentId());
            if (fragment.getDataPartition() == DataPartition.UNPARTITIONED) {
                Reference<Long> backendIdRef = new Reference<Long>();
                TNetworkAddress execHostport = ConnectContext.get() != null && ConnectContext.get().isResourceTagsSet() && !this.addressToBackendID.isEmpty() ? SimpleScheduler.getHostByCurrentBackend(this.addressToBackendID) : SimpleScheduler.getHost(this.idToBackend, backendIdRef);
                if (execHostport == null) {
                    LOG.warn("DataPartition UNPARTITIONED, no scanNode Backend available");
                    throw new UserException("There is no scanNode Backend available.");
                }
                if (backendIdRef.getRef() != null) {
                    this.addressToBackendID.put(execHostport, backendIdRef.getRef());
                }
                FInstanceExecParam instanceParam = new FInstanceExecParam(null, execHostport, 0, params);
                params.instanceExecParams.add(instanceParam);
                continue;
            }
            Pair<PlanNode, PlanNode> pairNodes = this.findLeftmostNode(fragment.getPlanRoot());
            PlanNode fatherNode = (PlanNode)pairNodes.first;
            PlanNode leftMostNode = (PlanNode)pairNodes.second;
            if (!(leftMostNode instanceof ScanNode)) {
                int inputFragmentIndex = 0;
                int maxParallelism = 0;
                int childrenCount = fatherNode != null ? fatherNode.getChildren().size() : 1;
                for (int j = 0; j < childrenCount; ++j) {
                    int currentChildFragmentParallelism = this.fragmentExecParamsMap.get((Object)((PlanFragment)fragment.getChild((int)j)).getFragmentId()).instanceExecParams.size();
                    if (currentChildFragmentParallelism <= maxParallelism) continue;
                    maxParallelism = currentChildFragmentParallelism;
                    inputFragmentIndex = j;
                }
                PlanFragmentId inputFragmentId = ((PlanFragment)fragment.getChild(inputFragmentIndex)).getFragmentId();
                int exchangeInstances = -1;
                if (ConnectContext.get() != null && ConnectContext.get().getSessionVariable() != null) {
                    exchangeInstances = ConnectContext.get().getSessionVariable().getExchangeInstanceParallel();
                }
                if (exchangeInstances > 0 && this.fragmentExecParamsMap.get((Object)inputFragmentId).instanceExecParams.size() > exchangeInstances) {
                    HashSet hostSet = Sets.newHashSet();
                    for (FInstanceExecParam execParams : this.fragmentExecParamsMap.get((Object)inputFragmentId).instanceExecParams) {
                        hostSet.add(execParams.host);
                    }
                    ArrayList hosts = Lists.newArrayList((Iterable)hostSet);
                    Collections.shuffle(hosts, instanceRandom);
                    for (int index = 0; index < exchangeInstances; ++index) {
                        FInstanceExecParam instanceParam = new FInstanceExecParam(null, (TNetworkAddress)hosts.get(index % hosts.size()), 0, params);
                        params.instanceExecParams.add(instanceParam);
                    }
                } else {
                    for (FInstanceExecParam execParams : this.fragmentExecParamsMap.get((Object)inputFragmentId).instanceExecParams) {
                        FInstanceExecParam instanceParam = new FInstanceExecParam(null, execParams.host, 0, params);
                        params.instanceExecParams.add(instanceParam);
                    }
                }
                Collections.shuffle(params.instanceExecParams, instanceRandom);
                continue;
            }
            int parallelExecInstanceNum = fragment.getParallelExecNum();
            if (this.isColocateFragment(fragment, fragment.getPlanRoot()) && this.fragmentIdToSeqToAddressMap.containsKey(fragment.getFragmentId()) && this.fragmentIdToSeqToAddressMap.get(fragment.getFragmentId()).size() > 0) {
                this.computeColocateJoinInstanceParam(fragment.getFragmentId(), parallelExecInstanceNum, params);
            } else if (this.bucketShuffleJoinController.isBucketShuffleJoin(fragment.getFragmentId().asInt())) {
                this.bucketShuffleJoinController.computeInstanceParam(fragment.getFragmentId(), parallelExecInstanceNum, params);
            } else {
                for (Map.Entry entry : this.fragmentExecParamsMap.get((Object)fragment.getFragmentId()).scanRangeAssignment.entrySet()) {
                    TNetworkAddress key = (TNetworkAddress)entry.getKey();
                    Map value = (Map)entry.getValue();
                    for (Integer planNodeId : value.keySet()) {
                        List perNodeScanRanges = (List)value.get(planNodeId);
                        int expectedInstanceNum = 1;
                        if (parallelExecInstanceNum > 1) {
                            expectedInstanceNum = Math.min(perNodeScanRanges.size(), parallelExecInstanceNum);
                        }
                        List perInstanceScanRanges = ListUtil.splitBySize(perNodeScanRanges, expectedInstanceNum);
                        LOG.debug("scan range number per instance is: {}", (Object)perInstanceScanRanges.size());
                        for (List scanRangeParams : perInstanceScanRanges) {
                            FInstanceExecParam instanceParam = new FInstanceExecParam(null, key, 0, params);
                            instanceParam.perNodeScanRanges.put(planNodeId, scanRangeParams);
                            params.instanceExecParams.add(instanceParam);
                        }
                    }
                }
            }
            if (!params.instanceExecParams.isEmpty()) continue;
            Reference<Long> backendIdRef = new Reference<Long>();
            TNetworkAddress execHostport = ConnectContext.get() != null && !ConnectContext.get().isResourceTagsSet() && !this.addressToBackendID.isEmpty() ? SimpleScheduler.getHostByCurrentBackend(this.addressToBackendID) : SimpleScheduler.getHost(this.idToBackend, backendIdRef);
            if (execHostport == null) {
                throw new UserException("There is no scanNode Backend available.");
            }
            if (backendIdRef.getRef() != null) {
                this.addressToBackendID.put(execHostport, backendIdRef.getRef());
            }
            FInstanceExecParam instanceParam = new FInstanceExecParam(null, execHostport, 0, params);
            params.instanceExecParams.add(instanceParam);
        }
    }

    private void assignRuntimeFilterAddr() throws Exception {
        for (PlanFragment fragment : this.fragments) {
            FragmentExecParams params = this.fragmentExecParamsMap.get(fragment.getFragmentId());
            for (RuntimeFilterId rid : fragment.getTargetRuntimeFilterIds()) {
                List targetFragments = this.ridToTargetParam.computeIfAbsent(rid, k -> new ArrayList());
                for (FInstanceExecParam instance : params.instanceExecParams) {
                    targetFragments.add(new FRuntimeFilterTargetParam(instance.instanceId, this.toBrpcHost(instance.host)));
                }
            }
            for (RuntimeFilterId rid : fragment.getBuilderRuntimeFilterIds()) {
                this.ridToBuilderNum.merge(rid, params.instanceExecParams.size(), Integer::sum);
            }
        }
        FragmentExecParams uppermostParams = this.fragmentExecParamsMap.get(this.fragments.get(0).getFragmentId());
        this.runtimeFilterMergeAddr = this.toBrpcHost(uppermostParams.instanceExecParams.get((int)0).host);
        this.runtimeFilterMergeInstanceId = uppermostParams.instanceExecParams.get((int)0).instanceId;
    }

    private boolean isColocateFragment(PlanFragment planFragment, PlanNode node) {
        if (ConnectContext.get() != null && ConnectContext.get().getSessionVariable().isDisableColocatePlan()) {
            return false;
        }
        if (this.colocateFragmentIds.contains(node.getFragmentId().asInt())) {
            return true;
        }
        if (planFragment.hasColocatePlanNode()) {
            this.colocateFragmentIds.add(planFragment.getId().asInt());
            return true;
        }
        return false;
    }

    private Pair<PlanNode, PlanNode> findLeftmostNode(PlanNode plan) {
        PlanNode newPlan = plan;
        PlanNode fatherPlan = null;
        while (newPlan.getChildren().size() != 0 && !(newPlan instanceof ExchangeNode)) {
            fatherPlan = newPlan;
            newPlan = (PlanNode)newPlan.getChild(0);
        }
        return new Pair<PlanNode, PlanNode>(fatherPlan, newPlan);
    }

    private <K, V> V findOrInsert(HashMap<K, V> m, K key, V defaultVal) {
        V value = m.get(key);
        if (value == null) {
            m.put(key, defaultVal);
            value = defaultVal;
        }
        return value;
    }

    private List<TScanRangeParams> findOrInsert(Map<Integer, List<TScanRangeParams>> m, Integer key, ArrayList<TScanRangeParams> defaultVal) {
        List<TScanRangeParams> value = m.get(key);
        if (value == null) {
            m.put(key, defaultVal);
            value = defaultVal;
        }
        return value;
    }

    private void computeColocateJoinInstanceParam(PlanFragmentId fragmentId, int parallelExecInstanceNum, FragmentExecParams params) {
        Map<Integer, TNetworkAddress> bucketSeqToAddress = this.fragmentIdToSeqToAddressMap.get(fragmentId);
        BucketSeqToScanRange bucketSeqToScanRange = this.fragmentIdTobucketSeqToScanRangeMap.get(fragmentId);
        Set<Integer> scanNodeIds = this.fragmentIdToScanNodeIds.get(fragmentId);
        HashMap addressToScanRanges = Maps.newHashMap();
        for (Map.Entry scanRanges : bucketSeqToScanRange.entrySet()) {
            TNetworkAddress address = bucketSeqToAddress.get(scanRanges.getKey());
            Map nodeScanRanges = (Map)scanRanges.getValue();
            HashMap filteredNodeScanRanges = Maps.newHashMap();
            for (Integer scanNodeId : nodeScanRanges.keySet()) {
                if (!scanNodeIds.contains(scanNodeId)) continue;
                filteredNodeScanRanges.put(scanNodeId, (List)nodeScanRanges.get(scanNodeId));
            }
            Pair<Integer, HashMap> filteredScanRanges = Pair.create((Integer)scanRanges.getKey(), filteredNodeScanRanges);
            if (!addressToScanRanges.containsKey(address)) {
                addressToScanRanges.put(address, Lists.newArrayList());
            }
            ((List)addressToScanRanges.get(address)).add(filteredScanRanges);
        }
        FragmentScanRangeAssignment assignment = params.scanRangeAssignment;
        for (Map.Entry addressScanRange : addressToScanRanges.entrySet()) {
            List scanRange = (List)addressScanRange.getValue();
            Map range = this.findOrInsert(assignment, (TNetworkAddress)addressScanRange.getKey(), new HashMap());
            int expectedInstanceNum = 1;
            if (parallelExecInstanceNum > 1) {
                expectedInstanceNum = Math.min(scanRange.size(), parallelExecInstanceNum);
            }
            List perInstanceScanRanges = ListUtil.splitBySize(scanRange, expectedInstanceNum);
            for (List perInstanceScanRange : perInstanceScanRanges) {
                FInstanceExecParam instanceParam = new FInstanceExecParam(null, (TNetworkAddress)addressScanRange.getKey(), 0, params);
                for (Pair nodeScanRangeMap : perInstanceScanRange) {
                    instanceParam.bucketSeqSet.add((Integer)nodeScanRangeMap.first);
                    for (Map.Entry nodeScanRange : ((Map)nodeScanRangeMap.second).entrySet()) {
                        if (!instanceParam.perNodeScanRanges.containsKey(nodeScanRange.getKey())) {
                            range.put((Integer)nodeScanRange.getKey(), Lists.newArrayList());
                            instanceParam.perNodeScanRanges.put((Integer)nodeScanRange.getKey(), Lists.newArrayList());
                        }
                        ((List)range.get(nodeScanRange.getKey())).addAll((Collection)nodeScanRange.getValue());
                        instanceParam.perNodeScanRanges.get(nodeScanRange.getKey()).addAll((Collection)nodeScanRange.getValue());
                    }
                }
                params.instanceExecParams.add(instanceParam);
            }
        }
    }

    private void computeScanRangeAssignment() throws Exception {
        HashMap assignedBytesPerHost = Maps.newHashMap();
        for (ScanNode scanNode : this.scanNodes) {
            List<TScanRangeLocations> locations = scanNode.getScanRangeLocations(0L);
            if (locations == null) continue;
            HashSet scanNodeIds = this.fragmentIdToScanNodeIds.get(scanNode.getFragmentId());
            if (scanNodeIds == null) {
                scanNodeIds = Sets.newHashSet();
                this.fragmentIdToScanNodeIds.put(scanNode.getFragmentId(), scanNodeIds);
            }
            scanNodeIds.add(scanNode.getId().asInt());
            FragmentScanRangeAssignment assignment = this.fragmentExecParamsMap.get((Object)scanNode.getFragmentId()).scanRangeAssignment;
            boolean fragmentContainsColocateJoin = this.isColocateFragment(scanNode.getFragment(), scanNode.getFragment().getPlanRoot());
            boolean fragmentContainsBucketShuffleJoin = this.bucketShuffleJoinController.isBucketShuffleJoin(scanNode.getFragmentId().asInt(), scanNode.getFragment().getPlanRoot());
            if (fragmentContainsColocateJoin) {
                this.computeScanRangeAssignmentByColocate((OlapScanNode)scanNode);
            }
            if (fragmentContainsBucketShuffleJoin) {
                this.bucketShuffleJoinController.computeScanRangeAssignmentByBucket((OlapScanNode)scanNode, (ImmutableMap<Long, Backend>)this.idToBackend, this.addressToBackendID);
            }
            if (fragmentContainsColocateJoin | fragmentContainsBucketShuffleJoin) continue;
            this.computeScanRangeAssignmentByScheduler(scanNode, locations, assignment, assignedBytesPerHost);
        }
    }

    private void computeScanRangeAssignmentByColocate(OlapScanNode scanNode) throws Exception {
        if (!this.fragmentIdToSeqToAddressMap.containsKey(scanNode.getFragmentId())) {
            this.fragmentIdToSeqToAddressMap.put(scanNode.getFragmentId(), (Map<Integer, TNetworkAddress>)new HashedMap());
            this.fragmentIdTobucketSeqToScanRangeMap.put(scanNode.getFragmentId(), new BucketSeqToScanRange());
        }
        Map<Integer, TNetworkAddress> bucketSeqToAddress = this.fragmentIdToSeqToAddressMap.get(scanNode.getFragmentId());
        BucketSeqToScanRange bucketSeqToScanRange = this.fragmentIdTobucketSeqToScanRangeMap.get(scanNode.getFragmentId());
        HashMap assignedBytesPerHost = Maps.newHashMap();
        for (Integer bucketSeq : scanNode.bucketSeq2locations.keySet()) {
            List locations = scanNode.bucketSeq2locations.get((Object)bucketSeq);
            if (!bucketSeqToAddress.containsKey(bucketSeq)) {
                this.getExecHostPortForFragmentIDAndBucketSeq((TScanRangeLocations)locations.get(0), scanNode.getFragmentId(), bucketSeq, assignedBytesPerHost);
            }
            for (TScanRangeLocations location : locations) {
                Map scanRanges = this.findOrInsert(bucketSeqToScanRange, bucketSeq, new HashMap());
                List<TScanRangeParams> scanRangeParamsList = this.findOrInsert(scanRanges, scanNode.getId().asInt(), new ArrayList<TScanRangeParams>());
                TScanRangeParams scanRangeParams = new TScanRangeParams();
                scanRangeParams.scan_range = location.scan_range;
                scanRangeParamsList.add(scanRangeParams);
            }
        }
    }

    private void getExecHostPortForFragmentIDAndBucketSeq(TScanRangeLocations seqLocation, PlanFragmentId fragmentId, Integer bucketSeq, HashMap<TNetworkAddress, Long> assignedBytesPerHost) throws Exception {
        Reference<Long> backendIdRef = new Reference<Long>();
        this.selectBackendsByRoundRobin(seqLocation, assignedBytesPerHost, backendIdRef);
        Backend backend = (Backend)this.idToBackend.get((Object)backendIdRef.getRef());
        TNetworkAddress execHostPort = new TNetworkAddress(backend.getHost(), backend.getBePort());
        this.addressToBackendID.put(execHostPort, backendIdRef.getRef());
        this.fragmentIdToSeqToAddressMap.get(fragmentId).put(bucketSeq, execHostPort);
    }

    public TScanRangeLocation selectBackendsByRoundRobin(TScanRangeLocations seqLocation, HashMap<TNetworkAddress, Long> assignedBytesPerHost, Reference<Long> backendIdRef) throws UserException {
        if (!Config.enable_local_replica_selection) {
            return this.selectBackendsByRoundRobin(seqLocation.getLocations(), assignedBytesPerHost, backendIdRef);
        }
        ArrayList<TScanRangeLocation> localLocations = new ArrayList<TScanRangeLocation>();
        ArrayList<TScanRangeLocation> nonlocalLocations = new ArrayList<TScanRangeLocation>();
        long localBeId = Catalog.getCurrentSystemInfo().getBackendIdByHost(FrontendOptions.getLocalHostAddress());
        for (TScanRangeLocation location : seqLocation.getLocations()) {
            if (location.backend_id == localBeId) {
                localLocations.add(location);
                continue;
            }
            nonlocalLocations.add(location);
        }
        try {
            return this.selectBackendsByRoundRobin(localLocations, assignedBytesPerHost, backendIdRef);
        }
        catch (UserException ue) {
            if (!Config.enable_local_replica_selection_fallback) {
                throw ue;
            }
            return this.selectBackendsByRoundRobin(nonlocalLocations, assignedBytesPerHost, backendIdRef);
        }
    }

    public TScanRangeLocation selectBackendsByRoundRobin(List<TScanRangeLocation> locations, HashMap<TNetworkAddress, Long> assignedBytesPerHost, Reference<Long> backendIdRef) throws UserException {
        Long minAssignedBytes = Long.MAX_VALUE;
        TScanRangeLocation minLocation = null;
        Long step = 1L;
        for (TScanRangeLocation location : locations) {
            Long assignedBytes = this.findOrInsert(assignedBytesPerHost, location.server, 0L);
            if (assignedBytes >= minAssignedBytes) continue;
            minAssignedBytes = assignedBytes;
            minLocation = location;
        }
        TScanRangeLocation location = SimpleScheduler.getLocation(minLocation, locations, this.idToBackend, backendIdRef);
        if (assignedBytesPerHost.containsKey(location.server)) {
            assignedBytesPerHost.put(location.server, assignedBytesPerHost.get(location.server) + step);
        } else {
            assignedBytesPerHost.put(location.server, step);
        }
        return location;
    }

    private void computeScanRangeAssignmentByScheduler(ScanNode scanNode, List<TScanRangeLocations> locations, FragmentScanRangeAssignment assignment, HashMap<TNetworkAddress, Long> assignedBytesPerHost) throws Exception {
        for (TScanRangeLocations scanRangeLocations : locations) {
            Reference<Long> backendIdRef = new Reference<Long>();
            TScanRangeLocation minLocation = this.selectBackendsByRoundRobin(scanRangeLocations, assignedBytesPerHost, backendIdRef);
            Backend backend = (Backend)this.idToBackend.get((Object)backendIdRef.getRef());
            TNetworkAddress execHostPort = new TNetworkAddress(backend.getHost(), backend.getBePort());
            this.addressToBackendID.put(execHostPort, backendIdRef.getRef());
            Map scanRanges = this.findOrInsert(assignment, execHostPort, new HashMap());
            List<TScanRangeParams> scanRangeParamsList = this.findOrInsert(scanRanges, scanNode.getId().asInt(), new ArrayList<TScanRangeParams>());
            TScanRangeParams scanRangeParams = new TScanRangeParams();
            scanRangeParams.scan_range = scanRangeLocations.scan_range;
            scanRangeParams.setVolumeId(minLocation.volume_id);
            scanRangeParamsList.add(scanRangeParams);
        }
    }

    public void updateFragmentExecStatus(TReportExecStatusParams params) {
        if (params.backend_num >= this.backendExecStates.size()) {
            LOG.warn("unknown backend number: {}, expected less than: {}", (Object)params.backend_num, (Object)this.backendExecStates.size());
            return;
        }
        BackendExecState execState = this.backendExecStates.get(params.backend_num);
        if (!execState.updateProfile(params)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            execState.printProfile(builder);
            LOG.debug("profile for query_id={} instance_id={}\n{}", (Object)DebugUtil.printId(this.queryId), (Object)DebugUtil.printId(params.getFragmentInstanceId()), (Object)builder.toString());
        }
        Status status = new Status(params.status);
        if (!(this.returnedAllResults && status.isCancelled() || status.ok())) {
            LOG.warn("one instance report fail, query_id={} instance_id={}", (Object)DebugUtil.printId(this.queryId), (Object)DebugUtil.printId(params.getFragmentInstanceId()));
            this.updateStatus(status, params.getFragmentInstanceId());
        }
        if (execState.done) {
            if (params.isSetDeltaUrls()) {
                this.updateDeltas(params.getDeltaUrls());
            }
            if (params.isSetLoadCounters()) {
                this.updateLoadCounters(params.getLoadCounters());
            }
            if (params.isSetTrackingUrl()) {
                this.trackingUrl = params.getTrackingUrl();
            }
            if (params.isSetExportFiles()) {
                this.updateExportFiles(params.getExportFiles());
            }
            if (params.isSetCommitInfos()) {
                this.updateCommitInfos(params.getCommitInfos());
            }
            if (params.isSetErrorTabletInfos()) {
                this.updateErrorTabletInfos(params.getErrorTabletInfos());
            }
            this.profileDoneSignal.markedCountDown(params.getFragmentInstanceId(), -1L);
        }
        if (params.isSetLoadedRows()) {
            Catalog.getCurrentCatalog().getLoadManager().updateJobProgress(this.jobId, params.getBackendId(), params.getQueryId(), params.getFragmentInstanceId(), params.getLoadedRows(), params.getLoadedBytes(), params.isDone());
        }
    }

    public void endProfile() {
        this.endProfile(true);
    }

    public void endProfile(boolean waitProfileDone) {
        if (this.backendExecStates.isEmpty()) {
            return;
        }
        if (waitProfileDone && this.needReport) {
            try {
                this.profileDoneSignal.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                LOG.warn("signal await error", (Throwable)e1);
            }
        }
        for (int i = 1; i < this.fragmentProfile.size(); ++i) {
            this.fragmentProfile.get(i).sortChildren();
        }
    }

    public boolean join(int timeoutS) {
        long waitTime;
        long fixedMaxWaitTime = 30L;
        for (long leftTimeoutS = (long)timeoutS; leftTimeoutS > 0L; leftTimeoutS -= waitTime) {
            waitTime = Math.min(leftTimeoutS, 30L);
            boolean awaitRes = false;
            try {
                awaitRes = this.profileDoneSignal.await(waitTime, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (awaitRes) {
                return true;
            }
            if (this.checkBackendState()) continue;
            return true;
        }
        return false;
    }

    private boolean checkBackendState() {
        for (BackendExecState backendExecState : this.needCheckBackendExecStates) {
            if (backendExecState.isBackendStateHealthy()) continue;
            this.queryStatus = new Status(TStatusCode.INTERNAL_ERROR, "backend " + backendExecState.backend.getId() + " is down");
            return false;
        }
        return true;
    }

    public boolean isDone() {
        return this.profileDoneSignal.getCount() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryStatisticsItem.FragmentInstanceInfo> getFragmentInstanceInfos() {
        ArrayList result = Lists.newArrayList();
        this.lock();
        try {
            for (int index = 0; index < this.fragments.size(); ++index) {
                for (BackendExecState backendExecState : this.backendExecStates) {
                    if (this.fragments.get(index).getFragmentId() != backendExecState.fragmentId) continue;
                    QueryStatisticsItem.FragmentInstanceInfo info = backendExecState.buildFragmentInstanceInfo();
                    result.add(info);
                }
            }
        }
        finally {
            this.unlock();
        }
        return result;
    }

    private void attachInstanceProfileToFragmentProfile() {
        for (BackendExecState backendExecState : this.backendExecStates) {
            if (!backendExecState.computeTimeInProfile(this.fragmentProfile.size())) {
                return;
            }
            this.fragmentProfile.get(backendExecState.profileFragmentId).addChild(backendExecState.profile);
        }
    }

    static class FRuntimeFilterTargetParam {
        public TUniqueId targetFragmentInstanceId;
        public TNetworkAddress targetFragmentInstanceAddr;

        public FRuntimeFilterTargetParam(TUniqueId id, TNetworkAddress host) {
            this.targetFragmentInstanceId = id;
            this.targetFragmentInstanceAddr = host;
        }
    }

    static class FInstanceExecParam {
        TUniqueId instanceId;
        TNetworkAddress host;
        Map<Integer, List<TScanRangeParams>> perNodeScanRanges = Maps.newHashMap();
        int perFragmentInstanceIdx;
        Set<Integer> bucketSeqSet = Sets.newHashSet();
        FragmentExecParams fragmentExecParams;

        public void addBucketSeq(int bucketSeq) {
            this.bucketSeqSet.add(bucketSeq);
        }

        public FInstanceExecParam(TUniqueId id, TNetworkAddress host, int perFragmentInstanceIdx, FragmentExecParams fragmentExecParams) {
            this.instanceId = id;
            this.host = host;
            this.perFragmentInstanceIdx = perFragmentInstanceIdx;
            this.fragmentExecParams = fragmentExecParams;
        }

        public PlanFragment fragment() {
            return this.fragmentExecParams.fragment;
        }
    }

    protected class FragmentExecParams {
        public PlanFragment fragment;
        public List<TPlanFragmentDestination> destinations = Lists.newArrayList();
        public Map<Integer, Integer> perExchNumSenders = Maps.newHashMap();
        public List<PlanFragmentId> inputFragments = Lists.newArrayList();
        public List<FInstanceExecParam> instanceExecParams = Lists.newArrayList();
        public FragmentScanRangeAssignment scanRangeAssignment = new FragmentScanRangeAssignment();

        public FragmentExecParams(PlanFragment fragment) {
            this.fragment = fragment;
        }

        List<TExecPlanFragmentParams> toThrift(int backendNum) {
            ArrayList paramsList = Lists.newArrayList();
            for (int i = 0; i < this.instanceExecParams.size(); ++i) {
                TLoadErrorHubInfo tLoadErrorHubInfo;
                LoadErrorHub.Param param;
                FInstanceExecParam instanceExecParam = this.instanceExecParams.get(i);
                TExecPlanFragmentParams params = new TExecPlanFragmentParams();
                params.setProtocolVersion(PaloInternalServiceVersion.V1);
                params.setFragment(this.fragment.toThrift());
                params.setDescTbl(Coordinator.this.descTable);
                params.setParams(new TPlanFragmentExecParams());
                params.setResourceInfo(Coordinator.this.tResourceInfo);
                params.params.setQueryId(Coordinator.this.queryId);
                params.params.setFragmentInstanceId(instanceExecParam.instanceId);
                HashMap scanRanges = instanceExecParam.perNodeScanRanges;
                if (scanRanges == null) {
                    scanRanges = Maps.newHashMap();
                }
                params.params.setPerNodeScanRanges((Map)scanRanges);
                params.params.setPerExchNumSenders(this.perExchNumSenders);
                params.params.setDestinations(this.destinations);
                params.params.setSenderId(i);
                params.params.setNumSenders(this.instanceExecParams.size());
                params.setCoord(Coordinator.this.coordAddress);
                params.setBackendNum(backendNum++);
                params.setQueryGlobals(Coordinator.this.queryGlobals);
                params.setQueryOptions(Coordinator.this.queryOptions);
                params.params.setSendQueryStatisticsWithEveryBatch(this.fragment.isTransferQueryStatisticsWithEveryBatch());
                params.params.setRuntimeFilterParams(new TRuntimeFilterParams());
                params.params.runtime_filter_params.setRuntimeFilterMergeAddr(Coordinator.this.runtimeFilterMergeAddr);
                if (instanceExecParam.instanceId.equals(Coordinator.this.runtimeFilterMergeInstanceId)) {
                    for (Map.Entry<RuntimeFilterId, List<FRuntimeFilterTargetParam>> entry : Coordinator.this.ridToTargetParam.entrySet()) {
                        ArrayList targetParams = Lists.newArrayList();
                        for (FRuntimeFilterTargetParam targetParam : entry.getValue()) {
                            targetParams.add(new TRuntimeFilterTargetParams(targetParam.targetFragmentInstanceId, targetParam.targetFragmentInstanceAddr));
                        }
                        params.params.runtime_filter_params.putToRidToTargetParam(entry.getKey().asInt(), (List)targetParams);
                    }
                    for (Map.Entry<RuntimeFilterId, Object> entry : Coordinator.this.ridToBuilderNum.entrySet()) {
                        params.params.runtime_filter_params.putToRuntimeFilterBuilderNum(entry.getKey().asInt(), ((Integer)entry.getValue()).intValue());
                    }
                    for (RuntimeFilter runtimeFilter : Coordinator.this.assignedRuntimeFilters) {
                        params.params.runtime_filter_params.putToRidToRuntimeFilter(runtimeFilter.getFilterId().asInt(), runtimeFilter.toThrift());
                    }
                }
                if (Coordinator.this.queryOptions.getQueryType() == TQueryType.LOAD && (param = Catalog.getCurrentCatalog().getLoadInstance().getLoadErrorHubInfo()) != null && (tLoadErrorHubInfo = param.toThrift()) != null) {
                    params.setLoadErrorHubInfo(tLoadErrorHubInfo);
                }
                paramsList.add(params);
            }
            return paramsList;
        }

        public void appendScanRange(StringBuilder sb, List<TScanRangeParams> params) {
            sb.append("range=[");
            int idx = 0;
            for (TScanRangeParams range : params) {
                TEsScanRange esScanRange;
                TPaloScanRange paloScanRange = range.getScanRange().getPaloScanRange();
                if (paloScanRange != null) {
                    if (idx++ != 0) {
                        sb.append(",");
                    }
                    sb.append("{tid=").append(paloScanRange.getTabletId()).append(",ver=").append(paloScanRange.getVersion()).append("}");
                }
                if ((esScanRange = range.getScanRange().getEsScanRange()) == null) continue;
                sb.append("{ index=").append(esScanRange.getIndex()).append(", shardid=").append(esScanRange.getShardId()).append("}");
            }
            sb.append("]");
        }

        public void appendTo(StringBuilder sb) {
            sb.append("{plan=");
            this.fragment.getPlanRoot().appendTrace(sb);
            sb.append(",instance=[");
            for (int i = 0; i < this.instanceExecParams.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                TNetworkAddress address = this.instanceExecParams.get((int)i).host;
                Map scanRanges = (Map)this.scanRangeAssignment.get(address);
                sb.append("{");
                sb.append("id=").append(DebugUtil.printId(this.instanceExecParams.get((int)i).instanceId));
                sb.append(",host=").append(this.instanceExecParams.get((int)i).host);
                if (scanRanges == null) {
                    sb.append("}");
                    continue;
                }
                sb.append(",range=[");
                int eIdx = 0;
                for (Map.Entry entry : scanRanges.entrySet()) {
                    if (eIdx++ != 0) {
                        sb.append(",");
                    }
                    sb.append("id").append(entry.getKey()).append(",");
                    this.appendScanRange(sb, (List)entry.getValue());
                }
                sb.append("]");
                sb.append("}");
            }
            sb.append("]");
            sb.append("}");
        }
    }

    public class BackendExecStates {
        long beId;
        TNetworkAddress brpcAddr;
        List<BackendExecState> states = Lists.newArrayList();
        boolean twoPhaseExecution = false;

        public BackendExecStates(long beId, TNetworkAddress brpcAddr, boolean twoPhaseExecution) {
            this.beId = beId;
            this.brpcAddr = brpcAddr;
            this.twoPhaseExecution = twoPhaseExecution;
        }

        public void addState(BackendExecState state) {
            this.states.add(state);
        }

        public void unsetFields() {
            boolean first = true;
            for (BackendExecState state : this.states) {
                if (first) {
                    first = false;
                    continue;
                }
                state.unsetFields();
            }
        }

        public Future<InternalService.PExecPlanFragmentResult> execRemoteFragmentsAsync() throws TException {
            try {
                TExecPlanFragmentParamsList paramsList = new TExecPlanFragmentParamsList();
                for (BackendExecState state : this.states) {
                    paramsList.addToParamsList(state.rpcParams);
                }
                return BackendServiceProxy.getInstance().execPlanFragmentsAsync(this.brpcAddr, paramsList, this.twoPhaseExecution);
            }
            catch (RpcException e) {
                return this.futureWithException(e);
            }
        }

        public Future<InternalService.PExecPlanFragmentResult> execPlanFragmentStartAsync() throws TException {
            try {
                InternalService.PExecPlanFragmentStartRequest.Builder builder = InternalService.PExecPlanFragmentStartRequest.newBuilder();
                Types.PUniqueId qid = Types.PUniqueId.newBuilder().setHi(((Coordinator)Coordinator.this).queryId.hi).setLo(((Coordinator)Coordinator.this).queryId.lo).build();
                builder.setQueryId(qid);
                return BackendServiceProxy.getInstance().execPlanFragmentStartAsync(this.brpcAddr, builder.build());
            }
            catch (RpcException e) {
                return this.futureWithException(e);
            }
        }

        @NotNull
        private Future<InternalService.PExecPlanFragmentResult> futureWithException(final RpcException e) {
            return new Future<InternalService.PExecPlanFragmentResult>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public InternalService.PExecPlanFragmentResult get() {
                    InternalService.PExecPlanFragmentResult result = InternalService.PExecPlanFragmentResult.newBuilder().setStatus(Types.PStatus.newBuilder().addErrorMsgs(e.getMessage()).setStatusCode(TStatusCode.THRIFT_RPC_ERROR.getValue()).build()).build();
                    return result;
                }

                @Override
                public InternalService.PExecPlanFragmentResult get(long timeout, TimeUnit unit) {
                    return this.get();
                }
            };
        }
    }

    public class BackendExecState {
        TExecPlanFragmentParams rpcParams;
        PlanFragmentId fragmentId;
        boolean initiated;
        volatile boolean done;
        boolean hasCanceled;
        int profileFragmentId;
        RuntimeProfile profile;
        TNetworkAddress brpcAddress;
        TNetworkAddress address;
        Backend backend;
        long lastMissingHeartbeatTime = -1L;
        TUniqueId instanceId;

        public BackendExecState(PlanFragmentId fragmentId, int instanceId, int profileFragmentId, TExecPlanFragmentParams rpcParams, Map<TNetworkAddress, Long> addressToBackendID) {
            this.profileFragmentId = profileFragmentId;
            this.fragmentId = fragmentId;
            this.rpcParams = rpcParams;
            this.initiated = false;
            this.done = false;
            FInstanceExecParam fi = ((FragmentExecParams)((Coordinator)Coordinator.this).fragmentExecParamsMap.get((Object)fragmentId)).instanceExecParams.get(instanceId);
            this.instanceId = fi.instanceId;
            this.address = fi.host;
            this.backend = (Backend)Coordinator.this.idToBackend.get((Object)addressToBackendID.get(this.address));
            this.brpcAddress = new TNetworkAddress(this.backend.getHost(), this.backend.getBrpcPort());
            String name = "Instance " + DebugUtil.printId(fi.instanceId) + " (host=" + this.address + ")";
            this.profile = new RuntimeProfile(name);
            this.hasCanceled = false;
            this.lastMissingHeartbeatTime = this.backend.getLastMissingHeartbeatTime();
        }

        public void unsetFields() {
            if (Coordinator.this.alreadySentBackendIds.contains(this.backend.getId())) {
                this.rpcParams.unsetDescTbl();
                this.rpcParams.unsetCoord();
                this.rpcParams.unsetQueryGlobals();
                this.rpcParams.unsetResourceInfo();
                this.rpcParams.setIsSimplifiedParam(true);
            } else {
                this.rpcParams.setIsSimplifiedParam(false);
            }
        }

        public synchronized boolean updateProfile(TReportExecStatusParams params) {
            if (this.done) {
                return false;
            }
            if (params.isSetProfile()) {
                this.profile.update(params.profile);
            }
            this.done = params.done;
            return true;
        }

        public synchronized void printProfile(StringBuilder builder) {
            this.profile.computeTimeInProfile();
            this.profile.prettyPrint(builder, "");
        }

        public synchronized boolean cancelFragmentInstance(Types.PPlanFragmentCancelReason cancelReason) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelRemoteFragments initiated={} done={} hasCanceled={} backend: {}, fragment instance id={}, reason: {}", (Object)this.initiated, (Object)this.done, (Object)this.hasCanceled, (Object)this.backend.getId(), (Object)DebugUtil.printId(this.fragmentInstanceId()), (Object)cancelReason.name());
            }
            try {
                if (!this.initiated) {
                    return false;
                }
                if (this.done) {
                    return false;
                }
                if (this.hasCanceled) {
                    return false;
                }
                try {
                    BackendServiceProxy.getInstance().cancelPlanFragmentAsync(this.brpcAddress, this.fragmentInstanceId(), cancelReason);
                }
                catch (RpcException e) {
                    LOG.warn("cancel plan fragment get a exception, address={}:{}", (Object)this.brpcAddress.getHostname(), (Object)this.brpcAddress.getPort());
                    SimpleScheduler.addToBlacklist(Coordinator.this.addressToBackendID.get(this.brpcAddress), e.getMessage());
                }
                this.hasCanceled = true;
            }
            catch (Exception e) {
                LOG.warn("catch a exception", (Throwable)e);
                return false;
            }
            return true;
        }

        public synchronized boolean computeTimeInProfile(int maxFragmentId) {
            if (this.profileFragmentId < 0 || this.profileFragmentId > maxFragmentId) {
                LOG.warn("profileFragmentId {} should be in [0, {})", (Object)this.profileFragmentId, (Object)maxFragmentId);
                return false;
            }
            this.profile.computeTimeInProfile();
            return true;
        }

        public boolean isBackendStateHealthy() {
            if (this.backend.getLastMissingHeartbeatTime() > this.lastMissingHeartbeatTime) {
                LOG.warn("backend {} is down while joining the coordinator. job id: {}", (Object)this.backend.getId(), (Object)Coordinator.this.jobId);
                return false;
            }
            return true;
        }

        public QueryStatisticsItem.FragmentInstanceInfo buildFragmentInstanceInfo() {
            return new QueryStatisticsItem.FragmentInstanceInfo.Builder().instanceId(this.fragmentInstanceId()).fragmentId(String.valueOf(this.fragmentId)).address(this.address).build();
        }

        private TUniqueId fragmentInstanceId() {
            return this.rpcParams.params.getFragmentInstanceId();
        }
    }

    class BucketShuffleJoinController {
        private Map<PlanFragmentId, BucketSeqToScanRange> fragmentIdBucketSeqToScanRangeMap = Maps.newHashMap();
        private Map<PlanFragmentId, Map<Integer, TNetworkAddress>> fragmentIdToSeqToAddressMap = Maps.newHashMap();
        private Map<PlanFragmentId, Map<Long, Integer>> fragmentIdToBuckendIdBucketCountMap = Maps.newHashMap();
        private Map<PlanFragmentId, Integer> fragmentIdToBucketNumMap = Maps.newHashMap();
        private Set<Integer> bucketShuffleFragmentIds = new HashSet<Integer>();
        private Map<PlanFragmentId, Set<Integer>> fragmentIdToScanNodeIds;

        public BucketShuffleJoinController(Map<PlanFragmentId, Set<Integer>> fragmentIdToScanNodeIds) {
            this.fragmentIdToScanNodeIds = fragmentIdToScanNodeIds;
        }

        private boolean isBucketShuffleJoin(int fragmentId, PlanNode node) {
            HashJoinNode joinNode;
            if (ConnectContext.get() != null && !ConnectContext.get().getSessionVariable().isEnableBucketShuffleJoin()) {
                return false;
            }
            if (fragmentId != node.getFragmentId().asInt()) {
                return false;
            }
            if (this.bucketShuffleFragmentIds.contains(fragmentId)) {
                return true;
            }
            if (node instanceof HashJoinNode && (joinNode = (HashJoinNode)node).isBucketShuffle()) {
                this.bucketShuffleFragmentIds.add(joinNode.getFragmentId().asInt());
                return true;
            }
            for (PlanNode childNode : node.getChildren()) {
                if (!this.isBucketShuffleJoin(fragmentId, childNode)) continue;
                return true;
            }
            return false;
        }

        private boolean isBucketShuffleJoin(int fragmentId) {
            return this.bucketShuffleFragmentIds.contains(fragmentId);
        }

        private int getFragmentBucketNum(PlanFragmentId fragmentId) {
            return this.fragmentIdToBucketNumMap.get(fragmentId);
        }

        private void getExecHostPortForFragmentIDAndBucketSeq(TScanRangeLocations seqLocation, PlanFragmentId fragmentId, Integer bucketSeq, ImmutableMap<Long, Backend> idToBackend, Map<TNetworkAddress, Long> addressToBackendID) throws Exception {
            Reference<Long> backendIdRef;
            TNetworkAddress execHostPort;
            Map<Long, Integer> buckendIdToBucketCountMap = this.fragmentIdToBuckendIdBucketCountMap.get(fragmentId);
            int maxBucketNum = Integer.MAX_VALUE;
            long buckendId = Long.MAX_VALUE;
            for (TScanRangeLocation location : seqLocation.locations) {
                if (buckendIdToBucketCountMap.containsKey(location.backend_id)) {
                    if (buckendIdToBucketCountMap.get(location.backend_id) >= maxBucketNum) continue;
                    maxBucketNum = buckendIdToBucketCountMap.get(location.backend_id);
                    buckendId = location.backend_id;
                    continue;
                }
                maxBucketNum = 0;
                buckendId = location.backend_id;
                buckendIdToBucketCountMap.put(buckendId, 0);
                break;
            }
            if ((execHostPort = SimpleScheduler.getHost(buckendId, seqLocation.locations, idToBackend, backendIdRef = new Reference<Long>())) == null) {
                throw new UserException("There is no scanNode Backend available.");
            }
            if (backendIdRef.getRef() != buckendId) {
                if (!buckendIdToBucketCountMap.containsKey(backendIdRef.getRef())) {
                    buckendIdToBucketCountMap.put(backendIdRef.getRef(), 1);
                } else {
                    buckendIdToBucketCountMap.put(backendIdRef.getRef(), buckendIdToBucketCountMap.get(backendIdRef.getRef()) + 1);
                }
            } else {
                buckendIdToBucketCountMap.put(buckendId, buckendIdToBucketCountMap.get(buckendId) + 1);
            }
            addressToBackendID.put(execHostPort, backendIdRef.getRef());
            this.fragmentIdToSeqToAddressMap.get(fragmentId).put(bucketSeq, execHostPort);
        }

        private void computeScanRangeAssignmentByBucket(OlapScanNode scanNode, ImmutableMap<Long, Backend> idToBackend, Map<TNetworkAddress, Long> addressToBackendID) throws Exception {
            if (!this.fragmentIdToSeqToAddressMap.containsKey(scanNode.getFragmentId())) {
                int bucketNum = 0;
                bucketNum = scanNode.getOlapTable().isColocateTable() ? scanNode.getOlapTable().getDefaultDistributionInfo().getBucketNum() : (int)scanNode.getTotalTabletsNum();
                this.fragmentIdToBucketNumMap.put(scanNode.getFragmentId(), bucketNum);
                this.fragmentIdToSeqToAddressMap.put(scanNode.getFragmentId(), (Map<Integer, TNetworkAddress>)new HashedMap());
                this.fragmentIdBucketSeqToScanRangeMap.put(scanNode.getFragmentId(), new BucketSeqToScanRange());
                this.fragmentIdToBuckendIdBucketCountMap.put(scanNode.getFragmentId(), new HashMap());
            }
            Map<Integer, TNetworkAddress> bucketSeqToAddress = this.fragmentIdToSeqToAddressMap.get(scanNode.getFragmentId());
            BucketSeqToScanRange bucketSeqToScanRange = this.fragmentIdBucketSeqToScanRangeMap.get(scanNode.getFragmentId());
            for (Integer bucketSeq : scanNode.bucketSeq2locations.keySet()) {
                List locations = scanNode.bucketSeq2locations.get((Object)bucketSeq);
                if (!bucketSeqToAddress.containsKey(bucketSeq)) {
                    this.getExecHostPortForFragmentIDAndBucketSeq((TScanRangeLocations)locations.get(0), scanNode.getFragmentId(), bucketSeq, idToBackend, addressToBackendID);
                }
                for (TScanRangeLocations location : locations) {
                    Map scanRanges = (Map)Coordinator.this.findOrInsert(bucketSeqToScanRange, bucketSeq, new HashMap());
                    List scanRangeParamsList = Coordinator.this.findOrInsert(scanRanges, scanNode.getId().asInt(), new ArrayList());
                    TScanRangeParams scanRangeParams = new TScanRangeParams();
                    scanRangeParams.scan_range = location.scan_range;
                    scanRangeParamsList.add(scanRangeParams);
                }
            }
        }

        private void computeInstanceParam(PlanFragmentId fragmentId, int parallelExecInstanceNum, FragmentExecParams params) {
            Map<Integer, TNetworkAddress> bucketSeqToAddress = this.fragmentIdToSeqToAddressMap.get(fragmentId);
            BucketSeqToScanRange bucketSeqToScanRange = this.fragmentIdBucketSeqToScanRangeMap.get(fragmentId);
            Set<Integer> scanNodeIds = this.fragmentIdToScanNodeIds.get(fragmentId);
            HashMap addressToScanRanges = Maps.newHashMap();
            for (Map.Entry scanRanges : bucketSeqToScanRange.entrySet()) {
                TNetworkAddress address = bucketSeqToAddress.get(scanRanges.getKey());
                Map nodeScanRanges = (Map)scanRanges.getValue();
                HashMap filteredNodeScanRanges = Maps.newHashMap();
                for (Integer scanNodeId : nodeScanRanges.keySet()) {
                    if (!scanNodeIds.contains(scanNodeId)) continue;
                    filteredNodeScanRanges.put(scanNodeId, (List)nodeScanRanges.get(scanNodeId));
                }
                Pair<Integer, HashMap> filteredScanRanges = Pair.create((Integer)scanRanges.getKey(), filteredNodeScanRanges);
                if (!addressToScanRanges.containsKey(address)) {
                    addressToScanRanges.put(address, Lists.newArrayList());
                }
                ((List)addressToScanRanges.get(address)).add(filteredScanRanges);
            }
            FragmentScanRangeAssignment assignment = params.scanRangeAssignment;
            for (Map.Entry addressScanRange : addressToScanRanges.entrySet()) {
                List scanRange = (List)addressScanRange.getValue();
                Map range = (Map)Coordinator.this.findOrInsert(assignment, (TNetworkAddress)addressScanRange.getKey(), new HashMap());
                int expectedInstanceNum = 1;
                if (parallelExecInstanceNum > 1) {
                    expectedInstanceNum = Math.min(scanRange.size(), parallelExecInstanceNum);
                }
                List perInstanceScanRanges = ListUtil.splitBySize(scanRange, expectedInstanceNum);
                for (List perInstanceScanRange : perInstanceScanRanges) {
                    FInstanceExecParam instanceParam = new FInstanceExecParam(null, (TNetworkAddress)addressScanRange.getKey(), 0, params);
                    for (Pair nodeScanRangeMap : perInstanceScanRange) {
                        instanceParam.addBucketSeq((Integer)nodeScanRangeMap.first);
                        for (Map.Entry nodeScanRange : ((Map)nodeScanRangeMap.second).entrySet()) {
                            if (!instanceParam.perNodeScanRanges.containsKey(nodeScanRange.getKey())) {
                                range.put((Integer)nodeScanRange.getKey(), Lists.newArrayList());
                                instanceParam.perNodeScanRanges.put((Integer)nodeScanRange.getKey(), Lists.newArrayList());
                            }
                            ((List)range.get(nodeScanRange.getKey())).addAll((Collection)nodeScanRange.getValue());
                            instanceParam.perNodeScanRanges.get(nodeScanRange.getKey()).addAll((Collection)nodeScanRange.getValue());
                        }
                    }
                    params.instanceExecParams.add(instanceParam);
                }
            }
        }
    }

    class BucketSeqToScanRange
    extends HashMap<Integer, Map<Integer, List<TScanRangeParams>>> {
        BucketSeqToScanRange() {
        }
    }

    class FragmentScanRangeAssignment
    extends HashMap<TNetworkAddress, Map<Integer, List<TScanRangeParams>>> {
        FragmentScanRangeAssignment() {
        }
    }
}

