/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.ldap.LdapAuthenticate;
import org.apache.doris.mysql.MysqlProto;
import org.apache.doris.mysql.nio.NConnectContext;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ConnectProcessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectScheduler {
    private static final Logger LOG = LogManager.getLogger(ConnectScheduler.class);
    private int maxConnections;
    private AtomicInteger numberConnection;
    private AtomicInteger nextConnectionId;
    private Map<Integer, ConnectContext> connectionMap = Maps.newConcurrentMap();
    private Map<String, AtomicInteger> connByUser = Maps.newConcurrentMap();
    private ExecutorService executor = ThreadPoolManager.newDaemonCacheThreadPool(Config.max_connection_scheduler_threads_num, "connect-scheduler-pool", true);
    private ScheduledExecutorService checkTimer = ThreadPoolManager.newDaemonScheduledThreadPool(1, "Connect-Scheduler-Check-Timer", true);

    public ConnectScheduler(int maxConnections) {
        this.maxConnections = maxConnections;
        this.numberConnection = new AtomicInteger(0);
        this.nextConnectionId = new AtomicInteger(0);
        this.checkTimer.scheduleAtFixedRate(new TimeoutChecker(), 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public boolean submit(ConnectContext context) {
        if (context == null) {
            return false;
        }
        context.setConnectionId(this.nextConnectionId.getAndAdd(1));
        if (context instanceof NConnectContext) {
            return true;
        }
        this.executor.submit(new LoopHandler(context));
        return true;
    }

    public boolean registerConnection(ConnectContext ctx) {
        if (this.numberConnection.incrementAndGet() > this.maxConnections) {
            this.numberConnection.decrementAndGet();
            return false;
        }
        this.connByUser.putIfAbsent(ctx.getQualifiedUser(), new AtomicInteger(0));
        AtomicInteger conns = this.connByUser.get(ctx.getQualifiedUser());
        if (ctx.getIsTempUser()) {
            if ((long)conns.incrementAndGet() > LdapAuthenticate.getMaxConn()) {
                conns.decrementAndGet();
                this.numberConnection.decrementAndGet();
                return false;
            }
        } else if ((long)conns.incrementAndGet() > ctx.getCatalog().getAuth().getMaxConn(ctx.getQualifiedUser())) {
            conns.decrementAndGet();
            this.numberConnection.decrementAndGet();
            return false;
        }
        this.connectionMap.put(ctx.getConnectionId(), ctx);
        return true;
    }

    public void unregisterConnection(ConnectContext ctx) {
        ctx.closeTxn();
        if (this.connectionMap.remove(ctx.getConnectionId()) != null) {
            AtomicInteger conns = this.connByUser.get(ctx.getQualifiedUser());
            if (conns != null) {
                conns.decrementAndGet();
            }
            this.numberConnection.decrementAndGet();
        }
    }

    public ConnectContext getContext(int connectionId) {
        return this.connectionMap.get(connectionId);
    }

    public int getConnectionNum() {
        return this.numberConnection.get();
    }

    public List<ConnectContext.ThreadInfo> listConnection(String user) {
        ArrayList infos = Lists.newArrayList();
        for (ConnectContext ctx : this.connectionMap.values()) {
            if (!ctx.getQualifiedUser().equals(user) && !Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.GRANT)) continue;
            infos.add(ctx.toThreadInfo());
        }
        return infos;
    }

    private class LoopHandler
    implements Runnable {
        ConnectContext context;

        LoopHandler(ConnectContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.context.setThreadLocalInfo();
                this.context.setConnectScheduler(ConnectScheduler.this);
                if (!MysqlProto.negotiate(this.context)) {
                    return;
                }
                if (!ConnectScheduler.this.registerConnection(this.context)) {
                    this.context.getState().setError(ErrorCode.ERR_USER_LIMIT_REACHED, "Reach limit of connections");
                    MysqlProto.sendResponsePacket(this.context);
                    return;
                }
                MysqlProto.sendResponsePacket(this.context);
                this.context.setStartTime();
                ConnectProcessor processor = new ConnectProcessor(this.context);
                processor.loop();
            }
            catch (Exception e) {
                if (this.context.getCurrentUserIdentity() != null) {
                    LOG.warn("connect processor exception because ", (Throwable)e);
                } else {
                    LOG.debug("connect processor exception because ", (Throwable)e);
                }
            }
            finally {
                ConnectScheduler.this.unregisterConnection(this.context);
                this.context.cleanup();
            }
        }
    }

    private class TimeoutChecker
    extends TimerTask {
        private TimeoutChecker() {
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            for (ConnectContext connectContext : ConnectScheduler.this.connectionMap.values()) {
                connectContext.checkTimeout(now);
            }
        }
    }
}

