/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.qe;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.doris.analysis.InsertStmt;
import org.apache.doris.analysis.KillStmt;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.mysql.MysqlChannel;
import org.apache.doris.mysql.MysqlCommand;
import org.apache.doris.mysql.MysqlPacket;
import org.apache.doris.mysql.MysqlProto;
import org.apache.doris.mysql.MysqlSerializer;
import org.apache.doris.plugin.AuditEvent;
import org.apache.doris.proto.Data;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.OriginStatement;
import org.apache.doris.qe.QueryDetail;
import org.apache.doris.qe.QueryDetailQueue;
import org.apache.doris.qe.QueryState;
import org.apache.doris.qe.ShowResultSet;
import org.apache.doris.qe.StmtExecutor;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.thrift.TMasterOpRequest;
import org.apache.doris.thrift.TMasterOpResult;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectProcessor {
    private static final Logger LOG = LogManager.getLogger(ConnectProcessor.class);
    private final ConnectContext ctx;
    private ByteBuffer packetBuf;
    private StmtExecutor executor = null;

    public ConnectProcessor(ConnectContext context) {
        this.ctx = context;
    }

    private void handleInitDb() {
        String dbName = new String(this.packetBuf.array(), 1, this.packetBuf.limit() - 1);
        if (Strings.isNullOrEmpty((String)this.ctx.getClusterName())) {
            this.ctx.getState().setError(ErrorCode.ERR_CLUSTER_NAME_NULL, "Please enter cluster");
            return;
        }
        dbName = ClusterNamespace.getFullName(this.ctx.getClusterName(), dbName);
        try {
            this.ctx.getCatalog().changeDb(this.ctx, dbName);
        }
        catch (DdlException e) {
            this.ctx.getState().setError(e.getMessage());
            return;
        }
        this.ctx.getState().setOk();
    }

    private void handleQuit() {
        this.ctx.setKilled();
        this.ctx.getState().setOk();
    }

    private void handlePing() {
        this.ctx.getState().setOk();
    }

    private void auditAfterExec(String origStmt, StatementBase parsedStmt, Data.PQueryStatistics statistics) {
        long endTime = System.currentTimeMillis();
        long elapseMs = endTime - this.ctx.getStartTime();
        this.ctx.getAuditEventBuilder().setEventType(AuditEvent.EventType.AFTER_QUERY).setState(this.ctx.getState().toString()).setQueryTime(elapseMs).setScanBytes(statistics == null ? 0L : statistics.getScanBytes()).setScanRows(statistics == null ? 0L : statistics.getScanRows()).setCpuTimeMs(statistics == null ? 0L : statistics.getCpuMs()).setPeakMemoryBytes(statistics == null ? 0L : statistics.getMaxPeakMemoryBytes()).setReturnRows(this.ctx.getReturnRows()).setStmtId(this.ctx.getStmtId()).setQueryId(this.ctx.queryId() == null ? "NaN" : DebugUtil.printId(this.ctx.queryId()));
        if (this.ctx.getState().isQuery()) {
            MetricRepo.COUNTER_QUERY_ALL.increase(1L);
            if (this.ctx.getState().getStateType() == QueryState.MysqlStateType.ERR && this.ctx.getState().getErrType() != QueryState.ErrType.ANALYSIS_ERR) {
                MetricRepo.COUNTER_QUERY_ERR.increase(1L);
            } else {
                MetricRepo.HISTO_QUERY_LATENCY.update(elapseMs);
            }
            this.ctx.getAuditEventBuilder().setIsQuery(true);
            this.ctx.getQueryDetail().setEventTime(endTime);
            this.ctx.getQueryDetail().setEndTime(endTime);
            this.ctx.getQueryDetail().setLatency(elapseMs);
            this.ctx.getQueryDetail().setState(QueryDetail.QueryMemState.FINISHED);
            QueryDetailQueue.addOrUpdateQueryDetail(this.ctx.getQueryDetail());
        } else {
            this.ctx.getAuditEventBuilder().setIsQuery(false);
        }
        this.ctx.getAuditEventBuilder().setFeIp(FrontendOptions.getLocalHostAddress());
        if (!this.ctx.getState().isQuery() && parsedStmt != null && parsedStmt.needAuditEncryption()) {
            this.ctx.getAuditEventBuilder().setStmt(parsedStmt.toSql());
        } else if (parsedStmt instanceof InsertStmt && ((InsertStmt)parsedStmt).isValuesOrConstantSelect()) {
            int length = Math.min(1024, origStmt.length());
            this.ctx.getAuditEventBuilder().setStmt(origStmt.substring(0, length));
        } else {
            this.ctx.getAuditEventBuilder().setStmt(origStmt);
        }
        Catalog.getCurrentAuditEventProcessor().handleAuditEvent(this.ctx.getAuditEventBuilder().build());
    }

    private void handleQuery() {
        boolean alreadyAddedToAuditInfoList;
        ArrayList auditInfoList;
        String originStmt;
        block14: {
            MetricRepo.COUNTER_REQUEST_ALL.increase(1L);
            originStmt = null;
            try {
                int ending;
                byte[] bytes = this.packetBuf.array();
                for (ending = this.packetBuf.limit() - 1; ending >= 1 && bytes[ending] == 0; --ending) {
                }
                originStmt = new String(bytes, 1, ending, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("UTF8 is not supported in this environment.");
                this.ctx.getState().setError(ErrorCode.ERR_UNKNOWN_CHARACTER_SET, "Unsupported character set(UTF-8)");
                return;
            }
            String sqlHash = DigestUtils.md5Hex((String)originStmt);
            this.ctx.setSqlHash(sqlHash);
            this.ctx.getAuditEventBuilder().reset();
            this.ctx.getAuditEventBuilder().setTimestamp(System.currentTimeMillis()).setClientIp(this.ctx.getMysqlChannel().getRemoteHostPortString()).setUser(this.ctx.getQualifiedUser()).setDb(this.ctx.getDatabase()).setSqlHash(this.ctx.getSqlHash());
            StatementBase parsedStmt = null;
            auditInfoList = Lists.newArrayList();
            alreadyAddedToAuditInfoList = false;
            try {
                List<StatementBase> stmts = this.analyze(originStmt);
                for (int i = 0; i < stmts.size(); ++i) {
                    alreadyAddedToAuditInfoList = false;
                    this.ctx.getState().reset();
                    if (i > 0) {
                        this.ctx.resetReturnRows();
                    }
                    parsedStmt = stmts.get(i);
                    parsedStmt.setOrigStmt(new OriginStatement(originStmt, i));
                    parsedStmt.setUserInfo(this.ctx.getCurrentUserIdentity());
                    this.executor = new StmtExecutor(this.ctx, parsedStmt);
                    this.ctx.setExecutor(this.executor);
                    this.executor.execute();
                    if (i != stmts.size() - 1) {
                        this.ctx.getState().serverStatus |= 8;
                        this.finalizeCommand();
                    }
                    auditInfoList.add(new Pair<StatementBase, Data.PQueryStatistics>(this.executor.getParsedStmt(), this.executor.getQueryStatisticsForAuditLog()));
                    alreadyAddedToAuditInfoList = true;
                }
            }
            catch (IOException e) {
                LOG.warn("Process one query failed because IOException: ", (Throwable)e);
                this.ctx.getState().setError(ErrorCode.ERR_UNKNOWN_ERROR, "Doris process failed");
            }
            catch (UserException e) {
                LOG.warn("Process one query failed because.", (Throwable)e);
                this.ctx.getState().setError(e.getMysqlErrorCode(), e.getMessage());
                this.ctx.getState().setErrType(QueryState.ErrType.ANALYSIS_ERR);
            }
            catch (Throwable e) {
                LOG.warn("Process one query failed because unknown reason: ", e);
                this.ctx.getState().setError(ErrorCode.ERR_UNKNOWN_ERROR, e.getClass().getSimpleName() + ", msg: " + e.getMessage());
                if (!(parsedStmt instanceof KillStmt)) break block14;
                this.ctx.getState().setErrType(QueryState.ErrType.ANALYSIS_ERR);
            }
        }
        if (!alreadyAddedToAuditInfoList && this.executor != null) {
            auditInfoList.add(new Pair<StatementBase, Data.PQueryStatistics>(this.executor.getParsedStmt(), this.executor.getQueryStatisticsForAuditLog()));
        }
        if (!auditInfoList.isEmpty()) {
            for (Pair audit : auditInfoList) {
                this.auditAfterExec(originStmt.replace("\n", " "), (StatementBase)audit.first, (Data.PQueryStatistics)audit.second);
            }
        } else {
            this.auditAfterExec(originStmt.replace("\n", " "), null, null);
        }
    }

    private List<StatementBase> analyze(String originStmt) throws AnalysisException, DdlException {
        LOG.debug("the originStmts are: {}", (Object)originStmt);
        SqlScanner input = new SqlScanner(new StringReader(originStmt), (Long)this.ctx.getSessionVariable().getSqlMode());
        SqlParser parser = new SqlParser(input);
        try {
            return SqlParserUtils.getMultiStmts(parser);
        }
        catch (Error e) {
            throw new AnalysisException("Please check your sql, we meet an error when parsing.", e);
        }
        catch (AnalysisException | DdlException e) {
            String errorMessage = parser.getErrorMsg(originStmt);
            LOG.debug("origin stmt: {}; Analyze error message: {}", (Object)originStmt, (Object)parser.getErrorMsg(originStmt), (Object)e);
            if (errorMessage == null) {
                throw e;
            }
            throw new AnalysisException(errorMessage, e);
        }
        catch (Exception e) {
            throw new AnalysisException("Internal Error, maybe syntax error or this is a bug");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFieldList() throws IOException {
        String tableName = null;
        try {
            tableName = new String(MysqlProto.readNulTerminateString(this.packetBuf), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unknown UTF-8 character set.");
            return;
        }
        if (Strings.isNullOrEmpty((String)tableName)) {
            this.ctx.getState().setError(ErrorCode.ERR_UNKNOWN_TABLE, "Empty tableName");
            return;
        }
        Database db = this.ctx.getCatalog().getDbNullable(this.ctx.getDatabase());
        if (db == null) {
            this.ctx.getState().setError(ErrorCode.ERR_BAD_DB_ERROR, "Unknown database(" + this.ctx.getDatabase() + ")");
            return;
        }
        Table table = db.getTableNullable(tableName);
        if (table == null) {
            this.ctx.getState().setError(ErrorCode.ERR_UNKNOWN_TABLE, "Unknown table(" + tableName + ")");
            return;
        }
        table.readLock();
        try {
            MysqlSerializer serializer = this.ctx.getSerializer();
            MysqlChannel channel = this.ctx.getMysqlChannel();
            List<Column> baseSchema = table.getBaseSchema();
            for (Column column : baseSchema) {
                serializer.reset();
                serializer.writeField(db.getFullName(), table.getName(), column, true);
                channel.sendOnePacket(serializer.toByteBuffer());
            }
        }
        finally {
            table.readUnlock();
        }
        this.ctx.getState().setEof();
    }

    private void dispatch() throws IOException {
        byte code = this.packetBuf.get();
        MysqlCommand command = MysqlCommand.fromCode(code);
        if (command == null) {
            ErrorReport.report(ErrorCode.ERR_UNKNOWN_COM_ERROR, new Object[0]);
            this.ctx.getState().setError(ErrorCode.ERR_UNKNOWN_COM_ERROR, "Unknown command(" + code + ")");
            LOG.warn("Unknown command(" + code + ")");
            return;
        }
        this.ctx.setCommand(command);
        this.ctx.setStartTime();
        switch (command) {
            case COM_INIT_DB: {
                this.handleInitDb();
                break;
            }
            case COM_QUIT: {
                this.handleQuit();
                break;
            }
            case COM_QUERY: {
                this.handleQuery();
                break;
            }
            case COM_FIELD_LIST: {
                this.handleFieldList();
                break;
            }
            case COM_PING: {
                this.handlePing();
                break;
            }
            default: {
                this.ctx.getState().setError(ErrorCode.ERR_UNKNOWN_COM_ERROR, "Unsupported command(" + (Object)((Object)command) + ")");
                LOG.warn("Unsupported command(" + (Object)((Object)command) + ")");
            }
        }
    }

    private ByteBuffer getResultPacket() {
        MysqlPacket packet = this.ctx.getState().toResponsePacket();
        if (packet == null) {
            return null;
        }
        MysqlSerializer serializer = this.ctx.getSerializer();
        serializer.reset();
        packet.writeTo(serializer);
        return serializer.toByteBuffer();
    }

    private void finalizeCommand() throws IOException {
        ByteBuffer packet = null;
        if (this.executor != null && this.executor.isForwardToMaster() && this.ctx.getState().getStateType() != QueryState.MysqlStateType.ERR) {
            ShowResultSet resultSet = this.executor.getShowResultSet();
            if (resultSet == null) {
                packet = this.executor.getOutputPacket();
            } else {
                this.executor.sendResultSet(resultSet);
                packet = this.getResultPacket();
                if (packet == null) {
                    LOG.debug("packet == null");
                    return;
                }
            }
        } else {
            packet = this.getResultPacket();
            if (packet == null) {
                LOG.debug("packet == null");
                return;
            }
        }
        MysqlChannel channel = this.ctx.getMysqlChannel();
        channel.sendAndFlush(packet);
    }

    public TMasterOpResult proxyExecute(TMasterOpRequest request) {
        UserIdentity currentUserIdentity;
        this.ctx.setDatabase(request.db);
        this.ctx.setQualifiedUser(request.user);
        this.ctx.setCatalog(Catalog.getCurrentCatalog());
        this.ctx.getState().reset();
        if (request.isSetCluster()) {
            this.ctx.setCluster(request.cluster);
        }
        if (request.isSetResourceInfo()) {
            this.ctx.getSessionVariable().setResourceGroup(request.getResourceInfo().getGroup());
        }
        if (request.isSetUserIp()) {
            this.ctx.setRemoteIP(request.getUserIp());
        }
        if (request.isSetStmtId()) {
            this.ctx.setForwardedStmtId(request.getStmtId());
        }
        if (request.isSetCurrentUserIdent()) {
            currentUserIdentity = UserIdentity.fromThrift(request.getCurrentUserIdent());
            this.ctx.setCurrentUserIdentity(currentUserIdentity);
        }
        if (request.isFoldConstantByBe()) {
            this.ctx.getSessionVariable().setEnableFoldConstantByBe(request.foldConstantByBe);
        }
        if (request.isSetSessionVariables()) {
            this.ctx.getSessionVariable().setForwardedSessionVariables(request.getSessionVariables());
        } else {
            if (request.isSetTimeZone()) {
                this.ctx.getSessionVariable().setTimeZone(request.getTimeZone());
            }
            if (request.isSetSqlMode()) {
                this.ctx.getSessionVariable().setSqlMode(request.sqlMode);
            }
            if (request.isSetEnableStrictMode()) {
                this.ctx.getSessionVariable().setEnableInsertStrict(request.enableStrictMode);
            }
            if (request.isSetCurrentUserIdent()) {
                currentUserIdentity = UserIdentity.fromThrift(request.getCurrentUserIdent());
                this.ctx.setCurrentUserIdentity(currentUserIdentity);
            }
            if (request.isSetInsertVisibleTimeoutMs()) {
                this.ctx.getSessionVariable().setInsertVisibleTimeoutMs(request.getInsertVisibleTimeoutMs());
            }
        }
        if (request.isSetQueryOptions()) {
            this.ctx.getSessionVariable().setForwardedSessionVariables(request.getQueryOptions());
        } else {
            if (request.isSetExecMemLimit()) {
                this.ctx.getSessionVariable().setMaxExecMemByte(request.getExecMemLimit());
            }
            if (request.isSetQueryTimeout()) {
                this.ctx.getSessionVariable().setQueryTimeoutS(request.getQueryTimeout());
            }
            if (request.isSetLoadMemLimit()) {
                this.ctx.getSessionVariable().setLoadMemLimit(request.loadMemLimit);
            }
        }
        this.ctx.setThreadLocalInfo();
        StmtExecutor executor = null;
        try {
            TUniqueId queryId;
            int idx = request.isSetStmtIdx() ? request.getStmtIdx() : 0;
            executor = new StmtExecutor(this.ctx, new OriginStatement(request.getSql(), idx), true);
            this.ctx.setExecutor(executor);
            if (request.isSetQueryId()) {
                queryId = request.getQueryId();
            } else {
                UUID uuid = UUID.randomUUID();
                queryId = new TUniqueId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            }
            executor.execute(queryId);
        }
        catch (IOException e) {
            LOG.warn("Process one query failed because IOException: ", (Throwable)e);
            this.ctx.getState().setError(ErrorCode.ERR_UNKNOWN_ERROR, "Doris process failed: " + e.getMessage());
        }
        catch (Throwable e) {
            LOG.warn("Process one query failed because unknown reason: ", e);
            this.ctx.getState().setError(ErrorCode.ERR_UNKNOWN_ERROR, "Unexpected exception: " + e.getMessage());
        }
        TMasterOpResult result = new TMasterOpResult();
        if (!(this.ctx.queryId() == null || request.isSetQueryId() && request.getQueryId().equals(this.ctx.queryId()))) {
            result.setQueryId(this.ctx.queryId());
        }
        result.setMaxJournalId(Catalog.getCurrentCatalog().getMaxJournalId().longValue());
        result.setPacket(this.getResultPacket());
        if (executor != null && executor.getProxyResultSet() != null) {
            result.setResultSet(executor.getProxyResultSet().tothrift());
        }
        return result;
    }

    public void processOnce() throws IOException {
        this.ctx.getState().reset();
        this.executor = null;
        MysqlChannel channel = this.ctx.getMysqlChannel();
        channel.setSequenceId(0);
        try {
            this.packetBuf = channel.fetchOnePacket();
            if (this.packetBuf == null) {
                LOG.warn("Null packet received from network. remote: {}", (Object)channel.getRemoteHostPortString());
                throw new IOException("Error happened when receiving packet.");
            }
        }
        catch (AsynchronousCloseException e) {
            return;
        }
        this.dispatch();
        this.finalizeCommand();
        this.ctx.setCommand(MysqlCommand.COM_SLEEP);
    }

    public void loop() {
        while (!this.ctx.isKilled()) {
            try {
                this.processOnce();
            }
            catch (Exception e) {
                LOG.warn("Exception happened in one session(" + this.ctx + ").", (Throwable)e);
                this.ctx.setKilled();
                break;
            }
        }
    }
}

